/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.converter.psi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.biopax.paxtools.converter.psi.EntryMapper;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import psidev.psi.mi.tab.PsimiTabException;
import psidev.psi.mi.tab.PsimiTabReader;
import psidev.psi.mi.tab.converter.tab2xml.Tab2Xml;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;

public class PsiToBiopax3Converter {
    private final String xmlBase;

    public PsiToBiopax3Converter() {
        this.xmlBase = null;
    }

    public PsiToBiopax3Converter(String xmlBase) {
        this.xmlBase = xmlBase;
    }

    public void convert(InputStream inputStream, OutputStream outputStream, boolean forceInteractionToComplex) throws IOException, PsimiXmlReaderException {
        if (inputStream == null || outputStream == null) {
            throw new IllegalArgumentException("convert(): one or more null arguments.");
        }
        PsimiXmlReader reader = new PsimiXmlReader();
        EntrySet entrySet = reader.read(inputStream);
        inputStream.close();
        this.convert(entrySet, outputStream, forceInteractionToComplex);
    }

    public void convertTab(InputStream inputStream, OutputStream outputStream, boolean forceInteractionToComplex) throws IOException, PsimiTabException {
        EntrySet entrySet;
        if (inputStream == null || outputStream == null) {
            throw new IllegalArgumentException("convertTab(): one or more null arguments.");
        }
        PsimiTabReader reader = new PsimiTabReader();
        Collection<BinaryInteraction> interactions = reader.read(inputStream);
        Tab2Xml tab2Xml = new Tab2Xml();
        try {
            entrySet = tab2Xml.convert(interactions);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (XmlConversionException e) {
            throw new RuntimeException(e);
        }
        inputStream.close();
        this.convert(entrySet, outputStream, forceInteractionToComplex);
    }

    public void convert(EntrySet entrySet, OutputStream outputStream, boolean forceInteractionToComplex) {
        if (entrySet == null || outputStream == null) {
            throw new IllegalArgumentException("convert: one or more null arguments.");
        }
        if (entrySet.getLevel() != 2) {
            throw new IllegalArgumentException("convert: only PSI-MI Level 2.5 is supported.");
        }
        Model model = BioPAXLevel.L3.getDefaultFactory().createModel();
        model.setXmlBase(this.xmlBase);
        EntryMapper entryMapper = new EntryMapper(model, forceInteractionToComplex);
        for (Entry entry : entrySet.getEntries()) {
            entryMapper.run(entry);
        }
        entrySet.getEntries().clear();
        entrySet = null;
        new SimpleIOHandler().convertToOWL(model, outputStream);
    }

    public String getXmlBase() {
        return this.xmlBase;
    }
}

