/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.biopax.paxtools.impl.level3.EntityFeatureImpl;
import org.biopax.paxtools.impl.level3.NamedImpl;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.EntityReferenceTypeVocabulary;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.util.BPCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityReferenceImpl
extends NamedImpl
implements EntityReference {
    private static final Logger log = LoggerFactory.getLogger(EntityReferenceImpl.class);
    private Set<EntityFeature> entityFeature = BPCollections.I.createSafeSet();
    private Set<SimplePhysicalEntity> entityReferenceOf = BPCollections.I.createSafeSet();
    private Set<Evidence> evidence = BPCollections.I.createSafeSet();
    private Set<EntityReferenceTypeVocabulary> entityReferenceType = BPCollections.I.createSafeSet();
    private Set<EntityReference> memberEntityReference = BPCollections.I.createSafeSet();
    private Set<EntityReference> ownerEntityReference = BPCollections.I.createSafeSet();

    public Class<? extends EntityReference> getModelInterface() {
        return EntityReference.class;
    }

    @Override
    public Set<EntityFeature> getEntityFeature() {
        return this.entityFeature;
    }

    @Override
    public void addEntityFeature(EntityFeature entityFeature) {
        if (entityFeature != null) {
            EntityReference eFof = entityFeature.getEntityFeatureOf();
            if (eFof != null && !eFof.equals(this)) {
                log.warn("addEntityFeature: violated the inverse-functional OWL constraint; to fix, " + entityFeature.getModelInterface().getSimpleName() + " " + entityFeature.getUri() + " should be REMOVED from " + eFof.getModelInterface().getSimpleName() + " " + eFof.getUri());
            }
            ((EntityFeatureImpl)entityFeature).setEntityFeatureOf(this);
            this.entityFeature.add(entityFeature);
        }
    }

    @Override
    public void removeEntityFeature(EntityFeature entityFeature) {
        if (this.entityFeature.contains(entityFeature)) {
            this.entityFeature.remove(entityFeature);
            if (entityFeature.getEntityFeatureOf() == this) {
                ((EntityFeatureImpl)entityFeature).setEntityFeatureOf(null);
            } else if (entityFeature.getEntityFeatureOf() != null) {
                log.warn("removeEntityFeature: removed " + entityFeature.getModelInterface().getSimpleName() + " " + entityFeature.getUri() + " from " + this.getModelInterface().getSimpleName() + " " + this.getUri() + "; though entityFeatureOf was another " + entityFeature.getEntityFeatureOf().getModelInterface().getSimpleName() + " " + entityFeature.getEntityFeatureOf().getUri());
            } else {
                log.warn("removeEntityFeature: removed " + entityFeature.getModelInterface().getSimpleName() + " " + entityFeature.getUri() + " from " + this.getModelInterface().getSimpleName() + " " + this.getUri() + ", but entityFeatureOf was already NULL (illegal state)");
            }
        } else {
            log.warn("removeEntityFeature: did nothing, because " + this.getUri() + " does not contain feature " + entityFeature.getUri());
        }
    }

    @Override
    public Set<SimplePhysicalEntity> getEntityReferenceOf() {
        return this.entityReferenceOf;
    }

    @Override
    public Set<EntityReferenceTypeVocabulary> getEntityReferenceType() {
        return this.entityReferenceType;
    }

    @Override
    public void addEntityReferenceType(EntityReferenceTypeVocabulary entityReferenceType) {
        if (entityReferenceType != null) {
            this.entityReferenceType.add(entityReferenceType);
        }
    }

    @Override
    public void removeEntityReferenceType(EntityReferenceTypeVocabulary entityReferenceType) {
        if (entityReferenceType != null) {
            this.entityReferenceType.remove(entityReferenceType);
        }
    }

    @Override
    public Set<EntityReference> getMemberEntityReference() {
        return this.memberEntityReference;
    }

    @Override
    public void addMemberEntityReference(EntityReference memberEntity) {
        if (memberEntity != null) {
            this.memberEntityReference.add(memberEntity);
            memberEntity.getMemberEntityReferenceOf().add(this);
        }
    }

    @Override
    public void removeMemberEntityReference(EntityReference memberEntity) {
        if (memberEntity != null) {
            this.memberEntityReference.remove(memberEntity);
            memberEntity.getMemberEntityReferenceOf().remove(this);
        }
    }

    @Override
    public Set<EntityReference> getMemberEntityReferenceOf() {
        return this.ownerEntityReference;
    }

    @Override
    public Set<Evidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void addEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.add(evidence2);
        }
    }

    @Override
    public void removeEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.remove(evidence2);
        }
    }
}

