/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.sbgn.VCompound;
import org.biopax.paxtools.io.sbgn.VNode;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.sbgn.SbgnPDLayout;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.layout.sbgn.SbgnProcessNode;
import org.sbgn.GlyphClazz;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.Sbgn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SBGNLayoutManager {
    private static final Logger log = LoggerFactory.getLogger(SBGNLayoutManager.class);
    private Layout layout;
    private VCompound root;
    private Map<VNode, LNode> viewToLayout;
    private Map<String, VNode> layoutToView;
    private Map<Glyph, VNode> glyphToVNode;
    private Map<String, Glyph> idToGLyph;
    private Map<String, Glyph> idToCompartmentGlyphs;
    private Map<String, Glyph> portIDToOwnerGlyph;
    private Map<String, Arc> idToArcs;

    SBGNLayoutManager() {
    }

    public void createLayout(Sbgn sbgn, boolean doLayout) {
        this.viewToLayout = new HashMap<VNode, LNode>();
        this.glyphToVNode = new HashMap<Glyph, VNode>();
        this.idToGLyph = new HashMap<String, Glyph>();
        this.idToCompartmentGlyphs = new HashMap<String, Glyph>();
        this.portIDToOwnerGlyph = new HashMap<String, Glyph>();
        this.layoutToView = new HashMap<String, VNode>();
        this.idToArcs = new HashMap<String, Arc>();
        this.layout = new SbgnPDLayout();
        LGraphManager graphMgr = this.layout.getGraphManager();
        graphMgr.addRoot();
        this.root = new VCompound(new Glyph());
        for (Glyph glyph : sbgn.getMap().getGlyph()) {
            Glyph compartment;
            if (this.glyphClazzOneOf(glyph, GlyphClazz.COMPARTMENT)) {
                this.idToCompartmentGlyphs.put(glyph.getId(), glyph);
            }
            if ((compartment = (Glyph)glyph.getCompartmentRef()) == null || !this.glyphClazzOneOf(glyph, GlyphClazz.COMPLEX)) continue;
            this.setCompartmentRefForComplexMembers(glyph, compartment, new HashSet<Glyph>());
        }
        if (!this.idToCompartmentGlyphs.isEmpty()) {
            ArrayList<Glyph> deletedList = new ArrayList<Glyph>();
            for (Glyph g : sbgn.getMap().getGlyph()) {
                Glyph glyph = (Glyph)g.getCompartmentRef();
                if (glyph == null) continue;
                this.idToCompartmentGlyphs.get(glyph.getId()).getGlyph().add(g);
                deletedList.add(g);
            }
            for (Glyph g : deletedList) {
                sbgn.getMap().getGlyph().remove(g);
            }
        }
        this.initPortIdToGlyphMap(sbgn.getMap().getGlyph());
        this.removePortsFromArcs(sbgn.getMap().getArc());
        this.assignProcessAndLogicOpNodesToCompartment(sbgn);
        this.createVNodes(this.root, sbgn.getMap().getGlyph());
        for (VNode vNode : this.root.children) {
            this.createLNode(vNode, null);
        }
        this.createLEdges(sbgn.getMap().getArc());
        if (doLayout) {
            this.layout.runLayout();
        }
        graphMgr.updateBounds();
        for (Iterator<Object> iterator : this.layout.getAllNodes()) {
            if (!(iterator instanceof SbgnProcessNode)) continue;
            VNode vNode = this.layoutToView.get(((SbgnProcessNode)((Object)iterator)).label);
            Bbox tempBbox = vNode.glyph.getBbox();
            tempBbox.setX((float)((SbgnProcessNode)((Object)iterator)).getLeft());
            tempBbox.setY((float)((SbgnProcessNode)((Object)iterator)).getTop());
            vNode.glyph.setBbox(tempBbox);
            SbgnPDNode inputLPort = ((SbgnProcessNode)((Object)iterator)).getInputPort();
            SbgnPDNode outputLPort = ((SbgnProcessNode)((Object)iterator)).getOutputPort();
            Port inputPort = new Port();
            Port outputPort = new Port();
            inputPort.setX((float)inputLPort.getCenterX());
            inputPort.setY((float)inputLPort.getCenterY());
            inputPort.setId(inputLPort.label);
            outputPort.setX((float)outputLPort.getCenterX());
            outputPort.setY((float)outputLPort.getCenterY());
            outputPort.setId(outputLPort.label);
            vNode.glyph.getPort().clear();
            this.connectArcToPort(inputLPort, inputPort);
            this.connectArcToPort(outputLPort, outputPort);
            vNode.glyph.getPort().add(inputPort);
            vNode.glyph.getPort().add(outputPort);
        }
        for (VNode vNode : this.root.children) {
            this.updateCompoundBounds(vNode.glyph, vNode.glyph.getGlyph());
        }
        for (Glyph glyph : this.idToCompartmentGlyphs.values()) {
            for (Glyph glyph2 : glyph.getGlyph()) {
                sbgn.getMap().getGlyph().add(glyph2);
            }
            glyph.getGlyph().clear();
        }
    }

    private void connectArcToPort(SbgnPDNode lPort, Port vPort) {
        for (Object e : lPort.getEdges()) {
            if (((LEdge)e).type.equals("rigid edge")) continue;
            Arc arc = this.idToArcs.get(((LEdge)e).label);
            if (lPort.label.equals(((LEdge)e).getSource().label)) {
                arc.setSource(vPort);
                continue;
            }
            if (!lPort.label.equals(((LEdge)e).getTarget().label)) continue;
            arc.setTarget(vPort);
        }
    }

    private void assignProcessAndLogicOpNodesToCompartment(Sbgn sbgn) {
        HashMap nodetoNeighbours = new HashMap();
        List<Glyph> glyphList = sbgn.getMap().getGlyph();
        List<Arc> arcList = sbgn.getMap().getArc();
        ArrayList<Glyph> targetNodes = new ArrayList<Glyph>();
        for (Glyph glyph : glyphList) {
            if (!this.glyphClazzOneOf(glyph, GlyphClazz.PROCESS, GlyphClazz.OMITTED_PROCESS, GlyphClazz.UNCERTAIN_PROCESS, GlyphClazz.PHENOTYPE, GlyphClazz.ASSOCIATION, GlyphClazz.DISSOCIATION, GlyphClazz.AND, GlyphClazz.OR, GlyphClazz.NOT)) continue;
            String processGlyphID = glyph.getId();
            nodetoNeighbours.put(processGlyphID, new HashMap());
            targetNodes.add(glyph);
            for (Arc arc : arcList) {
                Glyph target = null;
                Glyph source = null;
                source = arc.getSource() instanceof Port ? this.portIDToOwnerGlyph.get(((Port)arc.getSource()).getId()) : (Glyph)arc.getSource();
                target = arc.getTarget() instanceof Port ? this.portIDToOwnerGlyph.get(((Port)arc.getTarget()).getId()) : (Glyph)arc.getTarget();
                if (source.getId().equals(processGlyphID)) {
                    this.populateCompartmentOccurencesMap(target, (HashMap)nodetoNeighbours.get(processGlyphID));
                    continue;
                }
                if (!target.getId().equals(processGlyphID)) continue;
                this.populateCompartmentOccurencesMap(source, (HashMap)nodetoNeighbours.get(processGlyphID));
            }
        }
        for (Glyph glyph : targetNodes) {
            Glyph compartment;
            String id = glyph.getId();
            HashMap compartmentsOfTargetNode = (HashMap)nodetoNeighbours.get(id);
            LinkedList entries = new LinkedList(compartmentsOfTargetNode.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return -o1.getValue().compareTo(o2.getValue());
                }
            });
            if (entries.size() <= 0 || ((String)((Map.Entry)entries.get(0)).getKey()).equals("root") || (compartment = this.idToCompartmentGlyphs.get(((Map.Entry)entries.get(0)).getKey())) == null) continue;
            glyph.setCompartmentRef(compartment);
            compartment.getGlyph().add(glyph);
            sbgn.getMap().getGlyph().remove(glyph);
        }
    }

    private void populateCompartmentOccurencesMap(Glyph targetGlyph, HashMap<String, Integer> compartmentIDandOccurenceMap) {
        String rootID = "root";
        if (targetGlyph.getCompartmentRef() != null) {
            Glyph containerCompartment = (Glyph)targetGlyph.getCompartmentRef();
            String compartmentID = containerCompartment.getId();
            Integer compartmentOccurrenceValue = compartmentIDandOccurenceMap.get(compartmentID);
            if (compartmentOccurrenceValue != null) {
                compartmentIDandOccurenceMap.put(compartmentID, compartmentOccurrenceValue + 1);
            } else {
                compartmentIDandOccurenceMap.put(compartmentID, 1);
            }
        } else {
            Integer compartmentOccurrenceValue = compartmentIDandOccurenceMap.get(rootID);
            if (compartmentOccurrenceValue != null) {
                compartmentIDandOccurenceMap.put(rootID, compartmentOccurrenceValue + 1);
            } else {
                compartmentIDandOccurenceMap.put(rootID, 1);
            }
        }
    }

    private void updateCompoundBounds(Glyph parent, List<Glyph> childGlyphs) {
        float PAD = 2.0f;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        for (Glyph tmpGlyph : childGlyphs) {
            if (this.glyphClazzOneOf(tmpGlyph, GlyphClazz.UNIT_OF_INFORMATION, GlyphClazz.STATE_VARIABLE)) continue;
            if (tmpGlyph.getGlyph().size() > 0) {
                this.updateCompoundBounds(tmpGlyph, tmpGlyph.getGlyph());
            }
            float w = tmpGlyph.getBbox().getW();
            float h = tmpGlyph.getBbox().getH();
            minX = Math.min(minX, tmpGlyph.getBbox().getX());
            minY = Math.min(minY, tmpGlyph.getBbox().getY());
            maxX = Math.max(maxX, tmpGlyph.getBbox().getX() + w);
            maxY = Math.max(maxY, tmpGlyph.getBbox().getY() + h);
            if (minX == Float.MAX_VALUE) {
                minX = 0.0f;
            }
            if (minY == Float.MAX_VALUE) {
                minY = 0.0f;
            }
            if (maxX == Float.MIN_VALUE) {
                maxX = 0.0f;
            }
            if (maxY == Float.MIN_VALUE) {
                maxY = 0.0f;
            }
            parent.getBbox().setX(minX - PAD);
            parent.getBbox().setY(minY - PAD);
            parent.getBbox().setW(maxX - parent.getBbox().getX() + PAD);
            parent.getBbox().setH(maxY - parent.getBbox().getY() + PAD);
        }
    }

    private void createVNodes(VCompound parent, List<Glyph> glyphs) {
        for (Glyph glyph : glyphs) {
            VNode v;
            if (this.glyphClazzOneOf(glyph, GlyphClazz.UNIT_OF_INFORMATION, GlyphClazz.STATE_VARIABLE)) continue;
            if (!this.isChildless(glyph)) {
                v = new VCompound(glyph);
                this.idToGLyph.put(glyph.getId(), glyph);
                this.glyphToVNode.put(glyph, v);
                parent.children.add(v);
                this.createVNodes((VCompound)v, glyph.getGlyph());
                continue;
            }
            v = new VNode(glyph);
            this.idToGLyph.put(glyph.getId(), glyph);
            this.glyphToVNode.put(glyph, v);
            parent.children.add(v);
        }
    }

    private void createLEdges(List<Arc> arcs) {
        for (Arc arc : arcs) {
            LEdge lEdge = this.layout.newEdge(null);
            lEdge.type = arc.getClazz();
            lEdge.label = arc.getId();
            LNode sourceLNode = this.viewToLayout.get(this.glyphToVNode.get(arc.getSource()));
            LNode targetLNode = this.viewToLayout.get(this.glyphToVNode.get(arc.getTarget()));
            this.idToArcs.put(arc.getId(), arc);
            this.layout.getGraphManager().add(lEdge, sourceLNode, targetLNode);
        }
    }

    private void createLNode(VNode vNode, VNode parent) {
        LNode lNode = this.layout.newNode(vNode);
        lNode.type = vNode.glyph.getClazz();
        lNode.label = vNode.glyph.getId();
        LGraph rootLGraph = this.layout.getGraphManager().getRoot();
        this.viewToLayout.put(vNode, lNode);
        this.layoutToView.put(lNode.label, vNode);
        if (parent != null) {
            LNode parentLNode = this.viewToLayout.get(parent);
            parentLNode.getChild().add(lNode);
        } else {
            rootLGraph.add(lNode);
        }
        lNode.setLocation(vNode.glyph.getBbox().getX(), vNode.glyph.getBbox().getY());
        if (vNode instanceof VCompound) {
            VCompound vCompound = (VCompound)vNode;
            this.layout.getGraphManager().add(this.layout.newGraph(null), lNode);
            for (VNode vChildNode : vCompound.getChildren()) {
                this.createLNode(vChildNode, vCompound);
            }
        } else {
            lNode.setWidth(vNode.glyph.getBbox().getW());
            lNode.setHeight(vNode.glyph.getBbox().getH());
        }
    }

    private void setCompartmentRefForComplexMembers(Glyph glyph, Glyph compartment, Set<Glyph> visited) {
        if (!visited.add(glyph)) {
            return;
        }
        glyph.setCompartmentRef(compartment);
        if (glyph.getGlyph().size() > 0) {
            for (Glyph g : glyph.getGlyph()) {
                this.setCompartmentRefForComplexMembers(g, compartment, visited);
            }
        }
    }

    private void removePortsFromArcs(List<Arc> arcs) {
        for (Arc arc : arcs) {
            if (arc.getSource() instanceof Port) {
                Glyph source = this.portIDToOwnerGlyph.get(((Port)arc.getSource()).getId());
                arc.setSource(source);
            }
            if (!(arc.getTarget() instanceof Port)) continue;
            Glyph target = this.portIDToOwnerGlyph.get(((Port)arc.getTarget()).getId());
            arc.setTarget(target);
        }
    }

    private void initPortIdToGlyphMap(List<Glyph> glyphs) {
        for (Glyph glyph : glyphs) {
            for (Port p : glyph.getPort()) {
                this.portIDToOwnerGlyph.put(p.getId(), glyph);
            }
            if (glyph.getGlyph().size() <= 0) continue;
            this.initPortIdToGlyphMap(glyph.getGlyph());
        }
    }

    private boolean isChildless(Glyph targetGlyph) {
        boolean checker = true;
        for (Glyph glyph : targetGlyph.getGlyph()) {
            if (this.glyphClazzOneOf(glyph, GlyphClazz.STATE_VARIABLE, GlyphClazz.UNIT_OF_INFORMATION)) continue;
            checker = false;
            break;
        }
        return checker;
    }

    private boolean glyphClazzOneOf(Glyph g, GlyphClazz ... clazzes) {
        for (GlyphClazz clazz : clazzes) {
            if (!clazz.getClazz().equals(g.getClazz())) continue;
            return true;
        }
        return false;
    }
}

