/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.normalizer;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.biomodels.miriam.Miriam;
import net.biomodels.miriam.Resource;
import net.biomodels.miriam.Resources;
import net.biomodels.miriam.Synonyms;
import net.biomodels.miriam.Uri;
import net.biomodels.miriam.UriType;
import net.biomodels.miriam.Uris;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiriamLink {
    private static final Logger log = LoggerFactory.getLogger(MiriamLink.class);
    private static final String[] ARRAY_OF_STRINGS = new String[0];
    public static final String BINDING = "net.biomodels.miriam";
    private static final Miriam miriam;
    private static final Map<String, Miriam.Datatype> datatypesHash;
    public static boolean useObsoleteDatatypes;
    public static boolean useObsoleteResources;

    protected MiriamLink() {
    }

    public static String getServicesVersion() {
        return miriam.getDate().toString() + "; " + miriam.getDataVersion().toString();
    }

    public static String getDataTypeURI(String datatypeKey) {
        Miriam.Datatype datatype = MiriamLink.getDatatype(datatypeKey);
        return MiriamLink.getOfficialDataTypeURI(datatype);
    }

    public static String[] getDataTypeURIs(String datatypeKey) {
        HashSet<String> alluris = new HashSet<String>();
        Miriam.Datatype datatype = MiriamLink.getDatatype(datatypeKey);
        for (Uris uris : datatype.getUris()) {
            for (Uri uri : uris.getUri()) {
                alluris.add(uri.getValue());
            }
        }
        return alluris.toArray(ARRAY_OF_STRINGS);
    }

    public static String getResourceLocation(String resourceId) {
        Resource resource = MiriamLink.getResource(resourceId);
        return resource.getDataLocation();
    }

    public static String getResourceInstitution(String resourceId) {
        Resource resource = MiriamLink.getResource(resourceId);
        return resource.getDataInstitution();
    }

    public static String getURI(String name, String id) {
        Miriam.Datatype datatype = MiriamLink.getDatatype(name);
        String db = datatype.getName();
        if (MiriamLink.checkRegExp(id, db)) {
            try {
                return MiriamLink.getOfficialDataTypeURI(datatype) + ":" + URLEncoder.encode(id, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding error of id=" + id, e);
            }
        }
        throw new IllegalArgumentException("ID pattern mismatch. db=" + db + ", id=" + id + ", regexp: " + datatype.getPattern());
    }

    public static String getDataTypeDef(String datatypeKey) {
        Miriam.Datatype datatype = MiriamLink.getDatatype(datatypeKey);
        return datatype.getDefinition();
    }

    public static String[] getLocations(String datatypeKey, String entityId) {
        HashSet<String> locations = new HashSet<String>();
        Miriam.Datatype datatype = MiriamLink.getDatatype(datatypeKey);
        for (Resource resource : MiriamLink.getResources(datatype)) {
            String link = resource.getDataEntry();
            try {
                link = link.replaceFirst("\\$id", URLEncoder.encode(entityId, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            locations.add(link);
        }
        return locations.toArray(ARRAY_OF_STRINGS);
    }

    public static String[] getDataResources(String datatypeKey) {
        HashSet<String> locations = new HashSet<String>();
        Miriam.Datatype datatype = MiriamLink.getDatatype(datatypeKey);
        for (Resource resource : MiriamLink.getResources(datatype)) {
            String link = resource.getDataResource();
            locations.add(link);
        }
        return locations.toArray(ARRAY_OF_STRINGS);
    }

    public static boolean isDeprecated(String uri) {
        Miriam.Datatype datatype = datatypesHash.get(uri);
        String urn = MiriamLink.getOfficialDataTypeURI(datatype);
        return !uri.equalsIgnoreCase(urn);
    }

    public static String getDataTypePattern(String datatypeKey) {
        Miriam.Datatype datatype = MiriamLink.getDatatype(datatypeKey);
        return datatype.getPattern();
    }

    public static String getName(String datatypeKey) {
        Miriam.Datatype datatype = MiriamLink.getDatatype(datatypeKey);
        return datatype.getName();
    }

    public static String[] getNames(String datatypeKey) {
        HashSet<String> names = new HashSet<String>();
        Miriam.Datatype datatype = MiriamLink.getDatatype(datatypeKey);
        names.add(datatype.getName());
        Synonyms synonyms = datatype.getSynonyms();
        if (synonyms != null) {
            for (String name : synonyms.getSynonym()) {
                names.add(name);
            }
        }
        return names.toArray(ARRAY_OF_STRINGS);
    }

    public static String[] getDataTypesName() {
        HashSet<String> dataTypeNames = new HashSet<String>();
        for (Miriam.Datatype datatype : miriam.getDatatype()) {
            dataTypeNames.add(datatype.getName());
        }
        return dataTypeNames.toArray(ARRAY_OF_STRINGS);
    }

    public static String[] getDataTypesId() {
        HashSet<String> dataTypeIds = new HashSet<String>();
        for (Miriam.Datatype datatype : miriam.getDatatype()) {
            dataTypeIds.add(datatype.getId());
        }
        return dataTypeIds.toArray(new String[0]);
    }

    public static String getOfficialDataTypeURI(String uri) {
        return MiriamLink.getDataTypeURI(uri);
    }

    public static boolean checkRegExp(String identifier, String datatype) {
        Miriam.Datatype dt = MiriamLink.getDatatype(datatype);
        return Pattern.compile(dt.getPattern()).matcher(identifier).find();
    }

    public static String getOfficialDataTypeURI(Miriam.Datatype datatype) {
        for (Uris uris : datatype.getUris()) {
            for (Uri uri : uris.getUri()) {
                if (MiriamLink.isDeprecated(uri) || uri.getType() != UriType.URN) continue;
                return uri.getValue();
            }
        }
        return null;
    }

    private static boolean isDeprecated(Uri uri) {
        return uri.isDeprecated() != null && uri.isDeprecated() != false;
    }

    public static Miriam.Datatype getDatatype(String datatypeKey) {
        Miriam.Datatype dt = null;
        if (MiriamLink.containsIdOrName(datatypeKey)) {
            dt = datatypesHash.get(datatypeKey.toUpperCase());
        } else if (MiriamLink.containsUri(datatypeKey)) {
            dt = datatypesHash.get(datatypeKey);
        } else {
            throw new IllegalArgumentException("Datatype not found : " + datatypeKey);
        }
        if (!useObsoleteDatatypes && dt.isObsolete() != null && dt.isObsolete().booleanValue()) {
            throw new IllegalArgumentException("Datatype " + datatypeKey + "(" + dt.getName() + ") is obsolete (and useObsoleteDatatypes=false)");
        }
        return dt;
    }

    public static String[] getResourcesId() {
        HashSet<String> ids = new HashSet<String>();
        for (Miriam.Datatype datatype : miriam.getDatatype()) {
            for (Resource resource : MiriamLink.getResources(datatype)) {
                ids.add(resource.getId());
            }
        }
        return ids.toArray(new String[0]);
    }

    public static Resource getResource(String resourceId) {
        for (Miriam.Datatype datatype : miriam.getDatatype()) {
            for (Resource resource : MiriamLink.getResources(datatype)) {
                if (!resource.getId().equalsIgnoreCase(resourceId)) continue;
                return resource;
            }
        }
        throw new IllegalArgumentException("Resource not found : " + resourceId);
    }

    public static boolean containsIdOrName(String searchKey) {
        return datatypesHash.keySet().contains(searchKey.toUpperCase());
    }

    public static boolean containsUri(String searchUri) {
        return datatypesHash.keySet().contains(searchUri);
    }

    private static List<Resource> getResources(Miriam.Datatype datatype) {
        ArrayList<Resource> toReturn = new ArrayList<Resource>();
        Resources resources = datatype.getResources();
        if (resources != null) {
            for (Resource resource : resources.getResource()) {
                if (!useObsoleteResources && resource.isObsolete() != null && resource.isObsolete().booleanValue()) continue;
                toReturn.add(resource);
            }
        }
        return toReturn;
    }

    public static String convertUrn(String urn) {
        String[] tokens = urn.split(":");
        return "http://identifiers.org/" + tokens[tokens.length - 2] + "/" + URLDecoder.decode(tokens[tokens.length - 1]);
    }

    public static String getIdentifiersOrgURI(String name, String id) {
        String url;
        block4: {
            url = null;
            Miriam.Datatype datatype = MiriamLink.getDatatype(name);
            String db = datatype.getName();
            if (MiriamLink.checkRegExp(id, db)) {
                for (Uris uris : datatype.getUris()) {
                    for (Uri uri : uris.getUri()) {
                        if (!uri.getValue().startsWith("http://identifiers.org/")) continue;
                        url = uri.getValue() + id;
                        break block4;
                    }
                }
            } else {
                throw new IllegalArgumentException("ID pattern mismatch. db=" + db + ", id=" + id + ", regexp: " + datatype.getPattern());
            }
        }
        return url;
    }

    static {
        datatypesHash = new HashMap<String, Miriam.Datatype>();
        useObsoleteDatatypes = true;
        useObsoleteResources = true;
        try {
            JAXBContext jc = JAXBContext.newInstance(BINDING);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Miriam mir = null;
            InputStream is = MiriamLink.class.getResourceAsStream("/Miriam.xml");
            if (is == null) {
                throw new RuntimeException("Miriam.xml db is missing or broken. Please download the XML and schema from http://www.ebi.ac.uk/miriam/main/export/ and put at the classpath's root");
            }
            mir = (Miriam)unmarshaller.unmarshal(is);
            miriam = mir;
            log.info("MIRIAM XML imported, version: " + miriam.getDataVersion() + ", datatypes: " + miriam.getDatatype().size());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        for (Miriam.Datatype dt : miriam.getDatatype()) {
            datatypesHash.put(dt.getName().toUpperCase(), dt);
            datatypesHash.put(dt.getId().toUpperCase(), dt);
            Synonyms synonyms = dt.getSynonyms();
            if (synonyms != null) {
                for (String syn : synonyms.getSynonym()) {
                    datatypesHash.put(syn.toUpperCase(), dt);
                }
            }
            for (Uris uris : dt.getUris()) {
                for (Uri uri : uris.getUri()) {
                    datatypesHash.put(uri.getValue(), dt);
                }
            }
        }
    }
}

