/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.util.HGNC;
import org.biopax.paxtools.util.ClassFilterSet;

public class ConfigurableIDFetcher
implements IDFetcher {
    private final List<String> seqDbStartsWithOrEquals = new ArrayList<String>();
    private final List<String> chemDbStartsWithOrEquals = new ArrayList<String>();
    private boolean useNameWhenNoDbMatch = false;

    public ConfigurableIDFetcher seqDbStartsWithOrEquals(String dbStartsWithOrEquals) {
        this.seqDbStartsWithOrEquals.add(dbStartsWithOrEquals.toLowerCase());
        return this;
    }

    public List<String> getSeqDbStartsWithOrEquals() {
        return Collections.unmodifiableList(this.seqDbStartsWithOrEquals);
    }

    public ConfigurableIDFetcher chemDbStartsWithOrEquals(String dbStartsWithOrEquals) {
        this.chemDbStartsWithOrEquals.add(dbStartsWithOrEquals.toLowerCase());
        return this;
    }

    public List<String> getChemDbStartsWithOrEquals() {
        return Collections.unmodifiableList(this.chemDbStartsWithOrEquals);
    }

    public ConfigurableIDFetcher useNameWhenNoDbMatch(boolean useNameWhenNoDbMatch) {
        this.useNameWhenNoDbMatch = useNameWhenNoDbMatch;
        return this;
    }

    @Override
    public Set<String> fetchID(BioPAXElement ele) {
        HashSet<String> set = new HashSet<String>();
        if (ele instanceof XReferrable) {
            List<String> dbStartsWithOrEquals = ele instanceof SmallMoleculeReference || ele instanceof SmallMolecule ? this.chemDbStartsWithOrEquals : this.seqDbStartsWithOrEquals;
            for (String dbStartsWith : dbStartsWithOrEquals) {
                if (ele.getUri().startsWith("http://identifiers.org/" + dbStartsWith)) {
                    set.add(ele.getUri().substring(ele.getUri().lastIndexOf("/") + 1));
                } else {
                    for (Xref x : new ClassFilterSet<Xref, UnificationXref>(((XReferrable)ele).getXref(), UnificationXref.class)) {
                        this.collectXrefIdIfDbLike(x, dbStartsWith, set);
                    }
                    if (set.isEmpty()) {
                        for (Xref x : new ClassFilterSet<Xref, RelationshipXref>(((XReferrable)ele).getXref(), RelationshipXref.class)) {
                            this.collectXrefIdIfDbLike(x, dbStartsWith, set);
                        }
                    }
                }
                if (set.isEmpty()) continue;
                break;
            }
        }
        if (set.isEmpty() && ele instanceof Named && this.useNameWhenNoDbMatch) {
            Named e = (Named)ele;
            if (e.getDisplayName() != null && !e.getDisplayName().contains("...")) {
                set.add(e.getDisplayName());
            } else if (e.getStandardName() != null && !e.getStandardName().contains("...")) {
                set.add(e.getStandardName());
            } else if (!e.getName().isEmpty()) {
                TreeSet<String> names = new TreeSet<String>();
                for (String name : e.getName()) {
                    if (name.contains("...")) continue;
                    names.add(name);
                }
                set.add(((Object)names).toString());
            }
        }
        return set;
    }

    private void collectXrefIdIfDbLike(Xref x, String dbStartsWith, Set<String> set) {
        String db = x.getDb();
        String id = x.getId();
        if (db != null && id != null && !id.isEmpty() && (db = db.toLowerCase()).startsWith(dbStartsWith)) {
            if (db.startsWith("hgnc")) {
                id = HGNC.getSymbol(id);
            }
            if (id != null) {
                set.add(id);
            }
        }
    }
}

