/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.pattern.miner.SIFInteraction;

public class OutputColumn {
    private Type type;
    private PathAccessor[] accessors;

    public OutputColumn(String field) {
        if (field == null) {
            throw new IllegalArgumentException("The field parameter has to be specified");
        }
        try {
            this.type = Type.valueOf(field.toUpperCase());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.type == Type.CUSTOM) {
                throw new IllegalArgumentException("The \"custom\" type should be stated implicitly by passing path accessor strings as parameter.");
            }
            if (this.type == null) {
                this.type = Type.CUSTOM;
                String[] param = field.split(";");
                this.accessors = new PathAccessor[param.length];
                for (int i = 0; i < this.accessors.length; ++i) {
                    if (!param[i].contains("/")) {
                        throw new IllegalArgumentException("The parameter column field is not recognized as a pre-defined type. It also does not qualify as a path accessor argument string.");
                    }
                    this.accessors[i] = new PathAccessor(param[i]);
                }
            }
            return;
        }
    }

    public String getColumnValue(SIFInteraction inter) {
        switch (this.type.ordinal()) {
            case 0: {
                return this.concat(inter.getMediatorIDs());
            }
            case 4: {
                return this.concat(inter.getPathwayNames());
            }
            case 5: {
                return this.concat(inter.getPathwayUris());
            }
            case 1: {
                return this.concat(inter.getPublicationIDs(true));
            }
            case 2: {
                return this.concat(inter.getPublicationIDs(false));
            }
            case 6: {
                return this.concat(inter.getDataSources());
            }
            case 7: {
                return this.concat(inter.getCellularLocationsOfSource());
            }
            case 8: {
                return this.concat(inter.getCellularLocationsOfTarget());
            }
            case 3: {
                return this.concat(inter.getMediatorComments());
            }
            case 9: {
                HashSet<String> set = new HashSet<String>();
                for (PathAccessor acc : this.accessors) {
                    for (Object o : acc.getValueFromBeans((Collection<? extends BioPAXElement>)inter.mediators)) {
                        set.add(o.toString());
                    }
                }
                ArrayList<String> list = new ArrayList<String>(set);
                Collections.sort(list);
                return this.concat(list);
            }
        }
        throw new RuntimeException("Unhandled type: " + (Object)((Object)this.type) + ". This shouldn't be happening.");
    }

    private String concat(Collection<String> col) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String s : col) {
            if (first) {
                first = false;
            } else {
                b.append(";");
            }
            b.append(s);
        }
        return b.toString();
    }

    public static enum Type {
        MEDIATOR,
        PUBMED,
        PMC,
        COMMENTS,
        PATHWAY,
        PATHWAY_URI,
        RESOURCE,
        SOURCE_LOC,
        TARGET_LOC,
        CUSTOM;


        public static Type getType(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }
}

