/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.ivis.layout.ClusterManager;
import org.ivis.layout.Clustered;
import org.ivis.util.PointD;

public class Cluster
implements Comparable {
    protected Set<Clustered> nodes = new HashSet<Clustered>();
    protected ClusterManager clusterManager;
    protected int clusterID;
    protected String clusterName;
    protected List<PointD> polygon = new ArrayList<PointD>();

    public Cluster(ClusterManager clusterManager, String clusterName) {
        this.clusterManager = clusterManager;
        this.clusterName = clusterName;
        if (this.clusterManager != null) {
            while (!this.clusterManager.isClusterIDUsed(ClusterManager.idCounter)) {
                ++ClusterManager.idCounter;
            }
        }
        this.clusterID = ClusterManager.idCounter++;
    }

    public Cluster(ClusterManager clusterManager, int clusterID, String clusterName) {
        this.clusterManager = clusterManager;
        if (this.clusterManager != null && this.clusterManager.isClusterIDUsed(clusterID)) {
            System.err.println("Cluster ID " + clusterID + " is used before. ClusterID is set automatically.");
            while (this.clusterManager.isClusterIDUsed(ClusterManager.idCounter)) {
                ++ClusterManager.idCounter;
            }
            clusterID = ClusterManager.idCounter++;
        }
        this.clusterName = clusterName;
        this.clusterID = clusterID;
    }

    public Set<Clustered> getNodes() {
        return this.nodes;
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public List<PointD> getPolygon() {
        return this.polygon;
    }

    public void setPolygon(List<PointD> points) {
        this.polygon = points;
    }

    public void addNode(Clustered node) {
        node.addCluster(this);
    }

    public void removeNode(Clustered node) {
        node.removeCluster(this);
    }

    public void delete() {
        ArrayList<Clustered> copy = new ArrayList<Clustered>();
        copy.addAll(this.nodes);
        for (Clustered node : copy) {
            node.removeCluster(this);
        }
        this.clusterManager.getClusters().remove(this);
    }

    public void calculatePolygon() {
        if (this.clusterID == 0) {
            return;
        }
        this.calculateConvexHull();
    }

    private void findPoints() {
        this.polygon.clear();
        if (this.nodes.isEmpty()) {
            return;
        }
        for (Clustered node : this.nodes) {
            double left = node.getLeft();
            double right = node.getRight();
            double top = node.getTop();
            double bottom = node.getBottom();
            for (Clustered parent = node.getParent(); parent != null; parent = parent.getParent()) {
                left += parent.getLeft();
                right += parent.getLeft();
                top += parent.getTop();
                bottom += parent.getTop();
            }
            this.polygon.add(new PointD(left, top));
            this.polygon.add(new PointD(right, top));
            this.polygon.add(new PointD(right, bottom));
            this.polygon.add(new PointD(left, bottom));
        }
    }

    private void calculateConvexHull() {
        PointD pt2;
        PointD pt1;
        PointD pt3;
        int i;
        this.findPoints();
        if (this.polygon.isEmpty()) {
            return;
        }
        Collections.sort(this.polygon, new PointComparator());
        Stack<PointD> upperHull = new Stack<PointD>();
        Stack<PointD> lowerHull = new Stack<PointD>();
        int n = this.polygon.size();
        if (n < 3) {
            return;
        }
        upperHull.push(this.polygon.get(0));
        upperHull.push(this.polygon.get(1));
        block0: for (i = 2; i < this.polygon.size(); ++i) {
            pt3 = this.polygon.get(i);
            do {
                pt2 = (PointD)upperHull.pop();
                if (!upperHull.empty()) continue;
                upperHull.push(pt2);
                upperHull.push(pt3);
                continue block0;
            } while (!Cluster.rightTurn(pt1 = (PointD)upperHull.peek(), pt2, pt3));
            upperHull.push(pt2);
            upperHull.push(pt3);
        }
        lowerHull.push(this.polygon.get(n - 1));
        lowerHull.push(this.polygon.get(n - 2));
        block2: for (i = n - 3; i >= 0; --i) {
            pt3 = this.polygon.get(i);
            do {
                pt2 = (PointD)lowerHull.pop();
                if (!lowerHull.empty()) continue;
                lowerHull.push(pt2);
                lowerHull.push(pt3);
                continue block2;
            } while (!Cluster.rightTurn(pt1 = (PointD)lowerHull.peek(), pt2, pt3));
            lowerHull.push(pt2);
            lowerHull.push(pt3);
        }
        this.polygon.clear();
        n = lowerHull.size();
        for (i = 0; i < n; ++i) {
            this.polygon.add((PointD)lowerHull.pop());
        }
        n = upperHull.size();
        for (i = 0; i < n; ++i) {
            this.polygon.add((PointD)upperHull.pop());
        }
    }

    private static boolean rightTurn(PointD pt1, PointD pt2, PointD pt3) {
        double x1 = pt2.x - pt1.x;
        double y2 = -(pt3.y - pt2.y);
        double y1 = -(pt2.y - pt1.y);
        double x2 = pt3.x - pt2.x;
        return x1 * y2 - y1 * x2 <= 0.0;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Cluster) {
            Cluster cluster = (Cluster)obj;
            return Integer.valueOf(this.clusterID).compareTo(cluster.getClusterID());
        }
        return 0;
    }

    private class PointComparator
    implements Comparator<PointD> {
        private PointComparator() {
        }

        @Override
        public int compare(PointD o1, PointD o2) {
            PointD pt1 = o1;
            PointD pt2 = o2;
            if (pt1.x < pt2.x) {
                return -1;
            }
            if (pt1.x > pt2.x) {
                return 1;
            }
            if (Math.abs(pt1.x - pt2.x) < 1.0E-9 && pt1.y > pt2.y) {
                return -1;
            }
            if (Math.abs(pt1.x - pt2.x) < 1.0E-9 && pt1.y < pt2.y) {
                return 1;
            }
            return 0;
        }
    }
}

