/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import psidev.psi.mi.tab.PsimiTabReader;
import psidev.psi.mi.tab.model.BinaryInteraction;

public class PsimiTabIterator
implements psidev.psi.mi.tab.io.PsimiTabIterator {
    private BufferedReader interactionStreamReader;
    private BinaryInteraction nextLine;
    private int interactionsProcessedCount = 0;
    private int lineIndex = 0;
    private boolean lineConsummed = false;
    private PsimiTabReader mReader;

    public PsimiTabIterator(Reader psiMiTabInteractionsReader) {
        boolean isHeader = true;
        if (psiMiTabInteractionsReader == null) {
            throw new IllegalArgumentException("You must give a non null input stream.");
        }
        this.interactionStreamReader = psiMiTabInteractionsReader instanceof BufferedReader ? (BufferedReader)psiMiTabInteractionsReader : new BufferedReader(psiMiTabInteractionsReader);
        this.mReader = new PsimiTabReader();
        try {
            do {
                String firstLine;
                if ((firstLine = this.interactionStreamReader.readLine()) == null) {
                    this.nextLine = null;
                    isHeader = false;
                    continue;
                }
                if (firstLine.isEmpty() || firstLine.startsWith("#")) continue;
                this.nextLine = this.mReader.readLine(firstLine);
                ++this.lineIndex;
                isHeader = false;
            } while (isHeader);
        }
        catch (Exception e) {
            this.closeStreamReader();
            throw new RuntimeException("Error while reading the header line.", e);
        }
    }

    public boolean hasNext() {
        try {
            if (this.interactionStreamReader != null && this.lineConsummed) {
                String line = this.interactionStreamReader.readLine();
                BinaryInteraction binaryInteraction = this.nextLine = line != null ? this.mReader.readLine(line) : null;
                if (this.nextLine == null) {
                    this.closeStreamReader();
                    this.interactionStreamReader = null;
                } else {
                    ++this.lineIndex;
                    this.lineConsummed = false;
                }
            }
        }
        catch (Exception e) {
            this.closeStreamReader();
            throw new RuntimeException("Error while reading the file.", e);
        }
        return this.nextLine != null;
    }

    public BinaryInteraction next() {
        if (this.nextLine == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        BinaryInteraction interaction2 = this.nextLine;
        ++this.interactionsProcessedCount;
        this.lineConsummed = true;
        this.nextLine = null;
        return interaction2;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getInteractionsProcessedCount() {
        return this.interactionsProcessedCount;
    }

    private void closeStreamReader() {
        if (this.interactionStreamReader != null) {
            try {
                this.interactionStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

