/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.tab2graphml;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.PsimiTabException;
import psidev.psi.mi.tab.PsimiTabReader;
import psidev.psi.mi.tab.converter.tab2graphml.AliasByIncreasingLengthComparator;
import psidev.psi.mi.tab.converter.tab2graphml.AliasByTypeComparator;
import psidev.psi.mi.tab.converter.tab2graphml.AliasComparator;
import psidev.psi.mi.tab.converter.tab2graphml.CrossReferenceComparator;
import psidev.psi.mi.tab.converter.tab2graphml.IdentifierByDatabaseComparator;
import psidev.psi.mi.tab.converter.tab2graphml.IdentifierByTextComparator;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.Organism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphmlBuilder {
    private static final Log log = LogFactory.getLog(GraphmlBuilder.class);
    public static final String NEW_LINE = "\n";
    public static final String GRAPHML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"  \n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\n     http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n  <key id=\"label\" for=\"node\" attr.name=\"label\" attr.type=\"string\"/>\n  <key id=\"identifier\" for=\"node\" attr.name=\"identifier\" attr.type=\"string\"/>\n  <key id=\"specie\" for=\"node\" attr.name=\"specie\" attr.type=\"string\"/>\n  <key id=\"type\" for=\"node\" attr.name=\"type\" attr.type=\"string\"/>\n  <key id=\"shape\" for=\"node\" attr.name=\"shape\" attr.type=\"string\">\n    <default>ELLIPSE</default>\n  </key>\n  <graph id=\"G\" edgedefault=\"undirected\">\n";
    public static final String GRAPHML_FOOTER = "  </graph>\n</graphml>";
    private static final String COMPLEX = "complex";
    private static final String COMPOUND = "compound";
    private int nextNodeId = 1;
    private Map<String, Integer> molecule2node = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String build(InputStream is) throws IOException, PsimiTabException {
        long start = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder(8192);
        int interactionCount = 0;
        BufferedReader testReader = new BufferedReader(new InputStreamReader(is));
        try {
            PsimiTabReader reader = new PsimiTabReader();
            Iterator<BinaryInteraction> iterator = reader.iterate(testReader);
            sb.append(GRAPHML_HEADER);
            while (iterator.hasNext()) {
                Node nodeB;
                BinaryInteraction interaction2 = iterator.next();
                Object A = interaction2.getInteractorA();
                Object B = interaction2.getInteractorB();
                if (A == null && B != null) {
                    A = B;
                } else if (B == null && A != null) {
                    B = A;
                }
                Node nodeA = this.buildNode((Interactor)A);
                if (nodeA.hasXml()) {
                    sb.append(nodeA.getXml());
                }
                if ((nodeB = this.buildNode((Interactor)B)).hasXml()) {
                    sb.append(nodeB.getXml());
                }
                sb.append(this.buildEdge(interaction2, nodeA.getId(), nodeB.getId()));
                ++interactionCount;
            }
            log.info("Processed " + interactionCount + " binary interactions.");
            sb.append(GRAPHML_FOOTER);
        }
        catch (PsimiTabException e) {
            sb.append("Failed to parse MITAB data");
            sb.append(NEW_LINE);
            sb.append(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            testReader.close();
            this.molecule2node.clear();
        }
        String graphmlOutput = sb.toString();
        log.trace(graphmlOutput);
        long stop = System.currentTimeMillis();
        log.info("GraphML conversion took: " + (stop - start) + "ms");
        return graphmlOutput;
    }

    private String buildEdge(BinaryInteraction interaction2, int ida, int idb) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("     <edge source=\"" + ida + "\" target=\"" + idb + "\">").append(NEW_LINE);
        sb.append("     </edge>").append(NEW_LINE);
        return sb.toString();
    }

    private Node buildNode(Interactor interactor) {
        CrossReference cr = this.pickIdentifier(interactor);
        String db = cr.getDatabase();
        String id = cr.getIdentifier();
        if (this.molecule2node.containsKey(id)) {
            return new Node(this.molecule2node.get(id), null);
        }
        String moleculeType = "protein";
        if (db.equals("chebi") || db.equals("chembl") || db.equals("drugbank")) {
            moleculeType = COMPOUND;
        } else if (db.equals(COMPLEX)) {
            moleculeType = COMPLEX;
        }
        StringBuilder sb = new StringBuilder(256);
        String label = this.pickLabel(interactor);
        int nodeId = this.getNextNodeId();
        sb.append("     <node id=\"").append(nodeId).append("\">").append(NEW_LINE);
        sb.append("        <data key=\"label\">").append(this.escape(label)).append("</data>").append(NEW_LINE);
        sb.append("        <data key=\"identifier\">").append(db + "#" + id).append("</data>").append(NEW_LINE);
        String specieName = this.getSpecieName(interactor.getOrganism());
        if (specieName != null) {
            sb.append("        <data key=\"specie\">").append(this.escape(specieName)).append("</data>").append(NEW_LINE);
        }
        sb.append("        <data key=\"type\">").append(moleculeType).append("</data>").append(NEW_LINE);
        if (moleculeType.equals(COMPOUND)) {
            sb.append("        <data key=\"shape\">").append("TRIANGLE").append("</data>").append(NEW_LINE);
        } else if (moleculeType.equals(COMPLEX)) {
            sb.append("        <data key=\"shape\">").append("VEE").append("</data>").append(NEW_LINE);
        }
        sb.append("     </node>").append(NEW_LINE);
        this.molecule2node.put(id, nodeId);
        return new Node(nodeId, sb.toString());
    }

    private String escape(String s) {
        return StringEscapeUtils.escapeXml((String)s);
    }

    private String getSpecieName(Organism organism) {
        CrossReference first;
        String name = null;
        if (!organism.getIdentifiers().isEmpty() && ((name = (first = organism.getIdentifiers().iterator().next()).getText()) == null || StringUtils.isEmpty((String)name))) {
            name = first.getIdentifier();
        }
        if (name == null) {
            name = organism.getTaxid();
        }
        return name;
    }

    private int getNextNodeId() {
        return this.nextNodeId++;
    }

    protected CrossReference pickIdentifier(Interactor interactor) {
        CrossReference identifier = null;
        if (!interactor.getIdentifiers().isEmpty()) {
            IdentifierByDatabaseComparator comparator = new IdentifierByDatabaseComparator();
            identifier = this.pickFirstRelevantIdentifier(interactor.getIdentifiers(), comparator, true);
        } else if (!interactor.getAlternativeIdentifiers().isEmpty()) {
            IdentifierByDatabaseComparator comparator = new IdentifierByDatabaseComparator();
            identifier = this.pickFirstRelevantIdentifier(interactor.getAlternativeIdentifiers(), comparator, true);
        }
        if (identifier == null) {
            log.debug("WARNING - Could not find a relevant identifier for interactor: " + interactor);
            if (!interactor.getIdentifiers().isEmpty()) {
                identifier = interactor.getIdentifiers().iterator().next();
            } else if (!interactor.getAlternativeIdentifiers().isEmpty()) {
                identifier = interactor.getAlternativeIdentifiers().iterator().next();
            }
        }
        if (identifier == null) {
            throw new IllegalStateException("Can't find an Identifier for interactor " + interactor);
        }
        return identifier;
    }

    private CrossReference pickFirstRelevantIdentifier(Collection<CrossReference> identifiers, CrossReferenceComparator comparator, boolean allowNullIfNoMatch) {
        if (identifiers == null || identifiers.isEmpty()) {
            throw new IllegalArgumentException("You must give a non null/empty collection of identifiers");
        }
        boolean hasMatched = false;
        CrossReference picked = null;
        if (identifiers.size() > 1) {
            ArrayList<CrossReference> orderedRefs = new ArrayList<CrossReference>(identifiers);
            Collections.sort(orderedRefs, comparator);
            picked = (CrossReference)orderedRefs.get(0);
            hasMatched = comparator.hasMatchedAny();
        } else {
            picked = identifiers.iterator().next();
            hasMatched = comparator.matches(picked);
        }
        if (allowNullIfNoMatch && !hasMatched) {
            return null;
        }
        return picked;
    }

    private static void printIdentifiers(List<CrossReference> identifiers) {
        log.info("--- ordered list of Refs ---");
        for (CrossReference cr : identifiers) {
            log.info(cr.getDatabase() + ":" + cr.getIdentifier());
        }
        log.info("----------------------------");
    }

    protected String pickLabel(Interactor interactor) {
        CrossReference cr;
        CrossReferenceComparator comparator;
        String label = null;
        if (!interactor.getAliases().isEmpty()) {
            label = this.pickFirstRelevantAlias(interactor.getAliases(), new AliasByTypeComparator(), true);
        } else if (!interactor.getAlternativeIdentifiers().isEmpty()) {
            comparator = new IdentifierByTextComparator();
            cr = this.pickFirstRelevantIdentifier(interactor.getAlternativeIdentifiers(), comparator, true);
            if (cr != null) {
                label = cr.getIdentifier();
            }
        }
        if (label == null) {
            log.debug("WARNING - Could not find a relevant label for interactor: " + interactor);
            if (!interactor.getAliases().isEmpty()) {
                label = this.pickFirstRelevantAlias(interactor.getAliases(), new AliasByIncreasingLengthComparator(), true);
            } else if (!interactor.getIdentifiers().isEmpty()) {
                comparator = new IdentifierByDatabaseComparator();
                cr = this.pickFirstRelevantIdentifier(interactor.getIdentifiers(), comparator, false);
                if (cr != null) {
                    label = cr.getIdentifier();
                }
            } else if (!interactor.getAlternativeIdentifiers().isEmpty()) {
                CrossReference cr2 = interactor.getAlternativeIdentifiers().iterator().next();
                label = cr2.getIdentifier();
            }
        }
        if (label == null) {
            throw new IllegalStateException("Can't find a label for interactor " + interactor);
        }
        return label;
    }

    private String pickFirstRelevantAlias(Collection<Alias> aliases, AliasComparator comparator, boolean allowNullIfNoMatch) {
        if (aliases == null || aliases.isEmpty()) {
            throw new IllegalArgumentException("You must give a non null/empty collection of aliases");
        }
        boolean hasMatched = false;
        Alias picked = null;
        if (aliases.size() > 1) {
            ArrayList<Alias> orderedRefs = new ArrayList<Alias>(aliases);
            Collections.sort(orderedRefs, comparator);
            picked = (Alias)orderedRefs.get(0);
            hasMatched = comparator.hasMatchedAny();
        } else {
            picked = aliases.iterator().next();
            hasMatched = comparator.matches(picked);
        }
        if (allowNullIfNoMatch && !hasMatched) {
            return null;
        }
        return picked.getName();
    }

    private void printAliases(List<Alias> aliases) {
        log.info("--- Ordered list of Aliases ---");
        for (Alias a : aliases) {
            log.info(a.getDbSource() + ":" + a.getName() + "(" + a.getAliasType() + ")");
        }
        log.info("-------------------------------");
    }

    private class Node {
        int id;
        String xml;

        private Node(int id, String xml) {
            this.id = id;
            this.xml = xml;
        }

        public int getId() {
            return this.id;
        }

        public String getXml() {
            return this.xml;
        }

        public boolean hasXml() {
            return this.xml != null;
        }
    }
}

