/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import psidev.psi.mi.xml.PsimiXmlForm;
import psidev.psi.mi.xml.PsimiXmlVersion;
import psidev.psi.mi.xml.PsimiXmlWriterException;
import psidev.psi.mi.xml.converter.ConverterContext;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.io.impl.PsimiXmlWriter253;
import psidev.psi.mi.xml.io.impl.PsimiXmlWriter254;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.Participant;

public class PsimiXmlWriter
implements psidev.psi.mi.xml.io.PsimiXmlWriter {
    private static final PsimiXmlVersion DEFAULT_VERSION = PsimiXmlVersion.VERSION_254;
    private static final PsimiXmlForm DEFAULT_FORM = PsimiXmlForm.FORM_COMPACT;
    private psidev.psi.mi.xml.io.PsimiXmlWriter psiWriter;

    public PsimiXmlWriter() {
        this(DEFAULT_VERSION, DEFAULT_FORM);
    }

    public PsimiXmlWriter(PsimiXmlVersion version) {
        this(version, DEFAULT_FORM);
    }

    public PsimiXmlWriter(PsimiXmlVersion version, PsimiXmlForm xmlForm) {
        switch (version) {
            case VERSION_254: {
                this.psiWriter = new PsimiXmlWriter254();
                break;
            }
            case VERSION_253: {
                this.psiWriter = new PsimiXmlWriter253();
                break;
            }
            case VERSION_25_UNDEFINED: {
                this.psiWriter = new PsimiXmlWriter253();
            }
        }
        ConverterContext.getInstance().getConverterConfig().setXmlForm(xmlForm);
    }

    private void removeInteractorRedundancy(EntrySet mEntrySet) {
        if (ConverterContext.getInstance().getConverterConfig().getXmlForm() == PsimiXmlForm.FORM_COMPACT) {
            for (Entry entry : mEntrySet.getEntries()) {
                HashMap<Interactor, Interactor> uniqueInteractors = new HashMap<Interactor, Interactor>();
                for (Interaction interaction2 : entry.getInteractions()) {
                    for (Participant participant : interaction2.getParticipants()) {
                        if (participant.getInteractor() == null) continue;
                        Interactor myInteractor = participant.getInteractor();
                        if (uniqueInteractors.containsKey(myInteractor)) {
                            Interactor uniq = (Interactor)uniqueInteractors.get(myInteractor);
                            participant.setInteractor(uniq);
                            continue;
                        }
                        uniqueInteractors.put(myInteractor, myInteractor);
                    }
                }
                if (uniqueInteractors.isEmpty()) continue;
                entry.getInteractors().clear();
                entry.getInteractors().addAll(uniqueInteractors.keySet());
            }
        }
    }

    public void write(EntrySet mEntrySet, File file) throws PsimiXmlWriterException {
        this.write(mEntrySet, file, true);
    }

    public void write(EntrySet mEntrySet, OutputStream os) throws PsimiXmlWriterException {
        this.write(mEntrySet, os, true);
    }

    public void write(EntrySet mEntrySet, Writer writer) throws IOException, ConverterException, JAXBException, PsimiXmlWriterException {
        this.write(mEntrySet, writer, true);
    }

    public void write(EntrySet mEntrySet, PrintStream ps) throws IOException, ConverterException, JAXBException, PsimiXmlWriterException {
        this.write(mEntrySet, ps, true);
    }

    public void write(EntrySet mEntrySet, File file, boolean removeInteractorRedundancy) throws PsimiXmlWriterException {
        if (removeInteractorRedundancy) {
            this.removeInteractorRedundancy(mEntrySet);
        }
        this.psiWriter.write(mEntrySet, file);
    }

    public void write(EntrySet mEntrySet, OutputStream os, boolean removeInteractorRedundancy) throws PsimiXmlWriterException {
        if (removeInteractorRedundancy) {
            this.removeInteractorRedundancy(mEntrySet);
        }
        this.psiWriter.write(mEntrySet, os);
    }

    public void write(EntrySet mEntrySet, Writer writer, boolean removeInteractorRedundancy) throws IOException, ConverterException, JAXBException, PsimiXmlWriterException {
        if (removeInteractorRedundancy) {
            this.removeInteractorRedundancy(mEntrySet);
        }
        this.psiWriter.write(mEntrySet, writer);
    }

    public void write(EntrySet mEntrySet, PrintStream ps, boolean removeInteractorRedundancy) throws IOException, ConverterException, JAXBException, PsimiXmlWriterException {
        if (removeInteractorRedundancy) {
            this.removeInteractorRedundancy(mEntrySet);
        }
        this.psiWriter.write(mEntrySet, ps);
    }

    public String getAsString(EntrySet mEntrySet) throws PsimiXmlWriterException {
        this.removeInteractorRedundancy(mEntrySet);
        return this.psiWriter.getAsString(mEntrySet);
    }
}

