/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.examples.Macros;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level2.protein;
import org.biopax.paxtools.model.level2.relationshipXref;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.model.level2.xref;
import org.biopax.paxtools.util.Filter;

public class PathwayGenesExtractor
implements Visitor {
    static final String OUT = "geneset.txt";
    pathway pw;
    Map<String, Set<String>> geneset;
    Traverser traverser = new Traverser((EditorMap)SimpleEditorMap.get((BioPAXLevel)BioPAXLevel.L2), (Visitor)this, new Filter[0]);
    Collection<BioPAXElement> visited;
    String path = "";
    Collection<pathway> subpathways;
    Collection<interaction> interactions;

    public PathwayGenesExtractor(pathway pw) {
        this.geneset = new HashMap<String, Set<String>>();
        this.subpathways = new HashSet<pathway>();
        this.interactions = new HashSet<interaction>();
        this.visited = new HashSet<BioPAXElement>();
        this.pw = pw;
    }

    void run() {
        this.traverser.traverse((BioPAXElement)this.pw, null);
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (args.length != 2) {
            System.out.println("\nUse Parameters: biopaxFile pathwayFullRdfId\n");
            System.exit(-1);
        }
        Model model = Macros.open(args[0]);
        String pwId = args[1];
        pathway pw = (pathway)model.getByID(pwId);
        PathwayGenesExtractor extractor = new PathwayGenesExtractor(pw);
        extractor.run();
        PrintWriter out = new PrintWriter(OUT);
        out.println("rdf:IDs of proteins in the pathway : " + pw.getNAME() + " and its sub-pathways.");
        HashSet glist = new HashSet();
        for (String key : extractor.geneset.keySet()) {
            glist.addAll(extractor.geneset.get(key));
            StringBuffer sb = new StringBuffer(key);
            for (String name : extractor.geneset.get(key)) {
                sb.append(", ").append(name);
            }
            out.println(sb.toString());
        }
        out.println("\nALL IDs:");
        for (String g : glist) {
            out.println(g);
        }
        out.println("\nSub-pathways (rdfId : NAME):");
        for (pathway w : extractor.subpathways) {
            out.println(PathwayGenesExtractor.getLocalId((BioPAXElement)w) + " : " + w.getNAME());
        }
        out.println("\nInteractions:");
        for (interaction it : extractor.interactions) {
            out.println(PathwayGenesExtractor.getLocalId((BioPAXElement)it) + " : " + it.getNAME());
        }
        out.close();
    }

    public void visit(BioPAXElement domain1, Object range, Model model, PropertyEditor editor) {
        if (editor.getProperty().equals("NEXT-STEP")) {
            return;
        }
        if (range != null && range instanceof BioPAXElement && !this.visited.contains(range)) {
            BioPAXElement bpe = (BioPAXElement)range;
            this.path = this.path + this.getIdent(bpe);
            System.out.print(this.path + editor.getProperty() + "=" + PathwayGenesExtractor.getLocalId(bpe) + " " + bpe.getModelInterface().getSimpleName());
            if (bpe instanceof entity && ((entity)bpe).getNAME() != null) {
                System.out.print(" {" + ((entity)bpe).getNAME().replace("(name copied from entity in Homo sapiens)", "(name from human)") + "}");
            }
            if (bpe instanceof pathway) {
                this.subpathways.add((pathway)bpe);
            } else if (bpe instanceof interaction) {
                this.interactions.add((interaction)bpe);
            }
            if (bpe instanceof protein) {
                protein p = (protein)bpe;
                String id = PathwayGenesExtractor.getLocalId((BioPAXElement)p);
                HashSet<String> refs = new HashSet<String>();
                for (xref x : p.getXREF()) {
                    if (!(x instanceof unificationXref) && !(x instanceof relationshipXref)) continue;
                    refs.add(x.getID());
                }
                System.out.print(" (" + refs.size() + " ADDED!)");
                if (this.geneset.containsKey(id)) {
                    this.geneset.get(id).addAll(refs);
                } else {
                    this.geneset.put(id, refs);
                }
            }
            System.out.println();
            this.visited.add(bpe);
            this.traverser.traverse(bpe, model);
            this.path = this.path.substring(0, this.path.length() - 4);
        }
    }

    private String getIdent(BioPAXElement bpe) {
        String ident = "----";
        if (bpe instanceof pathway) {
            ident = "-pw-";
        } else if (bpe instanceof interaction) {
            ident = "-in-";
        } else if (bpe instanceof protein) {
            ident = "-pr-";
        } else if (bpe instanceof complex) {
            ident = "-co-";
        }
        return ident;
    }

    static String getLocalId(BioPAXElement bpe) {
        String id = bpe.getUri();
        return id.replaceFirst("^.+?#", "");
    }
}

