/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.command;

import org.biopax.paxtools.command.Command;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;

public abstract class AbstractPropertyCommand<D extends BioPAXElement, R>
implements Command {
    D bpe;
    PropertyEditor<D, R> editor;
    R value;

    AbstractPropertyCommand(D bpe, PropertyEditor<D, R> editor, R value) {
        if (bpe == null || editor == null) {
            throw new IllegalArgumentException();
        }
        this.bpe = bpe;
        this.editor = editor;
        this.value = value;
    }

    @Override
    public boolean undo() {
        try {
            this.undoAction();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract void undoAction();

    @Override
    public boolean redo() {
        try {
            this.redoAction();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract void redoAction();
}

