/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model.builder;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.AliasImpl;
import psidev.psi.mi.tab.model.Annotation;
import psidev.psi.mi.tab.model.AnnotationImpl;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.AuthorImpl;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.BinaryInteractionImpl;
import psidev.psi.mi.tab.model.Checksum;
import psidev.psi.mi.tab.model.ChecksumImpl;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.ConfidenceImpl;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.Feature;
import psidev.psi.mi.tab.model.FeatureImpl;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.Organism;
import psidev.psi.mi.tab.model.OrganismImpl;
import psidev.psi.mi.tab.model.Parameter;
import psidev.psi.mi.tab.model.ParameterImpl;
import psidev.psi.mi.tab.model.builder.IllegalFormatException;
import psidev.psi.mi.tab.model.builder.PsimiTabColumns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MitabParserUtils {
    private static final Log log = LogFactory.getLog(MitabParserUtils.class);

    public static String[] quoteAwareSplit(String str, char[] delimiters, boolean removeUnescapedQuotes) {
        if (str == null) {
            throw new NullPointerException("Null String to create Field");
        }
        if (str.isEmpty()) {
            throw new IllegalArgumentException("Empty String passed to create Field");
        }
        if (delimiters == null) {
            throw new NullPointerException("Null delimiters to create Field");
        }
        if (delimiters.length == 0) {
            throw new IllegalArgumentException("At least one delimiter char is needed");
        }
        LinkedList<String> groups = new LinkedList<String>();
        StringBuilder currGroup = new StringBuilder(str.length());
        char[] chars = str.toCharArray();
        boolean withinQuotes = false;
        boolean previousCharIsEscape = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean markedAsEscape = false;
            if (c == '\"') {
                if (withinQuotes) {
                    if (previousCharIsEscape) {
                        if (!removeUnescapedQuotes) {
                            currGroup.append("\\");
                        }
                        currGroup.append(c);
                    } else if (currGroup.length() > 0) {
                        withinQuotes = !withinQuotes;
                    }
                } else {
                    withinQuotes = true;
                }
                if (!removeUnescapedQuotes && !previousCharIsEscape) {
                    currGroup.append(c);
                }
            } else if (MitabParserUtils.arrayContains(delimiters, c)) {
                if (currGroup.length() > 0) {
                    if (!withinQuotes) {
                        groups.add(currGroup.toString());
                        currGroup.setLength(0);
                    } else {
                        currGroup.append(c);
                    }
                } else if (withinQuotes) {
                    currGroup.append(c);
                }
            } else if (c == '\\') {
                if (withinQuotes) {
                    previousCharIsEscape = true;
                    markedAsEscape = true;
                } else {
                    currGroup.append(c);
                }
            } else {
                currGroup.append(c);
            }
            if (markedAsEscape) continue;
            previousCharIsEscape = false;
        }
        if (currGroup.length() > 0) {
            groups.add(currGroup.toString());
        }
        return groups.toArray(new String[groups.size()]);
    }

    private static boolean arrayContains(char[] chars, char cToFind) {
        for (char c : chars) {
            if (c != cToFind) continue;
            return true;
        }
        return false;
    }

    public static BinaryInteraction<Interactor> buildBinaryInteraction(String[] line) throws IllegalFormatException {
        if (line == null) {
            throw new NullPointerException("Null line to create to create a BinaryInteraction");
        }
        if (line.length == 0) {
            throw new IllegalArgumentException("Empty line passed to create a BinaryInteraction");
        }
        if (line.length < PsimiTabColumns.MITAB_LENGTH.ordinal()) {
            line = MitabParserUtils.extendFormat(line, PsimiTabColumns.MITAB_LENGTH.ordinal());
        }
        Interactor interactorA = new Interactor();
        Interactor interactorB = new Interactor();
        BinaryInteractionImpl interaction2 = new BinaryInteractionImpl(interactorA, interactorB);
        interactorA.setIdentifiers(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.ID_INTERACTOR_A.ordinal()]));
        interactorA.setAlternativeIdentifiers(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.ALTID_INTERACTOR_A.ordinal()]));
        interactorA.setAliases(MitabParserUtils.splitAliases(line[PsimiTabColumns.ALIAS_INTERACTOR_A.ordinal()]));
        interactorA.setOrganism(MitabParserUtils.splitOrganism(line[PsimiTabColumns.TAXID_A.ordinal()]));
        interactorB.setIdentifiers(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.ID_INTERACTOR_B.ordinal()]));
        interactorB.setAlternativeIdentifiers(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.ALTID_INTERACTOR_B.ordinal()]));
        interactorB.setAliases(MitabParserUtils.splitAliases(line[PsimiTabColumns.ALIAS_INTERACTOR_B.ordinal()]));
        interactorB.setOrganism(MitabParserUtils.splitOrganism(line[PsimiTabColumns.TAXID_B.ordinal()]));
        interaction2.setDetectionMethods(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.INT_DET_METHOD.ordinal()]));
        interaction2.setAuthors(MitabParserUtils.splitAuthor(line[PsimiTabColumns.PUB_AUTH.ordinal()]));
        interaction2.setPublications(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.PUB_ID.ordinal()]));
        interaction2.setInteractionTypes(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.INTERACTION_TYPE.ordinal()]));
        interaction2.setSourceDatabases(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.SOURCE.ordinal()]));
        interaction2.setInteractionAcs(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.INTERACTION_ID.ordinal()]));
        interaction2.setConfidenceValues(MitabParserUtils.splitConfidences(line[PsimiTabColumns.CONFIDENCE.ordinal()]));
        interactorA.setBiologicalRoles(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.BIOROLE_A.ordinal()]));
        interactorA.setExperimentalRoles(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.EXPROLE_A.ordinal()]));
        interactorA.setInteractorTypes(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.INTERACTOR_TYPE_A.ordinal()]));
        interactorA.setXrefs(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.XREFS_A.ordinal()]));
        interactorA.setAnnotations(MitabParserUtils.splitAnnotations(line[PsimiTabColumns.ANNOTATIONS_A.ordinal()]));
        interactorA.setChecksums(MitabParserUtils.splitChecksums(line[PsimiTabColumns.CHECKSUM_A.ordinal()]));
        interactorB.setBiologicalRoles(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.BIOROLE_B.ordinal()]));
        interactorB.setExperimentalRoles(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.EXPROLE_B.ordinal()]));
        interactorB.setInteractorTypes(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.INTERACTOR_TYPE_B.ordinal()]));
        interactorB.setXrefs(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.XREFS_B.ordinal()]));
        interactorB.setAnnotations(MitabParserUtils.splitAnnotations(line[PsimiTabColumns.ANNOTATIONS_B.ordinal()]));
        interactorB.setChecksums(MitabParserUtils.splitChecksums(line[PsimiTabColumns.CHECKSUM_B.ordinal()]));
        interaction2.setComplexExpansion(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.COMPLEX_EXPANSION.ordinal()]));
        interaction2.setXrefs(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.XREFS_I.ordinal()]));
        interaction2.setAnnotations(MitabParserUtils.splitAnnotations(line[PsimiTabColumns.ANNOTATIONS_I.ordinal()]));
        interaction2.setHostOrganism(MitabParserUtils.splitOrganism(line[PsimiTabColumns.HOST_ORGANISM.ordinal()]));
        interaction2.setParameters(MitabParserUtils.splitParameters(line[PsimiTabColumns.PARAMETERS_I.ordinal()]));
        interaction2.setCreationDate(MitabParserUtils.splitDates(line[PsimiTabColumns.CREATION_DATE.ordinal()]));
        interaction2.setUpdateDate(MitabParserUtils.splitDates(line[PsimiTabColumns.UPDATE_DATE.ordinal()]));
        interaction2.setChecksums(MitabParserUtils.splitChecksums(line[PsimiTabColumns.CHECKSUM_I.ordinal()]));
        interaction2.setNegativeInteraction(MitabParserUtils.splitNegative(line[PsimiTabColumns.NEGATIVE.ordinal()]));
        interactorA.setFeatures(MitabParserUtils.splitFeatures(line[PsimiTabColumns.FEATURES_A.ordinal()]));
        interactorA.setStoichiometry(MitabParserUtils.splitStoichiometries(line[PsimiTabColumns.STOICHIOMETRY_A.ordinal()]));
        interactorA.setParticipantIdentificationMethods(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.PARTICIPANT_IDENT_MED_A.ordinal()]));
        interactorB.setFeatures(MitabParserUtils.splitFeatures(line[PsimiTabColumns.FEATURES_B.ordinal()]));
        interactorB.setStoichiometry(MitabParserUtils.splitStoichiometries(line[PsimiTabColumns.STOICHIOMETRY_B.ordinal()]));
        interactorB.setParticipantIdentificationMethods(MitabParserUtils.splitCrossReferences(line[PsimiTabColumns.PARTICIPANT_IDENT_MED_B.ordinal()]));
        if (!interactorA.isEmpty() && (interactorA.getIdentifiers() == null || interactorA.getIdentifiers().isEmpty())) {
            throw new IllegalFormatException("The interactor A has not an identifier but contains information in other attributes.Please, add an identifier: " + interactorA.toString());
        }
        if (!interactorB.isEmpty() && (interactorB.getIdentifiers() == null || interactorB.getIdentifiers().isEmpty())) {
            throw new IllegalFormatException("The interactor B has not an identifier but contains information in other attributes. Please, add an identifier: " + interactorB.toString());
        }
        if (interactorA.isEmpty() && interactorB.isEmpty()) {
            throw new IllegalFormatException("Both interactors are null or empety. We can have a interaction without interactors");
        }
        if (interactorA.isEmpty() && !interactorB.isEmpty()) {
            interaction2.setInteractorA(null);
        }
        if (interactorB.isEmpty() && !interactorA.isEmpty()) {
            interaction2.setInteractorB(null);
        }
        return interaction2;
    }

    public static String[] extendFormat(String[] oldFormat, int newSize) {
        int oldSize = oldFormat.length;
        if (oldSize >= newSize) {
            log.warn("The new size is smaller than the previous one, the array will not be modified.");
            return oldFormat;
        }
        String[] newFormat = new String[newSize];
        if (oldSize > 0) {
            System.arraycopy(oldFormat, 0, newFormat, 0, oldSize);
        }
        return newFormat;
    }

    public static Organism splitOrganism(String column) throws IllegalFormatException {
        OrganismImpl organism = null;
        if (column != null && !column.isEmpty()) {
            String[] result;
            organism = new OrganismImpl();
            for (String r : result = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] fields;
                if (r == null || (fields = MitabParserUtils.quoteAwareSplit(r, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = fields.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create a organism (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length == 1) {
                    if (result[0].equalsIgnoreCase("-")) continue;
                    throw new IllegalFormatException("String cannot be parsed to create a organism (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length == 2) {
                    organism.addIdentifier(new CrossReferenceImpl(fields[0], fields[1]));
                    continue;
                }
                if (length != 3) continue;
                organism.addIdentifier(new CrossReferenceImpl(fields[0], fields[1], fields[2]));
            }
        }
        return organism;
    }

    public static List<CrossReference> splitCrossReferences(String column) throws IllegalFormatException {
        ArrayList<CrossReference> objects = new ArrayList<CrossReference>();
        CrossReferenceImpl object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create a cross reference (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length == 1) {
                    if (field.equalsIgnoreCase("spoke")) {
                        object = new CrossReferenceImpl("psi-mi", "MI:1060", "spoke expansion");
                    } else if (field.equalsIgnoreCase("matrix")) {
                        object = new CrossReferenceImpl("psi-mi", "MI:1061", "matrix expansion");
                    } else if (field.equalsIgnoreCase("bipartite")) {
                        object = new CrossReferenceImpl("psi-mi", "MI:1062", "bipartite expansion");
                    } else if (!result[0].equalsIgnoreCase("-")) {
                        throw new IllegalFormatException("String cannot be parsed to create a cross reference (check the syntax): " + ArrayUtils.toString((Object)result));
                    }
                } else if (length == 2) {
                    object = new CrossReferenceImpl(result[0], result[1]);
                } else if (length == 3) {
                    object = new CrossReferenceImpl(result[0], result[1], result[2]);
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static List<Alias> splitAliases(String column) throws IllegalFormatException {
        ArrayList<Alias> objects = new ArrayList<Alias>();
        AliasImpl object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create an alias (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length == 1) {
                    if (!result[0].equalsIgnoreCase("-")) {
                        throw new IllegalFormatException("String cannot be parsed to create an alias (check the syntax): " + Arrays.asList(result).toString());
                    }
                } else if (length == 2) {
                    object = new AliasImpl(result[0], result[1]);
                } else if (length == 3) {
                    object = new AliasImpl(result[0], result[1], result[2]);
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static List<Confidence> splitConfidences(String column) throws IllegalFormatException {
        ArrayList<Confidence> objects = new ArrayList<Confidence>();
        ConfidenceImpl object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create the confidence (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length == 1) {
                    if (!result[0].equalsIgnoreCase("-")) {
                        object = new ConfidenceImpl("not-defined", result[0], "free-text");
                    }
                } else if (length == 2) {
                    object = new ConfidenceImpl(result[0], result[1]);
                } else if (length == 3) {
                    object = new ConfidenceImpl(result[0], result[1], result[2]);
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static List<Annotation> splitAnnotations(String column) throws IllegalFormatException {
        ArrayList<Annotation> objects = new ArrayList<Annotation>();
        AnnotationImpl object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create an annotation (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length == 1) {
                    if (!result[0].equalsIgnoreCase("-")) {
                        object = new AnnotationImpl(result[0]);
                    }
                } else if (length == 2) {
                    object = new AnnotationImpl(result[0], result[1]);
                } else {
                    throw new IllegalFormatException("String cannot be parsed to create an annotation (check the syntax): " + Arrays.asList(result).toString());
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static List<Parameter> splitParameters(String column) throws IllegalFormatException {
        ArrayList<Parameter> objects = new ArrayList<Parameter>();
        ParameterImpl object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create a parameter (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length == 1) {
                    if (!result[0].equalsIgnoreCase("-")) {
                        throw new IllegalFormatException("String cannot be parsed to create a parameter (check the syntax): " + Arrays.asList(result).toString());
                    }
                } else if (length == 2) {
                    object = new ParameterImpl(result[0], result[1]);
                } else if (length == 3) {
                    object = new ParameterImpl(result[0], result[1], result[2]);
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static List<Checksum> splitChecksums(String column) throws IllegalFormatException {
        ArrayList<Checksum> objects = new ArrayList<Checksum>();
        ChecksumImpl object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create a checksum (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length == 1) {
                    if (!result[0].equalsIgnoreCase("-")) {
                        throw new IllegalFormatException("String cannot be parsed to create a checksum (check the syntax): " + Arrays.asList(result).toString());
                    }
                } else if (length == 2) {
                    object = new ChecksumImpl(result[0], result[1]);
                } else {
                    throw new IllegalFormatException("String cannot be parsed to create a checksum (check the syntax): " + Arrays.asList(result).toString());
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static List<Integer> splitStoichiometries(String column) throws IllegalFormatException {
        ArrayList<Integer> objects = new ArrayList<Integer>();
        Integer object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create a stoichiometry (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length != 1) {
                    throw new IllegalFormatException("String cannot be parsed to create a stoichiometry (check the syntax): " + Arrays.asList(result).toString());
                }
                if (!result[0].equalsIgnoreCase("-")) {
                    object = new Integer(result[0]);
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static List<Feature> splitFeatures(String column) throws IllegalFormatException {
        ArrayList<Feature> objects = new ArrayList<Feature>();
        FeatureImpl object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create a feature (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length == 1) {
                    if (!result[0].equalsIgnoreCase("-")) {
                        String[] undeterminedRange = new String[]{"?-?"};
                        object = new FeatureImpl(result[0], Arrays.asList(undeterminedRange));
                    }
                } else if (length == 2) {
                    object = new FeatureImpl(result[0], Arrays.asList(result[1].split(",")));
                } else if (length == 3) {
                    object = new FeatureImpl(result[0], Arrays.asList(result[1].split(",")), result[2]);
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static List<Author> splitAuthor(String column) throws IllegalFormatException {
        ArrayList<Author> objects = new ArrayList<Author>();
        AuthorImpl object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create an author (check the syntax): " + Arrays.asList(result).toString());
                }
                if (!field.equalsIgnoreCase("-")) {
                    object = new AuthorImpl(field);
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static List<Date> splitDates(String column) throws IllegalFormatException {
        ArrayList<Date> objects = new ArrayList<Date>();
        Date object = null;
        if (column != null && !column.isEmpty()) {
            String[] fields;
            for (String field : fields = MitabParserUtils.quoteAwareSplit(column, new char[]{'|'}, false)) {
                String[] result;
                if (field == null || (result = MitabParserUtils.quoteAwareSplit(field, new char[]{':', '(', ')'}, true)) == null) continue;
                int length = result.length;
                if (length == 0 || length > 3) {
                    throw new IllegalFormatException("String cannot be parsed to create a date (check the syntax): " + Arrays.asList(result).toString());
                }
                if (length != 1) {
                    throw new IllegalFormatException("String cannot be parsed to create a date (check the syntax): " + result[0]);
                }
                try {
                    if (!result[0].equalsIgnoreCase("-")) {
                        object = new SimpleDateFormat("yyyy/MM/dd", Locale.ENGLISH).parse(result[0]);
                    }
                }
                catch (ParseException e) {
                    throw new IllegalFormatException("The date cannot be parsed to create a date (check the syntax): " + result[0]);
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    public static Boolean splitNegative(String column) throws IllegalFormatException {
        String[] result;
        boolean object = false;
        if (column != null && !column.isEmpty() && (result = MitabParserUtils.quoteAwareSplit(column, new char[]{':', '(', ')'}, true)) != null) {
            int length = result.length;
            if (length == 0 || length > 3) {
                throw new IllegalFormatException("String cannot be parsed to create a negative field (check the syntax): " + Arrays.asList(result).toString());
            }
            if (length != 1) {
                throw new IllegalFormatException("String cannot be parsed to create a negative field (check the syntax): " + Arrays.asList(result).toString());
            }
            if (!result[0].equalsIgnoreCase("-")) {
                object = Boolean.valueOf(result[0]);
            }
        }
        return object;
    }
}

