/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.xmlindex;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import psidev.psi.mi.xml.PsimiXmlReaderRuntimeException;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;
import psidev.psi.mi.xml.xmlindex.PsimiXmlExtractor;
import psidev.psi.mi.xml.xmlindex.PsimiXmlFileIndex;
import psidev.psi.mi.xml.xmlindex.PsimiXmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionIterator
implements Iterator<Interaction> {
    private File file;
    private Iterator<InputStreamRange> iterator;
    private PsimiXmlExtractor psimiXmlExtractor;
    private PsimiXmlPullParser psimiXmlPullParser;

    public InteractionIterator(PsimiXmlFileIndex index, List<InputStreamRange> ranges, File file, PsimiXmlPullParser psimiXmlPullParser) {
        if (index == null) {
            throw new IllegalArgumentException("You must give a non null PsimiXmlFileIndex");
        }
        if (ranges == null) {
            throw new IllegalArgumentException("You must give a non null List<InputStreamRange>");
        }
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null XML File");
        }
        if (psimiXmlPullParser == null) {
            throw new IllegalArgumentException("You must give a non null psimiXmlPullParser");
        }
        this.file = file;
        this.iterator = ranges.iterator();
        this.psimiXmlExtractor = new PsimiXmlExtractor(index, psimiXmlPullParser);
        this.psimiXmlPullParser = psimiXmlPullParser;
    }

    private Interaction getInteractionByRange(InputStreamRange range) {
        Interaction interaction2;
        try {
            FileInputStream fis = new FileInputStream(this.file);
            InputStream snippetStream = PsimiXmlExtractor.extractXmlSnippet(this.file, range);
            interaction2 = this.psimiXmlPullParser.parseInteraction(snippetStream);
            this.psimiXmlExtractor.resolveReferences(this.file, interaction2);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderRuntimeException("An error occured while parsing interaction", e);
        }
        return interaction2;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Interaction next() {
        InputStreamRange range = this.iterator.next();
        Interaction interaction2 = this.getInteractionByRange(range);
        this.psimiXmlExtractor.clearExperimentCache();
        return interaction2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Interaction iterator is read only, you cannot remove elements.");
    }
}

