/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.IDFetcher;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.converter.psi.PsiToBiopax3Converter;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.gsea.GSEAConverter;
import org.biopax.paxtools.io.sbgn.L3ToSBGNPDConverter;
import org.biopax.paxtools.io.sbgn.ListUbiqueDetector;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.NucleicAcidReference;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.normalizer.ConfigurableIDFetcher;
import org.biopax.paxtools.normalizer.Namespace;
import org.biopax.paxtools.normalizer.Resolver;
import org.biopax.paxtools.pattern.miner.BlacklistGenerator3;
import org.biopax.paxtools.pattern.miner.CustomFormat;
import org.biopax.paxtools.pattern.miner.Dialog;
import org.biopax.paxtools.pattern.miner.ExtendedSIFWriter;
import org.biopax.paxtools.pattern.miner.OutputColumn;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.biopax.paxtools.util.ClassFilterSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Commands {
    static final Logger log = LoggerFactory.getLogger(Commands.class);
    private static SimpleIOHandler io;
    static final ObjectMapper jacksonMaper;

    private Commands() {
        throw new UnsupportedOperationException("Non-instantiable utility class.");
    }

    static void toGSEA(String[] argv) throws IOException {
        boolean crossSpecies = false;
        boolean subPathways = false;
        boolean notPathways = false;
        HashSet<String> organisms = new HashSet<String>();
        if (argv.length < 4) {
            throw new IllegalArgumentException("Not enough arguments: " + String.valueOf(argv));
        }
        if (argv.length > 4) {
            for (int i = 4; i < argv.length; ++i) {
                if ("-crossSpecies".equalsIgnoreCase(argv[i])) {
                    crossSpecies = true;
                    continue;
                }
                if ("-subPathways".equalsIgnoreCase(argv[i])) {
                    subPathways = true;
                    continue;
                }
                if ("-notPathway".equalsIgnoreCase(argv[i])) {
                    notPathways = true;
                    continue;
                }
                if (!argv[i].startsWith("organisms=")) continue;
                for (String o : argv[i].substring(10).split(",")) {
                    organisms.add(o.trim().toLowerCase());
                }
            }
        }
        GSEAConverter gseaConverter = new GSEAConverter(argv[3], !crossSpecies, !subPathways);
        gseaConverter.setSkipOutsidePathways(!notPathways);
        gseaConverter.setAllowedOrganisms(organisms);
        gseaConverter.writeToGSEA(io.convertFromOWL(Commands.getInputStream(argv[1])), new FileOutputStream(argv[2]));
    }

    static void getNeighbors(String[] argv) throws IOException {
        String in = argv[1];
        String[] ids = argv[2].split(",");
        String out = argv[3];
        Model model = io.convertFromOWL(Commands.getInputStream(in));
        HashSet<BioPAXElement> elements = new HashSet<BioPAXElement>();
        for (String id : ids) {
            BioPAXElement e = model.getByID(id.toString());
            if (e != null && (e instanceof Entity || e instanceof entity)) {
                elements.add(e);
                continue;
            }
            log.warn("Source element not found: " + String.valueOf(id));
        }
        Set<BioPAXElement> result = QueryExecuter.runNeighborhood(elements, model, 1, Direction.BOTHSTREAM, new Filter[0]);
        Completer c = new Completer(io.getEditorMap());
        Cloner cln = new Cloner(io.getEditorMap(), io.getFactory());
        model = cln.clone(c.complete(result));
        if (model != null) {
            log.info("Elements in the result model: " + model.getObjects().size());
            io.convertToOWL(model, new FileOutputStream(out));
        } else {
            log.error("NULL model returned.");
        }
    }

    static void fetch(String[] argv) throws IOException {
        long start = System.currentTimeMillis();
        String in = argv[1];
        String out = argv[2];
        String[] uris = new String[]{};
        boolean absoluteUris = false;
        if (argv.length > 3) {
            for (int i = 3; i < argv.length; ++i) {
                String param = argv[i];
                if (param.startsWith("uris=")) {
                    uris = param.substring(5).split(",");
                    continue;
                }
                if (!param.startsWith("-absolute")) continue;
                absoluteUris = true;
            }
        }
        log.info("Loading the BioPAX model from " + in);
        Model model = io.convertFromOWL(Commands.getInputStream(in));
        log.info("Successfully loaded the BioPAX model. Writing to the output: " + out);
        SimpleIOHandler biopaxWriter = new SimpleIOHandler(model.getLevel());
        biopaxWriter.absoluteUris(absoluteUris);
        biopaxWriter.convertToOWL(model, new FileOutputStream(out), uris);
        long stop = System.currentTimeMillis();
        log.info(String.format("Done (in %d sec)", TimeUnit.MILLISECONDS.toSeconds(stop - start)));
    }

    static void toLevel3(String[] argv) throws IOException {
        String input = argv[1];
        String output = argv[2];
        boolean forcePsiInteractionToComplex = false;
        if (argv.length > 3) {
            for (int i = 3; i < argv.length; ++i) {
                String param = argv[i];
                if (!param.equalsIgnoreCase("-psimiToComplexes")) continue;
                forcePsiInteractionToComplex = true;
            }
        }
        Type type = Commands.detect(input);
        InputStream is = Commands.getInputStream(input);
        FileOutputStream os = new FileOutputStream(output);
        try {
            switch (type.ordinal()) {
                case 0: {
                    Model model = io.convertFromOWL(is);
                    model = new LevelUpgrader().filter(model);
                    if (model != null) {
                        io.setFactory(model.getLevel().getDefaultFactory());
                        io.convertToOWL(model, os);
                    }
                    break;
                }
                case 1: {
                    PsiToBiopax3Converter psimiConverter = new PsiToBiopax3Converter();
                    psimiConverter.convert(is, (OutputStream)os, forcePsiInteractionToComplex);
                    os.close();
                    break;
                }
                default: {
                    PsiToBiopax3Converter psimiConverter = new PsiToBiopax3Converter();
                    psimiConverter.convertTab(is, os, forcePsiInteractionToComplex);
                    os.close();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert " + input + "to BioPAX L3", e);
        }
    }

    private static Type detect(String input) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(Commands.getInputStream(input)));
            int linesToCheck = 20;
            while (linesToCheck-- > 0) {
                sb.append(reader.readLine()).append('\n');
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String buf = sb.toString();
        if (buf.contains("<rdf:RDF") && buf.contains("http://www.biopax.org/release/biopax")) {
            return Type.BIOPAX;
        }
        if (buf.contains("<entrySet") && buf.contains("/psidev")) {
            return Type.PSIMI;
        }
        return Type.PSIMITAB;
    }

    static void toSbgn(String[] argv) throws IOException {
        String input = argv[1];
        String output = argv[2];
        Model model = io.convertFromOWL(Commands.getInputStream(input));
        boolean doLayout = true;
        if (argv.length > 3) {
            for (int i = 3; i < argv.length; ++i) {
                String param = argv[i];
                if (!param.equalsIgnoreCase("-nolayout")) continue;
                doLayout = false;
                break;
            }
        }
        Blacklist blackList = null;
        File blacklistFile = new File("blacklist.txt");
        if (blacklistFile.exists()) {
            log.info("toSBGN: using blacklist.txt from current directory");
            blackList = new Blacklist(new FileInputStream(blacklistFile));
        } else {
            log.info("toSBGN: not blacklisting any ubiquitous molecules (no blacklist.txt found)");
        }
        ListUbiqueDetector ubd = blackList != null ? new ListUbiqueDetector(blackList.getListed()) : null;
        L3ToSBGNPDConverter l3ToSBGNPDConverter = new L3ToSBGNPDConverter(ubd, null, doLayout);
        l3ToSBGNPDConverter.writeSBGN(model, output);
    }

    static void toSifnx(String[] argv) throws IOException {
        boolean extended = false;
        boolean andSif = false;
        boolean mergeInteractions = true;
        boolean useNameIfNoId = false;
        HashSet<SIFEnum> include = new HashSet<SIFEnum>();
        HashSet<SIFEnum> exclude = new HashSet<SIFEnum>();
        ConfigurableIDFetcher idFetcher = new ConfigurableIDFetcher();
        ArrayList<String> customFieldList = new ArrayList<String>();
        if (argv.length > 3) {
            for (int i = 3; i < argv.length; ++i) {
                String param = argv[i];
                if (param.startsWith("seqDb=")) {
                    for (String db : param.substring(6).split(",")) {
                        idFetcher.seqDbStartsWithOrEquals(db);
                    }
                    continue;
                }
                if (param.startsWith("chemDb=")) {
                    for (String db : param.substring(7).split(",")) {
                        idFetcher.chemDbStartsWithOrEquals(db);
                    }
                    continue;
                }
                if (param.equalsIgnoreCase("-andSif")) {
                    andSif = true;
                    continue;
                }
                if (param.equalsIgnoreCase("-extended")) {
                    extended = true;
                    continue;
                }
                if (param.equalsIgnoreCase("-dontMergeInteractions")) {
                    mergeInteractions = false;
                    continue;
                }
                if (param.equalsIgnoreCase("-useNameIfNoId")) {
                    useNameIfNoId = true;
                    continue;
                }
                if (param.startsWith("include=")) {
                    for (String t : param.substring(8).split(",")) {
                        include.add(SIFEnum.valueOf(t.toUpperCase()));
                    }
                    continue;
                }
                if (param.startsWith("exclude=")) {
                    for (String t : param.substring(8).split(",")) {
                        exclude.add(SIFEnum.valueOf(t.toUpperCase()));
                    }
                    continue;
                }
                Object type = OutputColumn.Type.getType(param.toUpperCase());
                if ((type == null || type == OutputColumn.Type.CUSTOM) && !param.contains("/")) continue;
                if (!param.contains("/")) {
                    customFieldList.add(param.toUpperCase());
                    continue;
                }
                customFieldList.add(param);
            }
        }
        if (idFetcher.getChemDbStartsWithOrEquals().isEmpty()) {
            idFetcher.chemDbStartsWithOrEquals("chebi");
        }
        if (idFetcher.getSeqDbStartsWithOrEquals().isEmpty()) {
            idFetcher.chemDbStartsWithOrEquals("hgnc");
        }
        idFetcher.useNameWhenNoDbMatch(useNameIfNoId);
        Model model = Commands.getModel(io, argv[1]);
        if (mergeInteractions) {
            ModelUtils.mergeEquivalentInteractions(model);
        }
        HashSet<SIFEnum> sifTypes = include.isEmpty() ? new HashSet<SIFEnum>(Arrays.asList(SIFEnum.values())) : include;
        for (SIFType sIFType : exclude) {
            sifTypes.remove(sIFType);
        }
        SIFSearcher searcher = new SIFSearcher((IDFetcher)idFetcher, (SIFType[])sifTypes.toArray(new SIFEnum[0]));
        log.info("toSIF: using SIFTypes: " + String.valueOf(sifTypes));
        String string = System.getProperty("paxtools.pattern.blacklist", "blacklist.txt");
        File blacklistFile = new File(string);
        if (blacklistFile.exists()) {
            log.info("toSIF: using blacklist.txt from current directory");
            searcher.setBlacklist(new Blacklist(new FileInputStream(blacklistFile)));
        } else {
            log.info("toSIF: not blacklisting ubiquitous molecules (no blacklist.txt found)");
        }
        File outputFile = new File(argv[2]);
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        if (extended) {
            Set<SIFInteraction> binaryInts = searcher.searchSIF(model);
            ExtendedSIFWriter.write(binaryInts, outputStream);
        } else if (customFieldList.isEmpty()) {
            searcher.searchSIF(model, outputStream);
        } else {
            log.info("toSIF: using custom fields (extra columns): " + String.valueOf(customFieldList));
            searcher.searchSIF(model, outputStream, new CustomFormat(customFieldList.toArray(new String[0])));
        }
        if (extended && andSif) {
            Commands.sifnxToSif(outputFile.getPath(), outputFile.getPath() + ".sif");
        }
        log.info("toSIF: done.");
    }

    static void sifnxToSif(String inputFile, String outputFile) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(Commands.getInputStream(inputFile)));
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(outputFile));
        if (reader.ready()) {
            reader.readLine();
        }
        while (reader.ready() && (line = reader.readLine()) != null && !line.isEmpty()) {
            writer.write(StringUtils.join((Object[])Arrays.copyOfRange(line.split("\t", 4), 0, 3), '\t') + "\n");
        }
        reader.close();
        writer.close();
    }

    static void merge(String[] argv) throws IOException {
        Model model1 = Commands.getModel(io, argv[1]);
        Model model2 = Commands.getModel(io, argv[2]);
        Merger merger = new Merger(SimpleEditorMap.get(model1.getLevel()));
        merger.merge(model1, model2);
        io.setFactory(model1.getLevel().getDefaultFactory());
        io.convertToOWL(model1, new FileOutputStream(argv[3]));
    }

    static void blacklist(String[] argv) throws IOException {
        Model model = Commands.getModel(io, argv[1]);
        BlacklistGenerator3 gen = new BlacklistGenerator3();
        Blacklist blacklist = gen.generateBlacklist(model);
        blacklist.write(new FileOutputStream(argv[2]));
    }

    static void pattern(String[] argv) {
        Dialog.main(argv);
    }

    private static Model getModel(BioPAXIOHandler io, String fName) throws IOException {
        return io.convertFromOWL(Commands.getInputStream(fName));
    }

    static void summarize(String[] argv) throws IOException {
        log.debug("Importing the input model from " + argv[1] + "...");
        Model model = Commands.getModel(io, argv[1]);
        PrintStream out = new PrintStream(argv[2]);
        if (argv.length > 3) {
            for (int i = 3; i < argv.length; ++i) {
                if (argv[i].equals("--model")) {
                    Commands.summarize(model, out);
                    continue;
                }
                if (argv[i].equals("--pathways")) {
                    Commands.summarizePathways(model, out);
                    continue;
                }
                if (argv[i].equals("--hgnc-ids")) {
                    Commands.summarizeHgncIds(model, out);
                    continue;
                }
                if (argv[i].equals("--uniprot-ids")) {
                    Commands.summarizeUniprotIds(model, out);
                    continue;
                }
                if (argv[i].equals("--chebi-ids")) {
                    Commands.summarizeChebiIds(model, out);
                    continue;
                }
                if (!argv[i].equals("--uri-ids")) continue;
                Commands.mapUriToIds(model, out);
            }
        } else {
            Commands.summarize(model, out);
        }
        out.close();
    }

    static void mapUriToIds(Model model, PrintStream out) throws IOException {
        ArrayNode elements = jacksonMaper.createArrayNode();
        for (PhysicalEntity pe : model.getObjects(PhysicalEntity.class)) {
            ObjectNode jo = jacksonMaper.createObjectNode();
            jo.put("uri", pe.getUri());
            jo.put("type", pe.getModelInterface().getSimpleName());
            jo.put("generic", ModelUtils.isGeneric(pe));
            jo.put("label", pe.getDisplayName());
            ArrayNode ja = jo.putArray("name");
            pe.getName().forEach(ja::add);
            if (!(pe instanceof SmallMolecule)) {
                ja = jo.putArray("hgnc.symbol");
                Commands.identifiers(pe, "hgnc.symbol", false, false).forEach(ja::add);
                ja = jo.putArray("uniprot");
                Commands.identifiers(pe, "uniprot", true, false).forEach(ja::add);
            }
            if (pe instanceof SmallMolecule || PhysicalEntity.class.equals(pe.getModelInterface())) {
                ja = jo.putArray("chebi");
                Commands.identifiers(pe, "chebi", false, false).forEach(ja::add);
            }
            ja = jacksonMaper.createArrayNode();
            for (BioSource bs : ModelUtils.getOrganisms(pe)) {
                ja.add(bs.getDisplayName());
            }
            jo.put("organism", ja);
            ja = jacksonMaper.createArrayNode();
            for (Provenance ds : pe.getDataSource()) {
                ja.add(ds.getDisplayName());
            }
            jo.put("datasource", ja);
            elements.add(jo);
        }
        jacksonMaper.writeValue(out, (Object)elements);
    }

    static Set<String> identifiers(PhysicalEntity entity2, String xrefdb, boolean isPrefix, boolean includeEvidence) {
        HashSet<String> ids = new HashSet<String>();
        Fetcher fetcher = includeEvidence ? new Fetcher(SimpleEditorMap.L3, Fetcher.nextStepFilter) : new Fetcher(SimpleEditorMap.L3, Fetcher.nextStepFilter, Fetcher.evidenceFilter);
        fetcher.setSkipSubPathways(true);
        Set<XReferrable> children = fetcher.fetch((BioPAXElement)entity2, XReferrable.class);
        children.add(entity2);
        for (XReferrable child : children) {
            if (!(child instanceof PhysicalEntity) && !(child instanceof EntityReference) && !(child instanceof Gene)) continue;
            for (Xref x : child.getXref()) {
                if (x.getId() == null || x.getDb() == null) continue;
                String name = x.getDb();
                String prefix = "";
                String banana = "";
                String peel = "";
                if (Resolver.isKnownNameOrVariant(name)) {
                    Namespace ns = Resolver.getNamespace(name);
                    prefix = ns.getPrefix();
                    banana = ns.getBanana();
                    peel = ns.getBanana_peel();
                    name = ns.getName();
                }
                boolean bl = isPrefix ? StringUtils.startsWithIgnoreCase(name, xrefdb) || StringUtils.startsWithIgnoreCase(prefix, xrefdb) || StringUtils.startsWithIgnoreCase(x.getDb(), xrefdb) : StringUtils.equalsIgnoreCase(name, xrefdb) || StringUtils.equalsIgnoreCase(prefix, xrefdb) || StringUtils.equalsIgnoreCase(x.getDb(), xrefdb);
                boolean matches = bl;
                if (!matches) continue;
                String id = x.getId();
                if (StringUtils.isNotEmpty(banana)) {
                    id = StringUtils.startsWith(id, banana + peel) ? id : banana + peel + id;
                }
                ids.add(id);
            }
        }
        return ids;
    }

    static void summarizePathways(Model model, PrintStream out) {
        PathAccessor directChildPathwaysAccessor = new PathAccessor("Pathway/pathwayComponent:Pathway");
        PathAccessor pathwayComponentAccessor = new PathAccessor("Pathway/pathwayComponent");
        PathAccessor pathwayOrderStepProcessAccessor = new PathAccessor("Pathway/pathwayOrder/stepProcess");
        Set<Pathway> pathways = model.getObjects(Pathway.class);
        out.println("PATHWAY_URI\tDISPLAY_NAME\tDIRECT_SUB_PATHWAY_URIS\tALL_SUB_PATHWAY_URIS");
        for (Pathway pathway2 : pathways) {
            Pathway p;
            Object o2;
            StringBuilder sb = new StringBuilder();
            sb.append(pathway2.getUri()).append('\t').append(pathway2.getDisplayName()).append('\t');
            for (Object o2 : directChildPathwaysAccessor.getValueFromBean(pathway2)) {
                p = (Pathway)o2;
                sb.append(p.getUri()).append(";");
            }
            sb.append("\t");
            Fetcher fetcher = new Fetcher(SimpleEditorMap.L3, Fetcher.nextStepFilter);
            o2 = fetcher.fetch((BioPAXElement)pathway2, Pathway.class).iterator();
            while (o2.hasNext()) {
                p = (Pathway)o2.next();
                sb.append(p.getUri()).append(";");
            }
            out.println(sb);
        }
        out.println("\nPATHWAY_URI\tDATASOURCE\tDISPLAY_NAME\tALL_NAMES\tNUM_DIRECT_COMPONENT_OR_STEP_PROCESSES");
        for (Pathway pathway2 : pathways) {
            int size = pathwayComponentAccessor.getValueFromBean(pathway2).size() + pathwayOrderStepProcessAccessor.getValueFromBean(pathway2).size();
            String datasource = pathway2.getDataSource().iterator().next().getDisplayName();
            StringBuilder sb = new StringBuilder();
            sb.append(pathway2.getUri()).append('\t').append(datasource).append('\t').append(pathway2.getDisplayName()).append('\t');
            for (String name : pathway2.getName()) {
                sb.append('\"').append(name).append('\"').append(";");
            }
            sb.append('\t').append(size);
            out.println(sb);
        }
    }

    static void summarizeHgncIds(Model model, PrintStream out) {
        PathAccessor pa = new PathAccessor("EntityReference/entityReferenceOf/dataSource", model.getLevel());
        HashMap<Provenance, MutableInt> numErs = new HashMap<Provenance, MutableInt>();
        HashMap<Provenance, MutableInt> numProblematicErs = new HashMap<Provenance, MutableInt>();
        HashSet<SequenceEntityReference> haveMultipleHgnc = new HashSet<SequenceEntityReference>();
        TreeSet<String> problemErs = new TreeSet<String>();
        for (SequenceEntityReference ser : model.getObjects(SequenceEntityReference.class)) {
            if (!ser.getMemberEntityReference().isEmpty()) continue;
            HashSet<String> hgncSymbols = new HashSet<String>();
            HashSet<String> hgncIds = new HashSet<String>();
            for (Xref xref2 : ser.getXref()) {
                if (xref2 instanceof PublicationXref || StringUtils.isBlank(xref2.getDb()) || StringUtils.isBlank(xref2.getId()) || !StringUtils.startsWithIgnoreCase(xref2.getDb(), "hgnc")) continue;
                String id = xref2.getId().toLowerCase();
                if (StringUtils.startsWithIgnoreCase(id, "hgnc:") || StringUtils.isNumeric(id)) {
                    hgncIds.add(id);
                    continue;
                }
                hgncSymbols.add(id);
            }
            if (hgncIds.size() > 1 || hgncSymbols.size() > 1) {
                haveMultipleHgnc.add(ser);
            }
            String uri = ser.getUri();
            for (Object provenance : pa.getValueFromBean(ser)) {
                MutableInt tot;
                if (!(StringUtils.containsIgnoreCase(uri, "identifiers.org/hgnc") || StringUtils.containsIgnoreCase(uri, "bioregistry.io/hgnc") || StringUtils.containsIgnoreCase(ser.getXref().toString(), "hgnc"))) {
                    problemErs.add(String.format("%s\t%s\t%s", ((Provenance)provenance).getDisplayName(), ser.getDisplayName(), uri));
                    MutableInt n = (MutableInt)numProblematicErs.get(provenance);
                    if (n == null) {
                        numProblematicErs.put((Provenance)provenance, new MutableInt(1));
                    } else {
                        n.increment();
                    }
                }
                if ((tot = (MutableInt)numErs.get(provenance)) == null) {
                    numErs.put((Provenance)provenance, new MutableInt(1));
                    continue;
                }
                tot.increment();
            }
        }
        out.println("\nNumber of SequenceEntityReferences (non-generic) without any HGNC Symbol: " + problemErs.size());
        for (String line : problemErs) {
            out.println(line);
        }
        out.println("Number of SequenceEntityReferences (non-generic) having multiple HGNC Symbols: " + haveMultipleHgnc.size());
        for (SequenceEntityReference r : haveMultipleHgnc) {
            out.println(r.getUri());
        }
        out.println("Number of SequenceEntityReferences (non-generic) without any HGNC ID/Symbol, by data source:");
        int totalPrs = 0;
        int numPrsNoHgnc = 0;
        for (Provenance ds : numProblematicErs.keySet()) {
            int n = ((MutableInt)numProblematicErs.get(ds)).intValue();
            numPrsNoHgnc += n;
            int n2 = ((MutableInt)numErs.get(ds)).intValue();
            totalPrs += n2;
            out.println(String.format("%s\t\t%d\t(%3.1f%%)", ds.getUri(), n, Float.valueOf((float)n / (float)n2 * 100.0f)));
        }
        out.println(String.format("Total\t\t%d\t(%3.1f%%)", numPrsNoHgnc, Float.valueOf((float)numPrsNoHgnc / (float)totalPrs * 100.0f)));
    }

    static void summarizeUniprotIds(Model model, PrintStream out) {
        HashMap<Provenance, MutableInt> numErs = new HashMap<Provenance, MutableInt>();
        HashMap<Provenance, MutableInt> numProblematicErs = new HashMap<Provenance, MutableInt>();
        PathAccessor pa = new PathAccessor("EntityReference/entityReferenceOf:Protein/dataSource", model.getLevel());
        TreeSet<String> problemErs = new TreeSet<String>();
        for (ProteinReference pr : model.getObjects(ProteinReference.class)) {
            if (!pr.getMemberEntityReference().isEmpty()) continue;
            String uri = pr.getUri();
            for (Object provenance : pa.getValueFromBean(pr)) {
                MutableInt tot;
                if (!(StringUtils.containsIgnoreCase(uri, "identifiers.org/uniprot") || StringUtils.containsIgnoreCase(uri, "bioregistry.io/uniprot") || StringUtils.containsIgnoreCase(pr.getXref().toString(), "uniprot"))) {
                    problemErs.add(String.format("%s\t%s\t%s", ((Provenance)provenance).getDisplayName(), pr.getDisplayName(), uri));
                    MutableInt n = (MutableInt)numProblematicErs.get(provenance);
                    if (n == null) {
                        numProblematicErs.put((Provenance)provenance, new MutableInt(1));
                    } else {
                        n.increment();
                    }
                }
                if ((tot = (MutableInt)numErs.get(provenance)) == null) {
                    numErs.put((Provenance)provenance, new MutableInt(1));
                    continue;
                }
                tot.increment();
            }
        }
        out.println("\nNumber of ProteinReferences (non-generic) without any Uniprot AC:" + problemErs.size());
        for (String line : problemErs) {
            out.println(line);
        }
        out.println("Number of ProteinReferences (non-generic) without any Uniprot AC, by data source:");
        int totalErs = 0;
        int problematicErs = 0;
        for (Provenance ds : numProblematicErs.keySet()) {
            int n = ((MutableInt)numProblematicErs.get(ds)).intValue();
            problematicErs += n;
            int t = ((MutableInt)numErs.get(ds)).intValue();
            totalErs += t;
            out.println(String.format("%s\t\t%d\t(%3.1f%%)", ds.getUri(), n, Float.valueOf((float)n / (float)t * 100.0f)));
        }
        out.println(String.format("Total\t\t%d\t(%3.1f%%)", problematicErs, Float.valueOf((float)problematicErs / (float)totalErs * 100.0f)));
    }

    static void summarizeChebiIds(Model model, PrintStream out) {
        HashMap<Provenance, MutableInt> numErs = new HashMap<Provenance, MutableInt>();
        HashMap<Provenance, MutableInt> numProblematicErs = new HashMap<Provenance, MutableInt>();
        PathAccessor pa = new PathAccessor("EntityReference/entityReferenceOf:SmallMolecule/dataSource", model.getLevel());
        TreeSet<String> problemErs = new TreeSet<String>();
        for (SmallMoleculeReference smr : model.getObjects(SmallMoleculeReference.class)) {
            if (!smr.getMemberEntityReference().isEmpty()) continue;
            String uri = smr.getUri();
            for (Object provenance : pa.getValueFromBean(smr)) {
                MutableInt tot;
                if (!(StringUtils.containsIgnoreCase(uri, "identifiers.org/chebi") || StringUtils.containsIgnoreCase(uri, "bioregistry.io/chebi") || StringUtils.containsIgnoreCase(smr.getXref().toString(), "chebi"))) {
                    problemErs.add(String.format("%s\t%s\t%s", ((Provenance)provenance).getDisplayName(), smr.getDisplayName(), uri));
                    MutableInt n = (MutableInt)numProblematicErs.get(provenance);
                    if (n == null) {
                        numProblematicErs.put((Provenance)provenance, new MutableInt(1));
                    } else {
                        n.increment();
                    }
                }
                if ((tot = (MutableInt)numErs.get(provenance)) == null) {
                    numErs.put((Provenance)provenance, new MutableInt(1));
                    continue;
                }
                tot.increment();
            }
        }
        out.println("\nNumber of SmallMoleculeReferences (non-generic) without any ChEBI ID:" + problemErs.size());
        for (String line : problemErs) {
            out.println(line);
        }
        out.println("Number of SmallMoleculeReferences (non-generic) without any ChEBI ID, by data source:");
        int totalSmrs = 0;
        int numSmrsNoChebi = 0;
        for (Provenance ds : numProblematicErs.keySet()) {
            int n = ((MutableInt)numProblematicErs.get(ds)).intValue();
            numSmrsNoChebi += n;
            int t = ((MutableInt)numErs.get(ds)).intValue();
            totalSmrs += t;
            out.println(String.format("%s\t\t%d\t(%3.1f%%)", ds.getUri(), n, Float.valueOf((float)n / (float)t * 100.0f)));
        }
        out.println(String.format("Total\t\t%d\t(%3.1f%%)", numSmrsNoChebi, Float.valueOf((float)numSmrsNoChebi / (float)totalSmrs * 100.0f)));
    }

    /*
     * WARNING - void declaration
     */
    static void summarize(Model model, PrintStream out) throws IOException {
        void var14_27;
        String[] stringArray;
        BioPAXLevel level = model.getLevel();
        ObjectNode summary = jacksonMaper.createObjectNode();
        summary.put("xml:base", model.getXmlBase());
        summary.put("level", level.name());
        ArrayNode types = summary.putArray("types");
        SimpleEditorMap em = SimpleEditorMap.get(level);
        for (Class<? extends BioPAXElement> clazz : Commands.sortToName(em.getKnownSubClassesOf(BioPAXElement.class))) {
            Set<? extends BioPAXElement> allInstancesOfClass;
            int numInstances;
            if (!level.getDefaultFactory().canInstantiate(clazz) || (numInstances = (allInstancesOfClass = model.getObjects(clazz)).size()) <= 0) continue;
            ObjectNode type = types.addObject();
            type.put("type", clazz.getSimpleName());
            Collection<BioPAXElement> directInstances = Commands.filterToExactClass(allInstancesOfClass, clazz);
            int numDirectInstances = directInstances.size();
            type.put("instances", numInstances);
            type.put("direct_instances", numDirectInstances);
            for (PropertyEditor propertyEditor : em.getEditorsOf(clazz)) {
                Object val222;
                Method getMethod = propertyEditor.getGetMethod();
                Class<?> returnType = getMethod.getReturnType();
                HashMap<Object, Integer> cnt = new HashMap<Object, Integer>();
                if (returnType.isEnum() || Commands.implementsInterface(returnType, ControlledVocabulary.class) || Commands.implementsInterface(propertyEditor.getRange(), ControlledVocabulary.class)) {
                    for (BioPAXElement ele : directInstances) {
                        Set values = propertyEditor.getValueFromBean(ele);
                        if (values.isEmpty()) continue;
                        for (Object val222 : values) {
                            Commands.increaseCnt(cnt, val222);
                        }
                    }
                }
                if (cnt.isEmpty()) continue;
                ArrayNode props = type.putArray("cv_enum_props");
                ObjectNode p = props.addObject();
                p.put("prop", propertyEditor.getProperty());
                ObjectNode vals = p.putObject("values_to_str");
                String name = returnType.equals(Set.class) ? propertyEditor.getRange().getSimpleName() : returnType.getSimpleName();
                p.put("range", name);
                val222 = cnt.keySet().iterator();
                while (val222.hasNext()) {
                    Object key = val222.next();
                    vals.put(key.toString(), (Integer)cnt.get(key));
                }
            }
        }
        ArrayNode properties = summary.putArray("properties");
        if (model.getLevel() == BioPAXLevel.L3) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "UnificationXref/db";
            stringArray = stringArray2;
            stringArray2[1] = "RelationshipXref/db";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "unificationXref/DB";
            stringArray = stringArray3;
            stringArray3[1] = "relationshipXref/DB";
        }
        String[] propPaths = stringArray;
        TreeSet<String> cnt = new TreeSet<String>();
        for (String pPath : propPaths) {
            PathAccessor acc = new PathAccessor(pPath, model.getLevel());
            for (Object o : acc.getValueFromModel(model)) {
                cnt.add(o.toString());
            }
        }
        if (!cnt.isEmpty()) {
            ObjectNode p = properties.addObject();
            p.put("name", "xref.db");
            ArrayNode v = p.putArray("values");
            cnt.forEach(v::add);
            p.put("unique_values", cnt.size());
        }
        int speLackingEr = 0;
        int genericSpeLackingEr = 0;
        int speLackingErAndId = 0;
        int protLackingErAndId = 0;
        int molLackingErAndId = 0;
        boolean bl = false;
        TreeMap<Object, Integer> numSpeLackErByProvider = new TreeMap<Object, Integer>();
        for (SimplePhysicalEntity spe : model.getObjects(SimplePhysicalEntity.class)) {
            Object providers;
            Integer n;
            if (spe.getEntityReference() != null) continue;
            ++speLackingEr;
            if (!spe.getMemberPhysicalEntity().isEmpty()) {
                ++genericSpeLackingEr;
            }
            n = (n = (Integer)numSpeLackErByProvider.get(providers = spe.getDataSource().toString())) == null ? 1 : n + 1;
            numSpeLackErByProvider.put(providers, n);
            if (!spe.getXref().isEmpty() && new ClassFilterSet<Xref, PublicationXref>(spe.getXref(), PublicationXref.class).size() != spe.getXref().size()) continue;
            ++speLackingErAndId;
            if (spe instanceof Protein) {
                ++protLackingErAndId;
                continue;
            }
            if (spe instanceof SmallMolecule) {
                ++molLackingErAndId;
                continue;
            }
            if (!(spe instanceof NucleicAcid)) continue;
            ++var14_27;
        }
        ObjectNode speSummary = summary.putObject("spe_without_er");
        speSummary.put("description", "SimplePEs (not complexes) that do not have any entityReference");
        speSummary.put("total", speLackingEr);
        speSummary.put("generic", genericSpeLackingEr);
        ObjectNode speByDs = speSummary.putObject("by_source");
        for (Object key : numSpeLackErByProvider.keySet()) {
            speByDs.put((String)key, (Integer)numSpeLackErByProvider.get(key));
        }
        if (speLackingErAndId > 0) {
            ObjectNode speNoErNoId = speSummary.putObject("also_without_id");
            speNoErNoId.put("total", speLackingErAndId);
            speNoErNoId.put("proteins", protLackingErAndId);
            speNoErNoId.put("small_molecules", molLackingErAndId);
            speNoErNoId.put("nucl_acids", (int)var14_27);
        }
        int erLackingXref = 0;
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            if (!er.getMemberEntityReference().isEmpty() || !er.getXref().isEmpty() && new ClassFilterSet<Xref, PublicationXref>(er.getXref(), PublicationXref.class).size() != er.getXref().size()) continue;
            ++erLackingXref;
        }
        summary.put("nongeneric_er_without_xref", erLackingXref);
        int genesLackingOrganism = 0;
        int pwLackingOrganism = 0;
        int serLackingOrganism = 0;
        int narLackingOrganism = 0;
        for (BioPAXElement bpe : model.getObjects()) {
            if (bpe instanceof Gene && ((Gene)bpe).getOrganism() == null) {
                ++genesLackingOrganism;
                continue;
            }
            if (bpe instanceof Pathway && ((Pathway)bpe).getOrganism() == null) {
                ++pwLackingOrganism;
                continue;
            }
            if (!(bpe instanceof SequenceEntityReference) || ((SequenceEntityReference)bpe).getOrganism() != null) continue;
            ++serLackingOrganism;
            if (!(bpe instanceof NucleicAcidReference)) continue;
            ++narLackingOrganism;
        }
        ObjectNode noOrg = summary.putObject("without_organism");
        noOrg.put("genes", genesLackingOrganism);
        noOrg.put("pathways", pwLackingOrganism);
        noOrg.put("seq_er", serLackingOrganism);
        noOrg.put("nucleic_acid_refs", narLackingOrganism);
        noOrg.put("protein_refs", serLackingOrganism - narLackingOrganism);
        int badUXrefs = 0;
        for (Xref x : model.getObjects(Xref.class)) {
            if (x instanceof PublicationXref || !StringUtils.isBlank(x.getId()) && !StringUtils.isBlank(x.getDb())) continue;
            ++badUXrefs;
        }
        summary.put("uxrx_without_dbid", badUXrefs);
        jacksonMaper.writeValue(out, (Object)summary);
    }

    private static List<Class<? extends BioPAXElement>> sortToName(Set<? extends Class<? extends BioPAXElement>> classes) {
        ArrayList<Class<? extends BioPAXElement>> list = new ArrayList<Class<? extends BioPAXElement>>(classes);
        Collections.sort(list, Comparator.comparing(clazz -> clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1)));
        return list;
    }

    private static Collection<BioPAXElement> filterToExactClass(Collection<? extends BioPAXElement> classSet, Class<?> clazz) {
        HashSet<BioPAXElement> exact = new HashSet<BioPAXElement>();
        for (BioPAXElement bioPAXElement : classSet) {
            if (!bioPAXElement.getModelInterface().equals(clazz)) continue;
            exact.add(bioPAXElement);
        }
        return exact;
    }

    private static boolean implementsInterface(Class clazz, Class inter) {
        for (Class<?> anInter : clazz.getInterfaces()) {
            if (!anInter.equals(inter)) continue;
            return true;
        }
        return false;
    }

    private static void increaseCnt(Map<Object, Integer> cnt, Object key) {
        if (!cnt.containsKey(key)) {
            cnt.put(key, 0);
        }
        cnt.put(key, cnt.get(key) + 1);
    }

    private static InputStream getInputStream(String path) throws IOException {
        FileInputStream is = new FileInputStream(path);
        return path.endsWith(".gz") ? new GZIPInputStream(is) : is;
    }

    static {
        jacksonMaper = new ObjectMapper().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.FLUSH_AFTER_WRITE_VALUE, true).configure(SerializationFeature.INDENT_OUTPUT, true).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        io = new SimpleIOHandler();
        io.mergeDuplicates(true);
    }

    private static enum Type {
        BIOPAX,
        PSIMI,
        PSIMITAB;

    }
}

