/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Collection;
import java.util.HashSet;
import org.biopax.paxtools.controller.AbstractPropertyEditor;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cloner
implements Visitor {
    private static final Logger LOG = LoggerFactory.getLogger(Cloner.class);
    private final Traverser traverser;
    private final BioPAXFactory factory;

    public Cloner(EditorMap map, BioPAXFactory factory) {
        this.factory = factory;
        this.traverser = new Traverser(map, this, new Filter[0]);
    }

    public Model clone(Collection<BioPAXElement> toBeCloned) {
        Model targetModel = this.factory.createModel();
        for (BioPAXElement bpe : new HashSet<BioPAXElement>(toBeCloned)) {
            targetModel.addNew(bpe.getModelInterface(), bpe.getUri());
        }
        AbstractPropertyEditor.checkRestrictions.set(false);
        for (BioPAXElement bpe : toBeCloned) {
            this.traverser.traverse(bpe, targetModel);
        }
        AbstractPropertyEditor.checkRestrictions.set(true);
        return targetModel;
    }

    public void visit(BioPAXElement domain, Object range, Model targetModel, PropertyEditor editor) {
        BioPAXElement targetDomain = targetModel.getByID(domain.getUri());
        if (range instanceof BioPAXElement) {
            BioPAXElement bpe = (BioPAXElement)range;
            BioPAXElement existing = targetModel.getByID(bpe.getUri());
            if (existing != null) {
                editor.setValueToBean(existing, targetDomain);
            }
        } else {
            editor.setValueToBean(range, targetDomain);
        }
    }
}

