/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.PropertyFilterBilinked;
import org.biopax.paxtools.controller.TraverserBilinked;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.pathway;
import org.biopax.paxtools.model.level3.Pathway;

public class Completer
implements Visitor {
    protected TraverserBilinked traverser;
    private final Set<BioPAXElement> completed;
    private boolean skipSubPathways;

    public Completer(EditorMap map) {
        this.traverser = new TraverserBilinked(map, (Visitor)this, new PropertyFilterBilinked(){

            @Override
            public boolean filter(PropertyEditor editor) {
                return editor instanceof ObjectPropertyEditor && ((ObjectPropertyEditor)editor).isCompleteForward();
            }

            @Override
            public boolean filterInverse(PropertyEditor editor) {
                return editor instanceof ObjectPropertyEditor && ((ObjectPropertyEditor)editor).isCompleteBackward();
            }
        });
        this.completed = new HashSet<BioPAXElement>();
        this.skipSubPathways = true;
    }

    public Set<BioPAXElement> complete(Collection<BioPAXElement> elements) {
        this.completed.clear();
        for (BioPAXElement element : elements) {
            if (!this.completed.add(element)) continue;
            this.traverser.traverse(element, (Model)null);
        }
        return this.completed;
    }

    public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
        BioPAXElement element;
        if (range instanceof BioPAXElement && !this.completed.contains(element = (BioPAXElement)range)) {
            this.completed.add(element);
            if (!this.skipSubPathways || !(element instanceof Pathway) && !(element instanceof pathway)) {
                this.traverser.traverse(element, (Model)null);
            }
        }
    }

    public void setSkipSubPathways(boolean skipSubPathways) {
        this.skipSubPathways = skipSubPathways;
    }

    public boolean isSkipSubPathways() {
        return this.skipSubPathways;
    }
}

