/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.DataPropertyEditor;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.PropertyFilterBilinked;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.TraverserBilinked;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.impl.BioPAXElementImpl;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaReference;
import org.biopax.paxtools.model.level3.DnaRegion;
import org.biopax.paxtools.model.level3.DnaRegionReference;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.Observable;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaReference;
import org.biopax.paxtools.model.level3.RnaRegion;
import org.biopax.paxtools.model.level3.RnaRegionReference;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.UtilityClass;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.EquivalenceGrouper;
import org.biopax.paxtools.util.Filter;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ModelUtils.class);
    static final MessageDigest MD5_DIGEST;
    private static final BioPAXFactory factory;
    private static final EditorMap em;
    private static final SimpleIOHandler io;
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int BASE;

    ModelUtils() {
        throw new AssertionError((Object)"Not instantiable");
    }

    public static void replace(Model model, Map<? extends BioPAXElement, ? extends BioPAXElement> subs) {
        if (subs == null || subs.isEmpty()) {
            return;
        }
        Visitor visitor = (domain, range, bpModel, propertyEditor) -> {
            if (propertyEditor instanceof ObjectPropertyEditor && range != null && subs.containsKey(range)) {
                ObjectPropertyEditor editor = (ObjectPropertyEditor)propertyEditor;
                BioPAXElement value = (BioPAXElement)range;
                BioPAXElement replacement = (BioPAXElement)subs.get(range);
                if (replacement != null && !editor.getRange().isInstance(replacement)) {
                    throw new IllegalBioPAXArgumentException("Incompatible type! Attempted to replace " + value.getUri() + " (" + value.getModelInterface().getSimpleName() + ") with " + replacement.getUri() + " (" + replacement.getModelInterface().getSimpleName() + "); property: " + editor.getProperty() + " of bean: " + domain.getUri() + " (" + domain.getModelInterface().getSimpleName() + ")");
                }
                if (replacement != value) {
                    editor.removeValueFromBean(value, domain);
                    editor.setValueToBean(replacement, domain);
                } else {
                    LOG.debug("replace: skipped the identical: " + replacement.getUri());
                }
            }
        };
        Traverser traverser = new Traverser(em, visitor, new Filter[0]);
        model.getObjects().stream().forEach(bpe -> traverser.traverse(bpe, null));
    }

    public static <T extends BioPAXElement> Set<T> getRootElements(Model model, Class<T> filterClass) {
        HashSet result = new HashSet(model.getObjects(filterClass));
        Traverser traverser = new Traverser(em, (bpe, value, m, e) -> {
            if (filterClass.isInstance(value)) {
                result.remove(value);
            }
        }, pe -> pe instanceof ObjectPropertyEditor);
        model.getObjects().stream().forEach(e -> traverser.traverse(e, null));
        return result;
    }

    public static <T extends BioPAXElement> Set<BioPAXElement> removeObjectsIfDangling(Model model, Class<T> clazz) {
        HashSet<BioPAXElement> removed = new HashSet<BioPAXElement>();
        if (Entity.class.equals(clazz)) {
            LOG.warn("Ignored removeObjectsIfDangling call for: Entity.class (it would delete all)");
            return removed;
        }
        if (UtilityClass.class.equals(clazz) && ModelUtils.getRootElements(model, Entity.class).isEmpty()) {
            LOG.warn("Ignored removeObjectsIfDangling call: no root entities model; UtilityClass.class");
            return removed;
        }
        Set<BioPAXElement> dangling = ModelUtils.getRootElements(model, clazz);
        if (!dangling.isEmpty()) {
            LOG.info(dangling.size() + " " + clazz.getSimpleName() + " dangling objects will be deleted...");
            for (BioPAXElement thing : dangling) {
                model.remove(thing);
                removed.add(thing);
                LOG.debug("removed (dangling) " + thing.getUri() + " (" + thing.getModelInterface().getSimpleName() + ") " + String.valueOf(thing));
            }
            removed.addAll(ModelUtils.removeObjectsIfDangling(model, clazz));
        }
        return removed;
    }

    public static Model writeRead(Model model) {
        SimpleIOHandler io = new SimpleIOHandler(model.getLevel());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        io.convertToOWL(model, baos);
        return io.convertFromOWL(new ByteArrayInputStream(baos.toByteArray()));
    }

    public static Model getDirectChildren(BioPAXElement bpe) {
        Model m = factory.createModel();
        Traverser traverser = new Traverser(em, (domain, range, model, editor) -> {
            if (range instanceof BioPAXElement && !model.containsID(((BioPAXElement)range).getUri())) {
                model.add((BioPAXElement)range);
            }
        }, new Filter[0]);
        traverser.traverse(bpe, m);
        return m;
    }

    @Deprecated
    public static Model getAllChildren(BioPAXElement bpe, Filter<PropertyEditor> ... filters) {
        Model m = factory.createModel();
        if (filters.length == 0) {
            new Fetcher(em, Fetcher.nextStepFilter).fetch(bpe, m);
        } else {
            new Fetcher(em, filters).fetch(bpe, m);
        }
        m.remove(bpe);
        return m;
    }

    public static Set<BioPAXElement> getDirectChildrenAsSet(BioPAXElement bpe) {
        HashSet<BioPAXElement> toReturn = new HashSet<BioPAXElement>();
        Traverser traverser = new Traverser(em, (domain, range, model, editor) -> {
            if (range instanceof BioPAXElement) {
                toReturn.add((BioPAXElement)range);
            }
        }, new Filter[0]);
        traverser.traverse(bpe, null);
        return toReturn;
    }

    public static Map<Class<? extends BioPAXElement>, Integer> generateClassMetrics(Model model) {
        HashMap<Class<? extends BioPAXElement>, Integer> metrics = new HashMap<Class<? extends BioPAXElement>, Integer>();
        for (BioPAXElement bpe : model.getObjects()) {
            Integer count = (Integer)metrics.get(bpe.getModelInterface());
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            metrics.put(bpe.getModelInterface(), count);
        }
        return metrics;
    }

    public static <T extends BioPAXElement> T getObject(Model model, String uri, Class<T> clazz) {
        BioPAXElement bpe = model.getByID(uri);
        if (clazz.isInstance(bpe)) {
            return (T)bpe;
        }
        return null;
    }

    public static String md5hex(String id) {
        byte[] digest = MD5_DIGEST.digest(id.getBytes());
        StringBuffer sb = new StringBuffer();
        for (byte b : digest) {
            sb.append(Integer.toHexString(b & 0xFF | 0x100), 1, 3);
        }
        String hex = sb.toString();
        return hex;
    }

    public static void fixDanglingObjectProperties(BioPAXElement bpe, Model model) {
        Visitor visitor = (domain, range, m, editor) -> {
            BioPAXElement value;
            if (editor instanceof ObjectPropertyEditor && (value = (BioPAXElement)range) != null && !m.containsID(value.getUri())) {
                ((ObjectPropertyEditor)editor).removeValueFromBean(value, domain);
            }
        };
        Traverser traverser = new Traverser(em, visitor, new Filter[0]);
        traverser.traverse(bpe, model);
    }

    public static void fixDanglingInverseProperties(BioPAXElement bpe, Model model) {
        Visitor visitor = (domain, range, m, editor) -> {
            BioPAXElement value = (BioPAXElement)range;
            if (value != null && !m.containsID(value.getUri())) {
                ((ObjectPropertyEditor)editor).removeValueFromBean(domain, value);
            }
        };
        TraverserBilinked traverser = new TraverserBilinked(em, visitor, new PropertyFilterBilinked[0]);
        traverser.setInverseOnly(true);
        traverser.traverse(bpe, model);
    }

    public static Set<EntityFeature> getFeatureIntersection(PhysicalEntity physicalEntity1, FeatureType featureType1, PhysicalEntity physicalEntity2, FeatureType featureType2) {
        Set<EntityFeature> intersection = ModelUtils.getFeatureSetByType(physicalEntity1, featureType1);
        intersection.removeAll(ModelUtils.getFeatureSetByType(physicalEntity2, featureType2));
        return intersection;
    }

    public static Set<EntityFeature> getFeatureSetByType(PhysicalEntity pe, FeatureType type) {
        HashSet<EntityFeature> modifiableSet = new HashSet<EntityFeature>();
        switch (type.ordinal()) {
            case 0: {
                modifiableSet.addAll(pe.getFeature());
                break;
            }
            case 1: {
                modifiableSet.addAll(pe.getNotFeature());
                break;
            }
            case 2: {
                EntityReference er;
                if (!(pe instanceof SimplePhysicalEntity) || (er = ((SimplePhysicalEntity)pe).getEntityReference()) == null) break;
                modifiableSet.addAll(er.getEntityFeature());
                modifiableSet.removeAll(pe.getFeature());
                modifiableSet.removeAll(pe.getNotFeature());
            }
        }
        return modifiableSet;
    }

    public static boolean checkERFeatureSet(EntityReference er, boolean fix) {
        boolean check = true;
        for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
            for (EntityFeature ef : spe.getFeature()) {
                check = ModelUtils.scanAndAddToFeatureSet(er, fix, check, ef);
                if (fix || check) continue;
                return check;
            }
            for (EntityFeature ef : spe.getNotFeature()) {
                check = ModelUtils.scanAndAddToFeatureSet(er, fix, check, ef);
                if (fix || check) continue;
                return check;
            }
        }
        return check;
    }

    private static boolean scanAndAddToFeatureSet(EntityReference er, boolean fix, boolean check, EntityFeature ef) {
        if (!er.getEntityFeature().contains(ef)) {
            check = false;
            if (fix) {
                er.addEntityFeature(ef);
            }
        }
        return check;
    }

    public static Set<EntityFeature> findFeaturesAddedToSecond(PhysicalEntity first, PhysicalEntity second, boolean fix) {
        if (ModelUtils.checkCommonEntityReferenceForTwoPEs(first, second, fix)) {
            return null;
        }
        Set<EntityFeature> explicit = ModelUtils.getFeatureIntersection(first, FeatureType.NOT_FEATURE, second, FeatureType.FEATURE);
        Set<EntityFeature> implicit = ModelUtils.getFeatureIntersection(first, FeatureType.UNKNOWN_FEATURE, second, FeatureType.FEATURE);
        Set<EntityFeature> negativeImplicit = ModelUtils.getFeatureIntersection(first, FeatureType.NOT_FEATURE, second, FeatureType.UNKNOWN_FEATURE);
        if (fix) {
            for (EntityFeature implied : implicit) {
                LOG.info("The feature " + String.valueOf(implied) + "implied as a not-feature of " + String.valueOf(first) + ". Adding it to the not-feature list");
                first.addNotFeature(implied);
            }
            for (EntityFeature implied : negativeImplicit) {
                LOG.info("The feature " + String.valueOf(implied) + "implied as a feature of " + String.valueOf(second) + ". Adding it to the feature list");
                second.addFeature(implied);
            }
        }
        explicit.retainAll(implicit);
        explicit.retainAll(negativeImplicit);
        return explicit;
    }

    private static boolean checkCommonEntityReferenceForTwoPEs(PhysicalEntity first, PhysicalEntity second, boolean fix) {
        if (first instanceof SimplePhysicalEntity) {
            EntityReference er = ((SimplePhysicalEntity)first).getEntityReference();
            if (!er.getEntityReferenceOf().contains(second)) {
                LOG.warn("These two physicalEntities do not share an EntityReference. They can not be compared! Skipping");
                return false;
            }
            if (!ModelUtils.checkERFeatureSet(er, fix)) {
                LOG.warn("ER feature set is incomplete!");
                if (!fix) {
                    LOG.warn("fixing...");
                } else {
                    LOG.warn("skipping");
                    return false;
                }
            }
            return true;
        }
        LOG.warn("These two PhysicalEntities do not share an EntityReference. They can not be compared! Skipping");
        return false;
    }

    public static void fixControlled(Model model, Control control2) {
    }

    public static void normalizeGenerics(Model model) {
        HashSet<SimplePhysicalEntity> simplePEsToDo = new HashSet<SimplePhysicalEntity>();
        for (SimplePhysicalEntity spe : model.getObjects(SimplePhysicalEntity.class)) {
            if (spe.getEntityReference() != null || spe.getMemberPhysicalEntity().isEmpty()) continue;
            simplePEsToDo.add(spe);
        }
        HashMap<Set<EntityReference>, EntityReference> memberMap = new HashMap<Set<EntityReference>, EntityReference>();
        for (SimplePhysicalEntity pe : simplePEsToDo) {
            try {
                ModelUtils.createGenericEntityRef(model, pe, memberMap);
            }
            catch (Exception e) {
                LOG.error("createGenericEntityRef failed at " + pe.getUri(), e);
            }
        }
    }

    private static void createGenericEntityRef(Model model, SimplePhysicalEntity spe, Map<Set<EntityReference>, EntityReference> memberMap) {
        Set<EntityReference> members = spe.getGenericEntityReferences();
        EntityReference er = memberMap.get(members);
        if (er == null) {
            EntityReference firstEntityReference = spe.getEntityReference();
            if (firstEntityReference == null) {
                PhysicalEntity pe;
                Iterator<PhysicalEntity> iterator = spe.getMemberPhysicalEntity().iterator();
                while (iterator.hasNext() && (firstEntityReference = ((SimplePhysicalEntity)(pe = iterator.next())).getEntityReference()) == null) {
                }
            } else {
                return;
            }
            if (firstEntityReference != null) {
                String syntheticId = model.getXmlBase() + firstEntityReference.getModelInterface().getSimpleName() + "_" + ModelUtils.md5hex(spe.getUri());
                er = (EntityReference)model.addNew(firstEntityReference.getModelInterface(), syntheticId);
                er.addComment("auto-generated generic entity reference");
                ModelUtils.copySimplePointers(model, spe, er);
                for (UnificationXref ux : new HashSet(new ClassFilterSet<Xref, UnificationXref>(spe.getXref(), UnificationXref.class))) {
                    spe.removeXref(ux);
                }
                for (EntityReference member : members) {
                    er.addMemberEntityReference(member);
                }
                memberMap.put(members, er);
            } else {
                LOG.warn(String.format("Cannot generate a generic ER for generic SPE %s, for none of member PEs has got an ER.", spe.getUri()));
            }
        }
        spe.setEntityReference(er);
    }

    public static void addMissingEntityReference(Model model, SimplePhysicalEntity pe) {
        if (pe.getEntityReference() != null || !pe.getMemberPhysicalEntity().isEmpty()) {
            return;
        }
        Class type = null;
        if (pe instanceof Protein) {
            type = ProteinReference.class;
        } else if (pe instanceof SmallMolecule) {
            type = SmallMoleculeReference.class;
        } else if (pe instanceof Dna) {
            type = DnaReference.class;
        } else if (pe instanceof DnaRegion) {
            type = DnaRegionReference.class;
        } else if (pe instanceof Rna) {
            type = RnaReference.class;
        } else if (pe instanceof RnaRegion) {
            type = RnaRegionReference.class;
        }
        String syntheticId = model.getXmlBase() + type.getSimpleName() + "_" + ModelUtils.md5hex(pe.getUri());
        EntityReference er = (EntityReference)model.addNew(type, syntheticId);
        ModelUtils.copySimplePointers(model, pe, er);
        for (UnificationXref ux : new HashSet(new ClassFilterSet<Xref, UnificationXref>(pe.getXref(), UnificationXref.class))) {
            pe.removeXref(ux);
        }
        pe.setEntityReference(er);
    }

    private static void copySimplePointers(Model model, Named source, Named target) {
        block13: {
            Observable src;
            block12: {
                if (source.getDisplayName() != null) {
                    target.setDisplayName(source.getDisplayName());
                }
                if (source.getStandardName() != null) {
                    target.setStandardName(source.getStandardName());
                }
                for (String name : source.getName()) {
                    target.addName(name);
                }
                for (Xref xref2 : source.getXref()) {
                    if (xref2 instanceof UnificationXref) {
                        String uri = model.getXmlBase() + "RelationshipXref_" + ModelUtils.md5hex(xref2.getDb() + xref2.getId());
                        Xref byID = (Xref)model.getByID(uri);
                        if (byID == null) {
                            RelationshipXref rref = model.addNew(RelationshipXref.class, uri);
                            rref.setDb(xref2.getDb());
                            rref.setId(xref2.getId());
                            rref.setDbVersion(xref2.getDbVersion());
                            rref.setIdVersion(xref2.getDbVersion());
                            xref2 = rref;
                        } else {
                            xref2 = byID;
                        }
                    }
                    target.addXref(xref2);
                }
                if (!(source instanceof Entity) || !(target instanceof Entity)) break block12;
                src = (Entity)source;
                for (Evidence ev : src.getEvidence()) {
                    ((Entity)target).addEvidence(ev);
                }
                for (Provenance prov : src.getDataSource()) {
                    ((Entity)target).addDataSource(prov);
                }
                for (String comm : source.getComment()) {
                    target.addComment(comm);
                }
                break block13;
            }
            if (!(source instanceof EntityReference) || !(target instanceof EntityReference)) break block13;
            src = (EntityReference)source;
            for (Evidence ev : src.getEvidence()) {
                ((EntityReference)target).addEvidence(ev);
            }
            for (String comm : source.getComment()) {
                target.addComment(comm);
            }
        }
    }

    public static void replaceEquivalentFeatures(Model model) {
        EquivalenceGrouper<EntityFeature> equivalents = new EquivalenceGrouper<EntityFeature>();
        HashMap mapped = new HashMap();
        HashSet<EntityFeature> scheduled = new HashSet<EntityFeature>();
        for (EntityFeature entityFeature : model.getObjects(EntityFeature.class)) {
            if (entityFeature.getEntityFeatureOf() == null) {
                ModelUtils.inferEntityReference(entityFeature);
            }
            equivalents.add(entityFeature);
        }
        for (List list : equivalents.getBuckets()) {
            for (int i = 1; i < list.size(); ++i) {
                EntityFeature ef = (EntityFeature)list.get(i);
                if (LOG.isWarnEnabled()) {
                    LOG.warn("removing: " + ef.getUri() + " since it is equivalent to: " + String.valueOf(list.get(0)));
                }
                scheduled.add(ef);
            }
        }
        for (EntityFeature entityFeature : scheduled) {
            model.remove(entityFeature);
        }
        for (PhysicalEntity physicalEntity2 : model.getObjects(PhysicalEntity.class)) {
            HashSet<EntityFeature> features = new HashSet<EntityFeature>(physicalEntity2.getFeature());
            for (EntityFeature feature : features) {
                EntityFeature that = (EntityFeature)mapped.get(feature);
                if (that == null || that.equals(feature)) continue;
                LOG.debug(" replacing " + String.valueOf(feature) + "{" + feature.getUri() + "} with " + String.valueOf(that) + "{" + that.getUri() + "}");
                physicalEntity2.removeFeature(feature);
                physicalEntity2.addFeature(that);
            }
        }
    }

    private static void inferEntityReference(EntityFeature ef) {
        EntityReference er;
        if (ef.getEntityFeatureOf() != null) {
            return;
        }
        for (PhysicalEntity physicalEntity2 : ef.getFeatureOf()) {
            if (!(physicalEntity2 instanceof SimplePhysicalEntity) || (er = ((SimplePhysicalEntity)physicalEntity2).getEntityReference()) == null) continue;
            er.addEntityFeature(ef);
            break;
        }
        if (ef.getEntityFeatureOf() == null) {
            for (PhysicalEntity physicalEntity2 : ef.getNotFeatureOf()) {
                if (!(physicalEntity2 instanceof SimplePhysicalEntity) || (er = ((SimplePhysicalEntity)physicalEntity2).getEntityReference()) == null) continue;
                er.addEntityFeature(ef);
                break;
            }
        }
    }

    public static Set<String> getKeywords(BioPAXElement biopaxElement, int depth, Filter<DataPropertyEditor> ... dataPropertyFilters) {
        LOG.debug("getKeywords called: " + biopaxElement.getUri());
        SimpleEditorMap em = SimpleEditorMap.L3;
        HashSet<String> ss = new HashSet<String>();
        HashSet<BioPAXElement> elms = depth > 0 ? new Fetcher(em, Fetcher.nextStepFilter).fetch(biopaxElement, depth) : new HashSet<BioPAXElement>();
        elms.add(biopaxElement);
        for (BioPAXElement bpe : elms) {
            Set<PropertyEditor> props = em.getEditorsOf(bpe);
            for (PropertyEditor pe : props) {
                if (pe instanceof ObjectPropertyEditor || !ModelUtils.filter((DataPropertyEditor)pe, dataPropertyFilters)) continue;
                Set values = pe.getValueFromBean(bpe);
                for (Object v : values) {
                    if (pe.isUnknown(v)) continue;
                    ss.add(v.toString());
                }
            }
        }
        return ss;
    }

    private static <T extends PropertyEditor> boolean filter(T pe, Filter<T> ... propertyFilters) {
        if (propertyFilters.length == 0) {
            return true;
        }
        for (Filter<T> pf : propertyFilters) {
            if (pf.filter(pe)) continue;
            return false;
        }
        return true;
    }

    public static Set<BioSource> getOrganisms(BioPAXElement biopaxElement) {
        HashSet<BioSource> biosources = new HashSet<BioSource>();
        if (biopaxElement == null) {
            return biosources;
        }
        LOG.debug("getOrganisms called: " + biopaxElement.getUri());
        if (biopaxElement instanceof BioSource) {
            biosources.add((BioSource)biopaxElement);
        } else if (biopaxElement instanceof Pathway) {
            if (((Pathway)biopaxElement).getOrganism() != null) {
                biosources.add(((Pathway)biopaxElement).getOrganism());
            }
        } else if (biopaxElement instanceof Gene) {
            if (((Gene)biopaxElement).getOrganism() != null) {
                biosources.add(((Gene)biopaxElement).getOrganism());
            }
        } else if (biopaxElement instanceof PathwayStep) {
            Pathway pw = ((PathwayStep)biopaxElement).getPathwayOrderOf();
            if (pw != null && pw.getOrganism() != null) {
                biosources.add(pw.getOrganism());
            }
        } else if (biopaxElement instanceof Interaction || biopaxElement instanceof EntityReference || biopaxElement instanceof PhysicalEntity) {
            if (biopaxElement instanceof SequenceEntityReference && ((SequenceEntityReference)biopaxElement).getOrganism() != null) {
                biosources.add(((SequenceEntityReference)biopaxElement).getOrganism());
            }
            biosources.addAll(new Fetcher(em, Fetcher.nextStepFilter).fetch(biopaxElement, BioSource.class));
        }
        return biosources;
    }

    public static Set<Provenance> getDatasources(BioPAXElement biopaxElement) {
        HashSet<Provenance> datasources = new HashSet<Provenance>();
        if (biopaxElement == null) {
            return datasources;
        }
        LOG.debug("getDatasources called: " + biopaxElement.getUri());
        if (biopaxElement instanceof Provenance) {
            datasources.add((Provenance)biopaxElement);
        } else if (biopaxElement instanceof Entity) {
            datasources.addAll(((Entity)biopaxElement).getDataSource());
        } else if (biopaxElement instanceof EntityReference) {
            for (SimplePhysicalEntity spe : ((EntityReference)biopaxElement).getEntityReferenceOf()) {
                datasources.addAll(ModelUtils.getDatasources(spe));
            }
            for (EntityReference er : ((EntityReference)biopaxElement).getMemberEntityReferenceOf()) {
                datasources.addAll(ModelUtils.getDatasources(er));
            }
        } else if (biopaxElement instanceof PathwayStep) {
            datasources.addAll(ModelUtils.getDatasources(((PathwayStep)biopaxElement).getPathwayOrderOf()));
        }
        return datasources;
    }

    public static Set<Pathway> getParentPathways(BioPAXElement biopaxElement) {
        HashSet<BioPAXElement> visited = new HashSet<BioPAXElement>();
        return ModelUtils.getParentPathwaysRecursively(biopaxElement, visited);
    }

    private static Set<Pathway> getParentPathwaysRecursively(BioPAXElement biopaxElement, Set<BioPAXElement> visited) {
        HashSet<Pathway> pathways;
        block12: {
            block15: {
                block14: {
                    block13: {
                        block11: {
                            pathways = new HashSet<Pathway>();
                            if (biopaxElement == null || !visited.add(biopaxElement)) {
                                LOG.debug("Ignored null or previously visited object:" + String.valueOf(biopaxElement));
                                return pathways;
                            }
                            LOG.debug("getParentPathways called: " + biopaxElement.getUri());
                            if (!(biopaxElement instanceof Process)) break block11;
                            if (biopaxElement instanceof Pathway) {
                                pathways.add((Pathway)biopaxElement);
                            }
                            for (Pathway pw : ((Process)biopaxElement).getPathwayComponentOf()) {
                                pathways.addAll(ModelUtils.getParentPathwaysRecursively(pw, visited));
                            }
                            for (Interaction it : ((Process)biopaxElement).getParticipantOf()) {
                                pathways.addAll(ModelUtils.getParentPathwaysRecursively(it, visited));
                            }
                            for (PathwayStep pt : ((Process)biopaxElement).getStepProcessOf()) {
                                pathways.addAll(ModelUtils.getParentPathwaysRecursively(pt, visited));
                            }
                            break block12;
                        }
                        if (!(biopaxElement instanceof PathwayStep)) break block13;
                        pathways.addAll(ModelUtils.getParentPathwaysRecursively(((PathwayStep)biopaxElement).getPathwayOrderOf(), visited));
                        break block12;
                    }
                    if (!(biopaxElement instanceof PhysicalEntity)) break block14;
                    for (PhysicalEntity pe : ((PhysicalEntity)biopaxElement).getMemberPhysicalEntityOf()) {
                        pathways.addAll(ModelUtils.getParentPathwaysRecursively(pe, visited));
                    }
                    for (Interaction it : ((Entity)biopaxElement).getParticipantOf()) {
                        pathways.addAll(ModelUtils.getParentPathwaysRecursively(it, visited));
                    }
                    for (Complex c : ((PhysicalEntity)biopaxElement).getComponentOf()) {
                        pathways.addAll(ModelUtils.getParentPathwaysRecursively(c, visited));
                    }
                    break block12;
                }
                if (!(biopaxElement instanceof EntityReference)) break block15;
                for (EntityReference er : ((EntityReference)biopaxElement).getMemberEntityReferenceOf()) {
                    pathways.addAll(ModelUtils.getParentPathwaysRecursively(er, visited));
                }
                for (SimplePhysicalEntity spe : ((EntityReference)biopaxElement).getEntityReferenceOf()) {
                    pathways.addAll(ModelUtils.getParentPathwaysRecursively(spe, visited));
                }
                break block12;
            }
            if (!(biopaxElement instanceof Gene)) break block12;
            for (Interaction it : ((Entity)biopaxElement).getParticipantOf()) {
                pathways.addAll(ModelUtils.getParentPathwaysRecursively(it, visited));
            }
        }
        return pathways;
    }

    public static void mergeEquivalentInteractions(Model model) {
        EquivalenceGrouper<Conversion> groups = new EquivalenceGrouper<Conversion>(model.getObjects(Conversion.class));
        for (List<Conversion> group : groups.getBuckets()) {
            if (group.size() <= 1) continue;
            HashMap<Conversion, Conversion> subs = new HashMap<Conversion, Conversion>();
            Conversion primus = null;
            for (Conversion conversion2 : group) {
                if (primus == null) {
                    primus = conversion2;
                    continue;
                }
                ModelUtils.copySimplePointers(model, conversion2, primus);
                subs.put(conversion2, primus);
            }
            ModelUtils.replace(model, subs);
            for (Conversion conversion2 : subs.keySet()) {
                model.remove(conversion2);
            }
        }
    }

    public static void mergeEquivalentPhysicalEntities(Model model) {
        HashMap<PhysicalEntity, PhysicalEntity> subs = new HashMap<PhysicalEntity, PhysicalEntity>();
        EquivalenceGrouper<PhysicalEntity> groups = new EquivalenceGrouper<PhysicalEntity>(model.getObjects(PhysicalEntity.class));
        for (List<PhysicalEntity> group : groups.getBuckets()) {
            if (group.size() <= 1) continue;
            PhysicalEntity primus = null;
            for (PhysicalEntity pe : group) {
                if (primus == null) {
                    primus = pe;
                    continue;
                }
                ModelUtils.copySimplePointers(model, pe, primus);
                if (!subs.containsKey(pe)) {
                    subs.put(pe, primus);
                    continue;
                }
                throw new AssertionError((Object)("mergeEquivalentPhysicalEntities: equivalence groups do intersect; " + pe.getUri() + " was in the other group as well"));
            }
        }
        ModelUtils.replace(model, subs);
        for (BioPAXElement pe : subs.keySet()) {
            model.remove(pe);
        }
    }

    public static String encodeBase62(String str) {
        char[] chars = new StringBuilder(str).reverse().toString().toCharArray();
        long n = 0L;
        for (int i = chars.length - 1; i >= 0; --i) {
            n = (long)((double)n + (double)ALPHABET.indexOf(chars[i]) * Math.pow(BASE, i));
        }
        StringBuilder sb = new StringBuilder("");
        while (n > 0L) {
            int rem = (int)(n % (long)BASE);
            sb.append(ALPHABET.charAt(rem));
            n /= (long)BASE;
        }
        return sb.reverse().toString();
    }

    public static String shortenUri(String xmlbase, String uri) {
        return xmlbase + ModelUtils.encodeBase62(uri);
    }

    public static void updateUri(Model model, BioPAXElement el, String newUri) {
        if (newUri == null || newUri.isEmpty()) {
            throw new IllegalArgumentException("New URI is null or empty.");
        }
        if (model != null) {
            model.remove(el);
        }
        try {
            Method m = BioPAXElementImpl.class.getDeclaredMethod("setUri", String.class);
            m.setAccessible(true);
            m.invoke((Object)el, newUri);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (model != null) {
            model.add(el);
        }
    }

    public static void breakPathwayComponentCycle(Model model) {
        for (Pathway pathway2 : model.getObjects(Pathway.class)) {
            ModelUtils.breakPathwayComponentCycle(new HashSet<Pathway>(), pathway2, pathway2);
        }
    }

    private static void breakPathwayComponentCycle(Set<Pathway> visited, Pathway rootPathway, Pathway currentPathway) {
        if (!visited.add(currentPathway)) {
            return;
        }
        if (currentPathway.getPathwayComponent().contains(rootPathway)) {
            currentPathway.removePathwayComponent(rootPathway);
        }
        for (Process proc : currentPathway.getPathwayComponent()) {
            if (!(proc instanceof Pathway)) continue;
            ModelUtils.breakPathwayComponentCycle(visited, rootPathway, (Pathway)proc);
        }
    }

    public static boolean isGeneric(BioPAXElement e) {
        return e instanceof EntityReference && !((EntityReference)e).getMemberEntityReference().isEmpty() || e instanceof PhysicalEntity && !((PhysicalEntity)e).getMemberPhysicalEntity().isEmpty() || e instanceof SimplePhysicalEntity && ModelUtils.isGeneric(((SimplePhysicalEntity)e).getEntityReference());
    }

    static {
        factory = BioPAXLevel.L3.getDefaultFactory();
        em = SimpleEditorMap.L3;
        io = new SimpleIOHandler(BioPAXLevel.L3);
        try {
            MD5_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot instantiate MD5 MessageDigest!", e);
        }
        io.mergeDuplicates(true);
        io.normalizeNameSpaces(false);
        BASE = ALPHABET.length();
    }

    static enum FeatureType {
        FEATURE,
        NOT_FEATURE,
        UNKNOWN_FEATURE;

    }
}

