/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.SetEquivalenceChecker;

public class PathwayStepImpl
extends L3ElementImpl
implements PathwayStep {
    private Set<Process> stepProcess;
    private Set<PathwayStep> nextStep = BPCollections.I.createSafeSet();
    private Set<PathwayStep> nextStepOf = BPCollections.I.createSafeSet();
    private Pathway pathwayOrderOf;
    private Set<Evidence> evidence;

    public PathwayStepImpl() {
        this.stepProcess = BPCollections.I.createSafeSet();
        this.evidence = BPCollections.I.createSafeSet();
    }

    public Class<? extends PathwayStep> getModelInterface() {
        return PathwayStep.class;
    }

    @Override
    public Set<PathwayStep> getNextStep() {
        return this.nextStep;
    }

    @Override
    public void addNextStep(PathwayStep nextStep) {
        if (nextStep != null) {
            this.nextStep.add(nextStep);
            nextStep.getNextStepOf().add(this);
        }
    }

    @Override
    public void removeNextStep(PathwayStep nextStep) {
        if (nextStep != null) {
            nextStep.getNextStepOf().remove(this);
            this.nextStep.remove(nextStep);
        }
    }

    @Override
    public Set<PathwayStep> getNextStepOf() {
        return this.nextStepOf;
    }

    @Override
    public Set<Process> getStepProcess() {
        return this.stepProcess;
    }

    @Override
    public void addStepProcess(Process processStep) {
        if (processStep != null) {
            this.stepProcess.add(processStep);
            processStep.getStepProcessOf().add(this);
        }
    }

    @Override
    public void removeStepProcess(Process processStep) {
        if (processStep != null) {
            processStep.getStepProcessOf().remove(this);
            this.stepProcess.remove(processStep);
        }
    }

    @Override
    public Set<Evidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void addEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.add(evidence2);
        }
    }

    @Override
    public void removeEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.remove(evidence2);
        }
    }

    @Override
    public Pathway getPathwayOrderOf() {
        return this.pathwayOrderOf;
    }

    protected void setPathwayOrderOf(Pathway pathwayOrderOf) {
        this.pathwayOrderOf = pathwayOrderOf;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        boolean equivalence = false;
        if (element instanceof PathwayStep) {
            PathwayStep other = (PathwayStep)element;
            equivalence = SetEquivalenceChecker.hasEquivalentIntersection(this.evidence, other.getEvidence()) && SetEquivalenceChecker.isEquivalent(this.getStepProcess(), other.getStepProcess()) && SetEquivalenceChecker.isEquivalent(this.getNextStep(), other.getNextStep());
        }
        return equivalence;
    }
}

