/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.AbstractPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.StringPropertyEditor;
import org.biopax.paxtools.io.BioPAXIOHandlerAdapter;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BiochemicalPathwayStep;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.util.BioPaxIOException;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleIOHandler
extends BioPAXIOHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SimpleIOHandler.class);
    private XMLStreamReader r;
    private List<Triple> triples;
    private boolean mergeDuplicates = false;
    private static final String RDF_ID = "rdf:ID=\"";
    private static final String RDF_about = "rdf:about=\"";
    private static final String newline = System.getProperty("line.separator");
    private static final String close = "\">";
    private boolean normalizeNameSpaces = true;
    private boolean absoluteUris;

    public SimpleIOHandler() {
        this(null, null);
    }

    public SimpleIOHandler(BioPAXLevel level) {
        this(level.getDefaultFactory(), level);
    }

    public SimpleIOHandler(BioPAXFactory factory, BioPAXLevel level) {
        super(factory, level);
    }

    public void mergeDuplicates(boolean mergeDuplicates) {
        this.mergeDuplicates = mergeDuplicates;
    }

    public void checkRestrictions(boolean checkRestrictions) {
        AbstractPropertyEditor.checkRestrictions.set(checkRestrictions);
    }

    @Override
    protected void resetEditorMap() {
        this.setEditorMap(SimpleEditorMap.get(this.getLevel()));
    }

    public String getXmlStreamInfo() {
        if (this.r == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int event = this.r.getEventType();
        if (event == 1 || event == 2 || event == 9) {
            sb.append(this.r.getLocalName());
        }
        if (this.r.getLocation() != null) {
            sb.append(" at line ");
            sb.append(this.r.getLocation().getLineNumber());
            sb.append(" column ");
            sb.append(this.r.getLocation().getColumnNumber());
        }
        return sb.toString();
    }

    @Override
    protected void init(InputStream in) {
        try {
            XMLInputFactory xmlf = XMLInputFactory.newInstance();
            xmlf.setProperty("javax.xml.stream.isCoalescing", true);
            this.r = xmlf.createXMLStreamReader(in);
            this.triples = new LinkedList<Triple>();
        }
        catch (XMLStreamException e) {
            throw new BioPaxIOException(e.getClass().getSimpleName() + " " + e.getMessage() + "; " + String.valueOf(e.getLocation()), e);
        }
    }

    @Override
    protected void reset(InputStream in) {
        this.triples = null;
        try {
            this.r.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Can't close the stream");
        }
        this.r = null;
        super.reset(in);
    }

    @Override
    protected Map<String, String> readNameSpaces() {
        HashMap<String, String> ns = new HashMap<String, String>();
        try {
            int i;
            if (this.r.getEventType() == 7) {
                this.r.next();
            } else {
                throw new BioPaxIOException("Unexpected element at start");
            }
            while (this.r.getEventType() == 5) {
                this.r.next();
            }
            if (this.r.getEventType() != 1) {
                throw new BioPaxIOException("Unexpected element at start: " + this.r.getEventType());
            }
            if (!this.r.getLocalName().equalsIgnoreCase("rdf")) {
                throw new BioPaxIOException("Unexpected element at start: " + this.r.getLocalName());
            }
            int count = this.r.getNamespaceCount();
            for (i = 0; i < count; ++i) {
                String pre = this.r.getNamespacePrefix(i);
                if (pre == null) {
                    pre = "";
                }
                String namespace = this.r.getNamespaceURI(pre);
                ns.put(pre, namespace);
            }
            this.base = null;
            for (i = 0; i < this.r.getAttributeCount(); ++i) {
                if (!"base".equalsIgnoreCase(this.r.getAttributeLocalName(i)) || !"xml".equalsIgnoreCase(this.r.getAttributePrefix(i))) continue;
                this.base = this.r.getAttributeValue(i);
            }
        }
        catch (XMLStreamException e) {
            throw new BioPaxIOException(e.getClass().getSimpleName() + " " + e.getMessage() + "; " + String.valueOf(e.getLocation()));
        }
        return ns;
    }

    @Override
    protected void createAndBind(Model model) {
        try {
            int type;
            while ((type = this.r.getEventType()) != 8) {
                switch (type) {
                    case 1: {
                        String lname = this.r.getLocalName();
                        String nsUri = StringUtils.defaultString(this.r.getNamespaceURI());
                        if ("http://www.w3.org/2002/07/owl#".equalsIgnoreCase(nsUri)) {
                            log.debug(String.format("Ignoring owl:%s", lname));
                            break;
                        }
                        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equalsIgnoreCase(nsUri)) {
                            log.debug(String.format("Ignoring rdf:%s", lname));
                            break;
                        }
                        if (BioPAXLevel.isInBioPAXNameSpace(nsUri)) {
                            Class<? extends BioPAXElement> clazz;
                            BioPAXLevel level = this.getLevel();
                            try {
                                clazz = level.getInterfaceForName(lname);
                            }
                            catch (IllegalBioPAXArgumentException e) {
                                throw new BioPaxIOException(String.format("Unknown/misplaced BioPAX %s element: %s", new Object[]{level, this.getXmlStreamInfo()}), e);
                            }
                            if (this.factory.canInstantiate(clazz)) {
                                this.processIndividual(model);
                                break;
                            }
                            log.error(String.format("Ignoring abstract type: %s", this.getXmlStreamInfo()));
                            this.skip();
                            break;
                        }
                        log.warn(String.format("Ignoring non-biopax type %s%s", nsUri, this.getXmlStreamInfo()));
                        this.skip();
                        break;
                    }
                    case 4: {
                        if (!log.isTraceEnabled()) break;
                        StringBuilder sb = new StringBuilder("Ignoring text (escaped): ");
                        if (this.r.hasName()) {
                            sb.append(this.r.getLocalName());
                        }
                        if (this.r.hasText()) {
                            sb.append(this.r.getText());
                        }
                        if (!log.isTraceEnabled()) break;
                        log.trace(StringEscapeUtils.escapeJava(sb.toString()));
                        break;
                    }
                    case 2: {
                        if (!log.isTraceEnabled()) break;
                        log.trace("End of: " + this.getXmlStreamInfo());
                        break;
                    }
                    case 5: {
                        if (!log.isTraceEnabled()) break;
                        log.trace("Ignoring XML comment" + this.getXmlStreamInfo());
                        break;
                    }
                    default: {
                        if (!log.isTraceEnabled()) break;
                        log.trace("Other event: " + type);
                    }
                }
                this.r.next();
            }
            this.r.close();
        }
        catch (XMLStreamException e) {
            throw new BioPaxIOException(e.getClass().getSimpleName() + " " + e.getMessage() + "; " + String.valueOf(e.getLocation()));
        }
        Iterator<Triple> it = this.triples.iterator();
        while (it.hasNext()) {
            Triple triple = it.next();
            try {
                this.bindValue(triple, model);
            }
            catch (IllegalBioPAXArgumentException e) {
                log.warn("Binding " + String.valueOf(e));
            }
            it.remove();
        }
    }

    private void bindValue(Triple triple, Model model) {
        BioPAXElement domain = model.getByID(triple.domain);
        if (domain != null) {
            if (log.isTraceEnabled()) {
                log.trace("Binding " + String.valueOf(triple));
            }
            PropertyEditor<? extends BioPAXElement, ?> editor = this.getEditorMap().getEditorForProperty(triple.property, domain.getModelInterface());
            this.bindValue(triple.range, editor, domain, model);
        } else {
            log.warn("Binding ignored " + String.valueOf(triple));
        }
    }

    private String processIndividual(Model model) throws XMLStreamException {
        Class<? extends BioPAXElement> type;
        String lname = this.r.getLocalName();
        String id = this.getId();
        if (id == null) {
            throw new BioPaxIOException(String.format("Error processing %s%s (rdf:ID/rdf:about not found)", this.r.getNamespaceURI(), this.getXmlStreamInfo()));
        }
        try {
            type = this.level.getInterfaceForName(lname);
        }
        catch (IllegalBioPAXArgumentException e) {
            throw new BioPaxIOException(String.format("BioPAX %s error processing individual %s; %s", new Object[]{this.level, this.getXmlStreamInfo(), e}));
        }
        if (this.factory.canInstantiate(type)) {
            BioPAXElement bpe = model.getByID(id);
            if (!this.mergeDuplicates || bpe == null) {
                this.createBpe(lname, id, model);
            } else if (!lname.equals(bpe.getModelInterface().getSimpleName())) {
                throw new BioPaxIOException(String.format("Failed creating an instance of %s, URI:%s, as we have another object with the same URI but different type: %s", lname, id, bpe.getModelInterface().getSimpleName()));
            }
        } else {
            log.error(String.format("Ignoring abstract %s, id: %s", this.r.hasText() ? this.r.getText() : this.getXmlStreamInfo(), id));
        }
        this.r.next();
        while (this.r.getEventType() != 2) {
            if (this.r.getEventType() == 1) {
                this.processProperty(model, id);
            }
            this.r.next();
        }
        return id;
    }

    private void createBpe(String s, String id, Model model) {
        BioPAXElement bpe = this.factory.create(s, id);
        model.add(bpe);
    }

    private void skip() throws XMLStreamException {
        int depth = 1;
        while (this.r.getEventType() != 2 || depth != 0) {
            this.r.next();
            switch (this.r.getEventType()) {
                case 1: {
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
    }

    public String getId() {
        Object id = this.r.getAttributeValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        if (id == null) {
            id = this.r.getAttributeValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
            if (id != null && ((String)id).startsWith("#")) {
                id = this.base + ((String)id).substring(1, ((String)id).length());
            }
        } else if (this.base != null) {
            id = this.base + (String)id;
        }
        return id;
    }

    private void processProperty(Model model, String ownerID) throws XMLStreamException {
        if ("http://www.w3.org/2000/01/rdf-schema#".equals(this.r.getNamespaceURI()) && "comment".equals(this.r.getLocalName())) {
            BioPAXElement paxElement = model.getByID(ownerID);
            StringPropertyEditor commentor = this.getRDFCommentEditor(paxElement);
            this.r.next();
            assert (this.r.getEventType() == 4);
            String text = this.r.getText();
            if (text != null) {
                text = text.trim();
            }
            commentor.setValueToBean(text, paxElement);
            log.warn(String.format("rdfs:comment '%s' was converted to the biopax one for element: %s", StringEscapeUtils.escapeJava(text), ownerID));
            this.gotoEndElement();
        } else if (this.level.getNameSpace().equals(this.r.getNamespaceURI())) {
            String property = this.r.getLocalName();
            Object resource = this.r.getAttributeValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
            if (resource != null) {
                if (((String)resource).startsWith("#")) {
                    resource = (this.base == null ? "" : this.base) + ((String)resource).substring(1, ((String)resource).length());
                }
                this.gotoEndElement();
            } else {
                this.r.next();
                boolean found = false;
                while (this.r.getEventType() != 2) {
                    if (!found && this.r.getEventType() == 4) {
                        StringBuilder buff = new StringBuilder(this.r.getText());
                        this.r.next();
                        while (this.r.getEventType() == 4) {
                            buff.append(this.r.getText());
                            this.r.next();
                        }
                        resource = buff.toString();
                        continue;
                    }
                    if (this.r.getEventType() == 1) {
                        resource = this.processIndividual(model);
                        found = true;
                        this.r.next();
                        continue;
                    }
                    this.r.next();
                }
                resource = !found && resource != null ? ((String)resource).replaceAll("\\s+", " ").trim() : resource;
            }
            Triple triple = new Triple(ownerID, (String)resource, property);
            if (log.isTraceEnabled()) {
                log.trace("Triple " + String.valueOf(triple));
            }
            this.triples.add(triple);
        } else {
            String ruri = this.r.getNamespaceURI() != null ? this.r.getNamespaceURI() + this.r.getLocalName() : this.r.getLocalName();
            log.warn(String.format("Ignoring unknown prop of %s: %s", ownerID, ruri));
            this.gotoEndElement();
        }
    }

    private void gotoEndElement() throws XMLStreamException {
        while (this.r.getEventType() != 2) {
            this.r.next();
        }
    }

    @Override
    public void convertToOWL(Model model, OutputStream outputStream) {
        this.initializeExporter(model);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            this.writeObjects(out, model);
            ((Writer)out).close();
        }
        catch (IOException e) {
            throw new BioPaxIOException("Cannot convert to OWL!", e);
        }
    }

    public void writeObject(Writer out, BioPAXElement bean) throws IOException {
        String name = "bp:" + bean.getModelInterface().getSimpleName();
        this.writeIDLine(out, bean, name);
        Set<PropertyEditor> editors = this.editorMap.getEditorsOf(bean);
        if (editors == null || editors.isEmpty()) {
            log.info("no editors for " + bean.getUri() + " | " + bean.getModelInterface().getSimpleName());
            out.write(newline + "</" + name + ">");
            return;
        }
        for (PropertyEditor editor : editors) {
            Set value = editor.getValueFromBean(bean);
            for (Object valueElement : value) {
                if (editor.isUnknown(valueElement)) continue;
                this.writeStatementFor(bean, editor, valueElement, out);
            }
        }
        out.write(newline + "</" + name + ">");
    }

    private void writeObjects(Writer out, Model model) throws IOException {
        this.writeHeader(out);
        Set<BioPAXElement> bioPAXElements = model.getObjects();
        for (BioPAXElement bean : bioPAXElements) {
            this.writeObject(out, bean);
        }
        out.write(newline + "</rdf:RDF>");
    }

    private void writeStatementFor(BioPAXElement bean, PropertyEditor editor, Object value, Writer out) throws IOException {
        BiochemicalPathwayStep bps;
        Named named;
        assert (bean != null && editor != null && value != null);
        if (editor.getProperty().equalsIgnoreCase("name") && bean instanceof Named && (value.equals((named = (Named)bean).getDisplayName()) || value.equals(named.getStandardName()))) {
            return;
        }
        if (editor.getProperty().equalsIgnoreCase("stepProcess") && bean instanceof BiochemicalPathwayStep && value.equals((bps = (BiochemicalPathwayStep)bean).getStepConversion())) {
            return;
        }
        String prop = "bp:" + editor.getProperty();
        out.write(newline + " <" + prop);
        if (value instanceof BioPAXElement) {
            Object id = ((BioPAXElement)value).getUri();
            assert (id != null);
            if (!this.absoluteUris && this.base != null && ((String)id).startsWith(this.base)) {
                id = "#" + ((String)id).substring(this.base.length());
            }
            out.write(" rdf:resource=\"" + (String)id + "\" />");
        } else {
            String type = this.findLiteralType(editor);
            String valString = StringEscapeUtils.escapeXml(value.toString());
            if (StringUtils.isNotBlank(type)) {
                out.write(" rdf:datatype = \"http://www.w3.org/2001/XMLSchema#" + type + "\"");
            }
            out.write(">" + valString + "</" + prop + ">");
        }
    }

    private String findLiteralType(PropertyEditor editor) {
        Class range = editor.getRange();
        String type = null;
        if (range.isEnum() || range.equals(String.class)) {
            type = "string";
        } else if (range.equals(Double.TYPE) || range.equals(Double.class)) {
            type = "double";
        } else if (range.equals(Integer.TYPE) || range.equals(Integer.class)) {
            type = "int";
        } else if (range.equals(Float.TYPE) || range.equals(Float.class)) {
            type = "float";
        } else if (range.equals(Boolean.TYPE) || range.equals(Boolean.class)) {
            type = "boolean";
        } else if (range.equals(Long.TYPE) || range.equals(Long.class)) {
            type = "long";
        }
        return type;
    }

    private void writeIDLine(Writer out, BioPAXElement bpe, String name) throws IOException {
        out.write(newline + newline + "<" + name + " ");
        String s = bpe.getUri();
        if (!this.absoluteUris && this.base != null && s.startsWith(this.base)) {
            String id = s.substring(this.base.length());
            out.write(RDF_ID + id + close);
        } else {
            out.write(RDF_about + s + close);
        }
    }

    private void initializeExporter(Model model) {
        BioPAXLevel lev;
        this.base = model.getXmlBase();
        this.namespaces = new HashMap<String, String>(model.getNameSpacePrefixMap());
        this.normalizeNameSpaces();
        if (this.normalizeNameSpaces) {
            model.getNameSpacePrefixMap().clear();
            model.getNameSpacePrefixMap().putAll(this.namespaces);
        }
        if ((lev = model.getLevel()) != this.level) {
            this.resetLevel(lev, lev.getDefaultFactory());
        }
    }

    private void normalizeNameSpaces() {
        String owlPre = null;
        String rdfPre = null;
        String xsdPre = null;
        for (String pre : this.namespaces.keySet()) {
            String ns = (String)this.namespaces.get(pre);
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equalsIgnoreCase(ns)) {
                rdfPre = pre;
                continue;
            }
            if ("http://www.w3.org/2002/07/owl#".equalsIgnoreCase(ns)) {
                owlPre = pre;
                continue;
            }
            if (!"http://www.w3.org/2001/XMLSchema#".equalsIgnoreCase(ns)) continue;
            xsdPre = pre;
        }
        if (owlPre != null) {
            this.namespaces.remove(owlPre);
        }
        if (rdfPre != null) {
            this.namespaces.remove(rdfPre);
        }
        if (xsdPre != null) {
            this.namespaces.remove(xsdPre);
        }
        this.namespaces.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.namespaces.put("owl", "http://www.w3.org/2002/07/owl#");
        this.namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema#");
    }

    private void writeHeader(Writer out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.write(newline + "<rdf:RDF");
        String bpns = this.editorMap.getLevel().getNameSpace();
        for (String pre : this.namespaces.keySet()) {
            if (pre.equals("bp")) continue;
            out.write(newline + " xmlns" + (String)("".equals(pre) ? "" : ":" + pre) + "=\"" + (String)this.namespaces.get(pre) + "\"");
        }
        out.write(newline + " xmlns:bp=\"" + bpns + "\"");
        if (this.base != null) {
            out.write(newline + " xml:base=\"" + this.base + "\"");
        }
        out.write(">");
        out.write(newline + "<owl:Ontology rdf:about=\"\">");
        out.write(newline + " <owl:imports rdf:resource=\"" + bpns + "\" />");
        out.write(newline + "</owl:Ontology>");
    }

    public void absoluteUris(boolean absoluteUris) {
        this.absoluteUris = absoluteUris;
    }

    public boolean isAbsoluteUris() {
        return this.absoluteUris;
    }

    public void normalizeNameSpaces(boolean normalizeNameSpaces) {
        this.normalizeNameSpaces = normalizeNameSpaces;
    }

    public boolean isNormalizeNameSpaces() {
        return this.normalizeNameSpaces;
    }

    public boolean isMergeDuplicates() {
        return this.mergeDuplicates;
    }

    public static String convertToOwl(Model model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new SimpleIOHandler(model.getLevel()).convertToOWL(model, outputStream);
        return outputStream.toString(StandardCharsets.UTF_8);
    }

    public class Triple {
        public String domain;
        public String range;
        public String property;

        private Triple(String domain, String range, String property) {
            this.domain = domain;
            this.range = range;
            this.property = property;
        }

        public String toString() {
            return String.format("('%s'->%s->'%s')", this.domain, this.property, this.range);
        }
    }
}

