/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.gsea;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.IDFetcher;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.gsea.GMTEntry;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.normalizer.ConfigurableIDFetcher;
import org.biopax.paxtools.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GMTConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GMTConverter.class);
    private final IDFetcher idFetcher = new ConfigurableIDFetcher().chemDbStartsWithOrEquals("chebi").seqDbStartsWithOrEquals("hgnc.symbol").seqDbStartsWithOrEquals("hgnc symbol").seqDbStartsWithOrEquals("hgnc");
    private boolean skipSubPathways = true;
    private boolean skipOutsidePathways = false;
    private int minNumIdsPerEntry = 1;

    public boolean isSkipSubPathways() {
        return this.skipSubPathways;
    }

    public void setSkipSubPathways(boolean skipSubPathways) {
        this.skipSubPathways = skipSubPathways;
    }

    public boolean isSkipOutsidePathways() {
        return this.skipOutsidePathways;
    }

    public void setSkipOutsidePathways(boolean skipOutsidePathways) {
        this.skipOutsidePathways = skipOutsidePathways;
    }

    public int getMinNumIdsPerEntry() {
        return this.minNumIdsPerEntry;
    }

    public void setMinNumIdsPerEntry(int minNumIdsPerEntry) {
        this.minNumIdsPerEntry = minNumIdsPerEntry;
    }

    public void writeToGSEA(Model model, OutputStream out) throws IOException {
        Collection<GMTEntry> entries = this.convert(model);
        if (entries.size() > 0) {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            for (GMTEntry entry : entries) {
                if ((this.minNumIdsPerEntry > 1 || entry.identifiers().isEmpty()) && entry.identifiers().size() < this.minNumIdsPerEntry) continue;
                writer.write(String.valueOf(entry) + "\n");
            }
            ((Writer)writer).flush();
        }
    }

    public Collection<GMTEntry> convert(Model model) {
        TreeSet<GMTEntry> toReturn = new TreeSet<GMTEntry>(Comparator.comparing(GMTEntry::toString));
        Model l3Model = model.getLevel() == BioPAXLevel.L2 ? new LevelUpgrader().filter(model) : model;
        HashSet<EntityReference> entityReferences = new HashSet<EntityReference>(l3Model.getObjects(EntityReference.class));
        Set<Pathway> pathways = l3Model.getObjects(Pathway.class);
        for (Pathway pathway2 : pathways) {
            String name;
            String string = name = pathway2.getDisplayName() == null ? pathway2.getStandardName() : pathway2.getDisplayName();
            if (name == null || name.isEmpty()) {
                name = pathway2.getUri();
            }
            Pathway currentPathway = pathway2;
            String currentPathwayName = name;
            LOG.debug("Begin converting " + currentPathwayName + " pathway, uri=" + currentPathway.getUri());
            final HashSet<EntityReference> ers = new HashSet<EntityReference>();
            AbstractTraverser traverser = new AbstractTraverser(SimpleEditorMap.L3, new Filter[]{Fetcher.nextStepFilter, Fetcher.objectPropertiesOnlyFilter}){

                protected void visit(Object range, BioPAXElement domain, Model model, PropertyEditor editor) {
                    BioPAXElement bpe = (BioPAXElement)range;
                    if (bpe instanceof EntityReference) {
                        ers.add((EntityReference)bpe);
                    }
                    if (bpe instanceof Pathway) {
                        if (GMTConverter.this.skipSubPathways) {
                            LOG.debug("Skipping sub-pathway: " + bpe.getUri());
                        } else {
                            this.traverse(bpe, model);
                        }
                    } else {
                        this.traverse(bpe, model);
                    }
                }
            };
            ((Traverser)traverser).traverse(currentPathway, null);
            if (ers.isEmpty()) continue;
            LOG.debug("For pathway: " + currentPathwayName + " (" + currentPathway.getUri() + "), got " + ers.size() + " ERs");
            Collection<GMTEntry> entries = this.createGseaEntries(currentPathway.getUri(), currentPathwayName, this.getDataSource(currentPathway.getDataSource()), ers);
            if (!entries.isEmpty()) {
                toReturn.addAll(entries);
            }
            entityReferences.removeAll(ers);
            LOG.debug("- collected " + entries.size() + " entries.");
        }
        if (!entityReferences.isEmpty() && !this.skipOutsidePathways) {
            LOG.info("Creating entries for the rest of PRs (outside any pathway)...");
            toReturn.addAll(this.createGseaEntries("other", "other", this.getDataSource(l3Model.getObjects(Provenance.class)), entityReferences));
        }
        return toReturn;
    }

    private Collection<GMTEntry> createGseaEntries(String uri, String name, String dataSource2, Collection<EntityReference> ers) {
        ArrayList<GMTEntry> toReturn = new ArrayList<GMTEntry>();
        GMTEntry entry = new GMTEntry(uri, "", "", String.format("name: %s; datasource: %s", name, dataSource2));
        for (EntityReference er : ers) {
            entry.identifiers().addAll(this.idFetcher.fetchID(er));
        }
        toReturn.add(entry);
        return toReturn;
    }

    private String getDataSource(Collection<Provenance> provenances) {
        if (provenances.isEmpty()) {
            return "N/A";
        }
        TreeSet<String> dsNames = new TreeSet<String>();
        for (Provenance provenance : provenances) {
            String name = provenance.getDisplayName();
            if (name == null) {
                name = provenance.getStandardName();
            }
            if (name == null && !provenance.getName().isEmpty()) {
                name = provenance.getName().iterator().next();
            }
            if (name == null || name.length() <= 0) continue;
            dsNames.add(name.toLowerCase());
        }
        return StringUtils.join(dsNames, ";");
    }
}

