/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.gsea;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.gsea.GMTEntry;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.normalizer.Resolver;
import org.biopax.paxtools.util.ClassFilterSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSEAConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GSEAConverter.class);
    private String idType;
    private final boolean crossSpeciesCheckEnabled;
    private Collection<String> allowedOrganisms;
    private final boolean skipSubPathways;
    private Collection<Provenance> skipSubPathwaysOf;
    private boolean skipOutsidePathways = false;
    private int minNumOfGenesPerEntry = 1;

    public GSEAConverter() {
        this("", true);
    }

    public GSEAConverter(String idType, boolean crossSpeciesCheckEnabled) {
        this(idType, crossSpeciesCheckEnabled, false);
    }

    public GSEAConverter(String idType, boolean crossSpeciesCheckEnabled, boolean skipSubPathways) {
        this.idType = Resolver.isKnownNameOrVariant(idType) ? Resolver.getNamespace(idType).getPrefix().toLowerCase() : (StringUtils.isNotBlank(idType) ? idType.toLowerCase() : idType);
        this.crossSpeciesCheckEnabled = crossSpeciesCheckEnabled;
        this.skipSubPathways = skipSubPathways;
        this.skipSubPathwaysOf = Collections.emptySet();
    }

    public GSEAConverter(String idType, boolean crossSpeciesCheckEnabled, Collection<Provenance> skipSubPathwaysOf) {
        this(idType, crossSpeciesCheckEnabled, false);
        this.skipSubPathwaysOf = skipSubPathwaysOf == null ? Collections.emptySet() : skipSubPathwaysOf;
    }

    public String getIdType() {
        return this.idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public boolean isSkipOutsidePathways() {
        return this.skipOutsidePathways;
    }

    public void setSkipOutsidePathways(boolean skipOutsidePathways) {
        this.skipOutsidePathways = skipOutsidePathways;
    }

    public Collection<String> getAllowedOrganisms() {
        return this.allowedOrganisms;
    }

    public void setAllowedOrganisms(Set<String> allowedOrganisms) {
        this.allowedOrganisms = allowedOrganisms;
    }

    public int getMinNumOfGenesPerEntry() {
        return this.minNumOfGenesPerEntry;
    }

    public void setMinNumOfGenesPerEntry(int minNumOfGenesPerEntry) {
        this.minNumOfGenesPerEntry = minNumOfGenesPerEntry;
    }

    public void writeToGSEA(Model model, OutputStream out) throws IOException {
        Collection<GMTEntry> entries = this.convert(model);
        if (entries.size() > 0) {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            for (GMTEntry entry : entries) {
                if ((this.minNumOfGenesPerEntry > 1 || entry.identifiers().isEmpty()) && entry.identifiers().size() < this.minNumOfGenesPerEntry) continue;
                writer.write(String.valueOf(entry) + "\n");
            }
            ((Writer)writer).flush();
        }
    }

    public Collection<GMTEntry> convert(Model model) {
        TreeSet<GMTEntry> toReturn = new TreeSet<GMTEntry>(Comparator.comparing(GMTEntry::toString));
        Model l3Model = model.getLevel() == BioPAXLevel.L2 ? new LevelUpgrader().filter(model) : model;
        ArrayList<SequenceEntityReference> sequenceEntityReferences = new ArrayList<SequenceEntityReference>(l3Model.getObjects(SequenceEntityReference.class));
        Set<Pathway> pathways = l3Model.getObjects(Pathway.class);
        for (Pathway pathway2 : pathways) {
            String name;
            String string = name = pathway2.getDisplayName() == null ? pathway2.getStandardName() : pathway2.getDisplayName();
            if (StringUtils.isBlank(name)) {
                name = pathway2.getUri();
            }
            Pathway currentPathway = pathway2;
            String currentPathwayName = name;
            boolean ignoreSubPathways = !this.skipSubPathwaysOf.isEmpty() && this.shareSomeObjects(currentPathway.getDataSource(), this.skipSubPathwaysOf) || this.skipSubPathways;
            LOG.debug("Begin converting " + currentPathwayName + " pathway, uri=" + currentPathway.getUri());
            Fetcher fetcher = new Fetcher(SimpleEditorMap.L3, Fetcher.nextStepFilter);
            fetcher.setSkipSubPathways(ignoreSubPathways);
            Set<SequenceEntityReference> pathwaySers = fetcher.fetch((BioPAXElement)currentPathway, SequenceEntityReference.class);
            if (pathwaySers.isEmpty()) continue;
            LOG.debug("For pathway: " + currentPathwayName + " (" + currentPathway.getUri() + "), got " + pathwaySers.size() + " sERs; now - grouping by organism...");
            Map<String, Collection<SequenceEntityReference>> orgToPrsMap = this.organismToProteinRefsMap(pathwaySers);
            String dataSource2 = this.getDataSource(currentPathway.getDataSource());
            Collection<GMTEntry> entries = this.createGseaEntries(currentPathway.getUri(), currentPathwayName, dataSource2, orgToPrsMap);
            if (!entries.isEmpty()) {
                toReturn.addAll(entries);
            }
            sequenceEntityReferences.removeAll(pathwaySers);
            LOG.debug("- collected " + entries.size() + " entries.");
        }
        if (!sequenceEntityReferences.isEmpty() && !this.skipOutsidePathways) {
            LOG.info("Creating entries for the rest of PRs (outside any pathway)...");
            Map<String, Collection<SequenceEntityReference>> orgToPrsMap = this.organismToProteinRefsMap(sequenceEntityReferences);
            if (!orgToPrsMap.isEmpty()) {
                if (model.getUri() == null) {
                    toReturn.addAll(this.createGseaEntries("other", "other", this.getDataSource(l3Model.getObjects(Provenance.class)), orgToPrsMap));
                } else {
                    toReturn.addAll(this.createGseaEntries(model.getUri(), model.getName(), this.getDataSource(l3Model.getObjects(Provenance.class)), orgToPrsMap));
                }
            }
        }
        return toReturn;
    }

    private Collection<GMTEntry> createGseaEntries(String uri, String name, String dataSource2, Map<String, Collection<SequenceEntityReference>> orgToPrsMap) {
        ArrayList<GMTEntry> toReturn = new ArrayList<GMTEntry>();
        for (String org : orgToPrsMap.keySet()) {
            if (orgToPrsMap.get(org).size() <= 0) continue;
            GMTEntry GMTEntry2 = new GMTEntry(uri, org, this.idType, String.format("name: %s; datasource: %s", name, dataSource2));
            this.processEntityReferences(orgToPrsMap.get(org), GMTEntry2);
            toReturn.add(GMTEntry2);
        }
        return toReturn;
    }

    private Map<String, Collection<SequenceEntityReference>> organismToProteinRefsMap(Collection<SequenceEntityReference> seqErs) {
        HashMap<String, Collection<SequenceEntityReference>> map = new HashMap<String, Collection<SequenceEntityReference>>();
        if (seqErs.isEmpty()) {
            throw new IllegalArgumentException("Empty set");
        }
        if (this.crossSpeciesCheckEnabled) {
            for (SequenceEntityReference r : seqErs) {
                String key = this.getOrganismKey(r.getOrganism());
                if (this.allowedOrganisms != null && !this.allowedOrganisms.isEmpty() && !this.allowedOrganisms.contains(key)) continue;
                HashSet<SequenceEntityReference> sers = (HashSet<SequenceEntityReference>)map.get(key);
                if (sers == null) {
                    sers = new HashSet<SequenceEntityReference>();
                    map.put(key, sers);
                }
                sers.add(r);
            }
        } else {
            HashSet<SequenceEntityReference> sers = new HashSet<SequenceEntityReference>();
            for (SequenceEntityReference r : seqErs) {
                String key = this.getOrganismKey(r.getOrganism());
                if (this.allowedOrganisms != null && !this.allowedOrganisms.isEmpty() && !this.allowedOrganisms.contains(key)) continue;
                sers.add(r);
            }
            map.put("", sers);
        }
        return map;
    }

    void processEntityReferences(Collection<SequenceEntityReference> sers, GMTEntry targetEntry) {
        for (SequenceEntityReference ser : sers) {
            if (this.crossSpeciesCheckEnabled && !targetEntry.taxID().equals(this.getOrganismKey(ser.getOrganism()))) continue;
            if (StringUtils.isNotBlank(this.idType)) {
                int added = 0;
                for (Xref aXref : ser.getXref()) {
                    if (!(aXref instanceof UnificationXref) || aXref.getId() == null || aXref.getDb() == null || !Resolver.isKnownNameOrVariant(aXref.getDb()) || !StringUtils.equalsIgnoreCase(this.idType, Resolver.getNamespace(aXref.getDb()).getPrefix())) continue;
                    targetEntry.identifiers().add(aXref.getId());
                    ++added;
                }
                if (added == 0) {
                    for (Xref aXref : ser.getXref()) {
                        if (!(aXref instanceof RelationshipXref) || aXref.getId() == null || aXref.getDb() == null || !Resolver.isKnownNameOrVariant(aXref.getDb()) || !StringUtils.equalsIgnoreCase(this.idType, Resolver.getNamespace(aXref.getDb()).getPrefix())) continue;
                        targetEntry.identifiers().add(aXref.getId());
                        ++added;
                    }
                }
                if (added <= 12) continue;
                LOG.info("In GSEA entry: " + targetEntry.taxID() + " " + targetEntry.name() + ", sER " + ser.getUri() + " got " + added + " '" + this.idType + "' identifiers...");
                continue;
            }
            targetEntry.identifiers().add(ser.getUri());
        }
    }

    private String getDataSource(Collection<Provenance> provenances) {
        if (provenances.isEmpty()) {
            return "N/A";
        }
        TreeSet<String> dsNames = new TreeSet<String>();
        for (Provenance provenance : provenances) {
            String name = provenance.getDisplayName();
            if (name == null) {
                name = provenance.getStandardName();
            }
            if (name == null && !provenance.getName().isEmpty()) {
                name = provenance.getName().iterator().next();
            }
            if (name == null || name.length() <= 0) continue;
            dsNames.add(name.toLowerCase());
        }
        return StringUtils.join(dsNames, ";");
    }

    private String getOrganismKey(BioSource org) {
        if (org == null) {
            return "";
        }
        String key = new ClassFilterSet<Xref, UnificationXref>(org.getXref(), UnificationXref.class).stream().filter(x -> Resolver.isKnownNameOrVariant(x.getDb()) && "ncbitaxon".equals(Resolver.getNamespace(x.getDb()).getPrefix())).map(Xref::getId).findFirst().orElse("");
        if (key.isEmpty()) {
            if (org.getStandardName() != null) {
                key = org.getStandardName();
            } else if (org.getDisplayName() != null) {
                key = org.getDisplayName();
            } else if (!org.getName().isEmpty()) {
                key = org.getName().iterator().next();
            }
        }
        return key.toLowerCase();
    }

    private boolean shareSomeObjects(Collection<?> setA, Collection<?> setB) {
        return !setA.isEmpty() && !setB.isEmpty() ? !CollectionUtils.intersection(setA, setB).isEmpty() : false;
    }
}

