/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.normalizer;

import java.util.Map;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.ShallowCopy;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.BPCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NormalizerMap {
    static final Logger log = LoggerFactory.getLogger(NormalizerMap.class);
    final Model model;
    final Map<BioPAXElement, BioPAXElement> subs = BPCollections.I.createMap();
    final Map<String, BioPAXElement> uriToSub = BPCollections.I.createMap();
    final ShallowCopy copier;

    NormalizerMap(Model model) {
        this.model = model;
        this.copier = new ShallowCopy();
    }

    void put(BioPAXElement bpe, String newUri) {
        if (this.model.containsID(newUri)) {
            this.map(bpe, this.model.getByID(newUri));
        } else if (this.uriToSub.containsKey(newUri)) {
            this.map(bpe, this.uriToSub.get(newUri));
        } else {
            BioPAXElement copy = this.copier.copy(bpe, newUri);
            this.map(bpe, copy);
        }
    }

    void doSubs() {
        for (BioPAXElement e : this.subs.keySet()) {
            this.model.remove(e);
        }
        try {
            ModelUtils.replace(this.model, this.subs);
        }
        catch (Exception e) {
            log.error("Failed to replace BioPAX elements", e);
            return;
        }
        for (BioPAXElement e : this.subs.values()) {
            if (this.model.containsID(e.getUri())) continue;
            this.model.add(e);
        }
        for (BioPAXElement e : this.model.getObjects()) {
            ModelUtils.fixDanglingInverseProperties(e, this.model);
        }
    }

    private void map(BioPAXElement bpe, BioPAXElement newBpe) {
        this.subs.put(bpe, newBpe);
        this.uriToSub.put(newBpe.getUri(), newBpe);
    }
}

