/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.normalizer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.normalizer.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resolver {
    private static final Logger LOG = LoggerFactory.getLogger(Resolver.class);
    private static Map<String, Namespace> namespaces;
    private static Map<String, String> spellmap;
    private static Map<String, String> synonymap;
    public static final String BIOREGISTRY_IO = "http://bioregistry.io/";
    public static final String BIOREGISTRY_JSON_URL = "https://raw.githubusercontent.com/biopragmatics/bioregistry/main/exports/registry/registry.json";

    protected Resolver() {
    }

    public static boolean checkRegExp(String identifier, String datatype) {
        Namespace dt = Resolver.getNamespace(datatype);
        if (dt == null) {
            LOG.debug("Cannot check id: {} for unknown collection: {}; return: false", (Object)identifier, (Object)datatype);
            return false;
        }
        String banana = dt.getBanana();
        if (StringUtils.isNotBlank(banana)) {
            identifier = identifier.replaceFirst(banana + dt.getBanana_peel(), "");
        }
        return StringUtils.isNotBlank(dt.getPattern()) ? Pattern.compile(dt.getPattern()).matcher(identifier).find() : true;
    }

    public static Namespace getNamespace(String key) {
        return Resolver.getNamespace(key, true);
    }

    public static Namespace getNamespace(String key, boolean allowVariants) {
        if (StringUtils.isBlank(key)) {
            return null;
        }
        key = key.toUpperCase();
        key = StringUtils.removeEnd(key, "/");
        key = key.replaceFirst("OBO\\.", "");
        key = key.replaceFirst("PSI-", "");
        key = key.replaceFirst("URN:MIRIAM:", "");
        key = key.replaceFirst(".*IDENTIFIERS\\.ORG/(.*/)?", "");
        String prefix = (key = key.replaceFirst(".*BIOREGISTRY\\.IO/", "")).toLowerCase();
        Namespace ns = namespaces.get(prefix);
        if (ns == null && (prefix = synonymap.get(key)) != null) {
            ns = namespaces.get(prefix.toLowerCase());
        }
        if (ns == null && allowVariants && (prefix = spellmap.get(key.replaceAll("[^A-Z0-9]", ""))) != null) {
            ns = namespaces.get(prefix.toLowerCase());
        }
        return ns;
    }

    public static String getURI(String name, String id) {
        String cid = Resolver.getCURIE(name, id);
        return cid != null ? BIOREGISTRY_IO + cid : null;
    }

    public static String getCURIE(String name, String id) {
        Namespace ns = Resolver.getNamespace(name, true);
        if (ns != null && StringUtils.isNotBlank(ns.getPattern()) && Resolver.checkRegExp(id, name)) {
            String prefix = ns.getPrefix();
            String banana = ns.getBanana();
            if (StringUtils.isNotBlank(banana)) {
                id = id.replaceFirst(banana + ns.getBanana_peel(), "");
            }
            return prefix + ":" + id;
        }
        return null;
    }

    public static Map<String, Namespace> getNamespaces() {
        return Collections.unmodifiableMap(namespaces);
    }

    public static Map<String, String> getSpellmap() {
        return Collections.unmodifiableMap(spellmap);
    }

    public static void setSpellmap(Map<String, String> map) {
        spellmap = map;
    }

    public static Map<String, String> getSynonymap() {
        return Collections.unmodifiableMap(synonymap);
    }

    public static void setSynonymap(Map<String, String> map) {
        synonymap = map;
    }

    public static boolean isKnownNameOrVariant(String name) {
        return Resolver.getNamespace(name, true) != null;
    }

    static {
        InputStream is = null;
        try {
            ObjectMapper om = new ObjectMapper();
            om.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            is = Resolver.class.getResourceAsStream("spellmap.json");
            spellmap = new ConcurrentSkipListMap<String, String>(om.readValue(is, new TypeReference<Map<String, String>>(){}));
            is = Resolver.class.getResourceAsStream("synonymap.json");
            synonymap = new ConcurrentSkipListMap<String, String>(om.readValue(is, new TypeReference<Map<String, String>>(){}));
            boolean useLatestBioregistry = Boolean.getBoolean("paxtools.normalizer.use-latest-registry");
            if (useLatestBioregistry) {
                LOG.info("Getting registry.json from bioregistry.io (property: paxtools.normalizer.use-latest-registry=true)");
                try {
                    is = new URL(BIOREGISTRY_JSON_URL).openStream();
                    namespaces = new ConcurrentSkipListMap<String, Namespace>(om.readValue(is, new TypeReference<Map<String, Namespace>>(){}));
                }
                catch (Exception e) {
                    LOG.warn("Failed loading registry.json from URL (fallback to the built-in, v2023-08-26)", e);
                }
            }
            if (namespaces == null || namespaces.isEmpty()) {
                is = Resolver.class.getResourceAsStream("registry.json");
                namespaces = new ConcurrentSkipListMap<String, Namespace>(om.readValue(is, new TypeReference<Map<String, Namespace>>(){}));
            }
            LOG.info("read registry.json to the namespaces map; size: {}", (Object)namespaces.size());
            namespaces.forEach((prefix, ns) -> {
                ns.setPrefix((String)prefix);
                String uname = ns.getName().toUpperCase();
                String upref = prefix.toUpperCase();
                synonymap.put(uname, (String)prefix);
                synonymap.put(upref, (String)prefix);
                spellmap.put(uname.replaceAll("[^A-Z0-9]", ""), (String)prefix);
                spellmap.put(upref.replaceAll("[^A-Z0-9]", ""), (String)prefix);
                ns.getSynonyms().forEach(syn -> {
                    String s = syn.toUpperCase();
                    synonymap.putIfAbsent(s, (String)prefix);
                    spellmap.putIfAbsent(s.replaceAll("[^A-Z0-9]", ""), (String)prefix);
                });
            });
            LOG.info("initialized");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

