/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.constraint;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.constraint.ConstraintAdapter;

public class ControlToControllerER
extends ConstraintAdapter {
    static final PathAccessor TO_CONTROLLER = new PathAccessor("Control/controller*:PhysicalEntity");
    static final PathAccessor TO_SUB_ERS = new PathAccessor("SimplePhysicalEntity/memberPhysicalEntity*:SimplePhysicalEntity/entityReference");

    public ControlToControllerER() {
        super(2);
    }

    @Override
    public boolean canGenerate() {
        return true;
    }

    @Override
    public Collection<BioPAXElement> generate(Match match, int ... ind) {
        Control ctrl = (Control)match.get(ind[0]);
        return new HashSet<BioPAXElement>(this.getRelatedERs(ctrl));
    }

    public Set<EntityReference> getRelatedERs(Control ctrl) {
        HashSet<EntityReference> ers = new HashSet<EntityReference>();
        for (Object o : TO_CONTROLLER.getValueFromBean(ctrl)) {
            if (!(o instanceof PhysicalEntity)) continue;
            ers.addAll(this.getRelatedERs((PhysicalEntity)o));
        }
        return ers;
    }

    public Set<EntityReference> getRelatedERs(PhysicalEntity pe) {
        HashSet<EntityReference> ers = new HashSet<EntityReference>();
        if (pe instanceof Complex) {
            ers.addAll(((Complex)pe).getMemberReferences());
        } else if (pe instanceof SimplePhysicalEntity) {
            EntityReference er = ((SimplePhysicalEntity)pe).getEntityReference();
            if (er != null) {
                ers.add(er);
            }
            for (Object o : TO_SUB_ERS.getValueFromBean(pe)) {
                if (!(o instanceof EntityReference)) continue;
                ers.add((EntityReference)o);
            }
        }
        return ers;
    }
}

