/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.pattern.miner.CSCOBothControllerAndParticipantMiner;
import org.biopax.paxtools.pattern.miner.CSCOButIsParticipantMiner;
import org.biopax.paxtools.pattern.miner.CSCOThroughBindingSmallMoleculeMiner;
import org.biopax.paxtools.pattern.miner.CSCOThroughControllingSmallMoleculeMiner;
import org.biopax.paxtools.pattern.miner.CSCOThroughDegradationMiner;
import org.biopax.paxtools.pattern.miner.CatalysisPrecedesMiner;
import org.biopax.paxtools.pattern.miner.ChemicalAffectsThroughBindingMiner;
import org.biopax.paxtools.pattern.miner.ChemicalAffectsThroughControlMiner;
import org.biopax.paxtools.pattern.miner.ConsumptionControlledByMiner;
import org.biopax.paxtools.pattern.miner.ControlsExpressionMiner;
import org.biopax.paxtools.pattern.miner.ControlsExpressionWithConvMiner;
import org.biopax.paxtools.pattern.miner.ControlsPhosphorylationMiner;
import org.biopax.paxtools.pattern.miner.ControlsProductionOfMiner;
import org.biopax.paxtools.pattern.miner.ControlsStateChangeOfMiner;
import org.biopax.paxtools.pattern.miner.ControlsTransportMiner;
import org.biopax.paxtools.pattern.miner.ControlsTransportOfChemicalMiner;
import org.biopax.paxtools.pattern.miner.InComplexWithMiner;
import org.biopax.paxtools.pattern.miner.InteractsWithMiner;
import org.biopax.paxtools.pattern.miner.NeighborOfMiner;
import org.biopax.paxtools.pattern.miner.ReactsWithMiner;
import org.biopax.paxtools.pattern.miner.SIFMiner;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.miner.UsedToProduceMiner;

public enum SIFEnum implements SIFType
{
    CONTROLS_STATE_CHANGE_OF("First protein is controlling a reaction that changes the state of the second protein.", true, ControlsStateChangeOfMiner.class, CSCOButIsParticipantMiner.class, CSCOBothControllerAndParticipantMiner.class, CSCOThroughControllingSmallMoleculeMiner.class, CSCOThroughBindingSmallMoleculeMiner.class, CSCOThroughDegradationMiner.class),
    CONTROLS_TRANSPORT_OF("First protein is controlling a reaction that changes the cellular location of the second protein.", true, ControlsTransportMiner.class),
    CONTROLS_PHOSPHORYLATION_OF("First protein is controlling a reaction that changes the phosphorylation status of the second protein.", true, ControlsPhosphorylationMiner.class),
    CONTROLS_EXPRESSION_OF("First protein is controlling a conversion or a template reaction thatchanges expression of the second protein.", true, ControlsExpressionMiner.class, ControlsExpressionWithConvMiner.class),
    CATALYSIS_PRECEDES("First protein is controlling a reaction whose output molecule is input to another reaction controlled by the second protein.", true, CatalysisPrecedesMiner.class),
    IN_COMPLEX_WITH("Proteins appear as members of the same complex.", false, InComplexWithMiner.class),
    INTERACTS_WITH("Proteins appear as participants of the same MolecularInteraction.", false, InteractsWithMiner.class),
    NEIGHBOR_OF("Proteins appear as participants or controllers of the same interaction.", false, NeighborOfMiner.class),
    CONSUMPTION_CONTROLLED_BY("The small molecule is consumed by a reaction that is controlled by a protein.", true, ConsumptionControlledByMiner.class),
    CONTROLS_PRODUCTION_OF("The protein is controlling a reaction of which the small molecule is an output.", true, ControlsProductionOfMiner.class),
    CONTROLS_TRANSPORT_OF_CHEMICAL("The protein is controlling a reaction that changes cellular location of the small molecule.", true, ControlsTransportOfChemicalMiner.class),
    CHEMICAL_AFFECTS("A small molecule has an effect on a protein.", true, ChemicalAffectsThroughControlMiner.class, ChemicalAffectsThroughBindingMiner.class),
    REACTS_WITH("A small molecule is input to a biochemical reaction together with another small molecule. None of the molecules are also output.", false, ReactsWithMiner.class),
    USED_TO_PRODUCE("A small molecule is input to a biochemical reaction that produces another small molecule. Both small molecules appear at only one side of the reaction.", true, UsedToProduceMiner.class);

    private String description;
    private boolean directed;
    private List<Class<? extends SIFMiner>> miners;

    private SIFEnum(String description, boolean directed, Class<? extends SIFMiner> ... miners) {
        this.description = description;
        this.directed = directed;
        this.miners = Arrays.asList(miners);
    }

    @Override
    public String getTag() {
        return this.name().toLowerCase().replaceAll("_", "-");
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Class<? extends SIFMiner>> getMiners() {
        return this.miners;
    }

    public static SIFEnum typeOf(String tag) {
        if (StringUtils.isBlank(tag)) {
            return null;
        }
        SIFEnum type = null;
        try {
            tag = tag.toUpperCase().replaceAll("-", "_");
            type = SIFEnum.valueOf(tag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return type;
    }
}

