/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;

public class ChemicalNameNormalizer {
    Map<SmallMoleculeReference, SmallMoleculeReference> map = new HashMap<SmallMoleculeReference, SmallMoleculeReference>();
    private static final PathAccessor INTER_ACC = new PathAccessor("SmallMoleculeReference/entityReferenceOf/participantOf");

    public String getName(SmallMoleculeReference smr) {
        if (this.map.containsKey(smr)) {
            return this.map.get(smr).getDisplayName();
        }
        return smr.getDisplayName();
    }

    public ChemicalNameNormalizer(Model model) {
        HashSet<SmallMoleculeReference> standard = new HashSet<SmallMoleculeReference>();
        HashSet<SmallMoleculeReference> other = new HashSet<SmallMoleculeReference>();
        for (SmallMoleculeReference smr : model.getObjects(SmallMoleculeReference.class)) {
            if (smr.getUri().startsWith("http://identifiers")) {
                standard.add(smr);
                continue;
            }
            other.add(smr);
        }
        System.out.println("Standard smr = " + standard.size());
        System.out.println("Other smr = " + other.size());
        Map<SmallMoleculeReference, Set<String>> smrNames = this.collectNames(false, standard, other);
        Map<SmallMoleculeReference, Set<String>> smNames = this.collectNames(true, standard, other);
        Map<SmallMoleculeReference, Set<SmallMoleculeReference>> standardSelfMatch = this.getSelfMatching(standard, smrNames, smNames, true);
        for (SmallMoleculeReference smr : standardSelfMatch.keySet()) {
            Set<SmallMoleculeReference> matches = standardSelfMatch.get(smr);
            if (matches.size() == 1) {
                Iterator<Object> m = matches.iterator().next();
                if (smr.getDisplayName().length() > m.getDisplayName().length()) continue;
                this.map.put(smr, (SmallMoleculeReference)((Object)m));
                standard.remove(smr);
                continue;
            }
            System.out.print(smr.getDisplayName() + " matched more than one");
            for (SmallMoleculeReference match : matches) {
                System.out.print("\t" + match.getDisplayName());
            }
            System.out.println();
        }
        Map<SmallMoleculeReference, Set<SmallMoleculeReference>> selfMatch = this.getSelfMatching(other, smrNames, smNames, false);
        this.enrichNamesWithMatchings(selfMatch, smrNames);
        this.enrichNamesWithMatchings(selfMatch, smNames);
        HashSet<SmallMoleculeReference> missed = new HashSet<SmallMoleculeReference>();
        HashMap<SmallMoleculeReference, Set<SmallMoleculeReference>> multiMap = new HashMap<SmallMoleculeReference, Set<SmallMoleculeReference>>();
        for (SmallMoleculeReference smr : other) {
            Set<SmallMoleculeReference> matching = this.getMatching(smr, standard, smrNames, smNames);
            if (matching.size() == 1) {
                this.map.put(smr, matching.iterator().next());
                continue;
            }
            if (matching.size() > 1) {
                multiMap.put(smr, matching);
                continue;
            }
            missed.add(smr);
        }
        for (SmallMoleculeReference smr : multiMap.keySet()) {
            if (this.isGeneric(smr)) continue;
            Set matches = (Set)multiMap.get(smr);
            SmallMoleculeReference rep = this.selectRepresentative(matches, this.map);
            this.map.put(smr, rep);
            for (SmallMoleculeReference match : matches) {
                if (match == rep) continue;
                if (this.map.containsKey(match)) {
                    if (this.map.get(match) != rep) continue;
                    continue;
                }
                if (this.map.values().contains(match)) continue;
                this.map.put(match, rep);
            }
        }
        Iterator iter = multiMap.keySet().iterator();
        while (iter.hasNext()) {
            SmallMoleculeReference smr;
            smr = (SmallMoleculeReference)iter.next();
            if (!this.map.containsKey(smr)) continue;
            iter.remove();
        }
        System.out.println("matchCnt = " + this.map.size());
        System.out.println("multiCnt = " + multiMap.size());
        System.out.println("missCnt = " + missed.size());
        System.out.println();
    }

    private Map<SmallMoleculeReference, Set<String>> collectNames(boolean peLevel, Set<SmallMoleculeReference> ... sets) {
        HashMap<SmallMoleculeReference, Set<String>> map = new HashMap<SmallMoleculeReference, Set<String>>();
        for (Set<SmallMoleculeReference> set : sets) {
            for (SmallMoleculeReference smr : set) {
                map.put(smr, new HashSet());
                if (!peLevel) {
                    for (String name : smr.getName()) {
                        ((Set)map.get(smr)).add(name.toLowerCase());
                    }
                    continue;
                }
                for (SimplePhysicalEntity sm : smr.getEntityReferenceOf()) {
                    for (String name : sm.getName()) {
                        ((Set)map.get(smr)).add(name.toLowerCase());
                    }
                }
            }
        }
        return map;
    }

    private Set<SmallMoleculeReference> getNameNormalizedMatching(SmallMoleculeReference smr, Set<SmallMoleculeReference> smrs) {
        String name = null;
        String dispName = smr.getDisplayName().toLowerCase();
        if (dispName.endsWith("-)") || dispName.endsWith("+)")) {
            name = dispName.substring(0, dispName.lastIndexOf("(")).trim();
        } else if (dispName.endsWith(" zwitterion")) {
            name = dispName.substring(0, dispName.lastIndexOf(" ")).trim();
        }
        if (name == null) {
            return Collections.emptySet();
        }
        HashSet<SmallMoleculeReference> matching = new HashSet<SmallMoleculeReference>();
        for (SmallMoleculeReference ref : smrs) {
            if (!ref.getDisplayName().toLowerCase().equals(name)) continue;
            matching.add(ref);
        }
        return matching;
    }

    private Set<SmallMoleculeReference> getMatching(SmallMoleculeReference smr, Set<SmallMoleculeReference> standard, Map<SmallMoleculeReference, Set<String>> smrNames, Map<SmallMoleculeReference, Set<String>> smNames) {
        HashSet<SmallMoleculeReference> matching = new HashSet<SmallMoleculeReference>();
        for (SmallMoleculeReference std : standard) {
            if (std.getDisplayName() == null || smr.getDisplayName() == null || !std.getDisplayName().equalsIgnoreCase(smr.getDisplayName())) continue;
            matching.add(std);
        }
        if (!matching.isEmpty()) {
            return matching;
        }
        for (SmallMoleculeReference std : standard) {
            for (String name : smrNames.get(smr)) {
                if (!smrNames.get(std).contains(name)) continue;
                matching.add(std);
            }
        }
        if (!matching.isEmpty()) {
            return matching;
        }
        for (SmallMoleculeReference std : standard) {
            for (String name : smrNames.get(smr)) {
                if (!smNames.get(std).contains(name)) continue;
                matching.add(std);
            }
        }
        if (!matching.isEmpty()) {
            return matching;
        }
        for (SmallMoleculeReference std : standard) {
            for (String name : smNames.get(smr)) {
                if (!smrNames.get(std).contains(name)) continue;
                matching.add(std);
            }
        }
        if (!matching.isEmpty()) {
            return matching;
        }
        for (SmallMoleculeReference std : standard) {
            for (String name : smNames.get(smr)) {
                if (!smNames.get(std).contains(name)) continue;
                matching.add(std);
            }
        }
        return matching;
    }

    private Map<SmallMoleculeReference, Set<SmallMoleculeReference>> getSelfMatching(Set<SmallMoleculeReference> smrs, Map<SmallMoleculeReference, Set<String>> smrNames, Map<SmallMoleculeReference, Set<String>> smNames, boolean normalizeName) {
        HashMap<SmallMoleculeReference, Set<SmallMoleculeReference>> map = new HashMap<SmallMoleculeReference, Set<SmallMoleculeReference>>();
        for (SmallMoleculeReference smr : smrs) {
            Set<SmallMoleculeReference> matching;
            Set<SmallMoleculeReference> set = matching = normalizeName ? this.getNameNormalizedMatching(smr, smrs) : this.getMatching(smr, smrs, smrNames, smNames);
            assert (normalizeName || !matching.isEmpty() || smr.getName().isEmpty());
            matching.remove(smr);
            if (matching.isEmpty()) continue;
            map.put(smr, matching);
        }
        return map;
    }

    private Map<SmallMoleculeReference, Integer> getInteractionCounts(Set<SmallMoleculeReference> ... smrSets) {
        HashMap<SmallMoleculeReference, Integer> cnt = new HashMap<SmallMoleculeReference, Integer>();
        for (Set<SmallMoleculeReference> smrSet : smrSets) {
            for (SmallMoleculeReference smr : smrSet) {
                if (cnt.containsKey(smr)) continue;
                cnt.put(smr, INTER_ACC.getValueFromBean(smr).size());
            }
        }
        return cnt;
    }

    private void enrichNamesWithMatchings(Map<SmallMoleculeReference, Set<SmallMoleculeReference>> matchMap, Map<SmallMoleculeReference, Set<String>> names) {
        for (SmallMoleculeReference smr : matchMap.keySet()) {
            for (SmallMoleculeReference match : matchMap.get(smr)) {
                names.get(smr).addAll((Collection<String>)names.get(match));
            }
        }
    }

    private boolean isGeneric(SmallMoleculeReference smr) {
        if (!smr.getMemberEntityReference().isEmpty()) {
            return true;
        }
        for (SimplePhysicalEntity sm : smr.getEntityReferenceOf()) {
            if (sm.getMemberPhysicalEntity().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private SmallMoleculeReference selectRepresentative(Set<SmallMoleculeReference> smrs, Map<SmallMoleculeReference, SmallMoleculeReference> map) {
        ArrayList<SmallMoleculeReference> list = new ArrayList<SmallMoleculeReference>(smrs);
        Map<SmallMoleculeReference, Integer> cnt = this.getInteractionCounts(smrs);
        Collections.sort(list, (o1, o2) -> {
            if (map.containsValue(o1)) {
                if (!map.containsValue(o2)) {
                    return -1;
                }
            } else if (map.containsValue(o2)) {
                return 1;
            }
            if (!((Integer)cnt.get(o1)).equals(cnt.get(o2))) {
                return ((Integer)cnt.get(o2)).compareTo((Integer)cnt.get(o1));
            }
            if (o1.getDisplayName().endsWith(")")) {
                if (!o2.getDisplayName().endsWith(")")) {
                    return -1;
                }
            } else if (o2.getDisplayName().endsWith(")")) {
                return 1;
            }
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        });
        return (SmallMoleculeReference)list.get(0);
    }
}

