/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.algorithm;

import org.apache.commons.lang3.StringUtils;

public enum Direction {
    UPSTREAM("Search direction backwards in the order of events"),
    DOWNSTREAM("Search direction forward in the order of events"),
    BOTHSTREAM("Search towards both directions"),
    UNDIRECTED("Search without considering directions");

    private final String description;

    private Direction(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static Direction typeOf(String tag) {
        if (StringUtils.isBlank(tag)) {
            return null;
        }
        Direction type = null;
        try {
            type = Direction.valueOf(tag.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return type;
    }
}

