/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HGNC {
    private static final Logger LOG = LoggerFactory.getLogger(HGNC.class);
    private static Map<String, String> sym2id = new HashMap<String, String>();
    private static Map<String, String> id2sym = new HashMap<String, String>();
    private static Map<String, String> old2new = new HashMap<String, String>();
    private static Map<String, String> sym2eg = new HashMap<String, String>();
    private static Map<String, String> eg2sym = new HashMap<String, String>();
    public static final String GENENAMES_CUST_EXPORT_URL = "https://www.genenames.org/cgi-bin/download/custom?col=gd_hgnc_id&col=gd_app_sym&col=gd_prev_sym&col=gd_pub_eg_id&status=Approved&hgnc_dbtag=on&order_by=gd_app_sym_sort&format=text&submit=submit";

    public static String getSymbolByHgncIdOrSym(String idOrSymbol) {
        if (StringUtils.isBlank((CharSequence)idOrSymbol)) {
            return null;
        }
        if (StringUtils.isNumeric((CharSequence)idOrSymbol)) {
            idOrSymbol = "HGNC:" + (String)idOrSymbol;
        }
        if (id2sym.containsKey(((String)idOrSymbol).toUpperCase())) {
            return id2sym.get(((String)idOrSymbol).toUpperCase());
        }
        if (sym2id.containsKey(idOrSymbol)) {
            return idOrSymbol;
        }
        if (old2new.containsKey(idOrSymbol)) {
            return old2new.get(idOrSymbol);
        }
        if (!((String)idOrSymbol).toUpperCase().equals(idOrSymbol)) {
            return HGNC.getSymbolByHgncIdOrSym(((String)idOrSymbol).toUpperCase());
        }
        return null;
    }

    public static String getHgncId(String symbol) {
        String s = HGNC.getSymbolByHgncIdOrSym(symbol);
        return s != null ? sym2id.get(s) : null;
    }

    public static String getGeneId(String symbol) {
        String s = HGNC.getSymbolByHgncIdOrSym(symbol);
        return s != null ? sym2eg.get(s) : null;
    }

    public static String getSymbolByGeneId(String id) {
        return eg2sym.get(id);
    }

    public static boolean containsGeneId(String id) {
        return eg2sym.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Scanner reader = null;
        try {
            if (Boolean.getBoolean("paxtools.core.use-latest-genenames")) {
                try {
                    URL genenamesUrl = new URL(GENENAMES_CUST_EXPORT_URL);
                    reader = new Scanner(genenamesUrl.openStream());
                    LOG.info("Loading the latest mapping from: " + String.valueOf(genenamesUrl));
                }
                catch (IOException e) {
                    reader = null;
                    LOG.error("Failed getting the latest mapping from genenames.org; " + String.valueOf(e));
                }
            }
            if (reader == null) {
                LOG.info("Loading the built-in genenames.txt mapping file");
                reader = new Scanner(HGNC.class.getResourceAsStream("genenames.txt"));
            }
            reader.useDelimiter("/t");
            String line = reader.nextLine();
            LOG.debug("Skipped genenames title line: " + line);
            while (reader.hasNextLine()) {
                line = reader.nextLine();
                String[] token = line.split("\t", -1);
                String id = token[0].trim();
                String sym = token[1].trim();
                sym2id.put(sym, id);
                String ret = id2sym.put(id, sym);
                if (ret != null) {
                    LOG.warn("Ambiguous mapping; {} maps to hgnc: {}, {}", sym, ret, id);
                }
                String olds = token[2].trim();
                for (String old : olds.split(",")) {
                    old = old.trim();
                    old2new.put(old, sym);
                }
                String eg = token[3].trim();
                if (!StringUtils.isNotBlank(eg)) continue;
                sym2eg.put(sym, eg);
                ret = eg2sym.put(eg, sym);
                if (ret == null) continue;
                LOG.warn("Ambiguous mapping; {} maps to ncbigene: {}, {}", sym, ret, eg);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to init gene id/symbol mappings", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

