/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;
import psidev.psi.mi.tab.utils.PsiCollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterInteractorPairProcessor<T extends BinaryInteraction>
implements PostProcessorStrategy<T> {
    public static final Log log = LogFactory.getLog(ClusterInteractorPairProcessor.class);

    protected void mergeCollection(Collection source, Collection target) {
        if (source == null) {
            throw new IllegalArgumentException("Source collection must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target collection must not be null.");
        }
        if (source == target) {
            throw new IllegalStateException();
        }
        for (Object o : source) {
            target.add(o);
        }
    }

    @Override
    public Collection<T> process(Collection<T> interactions) {
        boolean verbose = true;
        HashMap<TwoInteractor, BinaryInteraction> map = new HashMap<TwoInteractor, BinaryInteraction>(interactions.size());
        int count = 0;
        int global = 0;
        long start = System.currentTimeMillis();
        Iterator<T> iterator = interactions.iterator();
        while (iterator.hasNext()) {
            TwoInteractor ti;
            BinaryInteraction target;
            BinaryInteraction interaction2 = (BinaryInteraction)iterator.next();
            ++global;
            if (log.isDebugEnabled() && ++count != 0 && count % 1000 == 0) {
                float elapsedTimeMin = (float)(System.currentTimeMillis() - start) / 60000.0f;
                int nbRemainInteractions = interactions.size() - global;
                double timeByInteraction = (double)elapsedTimeMin / 1000.0;
                double etaMin = timeByInteraction * (double)nbRemainInteractions;
                log.debug(global + " interactions processed (" + elapsedTimeMin + " min for these last 1000) - ETA = " + etaMin + " min");
                count = 0;
                start = System.currentTimeMillis();
            }
            if ((target = (BinaryInteraction)map.get(ti = new TwoInteractor(new SimpleInteractor((Interactor)interaction2.getInteractorA()), new SimpleInteractor((Interactor)interaction2.getInteractorB())))) != null) {
                if (target == interaction2) {
                    log.warn("The given collection cluster contained twice the same interaction. one was removed: " + interaction2);
                    iterator.remove();
                    continue;
                }
                this.mergeCollections(interaction2, target);
                continue;
            }
            map.put(ti, interaction2);
        }
        return map.values();
    }

    protected void mergeCollections(T interaction2, T target) {
        this.mergeCollection(interaction2.getAuthors(), target.getAuthors());
        this.mergeCollection(interaction2.getPublications(), target.getPublications());
        this.mergeCollection(interaction2.getConfidenceValues(), target.getConfidenceValues());
        this.mergeCollection(interaction2.getDetectionMethods(), target.getDetectionMethods());
        this.mergeCollection(interaction2.getInteractionTypes(), target.getInteractionTypes());
        this.mergeCollection(interaction2.getSourceDatabases(), target.getSourceDatabases());
        this.mergeCollection(interaction2.getInteractionAcs(), target.getInteractionAcs());
    }

    protected static class TwoInteractor {
        private SimpleInteractor interactorA;
        private SimpleInteractor interactorB;

        public TwoInteractor(SimpleInteractor interactorA, SimpleInteractor interactorB) {
            this.interactorA = interactorA;
            this.interactorB = interactorB;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwoInteractor that = (TwoInteractor)o;
            boolean isEqualAA = this.compareInteractors(this.interactorA, that.interactorA);
            boolean isEqualBB = this.compareInteractors(this.interactorB, that.interactorB);
            if (isEqualAA && isEqualBB) {
                return true;
            }
            boolean isEqualAB = this.compareInteractors(this.interactorA, that.interactorB);
            boolean isEqualBA = this.compareInteractors(this.interactorB, that.interactorA);
            return isEqualAB && isEqualBA;
        }

        public int hashCode() {
            Collection<Object> inter = Collections.EMPTY_LIST;
            int res = 1;
            if (this.interactorA != null && this.interactorB != null) {
                inter = PsiCollectionUtils.intersection(this.interactorA.identifiers, this.interactorB.identifiers);
                for (CrossReference crossReference : inter) {
                    res = 31 * res * crossReference.hashCode();
                }
                res *= this.interactorA.taxid != null ? this.interactorA.taxid.hashCode() : 1;
                res *= this.interactorB.taxid != null ? this.interactorB.taxid.hashCode() : 1;
            } else if (this.interactorA != null) {
                inter = this.interactorA.identifiers;
                for (CrossReference crossReference : inter) {
                    res = 31 * res * crossReference.hashCode();
                }
                res *= this.interactorA.taxid != null ? this.interactorA.taxid.hashCode() : 1;
            } else if (this.interactorB != null) {
                inter = this.interactorB.identifiers;
                for (CrossReference crossReference : inter) {
                    res = 31 * res * crossReference.hashCode();
                }
                res *= this.interactorB.taxid != null ? this.interactorB.taxid.hashCode() : 1;
            }
            return res;
        }

        private boolean compareInteractors(SimpleInteractor a, SimpleInteractor b) {
            if (a != null && b != null) {
                return a.equals(b);
            }
            if (a != null) {
                return false;
            }
            return b == null;
        }
    }

    protected static class SimpleInteractor {
        Collection<CrossReference> identifiers;
        Integer taxid;

        public SimpleInteractor(Interactor interactor) {
            if (interactor == null) {
                this.identifiers = new ArrayList<CrossReference>();
            } else {
                this.identifiers = interactor.getIdentifiers();
                if (interactor.hasOrganism()) {
                    for (CrossReference cr : interactor.getOrganism().getIdentifiers()) {
                        if (!cr.getDatabase().equals("taxid")) continue;
                        this.taxid = new Integer(cr.getIdentifier());
                    }
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleInteractor that = (SimpleInteractor)o;
            if (this.taxid != null ? !this.taxid.equals(that.taxid) : that.taxid != null) {
                return false;
            }
            return !PsiCollectionUtils.intersection(this.identifiers, that.identifiers).isEmpty();
        }

        public int hashCode() {
            int result = this.identifiers.hashCode();
            result = 31 * result + (this.taxid != null ? this.taxid.hashCode() : 0);
            return result;
        }
    }
}

