/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.xxindex.index;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBuffer
implements Iterable<Byte> {
    private List<Byte> buffer = new ArrayList<Byte>();

    public void append(byte b) {
        this.buffer.add(b);
    }

    public Byte get(int i) {
        return this.buffer.get(i);
    }

    public void remove(int i) {
        this.buffer.remove(i);
    }

    public int size() {
        return this.buffer.size();
    }

    public void clear() {
        this.buffer.clear();
    }

    public byte[] toArray() {
        int liSize = this.buffer.size();
        byte[] result = new byte[liSize];
        for (int i = 0; i < liSize; ++i) {
            result[i] = this.buffer.get(i);
        }
        return result;
    }

    public String toString(String charsetName) {
        String result;
        byte[] bArray = new byte[this.buffer.size()];
        int i = 0;
        for (Byte aByte : this.buffer) {
            bArray[i] = aByte;
            ++i;
        }
        if (charsetName == null) {
            result = new String(bArray);
        } else {
            try {
                result = new String(bArray, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                result = "Unsupported Charset name: " + charsetName;
            }
        }
        return result;
    }

    public String toString() {
        return this.toString(null);
    }

    protected String toStringByteByByte() {
        StringBuffer sb = new StringBuffer();
        for (Byte aByte : this.buffer) {
            byte[] b = new byte[]{aByte};
            sb.append(new String(b));
            sb.append("-");
        }
        return sb.toString();
    }

    @Override
    public Iterator<Byte> iterator() {
        return new ByteBufferIterator(this.buffer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByteBufferIterator
    implements Iterator<Byte> {
        private List<Byte> bBuf;
        private Iterator<Byte> iterator;

        protected ByteBufferIterator(List<Byte> buf) {
            this.bBuf = buf;
            this.iterator = this.bBuf.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Byte next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

