/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTraverser
extends Traverser
implements Visitor {
    private static final Logger log = LoggerFactory.getLogger(AbstractTraverser.class);
    protected final Set<BioPAXElement> visited;

    public AbstractTraverser(EditorMap editorMap, Filter<PropertyEditor> ... filters) {
        super(editorMap, null, filters);
        this.setVisitor(this);
        this.visited = new HashSet<BioPAXElement>();
    }

    protected abstract void visit(Object var1, BioPAXElement var2, Model var3, PropertyEditor<?, ?> var4);

    @Override
    public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor<?, ?> editor) {
        this.visit(range, domain, model, editor);
    }

    @Override
    public <D extends BioPAXElement> void traverse(D element, Model model) {
        if (this.visited.add(element)) {
            super.traverse(element, model);
        } else {
            log.debug("Escaped a loop: again " + element.getUri());
        }
    }

    public void reset() {
        this.visited.clear();
    }
}

