/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilterSet<F, E>
extends AbstractSet<E>
implements Filter<F> {
    private static final Logger log = LoggerFactory.getLogger(ClassFilterSet.class);
    int size = -1;
    protected final Set<? extends F> baseSet;

    public AbstractFilterSet(Set<? extends F> baseSet) {
        this.baseSet = baseSet;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            int i = 0;
            for (E e : this) {
                ++i;
            }
            this.size = i;
        }
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        return this.baseSet.contains(o) && this.filter(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new FilterIterator(this.baseSet.iterator());
    }

    private class FilterIterator
    implements Iterator<E> {
        E next = null;
        final Iterator<? extends F> base;

        public FilterIterator(Iterator<? extends F> base) {
            this.base = base;
            this.fetchNext();
        }

        private void fetchNext() {
            this.next = null;
            while (this.base.hasNext()) {
                Object check = this.base.next();
                if (!AbstractFilterSet.this.filter(check)) continue;
                try {
                    this.next = check;
                    break;
                }
                catch (ClassCastException ce) {
                    log.error("wrong use of filter set. Skipping.", (Throwable)ce);
                    return;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                Object value = this.next;
                this.fetchNext();
                return value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

