/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.biopax.paxtools.controller.FilteredByDomainPropertyAccessor;
import org.biopax.paxtools.controller.FilteredPropertyAccessor;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyAccessor;
import org.biopax.paxtools.controller.PropertyAccessorAdapter;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.TransitivePropertyAccessor;
import org.biopax.paxtools.controller.UnionPropertyAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathAccessor
extends PropertyAccessorAdapter<BioPAXElement, Object> {
    List<PropertyAccessor<? extends BioPAXElement, ?>> accessors;
    Class<? extends BioPAXElement> domain;
    List<Class<? extends BioPAXElement>> domainOrder = new ArrayList<Class<? extends BioPAXElement>>();
    public static final Logger log = LoggerFactory.getLogger(PathAccessor.class);
    BioPAXLevel level;

    public PathAccessor(List<PropertyAccessor<? extends BioPAXElement, ?>> objectAccessors, BioPAXLevel level) {
        super(BioPAXElement.class, Object.class, true);
        this.accessors = objectAccessors;
        this.domain = objectAccessors.get(0).getDomain();
        this.level = level;
    }

    public PathAccessor(String path, BioPAXLevel level) {
        super(BioPAXElement.class, Object.class, true);
        this.level = level;
        this.parsePath(path, 0);
    }

    private PathAccessor(StringTokenizer tk, BioPAXLevel level, Class<? extends BioPAXElement> domain, int depth) {
        super(BioPAXElement.class, Object.class, true);
        this.domain = domain;
        this.level = level;
        if (this.iterateTheRemainingPath(depth, tk) != depth) {
            throw new IllegalBioPAXArgumentException("Unexpected element. Parentheses do not match!");
        }
    }

    private int parsePath(String path, int depth) {
        PropertyAccessor stepAccessor;
        StringTokenizer st = new StringTokenizer(path, "/:*|()", true);
        this.domain = this.getClass(st.nextToken());
        this.accessors = new ArrayList();
        if (st.nextToken().equals("/")) {
            stepAccessor = this.getStepAccessor(this.level, st, this.domain);
            if (!this.domain.equals(stepAccessor.getDomain())) {
                assert (stepAccessor.getDomain().isAssignableFrom(this.domain)) : "There must be a serous bug in the design of property editor map!";
                stepAccessor = FilteredByDomainPropertyAccessor.create(stepAccessor, this.domain);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.accessors.add(stepAccessor);
        this.domainOrder.add(this.domain);
        return this.iterateTheRemainingPath(depth, st);
    }

    private int iterateTheRemainingPath(int depth, StringTokenizer st) {
        Class<? extends BioPAXElement> intermediate = this.getNextDomain();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("(")) {
                PathAccessor subPath = new PathAccessor(st, this.level, intermediate, depth++);
                this.accessors.add(subPath);
                this.domainOrder.add(intermediate);
                intermediate = this.getNextDomain();
                continue;
            }
            if (s.equals(")")) {
                return depth;
            }
            if (s.equals("/")) {
                this.accessors.add(this.getStepAccessor(this.level, st, intermediate));
                this.domainOrder.add(intermediate);
                intermediate = this.getNextDomain();
                continue;
            }
            if (s.equals("*")) {
                PropertyAccessor<? extends BioPAXElement, ?> lastAccessor = this.accessors.remove(this.accessors.size() - 1);
                this.accessors.add(TransitivePropertyAccessor.create(lastAccessor));
                continue;
            }
            if (s.equals(":")) {
                Class<? extends BioPAXElement> restricted = this.getClass(st.nextToken());
                if (restricted != null) {
                    PropertyAccessor<? extends BioPAXElement, ?> lastAccessor = this.accessors.remove(this.accessors.size() - 1);
                    this.accessors.add(FilteredPropertyAccessor.create(lastAccessor, restricted));
                }
                intermediate = restricted;
                continue;
            }
            if (s.equals("|")) {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            throw new IllegalArgumentException();
        }
        return depth;
    }

    private Class<? extends BioPAXElement> getNextDomain() {
        return this.accessors.isEmpty() ? this.domain : this.getLastAccessor();
    }

    private Class<? extends BioPAXElement> getLastAccessor() {
        return this.accessors.get(this.accessors.size() - 1).getRange();
    }

    public PathAccessor(String path) {
        this(path, BioPAXLevel.L3);
    }

    private Class<? extends BioPAXElement> getClass(String domainstr) {
        Class<? extends BioPAXElement> domain = this.level.getInterfaceForName(domainstr);
        if (domain == null) {
            throw new IllegalBioPAXArgumentException("Could not parse path." + domainstr + " did not resolve to anyBioPAX classes in level " + (Object)((Object)this.level) + ".");
        }
        return domain;
    }

    @Override
    public Set getValueFromBean(BioPAXElement bean) throws IllegalBioPAXArgumentException {
        HashSet<BioPAXElement> bpes = new HashSet<BioPAXElement>();
        bpes.add(bean);
        return this.getValueFromBeans((Collection<? extends BioPAXElement>)bpes);
    }

    @Override
    public Set getValueFromBeans(Collection<? extends BioPAXElement> beans) throws IllegalBioPAXArgumentException {
        Set<?> valueFromBean;
        Collection<? extends BioPAXElement> bpes = beans;
        for (int i = 0; i < this.accessors.size() - 1; ++i) {
            PropertyAccessor<BioPAXElement, ?> accessor = this.accessors.get(i);
            if (log.isTraceEnabled()) {
                log.trace(String.valueOf(accessor));
            }
            HashSet<? extends BioPAXElement> nextBpes = new HashSet<BioPAXElement>();
            for (BioPAXElement bioPAXElement : bpes) {
                if (log.isTraceEnabled()) {
                    log.trace("\t" + bioPAXElement);
                }
                if ((valueFromBean = accessor.getValueFromBean(bioPAXElement)).isEmpty()) continue;
                if (log.isTraceEnabled()) {
                    log.trace("\t\tv:" + valueFromBean);
                }
                nextBpes.addAll(valueFromBean);
                if (!log.isTraceEnabled()) continue;
                log.trace("\t\tn:" + nextBpes);
            }
            bpes = nextBpes;
        }
        HashSet values = new HashSet();
        PropertyAccessor<BioPAXElement, ?> lastStep = this.accessors.get(this.accessors.size() - 1);
        Class<? extends BioPAXElement> lastDomain = this.domainOrder.get(this.domainOrder.size() - 1);
        if (log.isTraceEnabled()) {
            log.trace(String.valueOf(lastStep));
        }
        for (BioPAXElement bioPAXElement : bpes) {
            if (!lastDomain.isInstance(bioPAXElement)) continue;
            log.trace("\t" + bioPAXElement);
            valueFromBean = lastStep.getValueFromBean(bioPAXElement);
            if (valueFromBean.isEmpty()) continue;
            values.addAll(valueFromBean);
            log.trace("\t" + values);
        }
        return values;
    }

    public Set getValueFromModel(Model model) {
        HashSet domains = new HashSet(model.getObjects(this.getDomain()));
        return this.getValueFromBeans(domains);
    }

    private <D extends BioPAXElement> PropertyAccessor getStepAccessor(BioPAXLevel level, StringTokenizer ct, Class<D> domain) {
        String property = ct.nextToken();
        PropertyAccessor<Object, Object> simple = null;
        if (property.endsWith("Of")) {
            String forwardName = property.substring(0, property.length() - 2);
            Set<ObjectPropertyEditor> iEds = SimpleEditorMap.get(level).getInverseEditorsOf(domain);
            if (iEds == null) {
                throw new IllegalBioPAXArgumentException("No inverse editors defined for " + domain);
            }
            for (ObjectPropertyEditor ope : iEds) {
                if (!ope.property.equals(forwardName) || simple != null) continue;
                simple = ope.getInverseAccessor();
            }
        } else {
            simple = SimpleEditorMap.get(level).getEditorForProperty(property, domain);
            if (simple == null) {
                Set subclassEditorsForProperty = SimpleEditorMap.get(level).getSubclassEditorsForProperty(property, domain);
                simple = new UnionPropertyAccessor(subclassEditorsForProperty, domain);
            }
        }
        return simple;
    }

    @Override
    public boolean isUnknown(Object value) {
        if (value instanceof Set) {
            for (Object o : (Set)value) {
                if (this.isSingleUnknown(o)) continue;
                return false;
            }
            return true;
        }
        return this.isSingleUnknown(value);
    }

    private boolean isSingleUnknown(Object value) {
        return value == null || BioPAXElement.UNKNOWN_DOUBLE.equals(value) || BioPAXElement.UNKNOWN_FLOAT.equals(value) || BioPAXElement.UNKNOWN_INT.equals(value);
    }

    public boolean applies(BioPAXElement bpe) {
        Class<? extends BioPAXElement> domain = this.accessors.iterator().next().getDomain();
        return domain.isInstance(bpe);
    }
}

