/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.EditorMapImpl;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SimpleEditorMap implements EditorMap
{
    L2(BioPAXLevel.L2),
    L3(BioPAXLevel.L3);

    private static final Logger log;
    private final SimpleEditorMapImpl impl;

    private SimpleEditorMap(BioPAXLevel level) {
        this.impl = new SimpleEditorMapImpl(level);
    }

    public static SimpleEditorMap get(BioPAXLevel level) {
        for (SimpleEditorMap value : SimpleEditorMap.values()) {
            if (!value.getLevel().equals((Object)level)) continue;
            return value;
        }
        throw new IllegalBioPAXArgumentException("Unknown level:" + String.valueOf((Object)level));
    }

    @Override
    public <D extends BioPAXElement> PropertyEditor<? super D, ?> getEditorForProperty(String property, Class<D> javaClass) {
        return this.impl.getEditorForProperty(property, javaClass);
    }

    @Override
    public Set<PropertyEditor> getEditorsForProperty(String property) {
        return this.impl.getEditorsForProperty(property);
    }

    @Override
    public <D extends BioPAXElement> Set<PropertyEditor<? extends D, ?>> getSubclassEditorsForProperty(String property, Class<D> domain) {
        return this.impl.getSubclassEditorsForProperty(property, domain);
    }

    @Override
    public Set<PropertyEditor> getEditorsOf(BioPAXElement bpe) {
        return this.impl.getEditorsOf(bpe);
    }

    @Override
    public Set<ObjectPropertyEditor> getInverseEditorsOf(BioPAXElement bpe) {
        return this.impl.getInverseEditorsOf(bpe);
    }

    @Override
    public <E extends BioPAXElement> Set<? extends Class<E>> getKnownSubClassesOf(Class<E> javaClass) {
        return this.impl.getKnownSubClassesOf(javaClass);
    }

    @Override
    public BioPAXLevel getLevel() {
        return this.impl.getLevel();
    }

    @Override
    public Set<PropertyEditor> getEditorsOf(Class<? extends BioPAXElement> domain) {
        return this.impl.getEditorsOf(domain);
    }

    @Override
    public Set<ObjectPropertyEditor> getInverseEditorsOf(Class<? extends BioPAXElement> domain) {
        return this.impl.getInverseEditorsOf(domain);
    }

    @Override
    public Iterator<PropertyEditor> iterator() {
        return this.impl.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readEditors(BioPAXLevel level, InputStream stream, EditorMapImpl map) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            String line = reader.readLine();
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreElements()) {
                map.registerModelClass(st.nextToken());
            }
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                st = new StringTokenizer(line);
                String domain = st.nextToken();
                Class<? extends BioPAXElement> domainInterface = map.getLevel().getInterfaceForName(domain);
                String propertyName = st.nextToken();
                HashMap<Class<? extends BioPAXElement>, Set<Class<? extends BioPAXElement>>> rangeRestrictions = new HashMap<Class<? extends BioPAXElement>, Set<Class<? extends BioPAXElement>>>();
                while (st.hasMoreTokens()) {
                    String rToken = st.nextToken();
                    if (!rToken.startsWith("R:")) continue;
                    StringTokenizer rt = new StringTokenizer(rToken.substring(2), "=");
                    Class<? extends BioPAXElement> rDomain = level.getInterfaceForName(rt.nextToken());
                    HashSet<Class<? extends BioPAXElement>> rRanges = new HashSet<Class<? extends BioPAXElement>>();
                    StringTokenizer dt = new StringTokenizer(rt.nextToken(), ",");
                    while (dt.hasMoreTokens()) {
                        rRanges.add(level.getInterfaceForName(dt.nextToken()));
                    }
                    rangeRestrictions.put(rDomain, rRanges);
                }
                map.createAndRegisterBeanEditor(propertyName, domainInterface, rangeRestrictions);
            }
        }
        catch (IOException e) {
            log.error("Could not initialize Editor Map", (Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ignore) {
                log.error("Could not close stream! Exiting");
                System.exit(1);
            }
        }
    }

    public static EditorMap buildCustomEditorMap(BioPAXLevel level, InputStream stream) {
        EditorMapImpl editorMap = new EditorMapImpl(level);
        SimpleEditorMap.readEditors(level, stream, editorMap);
        return editorMap;
    }

    static {
        log = LoggerFactory.getLogger(EditorMapImpl.class);
    }

    static class SimpleEditorMapImpl
    extends EditorMapImpl
    implements EditorMap {
        SimpleEditorMapImpl(BioPAXLevel level) {
            super(level);
            InputStream stream = this.getClass().getResourceAsStream(String.valueOf((Object)level) + "Editor.properties");
            SimpleEditorMap.readEditors(level, stream, this);
        }
    }
}

