/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.impl.level3.CellVocabularyImpl;
import org.biopax.paxtools.impl.level3.XReferrableImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlledVocabularyImpl
extends XReferrableImpl
implements ControlledVocabulary {
    private static final Logger LOG = LoggerFactory.getLogger(CellVocabularyImpl.class);
    private Set<String> term = BPCollections.I.createSet();

    public Class<? extends ControlledVocabulary> getModelInterface() {
        return ControlledVocabulary.class;
    }

    @Override
    public Set<String> getTerm() {
        return this.term;
    }

    public void setTerm(Set<String> term) {
        this.term = term;
    }

    @Override
    public void addTerm(String term) {
        if (term != null && term.length() > 0) {
            this.term.add(term);
        }
    }

    @Override
    public void removeTerm(String term) {
        if (term != null) {
            this.term.remove(term);
        }
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof ControlledVocabulary)) {
            return false;
        }
        ControlledVocabulary that = (ControlledVocabulary)element;
        Set terms = BPCollections.I.createSet();
        terms.addAll(this.term);
        terms.retainAll(that.getTerm());
        return this.getModelInterface().equals(that.getModelInterface()) && (this.term.isEmpty() && that.getTerm().isEmpty() || !terms.isEmpty()) && SetEquivalenceChecker.hasEquivalentIntersection(new ClassFilterSet<Xref, UnificationXref>(this.getXref(), UnificationXref.class), new ClassFilterSet<Xref, UnificationXref>(that.getXref(), UnificationXref.class));
    }

    @Override
    public String toString() {
        Object ret = this.getUri();
        try {
            if (!this.term.isEmpty()) {
                ret = this.getModelInterface().getSimpleName() + "_" + StringUtils.join(this.term, (String)",");
            }
        }
        catch (Exception e) {
            LOG.warn("toString(): ", (Throwable)e);
        }
        return ret;
    }
}

