/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.BiopaxSafeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BPCollections {
    I;

    private CollectionProvider cProvider;
    private final Logger log = LoggerFactory.getLogger(BPCollections.class);

    private BPCollections() {
        String prop = System.getProperty("paxtools.CollectionProvider");
        if (StringUtils.isNotBlank((CharSequence)prop)) {
            try {
                Class<?> cProviderClass = Class.forName(prop);
                this.cProvider = (CollectionProvider)cProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.log.info("Using custom paxtools.CollectionProvider=" + this.cProvider.getClass().getCanonicalName());
            }
            catch (Exception e) {
                this.log.warn("Could not initialize the specified collection provider: " + prop + "; will use the default implementation; error: " + String.valueOf(e));
            }
        }
        if (this.cProvider == null) {
            this.cProvider = new DefaultCollectionProvider();
            this.log.info("Using default paxtools.CollectionProvider=" + this.cProvider.getClass().getCanonicalName());
        }
    }

    public void setProvider(CollectionProvider newProvider) {
        if (newProvider == null) {
            throw new IllegalArgumentException();
        }
        this.cProvider = newProvider;
        this.log.info("Using CollectionProvider: " + newProvider.getClass().getSimpleName());
    }

    public <R> Set<R> createSet() {
        return this.cProvider.createSet();
    }

    public <R extends BioPAXElement> Set<R> createSafeSet() {
        return new BiopaxSafeSet();
    }

    public <D, R> Map<D, R> createMap() {
        return this.cProvider.createMap();
    }

    public static interface CollectionProvider {
        public <R> Set<R> createSet();

        public <D, R> Map<D, R> createMap();
    }

    public static class DefaultCollectionProvider
    implements CollectionProvider {
        @Override
        public <R> Set<R> createSet() {
            return new HashSet();
        }

        @Override
        public <D, R> Map<D, R> createMap() {
            return new HashMap();
        }
    }
}

