/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;

public class EquivalenceGrouper<T extends BioPAXElement> {
    Set<EquivalanceBucket<T>> buckets = new HashSet<EquivalanceBucket<T>>();

    public EquivalenceGrouper(Collection<? extends T> bpes) {
        this();
        this.addAll(bpes);
    }

    public Set<? extends List<T>> getBuckets() {
        return this.buckets;
    }

    void addAll(Collection<? extends T> bpes) {
        for (BioPAXElement bpe : bpes) {
            this.add(bpe);
        }
    }

    public EquivalanceBucket<T> access(T element) {
        EquivalanceBucket<T> value = null;
        if (element != null && (value = this.access(element, false)) == null) {
            value = this.access(element, true);
        }
        return value;
    }

    private EquivalanceBucket<T> access(T element, final boolean parity) {
        Object[] trap = new Object[]{null};
        if (this.buckets.contains(new Object((BioPAXElement)element, trap){
            final /* synthetic */ BioPAXElement val$element;
            final /* synthetic */ Object[] val$trap;
            {
                this.val$element = bioPAXElement;
                this.val$trap = objectArray;
            }

            public int hashCode() {
                return parity ? this.val$element.equivalenceCode() : this.val$element.hashCode();
            }

            public boolean equals(Object other) {
                if (other != null && other.equals(this.val$element)) {
                    this.val$trap[0] = other;
                    return true;
                }
                return false;
            }
        })) {
            return (EquivalanceBucket)trap[0];
        }
        return null;
    }

    public EquivalenceGrouper() {
    }

    public void add(T bpe) {
        EquivalanceBucket bucket = this.access(bpe);
        if (bucket == null) {
            bucket = new EquivalanceBucket(this, bpe);
            this.buckets.add(bucket);
        } else {
            for (BioPAXElement t : bucket) {
                if (t != bpe) continue;
                return;
            }
            bucket.add(bpe);
        }
    }

    private static class EquivalanceBucket<T extends BioPAXElement>
    extends LinkedList<T> {
        static final boolean EQUALITY = false;
        static final boolean EQUIVALENCE = true;
        private final int code;
        private boolean parity;
        final /* synthetic */ EquivalenceGrouper this$0;

        private EquivalanceBucket(T first) {
            this.this$0 = var1_1;
            this.add(first);
            if (first.equivalenceCode() == 0 || first.equivalenceCode() == first.hashCode()) {
                this.parity = false;
                this.code = first.hashCode();
            } else {
                this.parity = true;
                this.code = first.equivalenceCode();
            }
        }

        @Override
        public int hashCode() {
            return this.code;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof EquivalanceBucket) {
                return super.equals(o);
            }
            BioPAXElement t = (BioPAXElement)this.get(0);
            if (this.parity) {
                return t.isEquivalent((BioPAXElement)o);
            }
            return t.equals(o);
        }
    }
}

