/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.jena;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMapImpl;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.io.jena.JenaIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public final class JenaEditorMap
extends EditorMapImpl {
    private static final Log log = LogFactory.getLog(JenaEditorMap.class);

    public JenaEditorMap(BioPAXLevel level) {
        super(level);
        OntModel ontologyDefinition = JenaIOHandler.createModel();
        ontologyDefinition.read(this.level.getLevelFileAsStream(), this.level.getNameSpace());
        this.init();
        this.preprocessClasses(ontologyDefinition);
        this.preprocessProperties(ontologyDefinition);
        this.preprocessRestrictions(ontologyDefinition);
    }

    protected void init() {
    }

    private void preprocessClasses(OntModel model) {
        ExtendedIterator extendedIterator = model.listClasses();
        while (extendedIterator.hasNext()) {
            this.checkOntologyClassAndRegister((OntClass)extendedIterator.next());
        }
    }

    protected void checkOntologyClassAndRegister(OntClass ontClass) {
        if (this.isInBioPAXNameSpace(ontClass.getNameSpace())) {
            this.registerModelClass(ontClass.getLocalName());
        }
    }

    private void preprocessProperties(OntModel model) {
        ExtendedIterator extendedIterator = model.listDatatypeProperties();
        this.iteratePropertiesAndResolveDomain(extendedIterator);
        extendedIterator = model.listObjectProperties();
        this.iteratePropertiesAndResolveDomain(extendedIterator);
    }

    private void iteratePropertiesAndResolveDomain(ExtendedIterator extendedIterator) {
        while (extendedIterator.hasNext()) {
            OntProperty property = (OntProperty)extendedIterator.next();
            OntResource domain = this.retrieveDomain(property);
            this.recursivelyResolveUnionClasses(property, domain);
        }
    }

    private void recursivelyResolveUnionClasses(OntProperty property, OntResource domain) {
        String nameSpace = domain.getNameSpace();
        if (this.isInBioPAXNameSpace(nameSpace)) {
            this.createAndRegisterBeanEditor(property, domain);
        } else {
            ExtendedIterator unionSetClassIterator = ((UnionClass)domain.as(UnionClass.class)).listOperands();
            while (unionSetClassIterator.hasNext()) {
                OntClass ontClass = (OntClass)unionSetClassIterator.next();
                this.recursivelyResolveUnionClasses(property, (OntResource)ontClass);
            }
        }
    }

    protected void createAndRegisterBeanEditor(OntProperty property, OntResource domain) {
        this.createAndRegisterBeanEditor(property.getLocalName(), this.extractClass((Resource)domain.asClass()), null);
    }

    private OntResource retrieveDomain(OntProperty property) {
        OntResource domain = property.getDomain();
        if (domain == null) {
            OntProperty superProperty = property;
            while (domain == null) {
                superProperty = superProperty.getSuperProperty();
                domain = superProperty.getDomain();
            }
        }
        return domain;
    }

    private void preprocessRestrictions(OntModel model) {
        ExtendedIterator extendedIterator = model.listRestrictions();
        while (extendedIterator.hasNext()) {
            Restriction restriction = (Restriction)extendedIterator.next();
            try {
                this.preprocessRestriction(restriction);
            }
            catch (Exception ex) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Skipping. " + ex.getMessage()));
            }
        }
    }

    private void preprocessRestriction(Restriction restriction) {
        OntProperty ontProperty = restriction.getOnProperty();
        Set propertyEditors = (Set)this.propertyToEditorMap.get(ontProperty.getLocalName());
        if (propertyEditors == null) {
            throw new IllegalBioPAXArgumentException("No editors for property " + ontProperty.getLocalName());
        }
        ExtendedIterator iterator = restriction.listSubClasses(true);
        while (iterator.hasNext()) {
            Class<? extends BioPAXElement> domain;
            OntClass ontClass = (OntClass)iterator.next();
            try {
                domain = this.extractClass((Resource)ontClass);
            }
            catch (IllegalBioPAXArgumentException e) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Skipping. (" + e.getMessage() + ")"));
                continue;
            }
            for (PropertyEditor propertyEditor : propertyEditors) {
                if (!propertyEditor.getDomain().isAssignableFrom(domain) || !restriction.isAllValuesFromRestriction()) continue;
                AllValuesFromRestriction valuesFromRestriction = restriction.asAllValuesFromRestriction();
                if (!(propertyEditor instanceof ObjectPropertyEditor)) continue;
                OntClass values = (OntClass)valuesFromRestriction.getAllValuesFrom().as(OntClass.class);
                Set<Class<? extends BioPAXElement>> ranges = this.getSetOfJavaClasses(values);
                ((ObjectPropertyEditor)propertyEditor).addRangeRestriction(domain, ranges);
            }
        }
    }

    protected Class<? extends BioPAXElement> extractClass(Resource resource) {
        String localName = this.getJavaName(resource);
        return this.getLevel().getInterfaceForName(localName);
    }

    private String getJavaName(Resource resource) {
        return resource.getLocalName().replaceAll("-", "_");
    }

    private Set<Class<? extends BioPAXElement>> getSetOfJavaClasses(OntClass values) {
        HashSet<Class<? extends BioPAXElement>> set = new HashSet<Class<? extends BioPAXElement>>();
        this.recursivelyTraverse(values, set);
        assert (!set.isEmpty());
        return set;
    }

    private void recursivelyTraverse(OntClass values, HashSet<Class<? extends BioPAXElement>> set) {
        if (values.isUnionClass()) {
            UnionClass unionClass = values.asUnionClass();
            ExtendedIterator iterator1 = unionClass.listOperands();
            while (iterator1.hasNext()) {
                this.recursivelyTraverse((OntClass)iterator1.next(), set);
            }
        } else {
            set.add(this.extractClass((Resource)values));
        }
    }

    public XSDDatatype getDataTypeFor(PropertyEditor editor) {
        Class range = editor.getRange();
        XSDDatatype type = null;
        if (range.isEnum() || range.equals(String.class)) {
            type = XSDDatatype.XSDstring;
        } else if (range.equals(Double.TYPE)) {
            type = XSDDatatype.XSDdouble;
        } else if (range.equals(Integer.TYPE)) {
            type = XSDDatatype.XSDint;
        } else if (range.equals(Float.TYPE)) {
            type = XSDDatatype.XSDfloat;
        } else if (range.equals(Boolean.class) || range.equals(Boolean.TYPE)) {
            type = XSDDatatype.XSDboolean;
        }
        return type;
    }

    void writeSimpleEditorMapProperties(OutputStream out) {
        PrintStream stream = new PrintStream(out);
        for (Class aClass : this.classToEditorMap.keySet()) {
            stream.print(aClass.getSimpleName() + " ");
        }
        stream.println();
        for (Set propertyEditors : this.propertyToEditorMap.values()) {
            for (PropertyEditor propertyEditor : propertyEditors) {
                stream.println(propertyEditor.toString());
            }
        }
        stream.close();
    }

    public BioPAXLevel getLevel() {
        return this.level;
    }
}

