/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.jena;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.StringPropertyEditor;
import org.biopax.paxtools.io.BioPAXIOHandlerAdapter;
import org.biopax.paxtools.io.jena.JenaEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public final class JenaIOHandler
extends BioPAXIOHandlerAdapter {
    private static final OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
    private static final Log log = LogFactory.getLog(JenaIOHandler.class);
    private HashMap<Object, Individual> objectToIndividualMap;
    OntModel ontModel;

    public JenaIOHandler() {
        this(null, null);
    }

    public JenaIOHandler(BioPAXLevel level) {
        this(level.getDefaultFactory(), level);
    }

    public JenaIOHandler(BioPAXFactory factory, BioPAXLevel level) {
        super(factory, level);
    }

    protected void resetEditorMap() {
        this.setEditorMap((EditorMap)new JenaEditorMap(this.getLevel()));
    }

    protected void init(InputStream in) {
        this.ontModel = this.readJenaModel(in);
    }

    protected Map<String, String> readNameSpaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.putAll(this.ontModel.getNsPrefixMap());
        return namespaces;
    }

    protected void createAndBind(org.biopax.paxtools.model.Model model) {
        try {
            this.createObjects(this.ontModel, model);
            this.bindPropertiesToObjects(this.ontModel, model);
        }
        catch (IllegalBioPAXArgumentException e) {
            log.error((Object)e);
        }
    }

    public void convertToOWL(org.biopax.paxtools.model.Model model, OutputStream outputStream) {
        this.objectToIndividualMap = new HashMap();
        OntModel ontModel = this.initializeEmptyOntModel(model);
        this.createIndividuals(ontModel, model);
        this.bindObjectsToProperties(ontModel, model);
        RDFWriter writer = ontModel.getWriter("RDF/XML-ABBREV");
        writer.setProperty("relativeURIs", (Object)"same-document, relative, parent, absolute");
        String base = model.getXmlBase();
        if (log.isDebugEnabled()) {
            log.debug((Object)("base = " + base));
        }
        if (base != null && !"".equals(base)) {
            writer.setProperty("xmlbase", (Object)base);
        }
        writer.setProperty("showXmlDeclaration", (Object)"true");
        writer.write((Model)ontModel, outputStream, base);
    }

    public OntModel readJenaModel(InputStream in) {
        OntModel ontModel = JenaIOHandler.createModel();
        ontModel.read(in, "");
        return ontModel;
    }

    private void createObjects(OntModel ontModel, org.biopax.paxtools.model.Model model) {
        ExtendedIterator extendedIterator = ontModel.listIndividuals();
        while (extendedIterator.hasNext()) {
            Individual individual = (Individual)extendedIterator.next();
            OntClass ontClass = (OntClass)individual.getRDFType().as(OntClass.class);
            this.createAndAdd(model, individual.getURI(), ontClass.getLocalName());
        }
    }

    private void bindPropertiesToObjects(OntModel ontModel, org.biopax.paxtools.model.Model model) throws IllegalBioPAXArgumentException {
        ExtendedIterator extendedIterator = ontModel.listIndividuals();
        while (extendedIterator.hasNext()) {
            Individual individual = (Individual)extendedIterator.next();
            BioPAXElement bpe = model.getByID(individual.getURI());
            StmtIterator stmtIterator = individual.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = (Statement)stmtIterator.next();
                Property predicate = statement.getPredicate();
                try {
                    if (BioPAXLevel.isInBioPAXNameSpace((String)predicate.getNameSpace())) {
                        this.bindProperty(predicate, bpe, individual, model);
                        continue;
                    }
                    if (predicate.getLocalName().equals("comment") && predicate.getNameSpace().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                        OntProperty ontProperty;
                        StringPropertyEditor editor = this.getRDFCommentEditor(bpe);
                        try {
                            ontProperty = (OntProperty)predicate.as(OntProperty.class);
                        }
                        catch (ConversionException e) {
                            throw new IllegalBioPAXArgumentException("Unknown property! " + predicate + " bpe:" + bpe.getRDFId(), (Throwable)e);
                        }
                        this.checkCardinalityAndBindValue(bpe, individual, model, ontProperty, (PropertyEditor)editor);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Skipping non-biopax statement:" + predicate));
                }
                catch (IllegalBioPAXArgumentException e) {
                    log.error((Object)("Conversion error. " + (Object)((Object)e)));
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalBioPAXArgumentException("Conversion failed.", (Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalBioPAXArgumentException("Conversion failed.", (Throwable)ex);
                }
            }
        }
    }

    private void bindProperty(Property predicate, BioPAXElement bpe, Individual individual, org.biopax.paxtools.model.Model model) throws IllegalAccessException, InvocationTargetException {
        OntProperty ontProperty;
        try {
            ontProperty = (OntProperty)predicate.as(OntProperty.class);
        }
        catch (ConversionException e) {
            throw new IllegalBioPAXArgumentException("Unknown property! " + predicate + " bpe:" + bpe.getRDFId(), (Throwable)e);
        }
        String localName = ontProperty.getLocalName();
        PropertyEditor editor = this.getEditorMap().getEditorForProperty(localName, bpe.getModelInterface());
        if (editor == null) {
            throw new IllegalBioPAXArgumentException("Could not locate editor! " + predicate + " element:" + bpe.getRDFId() + " property:" + localName);
        }
        this.checkCardinalityAndBindValue(bpe, individual, model, ontProperty, editor);
    }

    private void checkCardinalityAndBindValue(BioPAXElement bpe, Individual individual, org.biopax.paxtools.model.Model model, OntProperty ontProperty, PropertyEditor editor) {
        if (editor.isMultipleCardinality()) {
            NodeIterator nodeIterator = individual.listPropertyValues((Property)ontProperty);
            while (nodeIterator.hasNext()) {
                RDFNode propertyValue = (RDFNode)nodeIterator.next();
                this.bindValue(propertyValue, editor, bpe, model);
            }
        } else {
            RDFNode propertyValue = individual.getPropertyValue((Property)ontProperty);
            this.bindValue(propertyValue, editor, bpe, model);
        }
    }

    private void bindValue(RDFNode propertyValue, PropertyEditor editor, BioPAXElement bpe, org.biopax.paxtools.model.Model model) {
        String stringValue = null;
        if (propertyValue.isResource()) {
            stringValue = ((Resource)propertyValue).getURI();
        } else if (propertyValue.isLiteral()) {
            stringValue = ((Literal)propertyValue).getString();
        } else {
            log.error((Object)("Unexpected state." + propertyValue + " is not a resource or literal."));
        }
        this.bindValue(stringValue, editor, bpe, model);
    }

    private OntModel initializeEmptyOntModel(org.biopax.paxtools.model.Model model) {
        OntModel ontModel = JenaIOHandler.createModel();
        String xmlBase = model.getXmlBase();
        if (xmlBase == null || xmlBase.equals("")) {
            xmlBase = "http://biopax.org/paxtools#";
        }
        Ontology base = ontModel.createOntology(xmlBase);
        String uri = model.getLevel().getNameSpace();
        uri = uri.substring(0, uri.length() - 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("uri = " + uri));
        }
        ontModel.setNsPrefixes(model.getNameSpacePrefixMap());
        base.addImport(ontModel.createResource(uri));
        ontModel.loadImports();
        return ontModel;
    }

    private void createIndividuals(OntModel ontModel, org.biopax.paxtools.model.Model model) {
        for (BioPAXElement bp : model.getObjects()) {
            String name = bp.getModelInterface().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            OntClass ontClass = ontModel.getOntClass(this.getLevel().getNameSpace() + name);
            if (log.isTraceEnabled()) {
                log.trace((Object)("ontClass = " + ontClass));
            }
            Individual individual = ontModel.createIndividual(bp.getRDFId(), (Resource)ontClass);
            if (log.isTraceEnabled()) {
                log.trace((Object)("individual = " + individual));
            }
            this.objectToIndividualMap.put(bp, individual);
        }
    }

    private void bindObjectsToProperties(OntModel ontModel, org.biopax.paxtools.model.Model model) {
        for (BioPAXElement bean : model.getObjects()) {
            Set beanEditors = this.getEditorMap().getEditorsOf(bean);
            for (PropertyEditor propertyEditor : beanEditors) {
                this.insertStatement(propertyEditor, bean, ontModel);
            }
        }
    }

    private void insertStatement(PropertyEditor editor, BioPAXElement bean, OntModel ontModel) {
        Set value = editor.getValueFromBean(bean);
        for (Object valueElement : value) {
            if (editor.isUnknown(valueElement)) continue;
            this.buildStatementFor(bean, editor, valueElement, ontModel);
        }
    }

    private void buildStatementFor(BioPAXElement bean, PropertyEditor editor, Object value, OntModel ontModel) {
        assert (bean != null && editor != null);
        Property property = ontModel.getProperty(this.getLevel().getNameSpace() + editor.getProperty());
        Individual ind = this.objectToIndividualMap.get(bean);
        Class range = editor.getRange();
        JenaEditorMap editorMap = (JenaEditorMap)this.getEditorMap();
        XSDDatatype dataType = editorMap.getDataTypeFor(editor);
        if (dataType != null) {
            ind.addProperty(property, (RDFNode)ontModel.createTypedLiteral(value.toString(), (RDFDatatype)dataType));
        } else {
            Individual valueInd = this.objectToIndividualMap.get(value);
            if (valueInd == null) {
                throw new IllegalBioPAXArgumentException(range + " : for value '" + value + "' coresponding individual value is NULL " + "(objectToIndividualMap)");
            }
            ind.addProperty(property, (RDFNode)valueInd);
        }
    }

    static OntModel createModel() {
        return ModelFactory.createOntologyModel((OntModelSpec)spec);
    }
}

