/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3undirected;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.query.model.AbstractGraph;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.biopax.paxtools.query.wrapperL3undirected.ControlWrapper;
import org.biopax.paxtools.query.wrapperL3undirected.InteractionWrapper;
import org.biopax.paxtools.query.wrapperL3undirected.PhysicalEntityWrapper;

public class GraphL3Undirected
extends AbstractGraph {
    protected Model model;
    protected List<Filter> filters;
    protected final Log log = LogFactory.getLog(GraphL3Undirected.class);

    public GraphL3Undirected(Model model, Filter ... filters) {
        assert (model.getLevel() == BioPAXLevel.L3);
        this.model = model;
        if (filters.length > 0) {
            this.filters = Arrays.asList(filters);
        }
    }

    private boolean passesFilters(Level3Element ele) {
        if (this.filters == null) {
            return true;
        }
        for (Filter filter : this.filters) {
            if (filter.okToTraverse(ele)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Node wrap(Object obj) {
        if (!(obj instanceof Level3Element)) {
            throw new IllegalArgumentException("An object other than a Level3Element is trying to be wrapped: " + obj);
        }
        if (!this.passesFilters((Level3Element)obj)) {
            return null;
        }
        if (obj instanceof PhysicalEntity) {
            return new PhysicalEntityWrapper((PhysicalEntity)obj, this);
        }
        if (obj instanceof Control) {
            return new ControlWrapper((Control)obj, this);
        }
        if (obj instanceof Interaction) {
            return new InteractionWrapper((Interaction)obj, this);
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Invalid BioPAX object to wrap as node. Ignoring: " + obj));
        }
        return null;
    }

    @Override
    public String getKey(Object wrapped) {
        if (wrapped instanceof BioPAXElement) {
            return ((BioPAXElement)wrapped).getRDFId();
        }
        throw new IllegalArgumentException("Object cannot be wrapped: " + wrapped);
    }

    @Override
    public Set<Node> getWrapperSet(Set<?> objects) {
        HashSet<Node> wrapped = new HashSet<Node>();
        for (Object object : objects) {
            Node node = (Node)this.getGraphObject(object);
            if (node == null) continue;
            wrapped.add(node);
        }
        return wrapped;
    }

    @Override
    public Map<Object, Node> getWrapperMap(Set<?> objects) {
        HashMap<Object, Node> map = new HashMap<Object, Node>();
        for (Object object : objects) {
            Node node = (Node)this.getGraphObject(object);
            if (node == null) continue;
            map.put(object, node);
        }
        return map;
    }

    @Override
    public Set<Object> getWrappedSet(Set<? extends GraphObject> wrappers) {
        HashSet<Object> objects = new HashSet<Object>();
        for (GraphObject graphObject : wrappers) {
            if (graphObject instanceof PhysicalEntityWrapper) {
                objects.add(((PhysicalEntityWrapper)graphObject).getPhysicalEntity());
                continue;
            }
            if (graphObject instanceof ControlWrapper) {
                objects.add(((ControlWrapper)graphObject).getControl());
                continue;
            }
            if (!(graphObject instanceof InteractionWrapper)) continue;
            objects.add(((InteractionWrapper)graphObject).getInteraction());
        }
        return objects;
    }

    public Model getModel() {
        return this.model;
    }
}

