/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3undirected;

import java.util.Collection;
import java.util.Collections;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.TemplateReactionRegulation;
import org.biopax.paxtools.query.model.AbstractNode;
import org.biopax.paxtools.query.model.Graph;
import org.biopax.paxtools.query.model.Node;
import org.biopax.paxtools.query.wrapperL3undirected.EdgeL3;

public class ControlWrapper
extends AbstractNode {
    protected Control ctrl;
    protected int sign;
    protected boolean transcription;

    protected ControlWrapper(Control ctrl, Graph graph) {
        super(graph);
        this.ctrl = ctrl;
        this.transcription = false;
    }

    @Override
    public boolean isBreadthNode() {
        return false;
    }

    @Override
    public int getSign() {
        return this.sign;
    }

    @Override
    public boolean isUbique() {
        return false;
    }

    @Override
    public String getKey() {
        return this.ctrl.getUri();
    }

    @Override
    public void init() {
        ControlType type = this.ctrl.getControlType();
        this.sign = type != null && type.toString().startsWith("I") ? -1 : 1;
        if (this.ctrl instanceof TemplateReactionRegulation) {
            this.transcription = true;
        }
    }

    private void bindUpstream(BioPAXElement element) {
        AbstractNode node = (AbstractNode)this.graph.getGraphObject(element);
        if (node != null) {
            EdgeL3 edge = new EdgeL3(node, this, this.graph);
            node.getDownstreamNoInit().add(edge);
            this.getUpstreamNoInit().add(edge);
        }
    }

    private void bindDownstream(BioPAXElement element) {
        AbstractNode node = (AbstractNode)this.graph.getGraphObject(element);
        if (node != null) {
            EdgeL3 edge = new EdgeL3(this, node, this.graph);
            this.getDownstreamNoInit().add(edge);
            node.getUpstreamNoInit().add(edge);
        }
    }

    @Override
    public void initUpstream() {
        for (Controller controller : this.ctrl.getController()) {
            if (controller instanceof Pathway) continue;
            PhysicalEntity pe = (PhysicalEntity)controller;
            this.bindUpstream((BioPAXElement)pe);
        }
        for (Control control : this.ctrl.getControlledOf()) {
            this.bindUpstream((BioPAXElement)control);
        }
        for (Process prc : this.ctrl.getControlled()) {
            if (!(prc instanceof Interaction)) continue;
            this.bindUpstream((BioPAXElement)prc);
        }
    }

    @Override
    public void initDownstream() {
        for (Controller controller : this.ctrl.getController()) {
            if (controller instanceof Pathway) continue;
            PhysicalEntity pe = (PhysicalEntity)controller;
            this.bindDownstream((BioPAXElement)pe);
        }
        for (Control control : this.ctrl.getControlledOf()) {
            this.bindDownstream((BioPAXElement)control);
        }
        for (Process prc : this.ctrl.getControlled()) {
            if (!(prc instanceof Interaction)) continue;
            this.bindDownstream((BioPAXElement)prc);
        }
    }

    public Control getControl() {
        return this.ctrl;
    }

    @Override
    public Collection<Node> getUpperEquivalent() {
        return Collections.emptySet();
    }

    @Override
    public Collection<Node> getLowerEquivalent() {
        return Collections.emptySet();
    }

    @Override
    public boolean isTranscription() {
        return this.transcription;
    }

    public void setTranscription(boolean transcription) {
        this.transcription = transcription;
    }
}

