/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3undirected;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.query.model.AbstractNode;
import org.biopax.paxtools.query.model.Graph;
import org.biopax.paxtools.query.wrapperL3undirected.EdgeL3;
import org.biopax.paxtools.query.wrapperL3undirected.EventWrapper;
import org.biopax.paxtools.query.wrapperL3undirected.GraphL3Undirected;

public class InteractionWrapper
extends EventWrapper {
    private Interaction interaction;

    protected InteractionWrapper(Interaction interaction, GraphL3Undirected graph) {
        super(graph);
        if (interaction instanceof Control) {
            throw new IllegalArgumentException("Control objects should be wrapped with ControlWrapper.");
        }
        this.interaction = interaction;
    }

    @Override
    public void initUpstream() {
        for (Entity entity : this.interaction.getParticipant()) {
            this.addToUpstream((BioPAXElement)entity, this.getGraph());
        }
        for (Control control : this.interaction.getControlledOf()) {
            this.addToUpstream((BioPAXElement)control, this.getGraph());
        }
    }

    @Override
    public void initDownstream() {
        for (Entity entity : this.interaction.getParticipant()) {
            this.addToDownstream((BioPAXElement)entity, this.getGraph());
        }
        for (Control control : this.interaction.getControlledOf()) {
            this.addToDownstream((BioPAXElement)control, this.getGraph());
        }
    }

    @Override
    public boolean isTranscription() {
        return false;
    }

    protected void addToDownstream(BioPAXElement pe, Graph graph) {
        AbstractNode node = (AbstractNode)graph.getGraphObject(pe);
        if (node != null) {
            EdgeL3 edge = new EdgeL3(this, node, graph);
            edge.setTranscription(true);
            node.getUpstreamNoInit().add(edge);
            this.getDownstreamNoInit().add(edge);
        }
    }

    @Override
    protected void addToUpstream(BioPAXElement ele, Graph graph) {
        AbstractNode node = (AbstractNode)graph.getGraphObject(ele);
        if (node != null) {
            EdgeL3 edge = new EdgeL3(node, this, graph);
            node.getDownstreamNoInit().add(edge);
            this.getUpstreamNoInit().add(edge);
        }
    }

    @Override
    public String getKey() {
        return this.interaction.getUri();
    }

    public Interaction getInteraction() {
        return this.interaction;
    }
}

