/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.search;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.Version;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.search.Indexer;
import org.biopax.paxtools.search.SearchResult;
import org.biopax.paxtools.search.Searcher;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEngine
implements Indexer,
Searcher {
    private static final Logger LOG = LoggerFactory.getLogger(SearchEngine.class);
    public static final String FIELD_URI = "uri";
    public static final String FIELD_KEYWORD = "keyword";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_XREFDB = "xrefdb";
    public static final String FIELD_XREFID = "xrefid";
    public static final String FIELD_PATHWAY = "pathway";
    public static final String FIELD_SIZE = "size";
    public static final String FIELD_ORGANISM = "organism";
    public static final String FIELD_DATASOURCE = "datasource";
    public static final String FIELD_TYPE = "type";
    public static final String[] DEFAULT_FIELDS = new String[]{"keyword", "name", "xrefid", "size"};
    private final Model model;
    private int maxHitsPerPage;
    private final Analyzer analyzer;
    private final File indexFile;
    private SearcherManager searcherManager;
    public static final int DEFAULT_MAX_HITS_PER_PAGE = 100;

    public SearchEngine(Model model, String indexLocation) {
        this.model = model;
        this.indexFile = new File(indexLocation);
        this.initSearcherManager();
        this.maxHitsPerPage = 100;
        this.analyzer = new StandardAnalyzer();
    }

    private void initSearcherManager() {
        try {
            if (this.indexFile.exists()) {
                this.searcherManager = new SearcherManager((Directory)MMapDirectory.open((File)this.indexFile), new SearcherFactory());
            } else {
                LOG.info(this.indexFile.getPath() + " does not exist.");
            }
        }
        catch (IOException e) {
            LOG.warn("Could not create a searcher: " + e);
        }
    }

    public void setMaxHitsPerPage(int maxHitsPerPage) {
        this.maxHitsPerPage = maxHitsPerPage;
    }

    public int getMaxHitsPerPage() {
        return this.maxHitsPerPage;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SearchResult search(String query, int page, Class<? extends BioPAXElement> filterByType, String[] datasources, String[] organisms) {
        SearchResult response = null;
        LOG.debug("search: " + query + ", page: " + page + ", filterBy: " + filterByType + "; extra filters: ds in (" + Arrays.toString(datasources) + "), org. in (" + Arrays.toString(organisms) + ")");
        IndexSearcher searcher = null;
        try {
            MultiFieldQueryParser queryParser = new MultiFieldQueryParser(DEFAULT_FIELDS, this.analyzer);
            queryParser.setAllowLeadingWildcard(true);
            searcher = (IndexSearcher)this.searcherManager.acquire();
            if (!query.trim().equals("*")) {
                Query luceneQuery = queryParser.parse(query);
                LOG.debug("parsed lucene query is " + luceneQuery.getClass().getSimpleName());
                org.apache.lucene.search.Filter filter = this.createFilter(filterByType, datasources, organisms);
                TopDocs topDocs = searcher.search(luceneQuery, filter, this.maxHitsPerPage);
                if (page > 0) {
                    TopScoreDocCollector collector = TopScoreDocCollector.create((int)(this.maxHitsPerPage * (page + 1)), (boolean)true);
                    searcher.search(luceneQuery, filter, (Collector)collector);
                    topDocs = collector.topDocs(page * this.maxHitsPerPage, this.maxHitsPerPage);
                }
                response = this.transform(luceneQuery, searcher, true, topDocs);
            } else {
                if (filterByType == null) {
                    filterByType = Level3Element.class;
                }
                BooleanQuery luceneQuery = new BooleanQuery();
                for (Class subType : SimpleEditorMap.L3.getKnownSubClassesOf(filterByType)) {
                    luceneQuery.add((Query)new TermQuery(new Term(FIELD_TYPE, subType.getSimpleName().toLowerCase())), BooleanClause.Occur.SHOULD);
                }
                org.apache.lucene.search.Filter filter = this.createFilter(null, datasources, organisms);
                TopDocs topDocs = searcher.search((Query)luceneQuery, filter, this.maxHitsPerPage);
                if (page > 0) {
                    TopScoreDocCollector collector = TopScoreDocCollector.create((int)(this.maxHitsPerPage * (page + 1)), (boolean)true);
                    searcher.search((Query)luceneQuery, filter, (Collector)collector);
                    topDocs = collector.topDocs(page * this.maxHitsPerPage, this.maxHitsPerPage);
                }
                response = this.transform((Query)luceneQuery, searcher, false, topDocs);
            }
        }
        catch (ParseException e) {
            try {
                throw new RuntimeException("getTopDocs: failed to parse the query string.", e);
                catch (IOException e2) {
                    throw new RuntimeException("getTopDocs: failed.", e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (searcher == null) throw throwable;
                    this.searcherManager.release(searcher);
                    searcher = null;
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (searcher != null) {
                this.searcherManager.release((Object)searcher);
                searcher = null;
            }
        }
        catch (IOException queryParser) {}
        response.setPage(page);
        return response;
    }

    /*
     * Unable to fully structure code
     */
    private SearchResult transform(Query query, IndexSearcher searcher, boolean highlight, TopDocs topDocs) throws CorruptIndexException, IOException {
        response = new SearchResult();
        hits = new ArrayList<BioPAXElement>();
        response.setMaxHitsPerPage(this.maxHitsPerPage);
        response.setHits(hits);
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            doc = searcher.doc(scoreDoc.doc);
            uri = doc.get("uri");
            bpe = this.model.getByID(uri);
            SearchEngine.LOG.debug("transform: doc:" + scoreDoc.doc + ", uri:" + uri);
            if (highlight && doc.get("keyword") != null) {
                scorer = new QueryScorer(query, "keyword");
                scorer.setExpandMultiTermQuery(true);
                formatter = new SimpleHTMLFormatter("<span class='hitHL'>", "</span>");
                highlighter = new Highlighter((Formatter)formatter, (Scorer)scorer);
                highlighter.setTextFragmenter((Fragmenter)new SimpleSpanFragmenter(scorer, 80));
                text = StringUtils.join((Object[])doc.getValues("keyword"), (String)" ");
                try {
                    tokenStream = this.analyzer.tokenStream("", (Reader)new StringReader(text));
                    res = highlighter.getBestFragments(tokenStream, text, 7, "...");
                    if (res == null || res.isEmpty()) ** GOTO lbl28
                    bpe.getAnnotations().put(HitAnnotation.HIT_EXCERPT.name(), res);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (highlight) {
                SearchEngine.LOG.warn("Highlighter skipped, because KEYWORD field was null; hit: " + uri + ", " + bpe.getModelInterface().getSimpleName());
            }
lbl28:
            // 5 sources

            if (doc.get("organism") != null && !bpe.getAnnotations().containsKey(HitAnnotation.HIT_ORGANISM.name())) {
                uniqueVals = new TreeSet<String>();
                for (String o : doc.getValues("organism")) {
                    uniqueVals.add(o);
                }
                bpe.getAnnotations().put(HitAnnotation.HIT_ORGANISM.name(), uniqueVals);
            }
            if (doc.get("datasource") != null && !bpe.getAnnotations().containsKey(HitAnnotation.HIT_DATASOURCE.name())) {
                uniqueVals = new TreeSet<E>();
                for (String d : doc.getValues("datasource")) {
                    uniqueVals.add(d);
                }
                bpe.getAnnotations().put(HitAnnotation.HIT_DATASOURCE.name(), uniqueVals);
            }
            if (doc.get("pathway") != null && !bpe.getAnnotations().containsKey(HitAnnotation.HIT_PATHWAY.name())) {
                uniqueVals = new TreeSet<E>();
                for (String d : doc.getValues("pathway")) {
                    if (d.equals(uri)) continue;
                    uniqueVals.add(d);
                }
                bpe.getAnnotations().put(HitAnnotation.HIT_PATHWAY.name(), uniqueVals);
            }
            if (doc.get("size") != null && !bpe.getAnnotations().containsKey(HitAnnotation.HIT_SIZE.name())) {
                bpe.getAnnotations().put(HitAnnotation.HIT_SIZE.name(), Integer.valueOf(doc.get("size")));
            }
            if ((excerpt = (String)bpe.getAnnotations().get(HitAnnotation.HIT_EXCERPT.name())) == null) {
                excerpt = "";
            }
            excerpt = excerpt + " -SCORE- " + scoreDoc.score + " -EXPLANATION- " + searcher.explain(query, scoreDoc.doc);
            bpe.getAnnotations().put(HitAnnotation.HIT_EXCERPT.name(), excerpt);
            hits.add(bpe);
        }
        response.setTotalHits(topDocs.totalHits);
        return response;
    }

    @Override
    public void index() {
        IndexWriter iw;
        int numObjects = this.model.getObjects().size();
        LOG.info("index(), there are " + numObjects + " BioPAX objects to be (re-)indexed.");
        try {
            if (this.searcherManager != null) {
                this.searcherManager.close();
                this.searcherManager = null;
            }
            IndexWriterConfig conf = new IndexWriterConfig(Version.LATEST, this.analyzer);
            iw = new IndexWriter((Directory)FSDirectory.open((File)this.indexFile), conf);
            iw.deleteAll();
            iw.commit();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a new IndexWriter.", e);
        }
        final IndexWriter indexWriter = iw;
        ExecutorService exec = Executors.newFixedThreadPool(30);
        final AtomicInteger numLeft = new AtomicInteger(numObjects);
        for (final BioPAXElement bpe : this.model.getObjects()) {
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    Set keywords = ModelUtils.getKeywords((BioPAXElement)bpe, (int)3, (Filter[])new Filter[0]);
                    for (String s : new HashSet(keywords)) {
                        if (!s.startsWith("REPLACED ") && !s.contains("ADDED")) continue;
                        keywords.remove(s);
                    }
                    bpe.getAnnotations().put(SearchEngine.FIELD_KEYWORD, keywords);
                    bpe.getAnnotations().put(SearchEngine.FIELD_DATASOURCE, ModelUtils.getDatasources((BioPAXElement)bpe));
                    bpe.getAnnotations().put(SearchEngine.FIELD_ORGANISM, ModelUtils.getOrganisms((BioPAXElement)bpe));
                    bpe.getAnnotations().put(SearchEngine.FIELD_PATHWAY, ModelUtils.getParentPathways((BioPAXElement)bpe));
                    if (bpe instanceof Process) {
                        int size = new Fetcher((EditorMap)SimpleEditorMap.L3, new Filter[]{Fetcher.nextStepFilter}).fetch(bpe, Process.class).size();
                        bpe.getAnnotations().put(SearchEngine.FIELD_SIZE, Integer.toString(size));
                    }
                    SearchEngine.this.index(bpe, indexWriter);
                    int left = numLeft.decrementAndGet();
                    if (left % 10000 == 0) {
                        LOG.info("index(), biopax objects left to index: " + left);
                    }
                }
            });
        }
        exec.shutdown();
        try {
            exec.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted!", e);
        }
        try {
            indexWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close IndexWriter.", e);
        }
        this.initSearcherManager();
    }

    void index(BioPAXElement bpe, IndexWriter indexWriter) {
        Document doc = new Document();
        StoredField field = new StoredField(FIELD_URI, bpe.getUri());
        doc.add((IndexableField)field);
        field = new StringField(FIELD_TYPE, bpe.getModelInterface().getSimpleName().toLowerCase(), Field.Store.YES);
        doc.add((IndexableField)field);
        if (!bpe.getAnnotations().isEmpty()) {
            if (bpe.getAnnotations().containsKey(FIELD_PATHWAY)) {
                this.addPathways((Set)bpe.getAnnotations().get(FIELD_PATHWAY), doc);
            }
            if (bpe.getAnnotations().containsKey(FIELD_ORGANISM)) {
                this.addOrganisms((Set)bpe.getAnnotations().get(FIELD_ORGANISM), doc);
            }
            if (bpe.getAnnotations().containsKey(FIELD_DATASOURCE)) {
                this.addDatasources((Set)bpe.getAnnotations().get(FIELD_DATASOURCE), doc);
            }
            if (bpe.getAnnotations().containsKey(FIELD_KEYWORD)) {
                this.addKeywords((Set)bpe.getAnnotations().get(FIELD_KEYWORD), doc);
            }
            if (bpe.getAnnotations().containsKey(FIELD_SIZE)) {
                field = new IntField(FIELD_SIZE, Integer.parseInt((String)bpe.getAnnotations().get(FIELD_SIZE)), Field.Store.YES);
                doc.add((IndexableField)field);
            }
        }
        bpe.getAnnotations().remove(FIELD_KEYWORD);
        bpe.getAnnotations().remove(FIELD_DATASOURCE);
        bpe.getAnnotations().remove(FIELD_ORGANISM);
        bpe.getAnnotations().remove(FIELD_PATHWAY);
        bpe.getAnnotations().remove(FIELD_SIZE);
        if (bpe instanceof Named) {
            Named named = (Named)bpe;
            if (named.getStandardName() != null) {
                field = new TextField(FIELD_NAME, named.getStandardName(), Field.Store.NO);
                field.setBoost(3.0f);
                doc.add((IndexableField)field);
            }
            if (named.getDisplayName() != null && !named.getDisplayName().equalsIgnoreCase(named.getStandardName())) {
                field = new TextField(FIELD_NAME, named.getDisplayName(), Field.Store.NO);
                field.setBoost(2.5f);
                doc.add((IndexableField)field);
            }
            for (String name : named.getName()) {
                if (name.equalsIgnoreCase(named.getDisplayName()) || name.equalsIgnoreCase(named.getStandardName())) continue;
                field = new TextField(FIELD_NAME, name.toLowerCase(), Field.Store.NO);
                field.setBoost(2.0f);
                doc.add((IndexableField)field);
            }
        }
        if (bpe instanceof XReferrable) {
            XReferrable xr = (XReferrable)bpe;
            for (Xref xref : xr.getXref()) {
                if (xref.getId() == null) continue;
                field = new StringField(FIELD_XREFID, xref.getId().toLowerCase(), Field.Store.NO);
                doc.add((IndexableField)field);
            }
        }
        if (bpe instanceof Xref) {
            Xref xref = (Xref)bpe;
            if (xref.getId() != null) {
                field = new StringField(FIELD_XREFID, xref.getId().toLowerCase(), Field.Store.NO);
                doc.add((IndexableField)field);
            }
            if (xref.getDb() != null) {
                field = new TextField(FIELD_XREFDB, xref.getDb().toLowerCase(), Field.Store.NO);
                doc.add((IndexableField)field);
            }
        }
        try {
            indexWriter.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to index; " + bpe.getUri(), e);
        }
    }

    private void addKeywords(Set<String> keywords, Document doc) {
        for (String keyword : keywords) {
            TextField f = new TextField(FIELD_KEYWORD, keyword.toLowerCase(), Field.Store.YES);
            doc.add((IndexableField)f);
        }
    }

    private void addDatasources(Set<Provenance> set, Document doc) {
        for (Provenance p : set) {
            doc.add((IndexableField)new StringField(FIELD_DATASOURCE, p.getUri(), Field.Store.YES));
            for (String s : p.getName()) {
                doc.add((IndexableField)new TextField(FIELD_DATASOURCE, s.toLowerCase(), Field.Store.NO));
            }
        }
    }

    private void addOrganisms(Set<BioSource> set, Document doc) {
        for (BioSource bs : set) {
            doc.add((IndexableField)new StoredField(FIELD_ORGANISM, bs.getUri()));
            for (String s : bs.getName()) {
                doc.add((IndexableField)new TextField(FIELD_ORGANISM, s.toLowerCase(), Field.Store.NO));
            }
            for (UnificationXref x : new ClassFilterSet(bs.getXref(), UnificationXref.class)) {
                if (x.getId() == null) continue;
                doc.add((IndexableField)new TextField(FIELD_ORGANISM, x.getId().toLowerCase(), Field.Store.NO));
            }
            if (bs.getTissue() != null) {
                for (String s : bs.getTissue().getTerm()) {
                    doc.add((IndexableField)new TextField(FIELD_ORGANISM, s.toLowerCase(), Field.Store.NO));
                }
            }
            if (bs.getCellType() == null) continue;
            for (String s : bs.getCellType().getTerm()) {
                doc.add((IndexableField)new TextField(FIELD_ORGANISM, s.toLowerCase(), Field.Store.NO));
            }
        }
    }

    private void addPathways(Set<Pathway> set, Document doc) {
        for (Pathway pw : set) {
            doc.add((IndexableField)new StoredField(FIELD_PATHWAY, pw.getUri()));
            for (String s : pw.getName()) {
                doc.add((IndexableField)new TextField(FIELD_PATHWAY, s.toLowerCase(), Field.Store.NO));
                doc.add((IndexableField)new StoredField(FIELD_KEYWORD, s.toLowerCase()));
            }
            for (UnificationXref x : new ClassFilterSet(pw.getXref(), UnificationXref.class)) {
                if (x.getId() == null) continue;
                doc.add((IndexableField)new TextField(FIELD_PATHWAY, x.getId().toLowerCase(), Field.Store.NO));
                doc.add((IndexableField)new StoredField(FIELD_KEYWORD, x.getId().toLowerCase()));
            }
        }
    }

    private String getTaxonId(BioSource bioSource) {
        String id = null;
        if (!bioSource.getXref().isEmpty()) {
            ClassFilterSet uxs = new ClassFilterSet(bioSource.getXref(), UnificationXref.class);
            for (UnificationXref ux : uxs) {
                if (!"taxonomy".equalsIgnoreCase(ux.getDb())) continue;
                id = ux.getId();
                break;
            }
        }
        return id;
    }

    private org.apache.lucene.search.Filter createFilter(Class<? extends BioPAXElement> type, String[] datasources, String[] organisms) {
        BooleanQuery filterQuery = new BooleanQuery();
        if (datasources != null && datasources.length > 0) {
            filterQuery.add(this.subQuery(datasources, FIELD_DATASOURCE), BooleanClause.Occur.MUST);
        }
        if (organisms != null && organisms.length > 0) {
            filterQuery.add(this.subQuery(organisms, FIELD_ORGANISM), BooleanClause.Occur.MUST);
        }
        if (type != null) {
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term(FIELD_TYPE, type.getSimpleName().toLowerCase())), BooleanClause.Occur.SHOULD);
            for (Class subType : SimpleEditorMap.L3.getKnownSubClassesOf(type)) {
                query.add((Query)new TermQuery(new Term(FIELD_TYPE, subType.getSimpleName().toLowerCase())), BooleanClause.Occur.SHOULD);
            }
            filterQuery.add((Query)query, BooleanClause.Occur.MUST);
        }
        if (!filterQuery.clauses().isEmpty()) {
            LOG.debug("filterQuery: " + filterQuery.toString());
            return new CachingWrapperFilter((org.apache.lucene.search.Filter)new QueryWrapperFilter((Query)filterQuery));
        }
        return null;
    }

    private Query subQuery(String[] filterValues, String filterField) {
        BooleanQuery query = new BooleanQuery();
        Pattern pattern = Pattern.compile("\\s");
        for (String v : filterValues) {
            if (pattern.matcher(v).find()) {
                BooleanQuery bq = new BooleanQuery();
                try {
                    TokenStream tokenStream = this.analyzer.tokenStream(filterField, (Reader)new StringReader(v));
                    CharTermAttribute chattr = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
                    tokenStream.reset();
                    while (tokenStream.incrementToken()) {
                        String token = chattr.toString();
                        bq.add((Query)new TermQuery(new Term(filterField, token)), BooleanClause.Occur.MUST);
                    }
                    tokenStream.end();
                    tokenStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to open a token stream; field:" + filterField + ", value:" + v, e);
                }
                query.add((Query)bq, BooleanClause.Occur.SHOULD);
                continue;
            }
            query.add((Query)new TermQuery(new Term(filterField, v.toLowerCase())), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    public static enum HitAnnotation {
        HIT_EXCERPT,
        HIT_SIZE,
        HIT_ORGANISM,
        HIT_DATASOURCE,
        HIT_PATHWAY;

    }
}

