/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.converter.psi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.CellVocabulary;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaReference;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.EvidenceCodeVocabulary;
import org.biopax.paxtools.model.level3.ExperimentalForm;
import org.biopax.paxtools.model.level3.ExperimentalFormVocabulary;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.GeneticInteraction;
import org.biopax.paxtools.model.level3.InteractionVocabulary;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaReference;
import org.biopax.paxtools.model.level3.Score;
import org.biopax.paxtools.model.level3.SequenceEntityReference;
import org.biopax.paxtools.model.level3.SequenceInterval;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.model.level3.SequenceRegionVocabulary;
import org.biopax.paxtools.model.level3.SequenceSite;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.TissueVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Availability;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentalInteractor;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorType;
import psidev.psi.mi.xml.model.Interval;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Organism;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.Range;
import psidev.psi.mi.xml.model.Source;
import psidev.psi.mi.xml.model.Unit;

class EntryMapper {
    private static final Logger LOG = LoggerFactory.getLogger(EntryMapper.class);
    private static final ArrayList<String> GENETIC_INTERACTIONS = new ArrayList();
    public static final String BIOGRID_EVIDENCE_CODE = "BioGRID Evidence Code";
    public static final String EXPERIMENTAL_FORM_ENTITY_COMMENT = "experimental form entity";
    public static final String FIGURE_LEGEND_CODE = "figure legend";
    private final Model bpModel;
    private final String xmlBase;
    private long counter;
    private final boolean forceInteractionToComplex;
    private static final Collection<String> BAD_ID_VALS;

    public EntryMapper(Model model, boolean forceInteractionToComplex) {
        this.bpModel = model;
        this.xmlBase = model.getXmlBase() == null ? "" : model.getXmlBase();
        this.counter = System.currentTimeMillis();
        this.forceInteractionToComplex = forceInteractionToComplex;
    }

    public void run(Entry entry) {
        HashSet<String> avail = new HashSet<String>();
        if (entry.hasAvailabilities()) {
            for (Availability a : entry.getAvailabilities()) {
                if (!a.hasValue()) continue;
                avail.add(a.getValue());
            }
        }
        Provenance pro = this.createProvenance(entry.getSource());
        HashSet<Interaction> participantInteractions = new HashSet<Interaction>();
        for (Interaction interaction : entry.getInteractions()) {
            for (Participant participant : interaction.getParticipants()) {
                if (!participant.hasInteraction()) continue;
                participantInteractions.add(participant.getInteraction());
            }
        }
        for (Interaction interaction : entry.getInteractions()) {
            if (participantInteractions.contains(interaction)) continue;
            this.processInteraction(interaction, avail, pro, false);
        }
    }

    private Provenance createProvenance(Source source) {
        String sourceUri;
        Provenance pro = null;
        String name = null;
        PublicationXref px = null;
        UnificationXref ux = null;
        if (source.hasNames()) {
            name = this.getName(source.getNames());
        }
        if (source.hasXref()) {
            ux = this.getPrimaryUnificationXref(source.getXref());
            if (name == null && ux != null) {
                name = ux.getDb() + "_" + ux.getId();
            }
        }
        if (source.hasBibref()) {
            psidev.psi.mi.xml.model.Xref psiXREF = source.getBibref().getXref();
            if (psiXREF != null) {
                px = this.publicationXref(psiXREF.getPrimaryRef().getDb(), psiXREF.getPrimaryRef().getId());
            }
            if (name == null && px != null) {
                name = px.getDb() + "_" + px.getId();
            }
        }
        String ver = null;
        if (source.hasReleaseDate()) {
            ver = source.getRelease();
            if (name == null) {
                name = ver;
            }
        }
        if ((pro = (Provenance)this.bpModel.getByID(sourceUri = name != null ? this.xmlBase + "Provenance_" + this.encode(name) : this.genUri(Provenance.class, new Object[0]))) == null) {
            pro = (Provenance)this.bpModel.addNew(Provenance.class, sourceUri);
            if (name != null) {
                pro.setDisplayName(name);
            }
            if (px != null) {
                pro.addXref((Xref)px);
            }
            if (ux != null) {
                pro.addXref((Xref)ux);
            }
            if (source.hasAttributes()) {
                for (Attribute attr : source.getAttributes()) {
                    pro.addComment(attr.toString());
                }
            }
            if (ver != null) {
                pro.addComment("Release Date: " + ver);
            }
        }
        return pro;
    }

    private Entity processInteraction(Interaction interaction, Set<String> avail, Provenance pro, boolean isComplex) {
        String type;
        Object bpInteraction = null;
        boolean isGeneticInteraction = false;
        String name = null;
        String shortName = null;
        if (interaction.hasNames()) {
            Names names = interaction.getNames();
            name = names.hasFullName() ? names.getFullName() : "";
            shortName = names.hasShortLabel() ? names.getShortLabel() : "";
        }
        HashSet<InteractionVocabulary> interactionVocabularies = new HashSet<InteractionVocabulary>();
        if (interaction.hasInteractionTypes()) {
            for (CvType interactionType : interaction.getInteractionTypes()) {
                InteractionVocabulary cv = this.findOrCreateControlledVocabulary(interactionType, InteractionVocabulary.class);
                if (cv == null) continue;
                interactionVocabularies.add(cv);
            }
        }
        HashSet<Evidence> bpEvidences = new HashSet();
        if (interaction.hasExperiments()) {
            bpEvidences = this.createBiopaxEvidences(interaction);
        }
        HashSet<String> participantTypes = new HashSet<String>();
        for (Object p : interaction.getParticipants()) {
            if (p.hasInteractor()) {
                type = this.getName(p.getInteractor().getInteractorType().getNames());
                if (type == null) {
                    type = "protein";
                }
                participantTypes.add(type.toLowerCase());
                continue;
            }
            if (!p.hasInteraction()) continue;
            participantTypes.add("complex");
        }
        if (participantTypes.size() > 1 && participantTypes.contains("gene")) {
            LOG.warn("Interaction: " + interaction.getId() + ", name(s): " + shortName + " " + name + "; has both 'gene' and physical entity type participants: " + participantTypes + "; so we'll replace 'gene' with 'dna' (a quick fix)");
            for (Object p : interaction.getParticipants()) {
                if (!p.hasInteractor() || !p.getInteractor().getInteractorType().hasNames() || !"gene".equalsIgnoreCase(type = this.getName(p.getInteractor().getInteractorType().getNames()))) continue;
                p.getInteractor().getInteractorType().getNames().setShortLabel("dna");
            }
        }
        HashSet<Entity> bpParticipants = new HashSet<Entity>();
        for (Object participant : interaction.getParticipants()) {
            Entity bpParticipant = this.createBiopaxEntity((Participant)participant, avail, pro);
            if (bpParticipant == null || bpParticipants.contains(bpParticipant)) continue;
            bpParticipants.add(bpParticipant);
        }
        HashSet<String> comments = new HashSet<String>();
        if (interaction.hasAttributes()) {
            for (Attribute attribute : interaction.getAttributes()) {
                String value;
                String key = attribute.getName();
                String string = value = attribute.hasValue() ? attribute.getValue() : "";
                if (key.equalsIgnoreCase(BIOGRID_EVIDENCE_CODE) && GENETIC_INTERACTIONS.contains(value)) {
                    isGeneticInteraction = true;
                }
                comments.add(key + ":" + value);
            }
        }
        if (participantTypes.size() == 1 && participantTypes.contains("gene")) {
            isGeneticInteraction = true;
        }
        if (!isGeneticInteraction) {
            isGeneticInteraction = this.isGeneticInteraction(bpEvidences);
        }
        bpInteraction = (isComplex || this.forceInteractionToComplex) && !isGeneticInteraction ? this.createComplex(bpParticipants, interaction.getImexId(), interaction.getId()) : (isGeneticInteraction ? this.createGeneticInteraction(bpParticipants, interactionVocabularies, interaction.getImexId(), interaction.getId()) : this.createMolecularInteraction(bpParticipants, interactionVocabularies, interaction.getImexId(), interaction.getId()));
        for (String c : comments) {
            bpInteraction.addComment(c);
        }
        for (Evidence evidence : bpEvidences) {
            bpInteraction.addEvidence(evidence);
        }
        this.addAvailabilityAndProvenance((Entity)bpInteraction, avail, pro);
        if (name != null) {
            bpInteraction.addName(name);
        }
        if (shortName != null) {
            if (shortName.length() < 51) {
                bpInteraction.setDisplayName(shortName);
            } else {
                bpInteraction.addName(shortName);
            }
        }
        HashSet<Xref> bpXrefs = new HashSet<Xref>();
        if (interaction.hasXref()) {
            bpXrefs.addAll(this.getXrefs(interaction.getXref()));
        }
        for (Xref bpXref : bpXrefs) {
            bpInteraction.addXref(bpXref);
        }
        return bpInteraction;
    }

    private Set<Evidence> createBiopaxEvidences(Interaction interaction) {
        HashSet<Evidence> evidences = new HashSet<Evidence>();
        for (ExperimentDescription experimentDescription : interaction.getExperiments()) {
            Set<EvidenceCodeVocabulary> evidenceCodes;
            PublicationXref px;
            psidev.psi.mi.xml.model.Xref psiXREF;
            String evUri = this.genUri(Evidence.class, interaction.getImexId(), interaction.getId(), experimentDescription.getId());
            Evidence evidence = (Evidence)this.bpModel.addNew(Evidence.class, evUri);
            if (experimentDescription.hasXref()) {
                for (Xref xref : this.getXrefs(experimentDescription.getXref())) {
                    evidence.addXref(xref);
                }
            }
            if (experimentDescription.getBibref() != null && (psiXREF = experimentDescription.getBibref().getXref()) != null && (px = this.publicationXref(psiXREF.getPrimaryRef().getDb(), psiXREF.getPrimaryRef().getId())) != null) {
                evidence.addXref((Xref)px);
            }
            if (experimentDescription.hasNames()) {
                Names names = experimentDescription.getNames();
                if (names.hasFullName()) {
                    evidence.addComment(names.getFullName().trim());
                }
                if (names.hasShortLabel()) {
                    evidence.addComment(names.getShortLabel().trim());
                }
            }
            if (experimentDescription.hasAttributes()) {
                for (String attr : this.getAttributes(experimentDescription.getAttributes())) {
                    evidence.addComment(attr.trim());
                }
            }
            if (experimentDescription.hasHostOrganisms()) {
                for (Organism organism : experimentDescription.getHostOrganisms()) {
                    evidence.addComment("Host " + organism.toString());
                }
            }
            if (experimentDescription.hasConfidences()) {
                for (Confidence psiConfidence : experimentDescription.getConfidences()) {
                    Score bpScoreOrConfidence = this.getScoreOrConfidence(psiConfidence);
                    if (bpScoreOrConfidence == null) continue;
                    evidence.addConfidence(bpScoreOrConfidence);
                }
            }
            if ((evidenceCodes = this.getEvidenceCodes(experimentDescription)) != null) {
                for (EvidenceCodeVocabulary ecv : evidenceCodes) {
                    evidence.addEvidenceCode(ecv);
                }
            }
            evidences.add(evidence);
        }
        return evidences;
    }

    private void addAvailabilityAndProvenance(Entity bpEntity, Set<String> avail, Provenance pro) {
        if (pro != null) {
            bpEntity.addDataSource(pro);
        }
        if (avail != null) {
            for (String a : avail) {
                bpEntity.addAvailability(a);
            }
        }
    }

    private Entity createBiopaxEntity(Participant participant, Set<String> avail, Provenance pro) {
        LOG.debug("createBiopaxEntity, processing participant: " + participant.getId());
        Entity entity = null;
        if (participant.hasInteractor()) {
            entity = this.createParticipant(participant, participant.getInteractor(), avail, pro, false);
        } else if (participant.hasInteraction()) {
            entity = (Complex)this.processInteraction(participant.getInteraction(), avail, pro, true);
        }
        if (entity == null) {
            return null;
        }
        Evidence participantEvidence = (Evidence)this.bpModel.getLevel().getDefaultFactory().create(Evidence.class, this.genUri(Evidence.class, "p", participant.getId()));
        if (participant.hasExperimentalRoles() || participant.hasExperimentalInteractors() || participant.hasFeatures()) {
            if (participant.hasExperimentalInteractors()) {
                for (ExperimentalInteractor experimentalInteractor : participant.getExperimentalInteractors()) {
                    Interactor interactor = experimentalInteractor.getInteractor();
                    LOG.debug("createBiopaxEntity, participant: " + participant.getId() + ", exp. interactor: " + interactor.getId());
                    Entity expEntity = this.createParticipant(participant, interactor, avail, pro, true);
                    assert (expEntity != null) : "expEntity is null";
                    if (!this.bpModel.contains((BioPAXElement)(expEntity = this.findEquivalentEntity(expEntity)))) {
                        this.bpModel.add((BioPAXElement)expEntity);
                    }
                    if (experimentalInteractor.hasExperiments()) {
                        for (ExperimentDescription exp : experimentalInteractor.getExperiments()) {
                            LOG.debug("createBiopaxEntity, making EFs for exp: " + exp.getId() + "; exp.ent: " + expEntity.getUri());
                            this.createAddExperimentalForm(participant, participantEvidence, expEntity, exp);
                        }
                        continue;
                    }
                    LOG.debug("createBiopaxEntity, making a EForm - one for all experiments ; exp.ent: " + expEntity.getUri());
                    this.createAddExperimentalForm(participant, participantEvidence, expEntity, null);
                }
            } else {
                LOG.debug("createBiopaxEntity, participant: " + participant.getId() + " doesn't have any exp. interactors");
                this.createAddExperimentalForm(participant, participantEvidence, null, null);
            }
            if (!participantEvidence.getExperimentalForm().isEmpty()) {
                this.bpModel.add((BioPAXElement)participantEvidence);
                entity.addEvidence(participantEvidence);
            } else {
                entity = this.findEquivalentEntity(entity);
            }
        }
        if (!this.bpModel.contains((BioPAXElement)entity)) {
            this.bpModel.add((BioPAXElement)entity);
        }
        return entity;
    }

    private Entity findEquivalentEntity(Entity entity) {
        Entity toReturn = entity;
        Class<PhysicalEntity> entityClass = PhysicalEntity.class;
        if (entity instanceof Gene) {
            entityClass = Gene.class;
        }
        for (Entity existingEntity : this.bpModel.getObjects(entityClass)) {
            if ((entity.getComment().contains(EXPERIMENTAL_FORM_ENTITY_COMMENT) || existingEntity.getComment().contains(EXPERIMENTAL_FORM_ENTITY_COMMENT)) && (!entity.getComment().contains(EXPERIMENTAL_FORM_ENTITY_COMMENT) || !existingEntity.getComment().contains(EXPERIMENTAL_FORM_ENTITY_COMMENT) || !entity.getDisplayName().equalsIgnoreCase(existingEntity.getDisplayName())) || !existingEntity.getEvidence().isEmpty() || !entity.getEvidence().isEmpty() || !existingEntity.isEquivalent((BioPAXElement)entity)) continue;
            toReturn = existingEntity;
            break;
        }
        return toReturn;
    }

    private Entity createParticipant(Participant participant, Interactor interactor, Set<String> avail, Provenance pro, boolean isExperimentalForm) {
        if (interactor == null) {
            throw new AssertionError((Object)("createParticipant: participant: " + participant.getId() + " has got null interactor"));
        }
        String entityType = null;
        InteractorType interactorType = interactor.getInteractorType();
        if (interactorType != null && interactorType.hasNames()) {
            entityType = this.getName(interactorType.getNames());
        }
        String name = null;
        String shortName = null;
        HashSet<String> synonyms = new HashSet<String>();
        Names psiNames = interactor.getNames();
        if (psiNames != null) {
            name = psiNames.hasFullName() ? psiNames.getFullName() : null;
            String string = shortName = psiNames.hasShortLabel() ? psiNames.getShortLabel() : null;
            if (psiNames.hasAliases()) {
                for (Alias alias : psiNames.getAliases()) {
                    if (!alias.hasValue()) continue;
                    synonyms.add(alias.getValue());
                }
            }
        }
        CellularLocationVocabulary cellularLocation = null;
        if (interactor.hasOrganism() && interactor.getOrganism().hasCompartment()) {
            cellularLocation = this.findOrCreateControlledVocabulary((CvType)interactor.getOrganism().getCompartment(), CellularLocationVocabulary.class);
        }
        Class<Protein> entityClass = Protein.class;
        Class<ProteinReference> entityReferenceClass = ProteinReference.class;
        if (entityType != null && !entityType.isEmpty()) {
            if ("small molecule".equals(entityType = entityType.toLowerCase()) || "polysaccharide".equals(entityType) || "bioactive entity".equals(entityType)) {
                entityClass = SmallMolecule.class;
                entityReferenceClass = SmallMoleculeReference.class;
            } else if ("dna".equals(entityType) || "deoxyribonucleic acid".equals(entityType) || entityType.contains("deoxyribonucleic") || entityType.contains("dna") || "nucleic acid".equals(entityType)) {
                entityClass = Dna.class;
                entityReferenceClass = DnaReference.class;
            } else if ("rna".equals(entityType) || "ribonucleic acid".equals(entityType) || "poly adenine".equals(entityType) || entityType.contains("rna")) {
                entityClass = Rna.class;
                entityReferenceClass = RnaReference.class;
            } else if ("gene".equals(entityType)) {
                entityClass = Gene.class;
                entityReferenceClass = null;
            } else if ("complex".equals(entityType) || entityType.contains("complex")) {
                entityClass = Complex.class;
                entityReferenceClass = null;
            } else if ("interaction".equals(entityType)) {
                LOG.warn("EntryMapper.createParticipant(): skip for interactor: " + interactor.getId() + " that has type: " + entityType + ", participant:" + participant.getId() + ").");
                return null;
            }
        }
        String entityUri = "";
        String baseUri = "";
        RelationshipXref x = this.getInteractorPrimaryRef(interactor.getXref());
        if (x != null) {
            baseUri = baseUri + this.encode(x.getDb() + "_" + x.getId());
            if (x.getRelationshipType() != null) {
                baseUri = baseUri + "_" + this.encode((String)x.getRelationshipType().getTerm().iterator().next());
            }
            entityUri = baseUri + "_" + String.valueOf(this.counter++);
        } else {
            entityUri = baseUri = String.valueOf(this.counter++);
        }
        if (cellularLocation != null) {
            entityUri = entityUri + "_" + this.encode((String)cellularLocation.getTerm().iterator().next());
        }
        entityUri = this.xmlBase + entityClass.getSimpleName() + "_" + entityUri;
        if (entityReferenceClass != null) {
            baseUri = this.xmlBase + entityReferenceClass.getSimpleName() + "_" + baseUri;
        }
        Entity entity = (Entity)this.bpModel.getLevel().getDefaultFactory().create(entityClass, entityUri);
        this.addAvailabilityAndProvenance(entity, avail, pro);
        if (name != null) {
            if (name.length() > 100 && shortName != null) {
                entity.addComment(name);
            } else {
                entity.addName(name);
            }
        }
        if (shortName != null) {
            entity.setDisplayName(shortName);
        }
        if (cellularLocation != null && entity instanceof PhysicalEntity) {
            ((PhysicalEntity)entity).setCellularLocation(cellularLocation);
        }
        Set<Xref> bpXrefsOfInteractor = this.getXrefs(interactor.getXref());
        BioSource bioSource = this.getBioSource(interactor);
        if (entityReferenceClass != null) {
            EntityReference entityReference = null;
            EntityReference er = (EntityReference)this.bpModel.getByID(baseUri);
            if (er != null && er.getModelInterface() == entityReferenceClass && (!(er instanceof SequenceEntityReference) || this.sameNameOrUndefined(((SequenceEntityReference)er).getOrganism(), bioSource))) {
                entityReference = er;
            } else if (er != null) {
                String newUri = baseUri + "_" + this.counter++;
                LOG.warn("A different " + er.getModelInterface().getSimpleName() + ", URI=" + baseUri + ", was found; for interactor:" + interactor.getId() + ", a new (" + entityReferenceClass.getSimpleName() + ") URI will be used:" + newUri);
                baseUri = newUri;
            }
            if (entityReference == null) {
                entityReference = (EntityReference)this.bpModel.addNew(entityReferenceClass, baseUri);
                if (shortName != null) {
                    entityReference.setDisplayName(shortName);
                }
                if (entityReference instanceof SequenceEntityReference) {
                    SequenceEntityReference ser = (SequenceEntityReference)entityReference;
                    ser.setOrganism(bioSource);
                    ser.setSequence(interactor.getSequence());
                }
            }
            if (entityReference == er && shortName != null && !isExperimentalForm) {
                if (er.getDisplayName() != null) {
                    if (shortName.length() < er.getDisplayName().length()) {
                        entityReference.addName(er.getDisplayName());
                        entityReference.setDisplayName(shortName);
                    } else {
                        entityReference.addName(shortName);
                    }
                } else {
                    entityReference.setDisplayName(shortName);
                }
            }
            if (!isExperimentalForm || entityReference != er) {
                if (name != null) {
                    if (name.length() > 100 && (entityReference.getDisplayName() != null || synonyms != null && !synonyms.isEmpty())) {
                        entityReference.addComment(name);
                    } else {
                        entityReference.addName(name);
                    }
                }
                if (synonyms != null) {
                    for (String synonym : synonyms) {
                        entityReference.addName(synonym);
                    }
                }
                if (bpXrefsOfInteractor != null) {
                    for (Xref xref : bpXrefsOfInteractor) {
                        entityReference.addXref(xref);
                    }
                }
            }
            ((SimplePhysicalEntity)entity).setEntityReference(entityReference);
        } else {
            if (synonyms != null) {
                for (String synonym : synonyms) {
                    entity.addName(synonym);
                }
            }
            if (bpXrefsOfInteractor != null) {
                for (Xref xref : bpXrefsOfInteractor) {
                    entity.addXref(xref);
                }
            }
            if (entity instanceof Gene) {
                ((Gene)entity).setOrganism(bioSource);
            }
        }
        if (isExperimentalForm) {
            entity.addComment(EXPERIMENTAL_FORM_ENTITY_COMMENT);
        } else {
            entity.addComment("psi-mi participant");
        }
        return entity;
    }

    private boolean sameNameOrUndefined(BioSource a, BioSource b) {
        return a == null ? b == null : (b == null ? false : a.getDisplayName() == null && b.getDisplayName() == null || a.getDisplayName() != null && a.getDisplayName().equalsIgnoreCase(b.getDisplayName()));
    }

    private Set<SequenceInterval> getSequenceLocation(Collection<Range> rangeList) {
        HashSet<SequenceInterval> toReturn = new HashSet<SequenceInterval>();
        for (Range range : rangeList) {
            Interval endInterval;
            Interval beginInterval = range.hasBeginInterval() ? range.getBeginInterval() : null;
            Interval interval = endInterval = range.hasEndInterval() ? range.getEndInterval() : null;
            if (beginInterval == null) continue;
            toReturn.add(this.getSequenceLocation(beginInterval.getBegin(), beginInterval.getEnd()));
            if (endInterval == null) continue;
            toReturn.add(this.getSequenceLocation(endInterval.getBegin(), endInterval.getEnd()));
        }
        return toReturn;
    }

    private BioSource getBioSource(Interactor interactor) {
        BioSource toReturn;
        Organism organism = interactor.getOrganism();
        if (organism == null) {
            return null;
        }
        CellVocabulary cellType = this.findOrCreateControlledVocabulary((CvType)organism.getCellType(), CellVocabulary.class);
        TissueVocabulary tissue = this.findOrCreateControlledVocabulary((CvType)organism.getTissue(), TissueVocabulary.class);
        String ncbiId = Integer.toString(organism.getNcbiTaxId());
        String name = null;
        if (organism.hasNames() && (name = this.getName(organism.getNames())) != null && ("homo sapiens".equalsIgnoreCase(name) || "human".equalsIgnoreCase(name)) && !"9606".equals(ncbiId)) {
            LOG.error("Taxonomy: " + ncbiId + " of organism: " + organism + ", interactor: " + interactor.getId() + " does not belong to '" + name + "'; the name will be removed. Data provider should probably use <experimentalInteractor> in addition to <interactor>");
            name = null;
        }
        String uri = this.xmlBase + "BioSource_taxonomy_" + ncbiId;
        if (tissue != null && !tissue.getTerm().isEmpty()) {
            uri = uri + "_" + this.encode((String)tissue.getTerm().iterator().next());
        }
        if (cellType != null && !cellType.getTerm().isEmpty()) {
            uri = uri + "_" + this.encode((String)cellType.getTerm().iterator().next());
        }
        if ((toReturn = (BioSource)this.bpModel.getByID(uri)) != null) {
            return toReturn;
        }
        toReturn = (BioSource)this.bpModel.addNew(BioSource.class, uri);
        String taxonXrefUri = this.xmlBase + "UnificationXref_taxonomy_" + ncbiId;
        UnificationXref taxonXref = (UnificationXref)this.bpModel.getByID(taxonXrefUri);
        if (taxonXref == null) {
            taxonXref = (UnificationXref)this.bpModel.addNew(UnificationXref.class, taxonXrefUri);
            taxonXref.setDb("Taxonomy");
            taxonXref.setId(ncbiId);
        }
        toReturn.addXref((Xref)taxonXref);
        if (cellType != null) {
            toReturn.setCellType(cellType);
        }
        if (tissue != null) {
            toReturn.setTissue(tissue);
        }
        if (name != null) {
            toReturn.setStandardName(name);
        }
        return toReturn;
    }

    private <T extends ControlledVocabulary> T findOrCreateControlledVocabulary(CvType cvType, Class<T> bpCvClass) {
        if (cvType == null) {
            return null;
        }
        String term = null;
        if (cvType.hasNames()) {
            term = this.getName(cvType.getNames());
        }
        UnificationXref bpXref = this.getPrimaryUnificationXref(cvType.getXref());
        T toReturn = this.findOrCreateControlledVocabulary(term, bpXref, bpCvClass);
        return toReturn;
    }

    private <T extends ControlledVocabulary> T findOrCreateControlledVocabulary(String term, UnificationXref bpXref, Class<T> bpCvClass) {
        String uri = this.xmlBase + bpCvClass.getSimpleName() + "_" + this.encode(term != null && !term.isEmpty() ? term : bpXref.getDb() + "_" + bpXref.getId());
        ControlledVocabulary toReturn = (ControlledVocabulary)this.bpModel.getByID(uri);
        if (toReturn != null) {
            return (T)toReturn;
        }
        toReturn = (ControlledVocabulary)this.bpModel.addNew(bpCvClass, uri);
        if (term != null) {
            toReturn.addTerm(term);
        }
        toReturn.addXref((Xref)bpXref);
        return (T)toReturn;
    }

    private Set<Xref> getXrefs(psidev.psi.mi.xml.model.Xref psiXREF) {
        HashSet<Xref> toReturn = new HashSet<Xref>();
        if (psiXREF == null) {
            return toReturn;
        }
        ArrayList<DbReference> psiDBRefList = new ArrayList<DbReference>();
        DbReference primaryRef = psiXREF.getPrimaryRef();
        if (primaryRef != null) {
            if ("identity".equals(primaryRef.getRefType()) || "identical object".equals(primaryRef.getRefType())) {
                UnificationXref bpXref = this.unificationXref(primaryRef.getDb(), primaryRef.getId());
                toReturn.add((Xref)bpXref);
            } else {
                psiDBRefList.add(psiXREF.getPrimaryRef());
            }
        }
        if (psiXREF.hasSecondaryRef()) {
            psiDBRefList.addAll(psiXREF.getSecondaryRef());
        }
        for (DbReference psiref : psiDBRefList) {
            if (psiref == null) continue;
            this.xref(psiref, toReturn);
        }
        return toReturn;
    }

    private void xref(DbReference psiref, Set<Xref> bpXrefs) {
        String refType = psiref.hasRefType() ? psiref.getRefType() : null;
        String refTypeAc = psiref.hasRefTypeAc() ? psiref.getRefTypeAc() : null;
        String psiDBRefId = psiref.getId();
        String psiDBRefDb = psiref.getDb();
        for (String dbRefId : psiDBRefId.split(",")) {
            Object bpXref = null;
            bpXref = !"pubmed".equalsIgnoreCase(psiDBRefDb) ? this.relationshipXref(psiDBRefDb, dbRefId, refType, refTypeAc) : this.publicationXref(psiDBRefDb, dbRefId);
            if (bpXref == null) continue;
            bpXrefs.add((Xref)bpXref);
        }
    }

    private String dbQuickFix(String db) {
        if ("entrezgene/locuslink".equalsIgnoreCase(db) || "entrezgene".equalsIgnoreCase(db) || "entrez gene".equalsIgnoreCase(db) || "ncbi gene".equalsIgnoreCase(db) || "geneid".equalsIgnoreCase(db) || "gene id".equalsIgnoreCase(db) || "ncbigene".equalsIgnoreCase(db)) {
            db = "NCBI Gene";
        }
        return db;
    }

    private UnificationXref getPrimaryUnificationXref(psidev.psi.mi.xml.model.Xref psiXref) {
        String refType;
        if (psiXref == null || psiXref.getPrimaryRef() == null) {
            return null;
        }
        UnificationXref toReturn = null;
        DbReference psiDBRef = psiXref.getPrimaryRef();
        String string = refType = psiDBRef.hasRefType() ? psiDBRef.getRefType() : null;
        if (refType == null || "identity".equals(refType) || "identical object".equals(refType)) {
            toReturn = this.unificationXref(psiDBRef.getDb(), psiDBRef.getId());
        }
        return toReturn;
    }

    private RelationshipXref getInteractorPrimaryRef(psidev.psi.mi.xml.model.Xref psiXref) {
        if (psiXref == null || psiXref.getPrimaryRef() == null) {
            return null;
        }
        DbReference psiDBRef = psiXref.getPrimaryRef();
        String refType = psiDBRef.hasRefType() ? psiDBRef.getRefType() : null;
        String refTypeAc = psiDBRef.hasRefType() ? psiDBRef.getRefTypeAc() : null;
        return this.relationshipXref(psiDBRef.getDb(), psiDBRef.getId(), refType, refTypeAc);
    }

    private UnificationXref unificationXref(String db, String id) {
        if (db == null || db.trim().isEmpty()) {
            LOG.warn("unificationXref(), db is null, id=" + id);
            return null;
        }
        db = this.dbQuickFix(db);
        if (id == null || id.trim().isEmpty() || BAD_ID_VALS.contains(id.trim().toUpperCase())) {
            LOG.warn("unificationXref(), illegal or empty id:" + id);
            return null;
        }
        id = id.trim();
        String xuri = this.xmlBase + "UnificationXref_" + this.encode(db.toLowerCase() + "_" + id);
        UnificationXref x = (UnificationXref)this.bpModel.getByID(xuri);
        if (x == null) {
            x = (UnificationXref)this.bpModel.addNew(UnificationXref.class, xuri);
            x.setDb(db);
            x.setId(id);
        }
        return x;
    }

    private PublicationXref publicationXref(String db, String id) {
        if (db == null || db.isEmpty()) {
            LOG.warn("publicationXref(), db is null, id=" + id);
            return null;
        }
        db = this.dbQuickFix(db);
        if (id == null || id.trim().isEmpty() || BAD_ID_VALS.contains(id.trim().toUpperCase())) {
            LOG.warn("publicationXref(), skip illegal id=" + id);
            return null;
        }
        id = id.trim();
        if ("pubmed".equalsIgnoreCase(db) && !id.matches("\\d+") || "14755292".equals(id)) {
            LOG.warn("publicationXref(), skip illegal or dummy publication id=" + id);
            return null;
        }
        String xuri = this.xmlBase + "PublicationXref_" + this.encode(db.toLowerCase() + "_" + id);
        PublicationXref x = (PublicationXref)this.bpModel.getByID(xuri);
        if (x == null) {
            x = (PublicationXref)this.bpModel.addNew(PublicationXref.class, xuri);
            x.setDb(db);
            x.setId(id);
        }
        return x;
    }

    private String encode(String id) {
        return id.replaceAll("[^-\\w]", "_");
    }

    private Set<EvidenceCodeVocabulary> getEvidenceCodes(ExperimentDescription experimentDescription) {
        HashSet<EvidenceCodeVocabulary> toReturn = new HashSet<EvidenceCodeVocabulary>();
        HashSet<Object> cvTypeSet = new HashSet<Object>(3);
        if (experimentDescription.getInteractionDetectionMethod() != null && !"MI:0686".equalsIgnoreCase(experimentDescription.getInteractionDetectionMethod().getXref().getPrimaryRef().getId())) {
            cvTypeSet.add(experimentDescription.getInteractionDetectionMethod());
        }
        if (experimentDescription.getParticipantIdentificationMethod() != null && !"MI:0686".equalsIgnoreCase(experimentDescription.getParticipantIdentificationMethod().getXref().getPrimaryRef().getId())) {
            cvTypeSet.add(experimentDescription.getParticipantIdentificationMethod());
        }
        if (experimentDescription.getFeatureDetectionMethod() != null && !"MI:0686".equalsIgnoreCase(experimentDescription.getFeatureDetectionMethod().getXref().getPrimaryRef().getId())) {
            cvTypeSet.add(experimentDescription.getFeatureDetectionMethod());
        }
        for (CvType cvType : cvTypeSet) {
            EvidenceCodeVocabulary ecv = this.findOrCreateControlledVocabulary(cvType, EvidenceCodeVocabulary.class);
            if (ecv == null) continue;
            toReturn.add(ecv);
        }
        return toReturn;
    }

    private Score getScoreOrConfidence(Confidence psiConfidence) {
        String unitName;
        if (psiConfidence == null) {
            return null;
        }
        String value = psiConfidence.getValue();
        Unit ocv = psiConfidence.getUnit();
        HashSet<Xref> bpXrefs = new HashSet<Xref>();
        if (ocv != null && ocv.getXref() != null) {
            bpXrefs.addAll(this.getXrefs(ocv.getXref()));
        }
        HashSet<String> comments = new HashSet<String>();
        if (ocv != null && ocv.getNames() != null && (unitName = this.getName(ocv.getNames())) != null) {
            comments.add(unitName);
        }
        if (ocv.hasAttributes()) {
            comments.addAll(this.getAttributes(ocv.getAttributes()));
        }
        Score ret = this.createScore(value, bpXrefs, comments);
        return ret;
    }

    private Set<String> getAttributes(Collection<Attribute> attributes) {
        HashSet<String> toReturn = new HashSet<String>();
        for (Attribute attribute : attributes) {
            String name;
            String attributeStr = "";
            if (attribute.hasValue()) {
                attributeStr = attribute.getValue();
            }
            String string = attributeStr = (name = attribute.getName()) != null ? (attributeStr = attributeStr + " " + name) : attributeStr;
            if (attribute.hasNameAc()) {
                attributeStr = attributeStr + " " + attribute.getNameAc();
            }
            if (attributeStr.length() <= 0) continue;
            toReturn.add(attributeStr);
        }
        return toReturn;
    }

    private void createAddExperimentalForm(Participant participant, Evidence pEvidence, Entity expEntity, ExperimentDescription exp) {
        HashSet<ModificationFeature> efs = new HashSet<ModificationFeature>();
        for (Object f : participant.getFeatures()) {
            ModificationFeature feature;
            if (exp != null && !f.getExperiments().contains(exp) && !f.getExperiments().isEmpty() || (feature = this.getFeature(ModificationFeature.class, (Feature)f)) == null) continue;
            efs.add(feature);
        }
        HashSet<ExperimentalFormVocabulary> efvs = new HashSet<ExperimentalFormVocabulary>();
        if (participant.hasExperimentalRoles()) {
            for (ExperimentalRole role : participant.getExperimentalRoles()) {
                ExperimentalFormVocabulary experimentalFormVocabulary;
                if (exp != null && !role.getExperiments().contains(exp) && !role.getExperiments().isEmpty()) continue;
                Object var9_10 = null;
                if (role.getXref() == null || "MI:0499".equalsIgnoreCase(role.getXref().getPrimaryRef().getId()) || (experimentalFormVocabulary = this.findOrCreateControlledVocabulary((CvType)role, ExperimentalFormVocabulary.class)) == null) continue;
                efvs.add(experimentalFormVocabulary);
            }
        }
        if (efs.isEmpty() && efvs.isEmpty() && expEntity == null) {
            return;
        }
        ExperimentalForm ef = (ExperimentalForm)this.bpModel.addNew(ExperimentalForm.class, this.genUri(ExperimentalForm.class, new Object[0]));
        if (!efs.isEmpty()) {
            ef.addComment(((Object)efs).toString());
            for (EntityFeature entityFeature : efs) {
                ef.addExperimentalFeature(entityFeature);
            }
        }
        if (!efvs.isEmpty()) {
            ef.addComment(((Object)efvs).toString());
            for (ExperimentalFormVocabulary experimentalFormVocabulary : efvs) {
                ef.addExperimentalFormDescription(experimentalFormVocabulary);
            }
        }
        if (expEntity != null) {
            ef.setExperimentalFormEntity(expEntity);
            ef.addComment("experimental form entity: " + expEntity.getDisplayName());
        }
        pEvidence.addExperimentalForm(ef);
    }

    private String getName(Names name) {
        if (name.hasShortLabel()) {
            return name.getShortLabel();
        }
        if (name.hasFullName()) {
            return name.getFullName();
        }
        return null;
    }

    private RelationshipXref relationshipXref(String db, String id, String refType, String refTypeAc) {
        if (db == null || db.trim().isEmpty()) {
            LOG.warn("relationshipXref(), db is null, id=" + id);
            return null;
        }
        db = this.dbQuickFix(db);
        if (id == null || id.trim().isEmpty() || BAD_ID_VALS.contains(id.trim().toUpperCase())) {
            LOG.warn("relationshipXref(), illegal id=" + id);
            return null;
        }
        id = id.trim();
        String uri = this.xmlBase + "RelationshipXref_";
        uri = refType != null && !refType.isEmpty() ? uri + this.encode(db.toLowerCase() + "_" + id + "_" + refType) : uri + this.encode(db.toLowerCase() + "_" + id);
        RelationshipXref x = (RelationshipXref)this.bpModel.getByID(uri);
        if (x == null) {
            x = (RelationshipXref)this.bpModel.addNew(RelationshipXref.class, uri);
            x.setDb(db);
            x.setId(id);
            if (refType != null) {
                String cvUri = refTypeAc != null ? "http://identifiers.org/psimi/" + refTypeAc : this.xmlBase + "RTV_" + this.encode(refType);
                RelationshipTypeVocabulary rtv = (RelationshipTypeVocabulary)this.bpModel.getByID(cvUri);
                if (rtv == null) {
                    rtv = (RelationshipTypeVocabulary)this.bpModel.addNew(RelationshipTypeVocabulary.class, cvUri);
                    rtv.addTerm(refType);
                    if (refTypeAc != null && !refTypeAc.isEmpty()) {
                        UnificationXref cvx = (UnificationXref)this.bpModel.addNew(UnificationXref.class, this.genUri(UnificationXref.class, new Object[0]));
                        cvx.setDb("PSI-MI");
                        cvx.setId(refTypeAc);
                        rtv.addXref((Xref)cvx);
                    }
                }
                x.setRelationshipType(rtv);
            }
        }
        return x;
    }

    private Score createScore(String value, Set<? extends Xref> bpXrefs, Set<String> comments) {
        Score bpScore = (Score)this.bpModel.addNew(Score.class, this.genUri(Score.class, value));
        if (value != null) {
            bpScore.setValue(value);
        }
        if (bpXrefs != null && !bpXrefs.isEmpty()) {
            for (Xref xref : bpXrefs) {
                bpScore.addXref(xref);
            }
        }
        if (comments != null && !comments.isEmpty()) {
            for (String string : comments) {
                bpScore.addComment(string);
            }
        }
        return bpScore;
    }

    private MolecularInteraction createMolecularInteraction(Set<? extends Entity> participants, Set<InteractionVocabulary> interactionVocabularies, Object ... psimiIds) {
        MolecularInteraction toReturn = (MolecularInteraction)this.bpModel.addNew(MolecularInteraction.class, this.genUri(MolecularInteraction.class, psimiIds));
        if (participants != null && !participants.isEmpty()) {
            for (Entity entity : participants) {
                toReturn.addParticipant(entity);
            }
        }
        for (InteractionVocabulary interactionVocabulary : interactionVocabularies) {
            toReturn.addInteractionType(interactionVocabulary);
        }
        return toReturn;
    }

    private GeneticInteraction createGeneticInteraction(Set<? extends Entity> participants, Set<InteractionVocabulary> interactionVocabularies, Object ... psimiIds) {
        GeneticInteraction toReturn = (GeneticInteraction)this.bpModel.addNew(GeneticInteraction.class, this.genUri(GeneticInteraction.class, psimiIds));
        if (participants != null && !participants.isEmpty()) {
            for (Entity entity : participants) {
                toReturn.addParticipant((Entity)((Gene)entity));
            }
        }
        for (InteractionVocabulary interactionVocabulary : interactionVocabularies) {
            toReturn.addInteractionType(interactionVocabulary);
        }
        return toReturn;
    }

    private Complex createComplex(Set<? extends Entity> participants, Object ... psimiIds) {
        Complex toReturn = (Complex)this.bpModel.addNew(Complex.class, this.genUri(Complex.class, psimiIds));
        if (participants != null && !participants.isEmpty()) {
            for (Entity entity : participants) {
                toReturn.addComponent((PhysicalEntity)entity);
            }
        }
        return toReturn;
    }

    private <T extends EntityFeature> T getFeature(Class<T> featureClass, Feature psiFeature) {
        String entityFeatureUri = this.genUri(featureClass, psiFeature.getId());
        EntityFeature entityFeature = (EntityFeature)this.bpModel.addNew(featureClass, entityFeatureUri);
        Set<SequenceInterval> featureLocations = this.getSequenceLocation(psiFeature.getRanges());
        if (featureLocations != null) {
            for (SequenceLocation sequenceLocation : featureLocations) {
                entityFeature.setFeatureLocation(sequenceLocation);
            }
        }
        String term = null;
        if (psiFeature.hasNames()) {
            term = this.getName(psiFeature.getNames());
        }
        UnificationXref unificationXref = this.getPrimaryUnificationXref(psiFeature.getXref());
        SequenceRegionVocabulary srv = this.findOrCreateControlledVocabulary(term, unificationXref, SequenceRegionVocabulary.class);
        entityFeature.setFeatureLocationType(srv);
        if (psiFeature.hasFeatureType() && featureClass == ModificationFeature.class) {
            SequenceModificationVocabulary smv = this.findOrCreateControlledVocabulary((CvType)psiFeature.getFeatureType(), SequenceModificationVocabulary.class);
            ((ModificationFeature)entityFeature).setModificationType(smv);
        }
        return (T)entityFeature;
    }

    private SequenceInterval getSequenceLocation(long beginSequenceInterval, long endSequenceInterval) {
        SequenceInterval toReturn = (SequenceInterval)this.bpModel.addNew(SequenceInterval.class, this.genUri(SequenceInterval.class, beginSequenceInterval, endSequenceInterval));
        SequenceSite bpSequenceSiteBegin = (SequenceSite)this.bpModel.addNew(SequenceSite.class, this.genUri(SequenceSite.class, beginSequenceInterval));
        bpSequenceSiteBegin.setSequencePosition((int)beginSequenceInterval);
        toReturn.setSequenceIntervalBegin(bpSequenceSiteBegin);
        SequenceSite bpSequenceSiteEnd = (SequenceSite)this.bpModel.addNew(SequenceSite.class, this.genUri(SequenceSite.class, endSequenceInterval));
        bpSequenceSiteEnd.setSequencePosition((int)endSequenceInterval);
        toReturn.setSequenceIntervalEnd(bpSequenceSiteEnd);
        return toReturn;
    }

    private boolean isGeneticInteraction(Set<Evidence> bpEvidence) {
        if (bpEvidence != null && !bpEvidence.isEmpty()) {
            for (Evidence e : bpEvidence) {
                Set evidenceCodes = e.getEvidenceCode();
                if (evidenceCodes == null) continue;
                for (EvidenceCodeVocabulary cv : evidenceCodes) {
                    Set terms = cv.getTerm();
                    if (terms == null) continue;
                    for (String term : terms) {
                        if (!GENETIC_INTERACTIONS.contains(term.toLowerCase())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private String genUri(Class<? extends BioPAXElement> type, Object ... psimiIds) {
        return this.xmlBase + type.getSimpleName() + "_" + UUID.randomUUID() + (psimiIds.length > 0 ? "_" + this.encode(ArrayUtils.toString((Object)psimiIds)) : "");
    }

    static {
        GENETIC_INTERACTIONS.add("dosage growth defect");
        GENETIC_INTERACTIONS.add("dosage lethality");
        GENETIC_INTERACTIONS.add("dosage rescue");
        GENETIC_INTERACTIONS.add("negative genetic");
        GENETIC_INTERACTIONS.add("phenotypic enhancement");
        GENETIC_INTERACTIONS.add("phenotypic suppression");
        GENETIC_INTERACTIONS.add("positive genetic");
        GENETIC_INTERACTIONS.add("synthetic growth defect");
        GENETIC_INTERACTIONS.add("synthetic haploinsufficiency");
        GENETIC_INTERACTIONS.add("synthetic lethality");
        GENETIC_INTERACTIONS.add("synthetic rescue");
        BAD_ID_VALS = Arrays.asList("0", "-1", "NULL", "NIL", "NONE", "N/A");
    }
}

