/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn;

import java.util.ArrayList;
import java.util.List;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;
import org.ivis.layout.Updatable;
import org.ivis.layout.cose.CoSEGraph;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;

public class VNode
implements Updatable {
    public Glyph glyph;
    public int clusterID;
    ArrayList<Glyph> stateGlyphs;
    ArrayList<Glyph> infoGlyphs;
    private static final String MACROMOLECULE = "macromolecule";
    private static final String UNIT_OF_INFORMATION = "unit of information";
    private static final String STATE_VARIABLE = "state variable";
    private static final String SOURCE_AND_SINK = "source and sink";
    private static final String ASSOCIATION = "association";
    private static final String DISSOCIATION = "dissociation";
    private static final String OMITTED_PROCESS = "omitted process";
    private static final String UNCERTAIN_PROCESS = "uncertain process";
    private static final String SIMPLE_CHEMICAL = "simple chemical";
    private static final String PROCESS = "process";
    private static final String COMPLEX = "complex";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String NOT = "not";
    private static final String PHENOTYPE = "phenotype";
    private static final String PERTURBING_AGENT = "perturbing agent";
    private static final String TAG = "tag";
    private static final String NUCLEIC_ACID_FEATURE = "nucleic acid feature";
    private static final String UNSPECIFIED_ENTITY = "unspecified entity";
    private static final int LOWERCASE_LETTER_PIXEL_WIDTH = 6;
    private static final int UPPERCASE_LETTER_PIXEL_WIDTH = 9;
    private static final int MAX_STATE_AND_INFO_WIDTH = 50;
    private static final int MAX_STATE_AND_INFO_HEIGHT = 15;
    private static final int OFFSET_BTW_INFO_GLYPHS = 5;
    private static final int MAX_INFO_BOX_NUMBER = 4;
    private static final int MAX_MACROMOLECULE_HEIGHT_WITH_INFO_BOXES = 25;
    private static Bound SOURCE_AND_SINK_BOUND;
    private static Bound LOGICAL_OPERATOR_BOUND;
    private static Bound PROCESS_NODES_BOUND;
    private static Bound MACROMOLECULE_BOUND;
    private static Bound NUCLEIC_ACID_FEATURE_BOUND;
    private static Bound SIMPLE_CHEMICAL_BOUND;
    private static Bound UNSPECIFIED_ENTITY_BOUND;
    private static Bound PHENOTYPE_BOUND;
    private static Bound PERTURBING_AGENT_BOUND;
    private static Bound TAG_BOUND;
    private static Bound INFO_BOUND;
    private static Bound STATE_BOUND;
    private static Bound COMPLEX_BOUND;

    public VNode(Glyph g) {
        SOURCE_AND_SINK_BOUND = new Bound(15.0f, 15.0f);
        LOGICAL_OPERATOR_BOUND = new Bound(15.0f, 15.0f);
        PROCESS_NODES_BOUND = new Bound(15.0f, 15.0f);
        MACROMOLECULE_BOUND = new Bound(48.0f, 20.0f);
        NUCLEIC_ACID_FEATURE_BOUND = new Bound(50.0f, 20.0f);
        SIMPLE_CHEMICAL_BOUND = new Bound(48.0f, 20.0f);
        UNSPECIFIED_ENTITY_BOUND = new Bound(40.0f, 40.0f);
        PHENOTYPE_BOUND = new Bound(50.0f, 20.0f);
        TAG_BOUND = new Bound(50.0f, 20.0f);
        PERTURBING_AGENT_BOUND = new Bound(50.0f, 20.0f);
        COMPLEX_BOUND = new Bound(48.0f, 20.0f);
        INFO_BOUND = new Bound(50.0f, 15.0f);
        STATE_BOUND = new Bound(50.0f, 15.0f);
        this.stateGlyphs = new ArrayList();
        this.infoGlyphs = new ArrayList();
        this.glyph = g;
        this.setSizeAccordingToClass();
    }

    public void update(LGraphObject lGraphObj) {
        if (lGraphObj instanceof CoSEGraph) {
            return;
        }
        LNode lNode = (LNode)lGraphObj;
        this.glyph.getBbox().setX((float)lNode.getLeft());
        this.glyph.getBbox().setY((float)lNode.getTop());
        this.placeStateAndInfoGlyphs();
    }

    public void setBounds(float w, float h) {
        this.glyph.getBbox().setW(w);
        this.glyph.getBbox().setH(h);
    }

    public void setSizeAccordingToClass() {
        String glyphClass = this.glyph.getClazz();
        Bbox b = new Bbox();
        this.glyph.setBbox(b);
        if (glyphClass == SOURCE_AND_SINK) {
            this.setBounds(SOURCE_AND_SINK_BOUND.getWidth(), SOURCE_AND_SINK_BOUND.getHeight());
        } else if (glyphClass == AND || glyphClass == OR || glyphClass == NOT) {
            this.setBounds(LOGICAL_OPERATOR_BOUND.getWidth(), LOGICAL_OPERATOR_BOUND.getHeight());
        } else if (glyphClass == ASSOCIATION || glyphClass == DISSOCIATION || glyphClass == OMITTED_PROCESS || glyphClass == UNCERTAIN_PROCESS || glyphClass == PROCESS) {
            this.setBounds(PROCESS_NODES_BOUND.getWidth(), PROCESS_NODES_BOUND.getHeight());
        } else if (glyphClass == SIMPLE_CHEMICAL) {
            this.setBounds(SIMPLE_CHEMICAL_BOUND.getWidth(), SIMPLE_CHEMICAL_BOUND.getHeight());
        } else if (glyphClass == UNSPECIFIED_ENTITY) {
            this.setBounds(UNSPECIFIED_ENTITY_BOUND.getWidth(), UNSPECIFIED_ENTITY_BOUND.getHeight());
        } else if (glyphClass == MACROMOLECULE) {
            this.setBounds(MACROMOLECULE_BOUND.getWidth(), MACROMOLECULE_BOUND.getHeight());
        } else if (glyphClass == NUCLEIC_ACID_FEATURE) {
            this.setBounds(NUCLEIC_ACID_FEATURE_BOUND.getWidth(), NUCLEIC_ACID_FEATURE_BOUND.getHeight());
        } else if (glyphClass == STATE_VARIABLE) {
            this.setBounds(STATE_BOUND.getWidth(), STATE_BOUND.getHeight());
        } else if (glyphClass == UNIT_OF_INFORMATION) {
            this.setBounds(INFO_BOUND.getWidth(), INFO_BOUND.getHeight());
        } else if (glyphClass == PHENOTYPE) {
            this.setBounds(PHENOTYPE_BOUND.getWidth(), PHENOTYPE_BOUND.getHeight());
        } else if (glyphClass == PERTURBING_AGENT) {
            this.setBounds(PERTURBING_AGENT_BOUND.getWidth(), PERTURBING_AGENT_BOUND.getHeight());
        } else if (glyphClass == TAG) {
            this.setBounds(TAG_BOUND.getWidth(), TAG_BOUND.getHeight());
        } else if (glyphClass == COMPLEX) {
            this.setBounds(COMPLEX_BOUND.getWidth(), COMPLEX_BOUND.getHeight());
        }
        if (this.glyph.getClone() != null) {
            Bbox glyphBbox = this.glyph.getBbox();
            this.setBounds(3.0f * glyphBbox.getW() / 4.0f, 3.0f * glyphBbox.getH() / 4.0f);
        }
        if (glyphClass == MACROMOLECULE || glyphClass == NUCLEIC_ACID_FEATURE || glyphClass == SIMPLE_CHEMICAL || glyphClass == COMPLEX) {
            this.updateSizeForStateAndInfo();
        }
    }

    public int calcReqWidthByStateAndInfos(List<Glyph> stateORinfoList) {
        int wholeSize = 0;
        int count = 0;
        for (Glyph tmpGlyph : stateORinfoList) {
            String text;
            if (tmpGlyph.getState() != null) {
                text = tmpGlyph.getState().getValue();
                if (tmpGlyph.getState().getVariable() != null && tmpGlyph.getState().getVariable().length() > 0 && tmpGlyph.getState().getVariable() != null) {
                    text = text + "@" + tmpGlyph.getState().getVariable();
                }
            } else if (tmpGlyph.getLabel() != null) {
                text = tmpGlyph.getLabel().getText();
            } else {
                throw new RuntimeException("Encountered an information glyph with no state variable (as modification boxes should have) and no label (as molecule type boxed should have). glyph = " + tmpGlyph);
            }
            int numOfUpper = 0;
            int numOfLower = 0;
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isLowerCase(text.charAt(i))) {
                    ++numOfLower;
                    continue;
                }
                ++numOfUpper;
            }
            Bbox b = new Bbox();
            tmpGlyph.setBbox(b);
            float requiredSize = numOfLower * 6 + numOfUpper * 9;
            if (requiredSize < 50.0f) {
                tmpGlyph.getBbox().setW(requiredSize);
            } else {
                tmpGlyph.getBbox().setW(VNode.STATE_BOUND.width);
            }
            tmpGlyph.getBbox().setH(15.0f);
            if (count < 2) {
                wholeSize = (int)((float)wholeSize + tmpGlyph.getBbox().getW());
            }
            ++count;
        }
        return wholeSize;
    }

    public void updateSizeForStateAndInfo() {
        for (Glyph glyph : this.glyph.getGlyph()) {
            if (glyph.getClazz() == STATE_VARIABLE) {
                this.stateGlyphs.add(glyph);
                continue;
            }
            if (glyph.getClazz() != UNIT_OF_INFORMATION) continue;
            this.infoGlyphs.add(glyph);
        }
        int wholeWidthOfStates = this.calcReqWidthByStateAndInfos(this.stateGlyphs);
        int wholeWidthOfInfos = this.calcReqWidthByStateAndInfos(this.infoGlyphs);
        int numOfStates = this.stateGlyphs.size();
        int numOfInfos = this.infoGlyphs.size();
        if (numOfStates > 0 || numOfInfos > 0) {
            this.glyph.getBbox().setH(this.glyph.getBbox().getH() + 7.0f);
        }
        numOfStates = numOfStates >= 2 ? 2 : numOfStates;
        numOfInfos = numOfInfos >= 2 ? 2 : numOfInfos;
        float requiredWidthForStates = (numOfStates + 1) * 5 + wholeWidthOfStates;
        float requiredWidthForInfos = (numOfInfos + 1) * 5 + wholeWidthOfInfos;
        if (this.glyph.getBbox().getW() < requiredWidthForStates || this.glyph.getBbox().getW() < requiredWidthForInfos) {
            this.glyph.getBbox().setW(Math.max(requiredWidthForStates, requiredWidthForInfos));
        }
    }

    public void placeStateAndInfoGlyphs() {
        Glyph tmpglyph;
        int i;
        int numOfStates = this.stateGlyphs.size();
        int numOfInfos = this.infoGlyphs.size();
        if (numOfStates > 0 || numOfInfos > 0) {
            this.glyph.getBbox().setH(this.glyph.getBbox().getH() - 7.0f);
        }
        float parent_y_up = this.glyph.getBbox().getY() - VNode.INFO_BOUND.height / 2.0f;
        float parent_y_bot = this.glyph.getBbox().getY() + this.glyph.getBbox().getH() - VNode.INFO_BOUND.height / 2.0f;
        float parent_x_up = this.glyph.getBbox().getX();
        float parentWidth = this.glyph.getBbox().getW();
        String parentID = this.glyph.getId();
        int usedWidth = 0;
        for (i = 0; i < numOfStates; ++i) {
            tmpglyph = this.stateGlyphs.get(i);
            if (numOfStates == 1) {
                tmpglyph.getBbox().setX(parent_x_up + parentWidth / 2.0f - tmpglyph.getBbox().getW() / 2.0f);
                tmpglyph.getBbox().setY(parent_y_bot);
                tmpglyph.setId(parentID + ".state." + (i + 1));
                break;
            }
            tmpglyph.setId(parentID + ".state." + (i + 1));
            tmpglyph.getBbox().setX(parent_x_up + (float)((i + 1) * 5) + (float)usedWidth);
            tmpglyph.getBbox().setY(parent_y_bot);
            usedWidth = (int)((float)usedWidth + tmpglyph.getBbox().getW());
        }
        usedWidth = 0;
        for (i = 0; i < numOfInfos; ++i) {
            tmpglyph = this.infoGlyphs.get(i);
            if (numOfInfos == 1) {
                tmpglyph.getBbox().setX(parent_x_up + parentWidth / 2.0f - tmpglyph.getBbox().getW() / 2.0f);
                tmpglyph.getBbox().setY(parent_y_up);
                tmpglyph.setId(parentID + ".info." + (i + 1));
                break;
            }
            tmpglyph.setId(parentID + ".info." + (i + 1));
            tmpglyph.getBbox().setX(parent_x_up + (float)((i + 1) * 5) + (float)usedWidth);
            tmpglyph.getBbox().setY(parent_y_up);
            usedWidth = (int)((float)usedWidth + tmpglyph.getBbox().getW());
        }
    }

    public class Bound {
        public float width;
        public float height;

        public Bound(float width, float height) {
            this.width = width;
            this.height = height;
        }

        public float getWidth() {
            return this.width;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public float getHeight() {
            return this.height;
        }

        public void setHeight(float height) {
            this.height = height;
        }
    }
}

