/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn.idmapping;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.biopax.paxtools.io.sbgn.idmapping.HGNC;

public class EntrezGene {
    private static Map<String, String> sym2id;
    private static Map<String, String> id2sym;

    public static void main(String[] args) {
        System.out.println("getSymbol(\"367\") = " + EntrezGene.getSymbol("367"));
        System.out.println("getID(\"AR\") = " + EntrezGene.getID("AR"));
    }

    public static String getID(String symbol) {
        return sym2id.get(symbol);
    }

    public static String getSymbol(String id) {
        return id2sym.get(id);
    }

    public static boolean containsID(String id) {
        return id2sym.containsKey(id);
    }

    public static boolean containsSymbol(String symbol) {
        return sym2id.containsKey(symbol);
    }

    static {
        try {
            sym2id = new HashMap<String, String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(HGNC.class.getResourceAsStream("EntrezGene.txt")));
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                if (token.length >= 2) {
                    String sym = token[0];
                    String id = token[1];
                    if (sym.length() > 0 && id.length() > 0) {
                        sym2id.put(sym, id);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
            id2sym = new HashMap<String, String>();
            for (String key : sym2id.keySet()) {
                id2sym.put(sym2id.get(key), key);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

