/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.biopax.paxtools.io.sbgn.CommonFeatureStringGenerator;
import org.biopax.paxtools.io.sbgn.FeatureDecorator;
import org.biopax.paxtools.io.sbgn.SBGNLayoutManager;
import org.biopax.paxtools.io.sbgn.UbiqueDetector;
import org.biopax.paxtools.io.sbgn.idmapping.HGNC;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaRegion;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.FragmentFeature;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaRegion;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.model.level3.Xref;
import org.sbgn.ArcClazz;
import org.sbgn.GlyphClazz;
import org.sbgn.Language;
import org.sbgn.SbgnUtil;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Label;
import org.sbgn.bindings.Map;
import org.sbgn.bindings.ObjectFactory;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.Sbgn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L3ToSBGNPDConverter {
    private static final Logger log = LoggerFactory.getLogger(L3ToSBGNPDConverter.class);
    public static final String IS_UBIQUE = "IS_UBIQUE";
    private static java.util.Map<Class<? extends BioPAXElement>, String> typeMatchMap;
    private static ObjectFactory factory;
    protected UbiqueDetector ubiqueDet;
    protected FeatureDecorator featStrGen;
    protected boolean doLayout;
    protected java.util.Map<String, Set<String>> sbgn2BPMap;
    protected boolean flattenComplexContent;
    protected boolean useTwoGlyphsForReversibleConversion;
    java.util.Map<String, Glyph> glyphMap;
    java.util.Map<String, Arc> arcMap;
    java.util.Map<String, Glyph> compartmentMap;
    Set<Glyph> ubiqueSet;

    public L3ToSBGNPDConverter() {
        this(null, null, true);
    }

    public L3ToSBGNPDConverter(UbiqueDetector ubiqueDet, FeatureDecorator featStrGen, boolean doLayout) {
        this.ubiqueDet = ubiqueDet;
        this.featStrGen = featStrGen;
        this.doLayout = doLayout;
        if (this.featStrGen == null) {
            this.featStrGen = new CommonFeatureStringGenerator();
        }
        this.useTwoGlyphsForReversibleConversion = true;
        this.sbgn2BPMap = new HashMap<String, Set<String>>();
        this.flattenComplexContent = true;
    }

    public boolean isUseTwoGlyphsForReversibleConversion() {
        return this.useTwoGlyphsForReversibleConversion;
    }

    public void setUseTwoGlyphsForReversibleConversion(boolean useTwoGlyphsForReversibleConversion) {
        this.useTwoGlyphsForReversibleConversion = useTwoGlyphsForReversibleConversion;
    }

    public boolean isFlattenComplexContent() {
        return this.flattenComplexContent;
    }

    public void setFlattenComplexContent(boolean flattenComplexContent) {
        this.flattenComplexContent = flattenComplexContent;
    }

    public void writeSBGN(Model model, String file) {
        Sbgn sbgn = this.createSBGN(model);
        try {
            SbgnUtil.writeToFile((Sbgn)sbgn, (File)new File(file));
        }
        catch (JAXBException e) {
            if (e.getCause() != null) {
                log.error("writeSBGN SbgnUtil.writeToFile failed", e.getCause());
            }
            log.error("writeSBGN SbgnUtil.writeToFile failed", (Throwable)e);
        }
    }

    public void writeSBGN(Model model, OutputStream stream) {
        Sbgn sbgn = this.createSBGN(model);
        try {
            sbgn.toString();
            JAXBContext context = JAXBContext.newInstance((String)"org.sbgn.bindings");
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)sbgn, stream);
        }
        catch (JAXBException e) {
            if (e.getCause() != null) {
                log.error("writeSBGN SbgnUtil.writeToFile failed", e.getCause());
            } else {
                log.error("writeSBGN SbgnUtil.writeToFile failed", (Throwable)e);
            }
            e.printStackTrace(new PrintWriter(stream));
        }
    }

    public Sbgn createSBGN(Model model) {
        assert (model.getLevel().equals((Object)BioPAXLevel.L3)) : "This method only supports L3 graphs";
        this.glyphMap = new HashMap<String, Glyph>();
        this.compartmentMap = new HashMap<String, Glyph>();
        this.arcMap = new HashMap<String, Arc>();
        this.ubiqueSet = new HashSet<Glyph>();
        for (PhysicalEntity entity : model.getObjects(PhysicalEntity.class)) {
            if (!this.needsToBeCreatedInitially(entity)) continue;
            this.createGlyph(entity);
        }
        for (Conversion conv : model.getObjects(Conversion.class)) {
            if (conv.getConversionDirection() == null || conv.getConversionDirection().equals((Object)ConversionDirectionType.LEFT_TO_RIGHT) || conv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE) && this.useTwoGlyphsForReversibleConversion) {
                this.createProcessAndConnections(conv, ConversionDirectionType.LEFT_TO_RIGHT);
            }
            if (conv.getConversionDirection() != null && (conv.getConversionDirection().equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) || conv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE) && this.useTwoGlyphsForReversibleConversion)) {
                this.createProcessAndConnections(conv, ConversionDirectionType.RIGHT_TO_LEFT);
            }
            if (conv.getConversionDirection() == null || !conv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE) || this.useTwoGlyphsForReversibleConversion) continue;
            this.createProcessAndConnections(conv, ConversionDirectionType.REVERSIBLE);
        }
        for (TemplateReaction tr : model.getObjects(TemplateReaction.class)) {
            this.createProcessAndConnections(tr);
        }
        Sbgn sbgn = factory.createSbgn();
        Map map = new Map();
        sbgn.setMap(map);
        map.setLanguage(Language.PD.toString());
        map.getGlyph().addAll(this.getRootGlyphs(this.glyphMap.values()));
        map.getGlyph().addAll(this.getRootGlyphs(this.ubiqueSet));
        map.getGlyph().addAll(this.compartmentMap.values());
        map.getArc().addAll(this.arcMap.values());
        if (this.doLayout) {
            SBGNLayoutManager coseLayoutManager = new SBGNLayoutManager();
            sbgn = coseLayoutManager.createLayout(sbgn);
        }
        return sbgn;
    }

    private boolean needsToBeCreatedInitially(PhysicalEntity entity) {
        if (entity instanceof Complex) {
            Complex c = (Complex)entity;
            if (c.getParticipantOf().isEmpty() && !c.getComponentOf().isEmpty()) {
                return false;
            }
        } else {
            if (entity.getParticipantOf().isEmpty() && !entity.getComponentOf().isEmpty()) {
                return false;
            }
            if (this.ubiqueDet != null && this.ubiqueDet.isUbique(entity)) {
                return false;
            }
        }
        return true;
    }

    private Glyph createGlyph(PhysicalEntity pe) {
        String id = this.convertID(pe.getUri());
        if (this.glyphMap.containsKey(id)) {
            return this.glyphMap.get(id);
        }
        Glyph g = this.createGlyphBasics(pe);
        this.glyphMap.put(g.getId(), g);
        if (g.getClone() != null) {
            this.ubiqueSet.add(g);
        }
        this.assignLocation(pe, g);
        if (pe instanceof Complex) {
            this.createComplexContent((Complex)pe);
        }
        return g;
    }

    private void assignLocation(PhysicalEntity pe, Glyph g) {
        Glyph loc = this.getCompartment(this.getCompartment(pe));
        if (loc != null) {
            g.setCompartmentRef((Object)loc);
        }
    }

    private Glyph createGlyphBasics(PhysicalEntity pe) {
        return this.createGlyphBasics(pe, true);
    }

    private Glyph createGlyphBasics(PhysicalEntity pe, boolean idIsFinal) {
        String s = typeMatchMap.get(pe.getModelInterface());
        Glyph g = factory.createGlyph();
        g.setId(this.convertID(pe.getUri()));
        g.setClazz(s);
        Label label = factory.createLabel();
        label.setText(this.findALabelForMolecule(pe));
        g.setLabel(label);
        if (this.ubiqueDet != null && this.ubiqueDet.isUbique(pe)) {
            g.setClone(factory.createGlyphClone());
        }
        List<Glyph> states = this.getInformation(pe);
        g.getGlyph().addAll(states);
        if (idIsFinal) {
            this.sbgn2BPMap.put(g.getId(), new HashSet());
            this.sbgn2BPMap.get(g.getId()).add(pe.getUri());
        }
        return g;
    }

    private Glyph getGlyphToLink(PhysicalEntity pe, String linkID) {
        if (this.ubiqueDet == null || !this.ubiqueDet.isUbique(pe)) {
            return this.glyphMap.get(this.convertID(pe.getUri()));
        }
        Glyph g = this.createGlyphBasics(pe, false);
        g.setId(this.convertID(pe.getUri()) + linkID);
        this.sbgn2BPMap.put(g.getId(), new HashSet());
        this.sbgn2BPMap.get(g.getId()).add(pe.getUri());
        this.assignLocation(pe, g);
        this.ubiqueSet.add(g);
        return g;
    }

    private void createComplexContent(Complex cx) {
        Glyph cg = this.glyphMap.get(this.convertID(cx.getUri()));
        if (this.flattenComplexContent) {
            for (PhysicalEntity mem : this.getFlattenedMembers(cx)) {
                this.createComplexMember(mem, cg);
            }
        } else {
            for (PhysicalEntity mem : cx.getComponent()) {
                if (mem instanceof Complex) {
                    this.addComplexAsMember((Complex)mem, cg);
                    continue;
                }
                this.createComplexMember(mem, cg);
            }
        }
    }

    private void addComplexAsMember(Complex cx, Glyph container) {
        Glyph inner = this.createComplexMember((PhysicalEntity)cx, container);
        for (PhysicalEntity mem : cx.getComponent()) {
            if (mem instanceof Complex) {
                this.addComplexAsMember((Complex)mem, inner);
                continue;
            }
            this.createComplexMember(mem, inner);
        }
    }

    private Set<PhysicalEntity> getFlattenedMembers(Complex cx) {
        HashSet<PhysicalEntity> set = new HashSet<PhysicalEntity>();
        for (PhysicalEntity mem : cx.getComponent()) {
            if (mem instanceof Complex) {
                if (!this.hasNonComplexMember((Complex)mem)) {
                    set.add(mem);
                    continue;
                }
                set.addAll(this.getFlattenedMembers((Complex)mem));
                continue;
            }
            set.add(mem);
        }
        return set;
    }

    private boolean hasNonComplexMember(Complex cx) {
        for (PhysicalEntity mem : cx.getComponent()) {
            if (!(mem instanceof Complex)) {
                return true;
            }
            if (!this.hasNonComplexMember((Complex)mem)) continue;
            return true;
        }
        return false;
    }

    private Glyph createComplexMember(PhysicalEntity pe, Glyph container) {
        Glyph g = this.createGlyphBasics(pe, false);
        container.getGlyph().add(g);
        g.setId(g.getId() + "_" + container.getId());
        this.glyphMap.put(g.getId(), g);
        this.sbgn2BPMap.put(g.getId(), new HashSet());
        this.sbgn2BPMap.get(g.getId()).add(pe.getUri());
        return g;
    }

    private String findALabelForMolecule(PhysicalEntity pe) {
        String shortName;
        String name;
        for (Object xref : pe.getXref()) {
            String sym = this.extractGeneSymbol((Xref)xref);
            if (sym == null) continue;
            return sym;
        }
        EntityReference er = null;
        if (pe instanceof SimplePhysicalEntity) {
            er = ((SimplePhysicalEntity)pe).getEntityReference();
        }
        if (er != null) {
            for (Xref xref : er.getXref()) {
                String sym = this.extractGeneSymbol(xref);
                if (sym == null) continue;
                return sym;
            }
        }
        if ((name = pe.getDisplayName()) == null || name.trim().isEmpty()) {
            if (er != null) {
                name = er.getDisplayName();
            }
            if ((name == null || name.trim().isEmpty()) && ((name = pe.getStandardName()) == null || name.trim().isEmpty())) {
                if (er != null) {
                    name = er.getStandardName();
                }
                if (name == null || name.trim().isEmpty()) {
                    if (!pe.getName().isEmpty()) {
                        name = (String)pe.getName().iterator().next();
                    } else if (er != null && !er.getName().isEmpty()) {
                        name = (String)er.getName().iterator().next();
                    }
                }
            }
        }
        if (pe instanceof SmallMolecule && (shortName = this.getShortestName((SimplePhysicalEntity)((SmallMolecule)pe))) != null && (name == null || shortName.length() < name.length() && !shortName.isEmpty())) {
            name = shortName;
        }
        if (name == null || name.trim().isEmpty()) {
            name = "noname";
        }
        return name;
    }

    private String getShortestName(SimplePhysicalEntity spe) {
        String name = null;
        for (String s : spe.getName()) {
            if (name != null && s.length() <= name.length()) continue;
            name = s;
        }
        EntityReference er = spe.getEntityReference();
        if (er != null) {
            for (String s : er.getName()) {
                if (name != null && s.length() <= name.length()) continue;
                name = s;
            }
        }
        return name;
    }

    private String extractGeneSymbol(Xref xref) {
        if (xref.getDb() != null && (xref.getDb().equalsIgnoreCase("HGNC Symbol") || xref.getDb().equalsIgnoreCase("Gene Symbol") || xref.getDb().equalsIgnoreCase("HGNC"))) {
            String ref = xref.getId();
            if (ref != null) {
                if ((ref = ref.trim()).contains(":")) {
                    ref = ref.substring(ref.indexOf(":") + 1);
                }
                if (ref.contains("_")) {
                    ref = ref.substring(ref.indexOf("_") + 1);
                }
                if (!HGNC.containsSymbol(ref) && Character.isDigit(ref.charAt(0))) {
                    ref = HGNC.getSymbol(ref);
                }
            }
            return ref;
        }
        return null;
    }

    private List<Glyph> getInformation(PhysicalEntity pe) {
        ArrayList<Glyph> list = new ArrayList<Glyph>();
        if (pe instanceof NucleicAcid) {
            Glyph g = factory.createGlyph();
            g.setClazz(GlyphClazz.UNIT_OF_INFORMATION.getClazz());
            Label label = factory.createLabel();
            String s = "mt:";
            s = s + (pe instanceof Dna || pe instanceof DnaRegion ? "DNA" : (pe instanceof Rna || pe instanceof RnaRegion ? "RNA" : "NuclAc"));
            label.setText(s);
            g.setLabel(label);
            list.add(g);
        }
        this.extractFeatures(pe.getFeature(), true, list);
        this.extractFeatures(pe.getNotFeature(), false, list);
        return list;
    }

    private void extractFeatures(Set<EntityFeature> features, boolean normalFeature, List<Glyph> list) {
        for (EntityFeature feature : features) {
            if (!(feature instanceof ModificationFeature) && !(feature instanceof FragmentFeature)) continue;
            Glyph stvar = factory.createGlyph();
            stvar.setClazz(GlyphClazz.STATE_VARIABLE.getClazz());
            Glyph.State state = this.featStrGen.createStateVar(feature, factory);
            if (state == null) continue;
            if (!normalFeature) {
                state.setValue("!" + state.getValue());
            }
            stvar.setState(state);
            list.add(stvar);
        }
    }

    private Glyph getCompartment(String name) {
        if (name == null) {
            return null;
        }
        if (this.compartmentMap.containsKey(name)) {
            return this.compartmentMap.get(name);
        }
        Glyph comp = factory.createGlyph();
        comp.setId(name);
        Label label = factory.createLabel();
        label.setText(name);
        comp.setLabel(label);
        comp.setClazz(GlyphClazz.COMPARTMENT.getClazz());
        this.compartmentMap.put(name, comp);
        return comp;
    }

    private String getCompartment(PhysicalEntity pe) {
        CellularLocationVocabulary cl = pe.getCellularLocation();
        if (cl != null && !cl.getTerm().isEmpty()) {
            return ((String)cl.getTerm().iterator().next()).replaceAll(" ", "_");
        }
        return null;
    }

    private void createProcessAndConnections(Conversion cnv, ConversionDirectionType direction) {
        Glyph g;
        assert (cnv.getConversionDirection() == null || cnv.getConversionDirection().equals((Object)direction) || cnv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE));
        Glyph process = factory.createGlyph();
        process.setClazz(GlyphClazz.PROCESS.getClazz());
        process.setId(this.convertID(cnv.getUri()) + direction);
        this.glyphMap.put(process.getId(), process);
        Set input = direction.equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) ? cnv.getRight() : cnv.getLeft();
        Set output = direction.equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) ? cnv.getLeft() : cnv.getRight();
        this.addPorts(process);
        java.util.Map<PhysicalEntity, Stoichiometry> stoic = this.getStoichiometry(cnv);
        for (PhysicalEntity pe : input) {
            g = this.getGlyphToLink(pe, process.getId());
            this.createArc(g, process.getPort().get(0), direction == ConversionDirectionType.REVERSIBLE ? ArcClazz.PRODUCTION.getClazz() : ArcClazz.CONSUMPTION.getClazz(), stoic.get(pe));
        }
        for (PhysicalEntity pe : output) {
            g = this.getGlyphToLink(pe, process.getId());
            this.createArc(process.getPort().get(1), g, ArcClazz.PRODUCTION.getClazz(), stoic.get(pe));
        }
        for (Control ctrl : cnv.getControlledOf()) {
            CatalysisDirectionType catDir;
            if (ctrl instanceof Catalysis && (catDir = ((Catalysis)ctrl).getCatalysisDirection()) != null && (catDir.equals((Object)CatalysisDirectionType.LEFT_TO_RIGHT) && direction.equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) || catDir.equals((Object)CatalysisDirectionType.RIGHT_TO_LEFT) && direction.equals((Object)ConversionDirectionType.LEFT_TO_RIGHT)) || (g = this.createControlStructure(ctrl)) == null) continue;
            this.createArc(g, process, this.getControlType(ctrl), null);
        }
        this.sbgn2BPMap.put(process.getId(), new HashSet());
        this.sbgn2BPMap.get(process.getId()).add(cnv.getUri());
    }

    private java.util.Map<PhysicalEntity, Stoichiometry> getStoichiometry(Conversion conv) {
        HashMap<PhysicalEntity, Stoichiometry> map = new HashMap<PhysicalEntity, Stoichiometry>();
        for (Stoichiometry stoc : conv.getParticipantStoichiometry()) {
            map.put(stoc.getPhysicalEntity(), stoc);
        }
        return map;
    }

    private void createProcessAndConnections(TemplateReaction tr) {
        Glyph g;
        Glyph process = factory.createGlyph();
        process.setClazz(GlyphClazz.PROCESS.getClazz());
        process.setId(this.convertID(tr.getUri()));
        this.glyphMap.put(process.getId(), process);
        this.addPorts(process);
        Glyph sas = factory.createGlyph();
        sas.setClazz(GlyphClazz.SOURCE_AND_SINK.getClazz());
        sas.setId("SAS_For_" + process.getId());
        this.glyphMap.put(sas.getId(), sas);
        this.createArc(sas, process.getPort().get(0), ArcClazz.CONSUMPTION.getClazz(), null);
        for (PhysicalEntity pe : tr.getProduct()) {
            g = this.getGlyphToLink(pe, process.getId());
            this.createArc(process.getPort().get(1), g, ArcClazz.PRODUCTION.getClazz(), null);
        }
        for (Control ctrl : tr.getControlledOf()) {
            g = this.createControlStructure(ctrl);
            if (g == null) continue;
            this.createArc(g, process, this.getControlType(ctrl), null);
        }
        this.sbgn2BPMap.put(process.getId(), new HashSet());
        this.sbgn2BPMap.get(process.getId()).add(tr.getUri());
    }

    private Glyph createControlStructure(Control ctrl) {
        Glyph cg;
        Set<PhysicalEntity> controllers = this.getControllers(ctrl);
        if (controllers.isEmpty()) {
            cg = null;
        } else if (controllers.size() == 1 && this.getControllerSize(ctrl.getControlledOf()) == 0) {
            cg = this.getGlyphToLink(controllers.iterator().next(), this.convertID(ctrl.getUri()));
        } else {
            Set cofs;
            Glyph g;
            ArrayList<Glyph> toConnect = new ArrayList<Glyph>();
            Glyph gg = this.handlePEGroup(controllers, this.convertID(ctrl.getUri()));
            if (gg != null) {
                toConnect.add(gg);
            }
            for (Control ctrl2 : ctrl.getControlledOf()) {
                Glyph g2 = this.createControlStructure(ctrl2);
                if (g2 == null) continue;
                if (this.getControlType(ctrl2).equals(ArcClazz.INHIBITION.getClazz())) {
                    g2 = this.addNOT(g2);
                }
                toConnect.add(g2);
            }
            if (ctrl instanceof Catalysis && (g = this.handlePEGroup(cofs = ((Catalysis)ctrl).getCofactor(), this.convertID(ctrl.getUri()))) != null) {
                toConnect.add(g);
            }
            if (toConnect.isEmpty()) {
                return null;
            }
            cg = toConnect.size() == 1 ? (Glyph)toConnect.iterator().next() : this.connectWithAND(toConnect);
        }
        return cg;
    }

    private Glyph handlePEGroup(Set<PhysicalEntity> pes, String context) {
        int sz = pes.size();
        if (sz > 1) {
            List<Glyph> gs = this.getGlyphsOfPEs(pes, context);
            return this.connectWithAND(gs);
        }
        if (sz == 1 && this.glyphMap.containsKey(this.convertID(pes.iterator().next().getUri()))) {
            return this.getGlyphToLink(pes.iterator().next(), context);
        }
        return null;
    }

    private List<Glyph> getGlyphsOfPEs(Set<PhysicalEntity> pes, String context) {
        ArrayList<Glyph> gs = new ArrayList<Glyph>();
        for (PhysicalEntity pe : pes) {
            if (!this.glyphMap.containsKey(this.convertID(pe.getUri()))) continue;
            gs.add(this.getGlyphToLink(pe, context));
        }
        return gs;
    }

    private Glyph connectWithAND(List<Glyph> gs) {
        Glyph and;
        String id = "";
        for (Glyph g : gs) {
            id = id + (id.length() > 0 ? "-AND-" : "") + g.getId();
        }
        if (!this.glyphMap.containsKey(id)) {
            and = factory.createGlyph();
            and.setClazz(GlyphClazz.AND.getClazz());
            and.setId(id);
            this.glyphMap.put(and.getId(), and);
        } else {
            and = this.glyphMap.get(id);
        }
        for (Glyph g : gs) {
            this.createArc(g, and, ArcClazz.LOGIC_ARC.getClazz(), null);
        }
        return and;
    }

    private Glyph addNOT(Glyph g) {
        Glyph not;
        String id = "NOT-" + g.getId();
        if (!this.glyphMap.containsKey(id)) {
            not = factory.createGlyph();
            not.setId(id);
            not.setClazz(GlyphClazz.NOT.getClazz());
            this.glyphMap.put(not.getId(), not);
        } else {
            not = this.glyphMap.get(id);
        }
        this.createArc(g, not, ArcClazz.LOGIC_ARC.getClazz(), null);
        return not;
    }

    private String getControlType(Control ctrl) {
        if (ctrl instanceof Catalysis) {
            return ArcClazz.CATALYSIS.getClazz();
        }
        ControlType type = ctrl.getControlType();
        if (type == null) {
            return ArcClazz.STIMULATION.getClazz();
        }
        switch (type) {
            case ACTIVATION: 
            case ACTIVATION_ALLOSTERIC: 
            case ACTIVATION_NONALLOSTERIC: 
            case ACTIVATION_UNKMECH: {
                return ArcClazz.STIMULATION.getClazz();
            }
            case INHIBITION: 
            case INHIBITION_ALLOSTERIC: 
            case INHIBITION_OTHER: 
            case INHIBITION_UNKMECH: 
            case INHIBITION_COMPETITIVE: 
            case INHIBITION_IRREVERSIBLE: 
            case INHIBITION_UNCOMPETITIVE: 
            case INHIBITION_NONCOMPETITIVE: {
                return ArcClazz.INHIBITION.getClazz();
            }
        }
        throw new RuntimeException("Invalid control type: " + type);
    }

    private int getControllerSize(Set<Control> ctrlSet) {
        int size = 0;
        for (Control ctrl : ctrlSet) {
            size += this.getControllers(ctrl).size();
        }
        return size;
    }

    private Set<PhysicalEntity> getControllers(Control ctrl) {
        HashSet<PhysicalEntity> controllers = new HashSet<PhysicalEntity>();
        for (Controller clr : ctrl.getController()) {
            if (!(clr instanceof PhysicalEntity) || !this.glyphMap.containsKey(this.convertID(clr.getUri()))) continue;
            controllers.add((PhysicalEntity)clr);
        }
        return controllers;
    }

    private void addPorts(Glyph g) {
        Port inputPort = factory.createPort();
        Port outputPort = factory.createPort();
        inputPort.setId(g.getId() + "-input");
        outputPort.setId(g.getId() + "-output");
        g.getPort().add(inputPort);
        g.getPort().add(outputPort);
    }

    private void createArc(Object source, Object target, String clazz, Stoichiometry stoic) {
        assert (source instanceof Glyph || source instanceof Port) : "source = " + source;
        assert (target instanceof Glyph || target instanceof Port) : "target = " + target;
        Arc arc = factory.createArc();
        arc.setSource(source);
        arc.setTarget(target);
        arc.setClazz(clazz);
        String sourceID = source instanceof Glyph ? ((Glyph)source).getId() : ((Port)source).getId();
        String targetID = target instanceof Glyph ? ((Glyph)target).getId() : ((Port)target).getId();
        arc.setId(sourceID + "--to--" + targetID);
        if (stoic != null && stoic.getStoichiometricCoefficient() != 1.0f) {
            Glyph card = factory.createGlyph();
            card.setClazz(GlyphClazz.CARDINALITY.getClazz());
            Label label = factory.createLabel();
            label.setText(new DecimalFormat("0.##").format(stoic.getStoichiometricCoefficient()));
            card.setLabel(label);
            arc.getGlyph().add(card);
        }
        Arc.Start start = new Arc.Start();
        start.setX(0.0f);
        start.setY(0.0f);
        arc.setStart(start);
        Arc.End end = new Arc.End();
        end.setX(0.0f);
        end.setY(0.0f);
        arc.setEnd(end);
        this.arcMap.put(arc.getId(), arc);
    }

    private Set<Glyph> getRootGlyphs(Collection<Glyph> glyphCol) {
        HashSet<Glyph> root = new HashSet<Glyph>(glyphCol);
        HashSet<Glyph> children = new HashSet<Glyph>();
        for (Glyph glyph : glyphCol) {
            this.addChildren(glyph, children);
        }
        root.removeAll(children);
        return root;
    }

    private void addChildren(Glyph glyph, Set<Glyph> set) {
        for (Glyph child : glyph.getGlyph()) {
            set.add(child);
            this.addChildren(child, set);
        }
    }

    public java.util.Map<String, Set<String>> getSbgn2BPMap() {
        return this.sbgn2BPMap;
    }

    private String convertID(String biopaxID) {
        return biopaxID.replaceAll("[^-\\w]", "_");
    }

    static {
        factory = new ObjectFactory();
        typeMatchMap = new HashMap<Class<? extends BioPAXElement>, String>();
        typeMatchMap.put(Protein.class, GlyphClazz.MACROMOLECULE.getClazz());
        typeMatchMap.put(SmallMolecule.class, GlyphClazz.SIMPLE_CHEMICAL.getClazz());
        typeMatchMap.put(Dna.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(Rna.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(DnaRegion.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(RnaRegion.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(NucleicAcid.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(PhysicalEntity.class, GlyphClazz.UNSPECIFIED_ENTITY.getClazz());
        typeMatchMap.put(SimplePhysicalEntity.class, GlyphClazz.UNSPECIFIED_ENTITY.getClazz());
        typeMatchMap.put(Complex.class, GlyphClazz.COMPLEX.getClazz());
    }
}

