/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn;

import java.io.File;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.io.sbgn.CommonFeatureStringGenerator;
import org.biopax.paxtools.io.sbgn.FeatureDecorator;
import org.biopax.paxtools.io.sbgn.SBGNLayoutManager;
import org.biopax.paxtools.io.sbgn.UbiqueDetector;
import org.biopax.paxtools.io.sbgn.idmapping.HGNC;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaRegion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.FragmentFeature;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.GeneticInteraction;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.PhenotypeVocabulary;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaRegion;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.sbgn.ArcClazz;
import org.sbgn.GlyphClazz;
import org.sbgn.Language;
import org.sbgn.SbgnUtil;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Label;
import org.sbgn.bindings.Map;
import org.sbgn.bindings.ObjectFactory;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.Sbgn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L3ToSBGNPDConverter {
    private static final Logger log = LoggerFactory.getLogger(L3ToSBGNPDConverter.class);
    private static java.util.Map<Class<? extends BioPAXElement>, String> typeMatchMap;
    private static ObjectFactory factory;
    protected UbiqueDetector ubiqueDet;
    protected FeatureDecorator featStrGen;
    protected boolean doLayout;
    protected int maxNodes;
    protected java.util.Map<String, Set<String>> sbgn2BPMap;
    protected boolean flattenComplexContent;
    protected boolean useTwoGlyphsForReversibleConversion;
    java.util.Map<String, Glyph> glyphMap;
    java.util.Map<String, Arc> arcMap;
    java.util.Map<String, Glyph> compartmentMap;
    Set<Glyph> ubiqueSet;

    public L3ToSBGNPDConverter() {
        this(null, null, false);
    }

    public L3ToSBGNPDConverter(UbiqueDetector ubiqueDet, FeatureDecorator featStrGen, boolean doLayout) {
        this.ubiqueDet = ubiqueDet;
        this.featStrGen = featStrGen != null ? featStrGen : new CommonFeatureStringGenerator();
        this.doLayout = doLayout;
        this.useTwoGlyphsForReversibleConversion = true;
        this.sbgn2BPMap = new HashMap<String, Set<String>>();
        this.flattenComplexContent = true;
        this.maxNodes = 1000;
    }

    public void setDoLayout(boolean doLayout) {
        this.doLayout = doLayout;
    }

    public boolean isUseTwoGlyphsForReversibleConversion() {
        return this.useTwoGlyphsForReversibleConversion;
    }

    public void setUseTwoGlyphsForReversibleConversion(boolean useTwoGlyphsForReversibleConversion) {
        this.useTwoGlyphsForReversibleConversion = useTwoGlyphsForReversibleConversion;
    }

    public boolean isFlattenComplexContent() {
        return this.flattenComplexContent;
    }

    public void setFlattenComplexContent(boolean flattenComplexContent) {
        this.flattenComplexContent = flattenComplexContent;
    }

    public void writeSBGN(Model model, String file) {
        Sbgn sbgn = this.createSBGN(model);
        try {
            SbgnUtil.writeToFile((Sbgn)sbgn, (File)new File(file));
        }
        catch (JAXBException e) {
            throw new RuntimeException("writeSBGN, SbgnUtil.writeToFile failed", e);
        }
    }

    public void writeSBGN(Model model, OutputStream stream) {
        Sbgn sbgn = this.createSBGN(model);
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.sbgn.bindings");
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)sbgn, stream);
        }
        catch (JAXBException e) {
            throw new RuntimeException("writeSBGN: JAXB marshalling failed", e);
        }
    }

    public Sbgn createSBGN(Model model) {
        assert (model.getLevel().equals((Object)BioPAXLevel.L3)) : "This method only supports L3 graphs";
        this.glyphMap = new HashMap<String, Glyph>();
        this.compartmentMap = new HashMap<String, Glyph>();
        this.arcMap = new HashMap<String, Arc>();
        this.ubiqueSet = new HashSet<Glyph>();
        int n = 0;
        for (Entity entity : model.getObjects(Entity.class)) {
            if (!this.needsToBeCreatedInitially(entity)) continue;
            this.createGlyph(entity);
            ++n;
        }
        for (Interaction interaction : model.getObjects(Interaction.class)) {
            if (interaction.getParticipant().isEmpty()) continue;
            if (interaction instanceof Conversion) {
                Conversion conv = (Conversion)interaction;
                if (conv.getConversionDirection() == null || conv.getConversionDirection().equals((Object)ConversionDirectionType.LEFT_TO_RIGHT) || conv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE) && this.useTwoGlyphsForReversibleConversion) {
                    this.createProcessAndConnections(conv, ConversionDirectionType.LEFT_TO_RIGHT);
                } else if (conv.getConversionDirection() != null && (conv.getConversionDirection().equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) || conv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE) && this.useTwoGlyphsForReversibleConversion)) {
                    this.createProcessAndConnections(conv, ConversionDirectionType.RIGHT_TO_LEFT);
                } else if (conv.getConversionDirection() != null && conv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE) && !this.useTwoGlyphsForReversibleConversion) {
                    this.createProcessAndConnections(conv, ConversionDirectionType.REVERSIBLE);
                }
            } else if (interaction instanceof TemplateReaction) {
                this.createProcessAndConnections((TemplateReaction)interaction);
            } else if (interaction instanceof MolecularInteraction) {
                this.createBasicProcess(interaction);
            } else if (interaction instanceof GeneticInteraction) {
                this.createGiProcess((GeneticInteraction)interaction);
            } else if (!(interaction instanceof Control)) {
                this.createBasicProcess(interaction);
            } else {
                Control control = (Control)interaction;
                if (control.getControlled() == null || control.getControlled().isEmpty()) {
                    Glyph g = this.createControlStructure(control);
                    this.processControllers(control.getControlledOf(), g);
                }
            }
            ++n;
        }
        Sbgn sbgn = factory.createSbgn();
        Map map = new Map();
        sbgn.setMap(map);
        map.setLanguage(Language.PD.toString());
        map.getGlyph().addAll(this.getRootGlyphs(this.glyphMap.values()));
        map.getGlyph().addAll(this.getRootGlyphs(this.ubiqueSet));
        map.getGlyph().addAll(this.compartmentMap.values());
        map.getArc().addAll(this.arcMap.values());
        boolean layout = this.doLayout && n < this.maxNodes && !this.arcMap.isEmpty();
        try {
            new SBGNLayoutManager().createLayout(sbgn, layout);
        }
        catch (Exception e) {
            throw new RuntimeException("SBGN Layout of " + model.getXmlBase() + (model.getName() == null ? "" : model.getName()) + " failed.", e);
        }
        if (!layout) {
            log.warn(String.format("No layout, for either it's disabled: %s, or ~ no. nodes > %s: %s, or - no edges: %s", !this.doLayout, this.maxNodes, n > this.maxNodes, this.arcMap.isEmpty()));
        }
        return sbgn;
    }

    private void processControllers(Set<Control> controls, Glyph process) {
        for (Control ctrl : controls) {
            Glyph g = this.createControlStructure(ctrl);
            if (g == null) continue;
            this.createArc(g, process, this.getControlType(ctrl), null);
            this.processControllers(ctrl.getControlledOf(), g);
        }
    }

    private boolean needsToBeCreatedInitially(Entity ent) {
        boolean create = false;
        if (ent instanceof PhysicalEntity || ent instanceof Gene) {
            if (this.ubiqueDet != null && this.ubiqueDet.isUbique(ent)) {
                create = false;
            } else if (!ent.getParticipantOf().isEmpty()) {
                create = true;
            } else if (ent instanceof Complex && ((Complex)ent).getComponentOf().isEmpty() && ((Complex)ent).getMemberPhysicalEntityOf().isEmpty()) {
                create = true;
            }
        }
        return create;
    }

    private Glyph createGlyph(Entity e) {
        String id = this.convertID(e.getUri());
        if (this.glyphMap.containsKey(id)) {
            return this.glyphMap.get(id);
        }
        Glyph g = this.createGlyphBasics(e, true);
        this.glyphMap.put(g.getId(), g);
        if (g.getClone() != null) {
            this.ubiqueSet.add(g);
        }
        if (e instanceof PhysicalEntity) {
            PhysicalEntity pe = (PhysicalEntity)e;
            this.assignLocation(pe, g);
            if ("or".equalsIgnoreCase(g.getClazz())) {
                this.buildGeneric(pe, g, null);
            } else if (pe instanceof Complex) {
                this.createComplexContent((Complex)pe, g);
            }
        }
        return g;
    }

    private void assignLocation(PhysicalEntity pe, Glyph g) {
        Glyph loc = this.getCompartment(pe);
        if (loc != null) {
            g.setCompartmentRef((Object)loc);
        }
    }

    private Glyph createGlyphBasics(Entity e, boolean idIsFinal) {
        Glyph g = factory.createGlyph();
        g.setId(this.convertID(e.getUri()));
        String s = typeMatchMap.get(e.getModelInterface());
        if (e instanceof Complex && !((Complex)e).getMemberPhysicalEntity().isEmpty() && ((Complex)e).getComponent().isEmpty() || e instanceof SimplePhysicalEntity && ((SimplePhysicalEntity)e).getEntityReference() == null && !((SimplePhysicalEntity)e).getMemberPhysicalEntity().isEmpty()) {
            s = GlyphClazz.OR.getClazz();
        }
        g.setClazz(s);
        Label label = factory.createLabel();
        label.setText(this.findLabelFor(e));
        g.setLabel(label);
        if (this.ubiqueDet != null && this.ubiqueDet.isUbique(e)) {
            g.setClone(factory.createGlyphClone());
        }
        if (!g.getClazz().equals(GlyphClazz.OR.getClazz())) {
            g.getGlyph().addAll(this.getInformation(e));
        }
        if (idIsFinal) {
            HashSet<String> uris = new HashSet<String>();
            uris.add(e.getUri());
            this.sbgn2BPMap.put(g.getId(), uris);
        }
        return g;
    }

    private Glyph getGlyphToLink(Entity e, String linkID) {
        if (this.ubiqueDet == null || !this.ubiqueDet.isUbique(e)) {
            return this.glyphMap.get(this.convertID(e.getUri()));
        }
        Glyph g = this.createGlyphBasics(e, false);
        g.setId(this.convertID(e.getUri()) + "_" + ModelUtils.md5hex((String)linkID));
        HashSet<String> uris = new HashSet<String>();
        uris.add(e.getUri());
        this.sbgn2BPMap.put(g.getId(), uris);
        if (e instanceof PhysicalEntity && ((PhysicalEntity)e).getCellularLocation() != null) {
            this.assignLocation((PhysicalEntity)e, g);
        }
        this.ubiqueSet.add(g);
        return g;
    }

    private void createComplexContent(Complex cx, Glyph cg) {
        if (this.flattenComplexContent) {
            for (PhysicalEntity mem : this.getFlattenedMembers(cx)) {
                this.createComplexMember(mem, cg);
            }
        } else {
            for (PhysicalEntity mem : cx.getComponent()) {
                if (mem instanceof Complex) {
                    this.addComplexAsMember((Complex)mem, cg);
                    continue;
                }
                this.createComplexMember(mem, cg);
            }
        }
    }

    private void buildGeneric(PhysicalEntity generic, Glyph or, Glyph container) {
        assert ("or".equalsIgnoreCase(or.getClazz())) : "must be 'or' glyph class";
        for (PhysicalEntity m : generic.getMemberPhysicalEntity()) {
            Glyph g = this.createGlyphBasics((Entity)m, false);
            if (container != null) {
                container.getGlyph().add(g);
            }
            String gid = g.getId() + "_" + ModelUtils.md5hex((String)("memberof_" + or.getId()));
            g.setId(gid);
            this.glyphMap.put(gid, g);
            HashSet<String> uris = new HashSet<String>();
            uris.add(m.getUri());
            this.sbgn2BPMap.put(gid, uris);
            this.assignLocation(m, g);
            this.createArc(g, or, ArcClazz.LOGIC_ARC.getClazz(), null);
            if (!(m instanceof Complex)) continue;
            this.createComplexContent((Complex)m, g);
        }
    }

    private void addComplexAsMember(Complex cx, Glyph container) {
        Glyph inner = this.createComplexMember((PhysicalEntity)cx, container);
        for (PhysicalEntity mem : cx.getComponent()) {
            if (mem instanceof Complex) {
                this.addComplexAsMember((Complex)mem, inner);
                continue;
            }
            this.createComplexMember(mem, inner);
        }
    }

    private Set<PhysicalEntity> getFlattenedMembers(Complex cx) {
        HashSet<PhysicalEntity> set = new HashSet<PhysicalEntity>();
        for (PhysicalEntity mem : cx.getComponent()) {
            if (mem instanceof Complex) {
                if (!this.hasNonComplexMember((Complex)mem)) {
                    set.add(mem);
                    continue;
                }
                set.addAll(this.getFlattenedMembers((Complex)mem));
                continue;
            }
            set.add(mem);
        }
        return set;
    }

    private boolean hasNonComplexMember(Complex cx) {
        for (PhysicalEntity mem : cx.getComponent()) {
            if (mem instanceof Complex && !this.hasNonComplexMember((Complex)mem)) continue;
            return true;
        }
        return false;
    }

    private Glyph createComplexMember(PhysicalEntity pe, Glyph container) {
        Glyph g = this.createGlyphBasics((Entity)pe, false);
        container.getGlyph().add(g);
        g.setId(g.getId() + "_" + ModelUtils.md5hex((String)container.getId()));
        this.glyphMap.put(g.getId(), g);
        HashSet<String> uris = new HashSet<String>();
        uris.add(pe.getUri());
        this.sbgn2BPMap.put(g.getId(), uris);
        if ("or".equalsIgnoreCase(g.getClazz())) {
            this.buildGeneric(pe, g, container);
        }
        return g;
    }

    private String findLabelFor(Entity pe) {
        String shortName;
        String name;
        for (Object xref : pe.getXref()) {
            String sym = this.extractGeneSymbol((Xref)xref);
            if (sym == null) continue;
            return sym;
        }
        EntityReference er = null;
        if (pe instanceof SimplePhysicalEntity) {
            er = ((SimplePhysicalEntity)pe).getEntityReference();
        }
        if (er != null) {
            for (Xref xref : er.getXref()) {
                String sym = this.extractGeneSymbol(xref);
                if (sym == null) continue;
                return sym;
            }
        }
        if ((name = pe.getDisplayName()) == null || name.trim().isEmpty()) {
            if (er != null) {
                name = er.getDisplayName();
            }
            if ((name == null || name.trim().isEmpty()) && ((name = pe.getStandardName()) == null || name.trim().isEmpty())) {
                if (er != null) {
                    name = er.getStandardName();
                }
                if (name == null || name.trim().isEmpty()) {
                    if (!pe.getName().isEmpty()) {
                        name = (String)pe.getName().iterator().next();
                    } else if (er != null && !er.getName().isEmpty()) {
                        name = (String)er.getName().iterator().next();
                    }
                }
            }
        }
        if (pe instanceof SmallMolecule && (shortName = this.getShortestName((SimplePhysicalEntity)((SmallMolecule)pe))) != null && (name == null || shortName.length() < name.length() && !shortName.isEmpty())) {
            name = shortName;
        }
        if (name == null || name.trim().isEmpty()) {
            name = "noname";
        }
        return name;
    }

    private String getShortestName(SimplePhysicalEntity spe) {
        String name = null;
        for (String s : spe.getName()) {
            if (name != null && s.length() <= name.length()) continue;
            name = s;
        }
        EntityReference er = spe.getEntityReference();
        if (er != null) {
            for (String s : er.getName()) {
                if (name != null && s.length() <= name.length()) continue;
                name = s;
            }
        }
        return name;
    }

    private String extractGeneSymbol(Xref xref) {
        if (xref.getDb() != null && (xref.getDb().equalsIgnoreCase("HGNC Symbol") || xref.getDb().equalsIgnoreCase("Gene Symbol") || xref.getDb().equalsIgnoreCase("HGNC"))) {
            String ref = xref.getId();
            if (ref != null) {
                if ((ref = ref.trim()).contains(":")) {
                    ref = ref.substring(ref.indexOf(":") + 1);
                }
                if (ref.contains("_")) {
                    ref = ref.substring(ref.indexOf("_") + 1);
                }
                if (!HGNC.containsSymbol(ref) && Character.isDigit(ref.charAt(0))) {
                    ref = HGNC.getSymbol(ref);
                }
            }
            return ref;
        }
        return null;
    }

    private List<Glyph> getInformation(Entity e) {
        ArrayList<Glyph> list = new ArrayList<Glyph>();
        if (e instanceof NucleicAcid || e instanceof Gene) {
            Glyph g = factory.createGlyph();
            g.setClazz(GlyphClazz.UNIT_OF_INFORMATION.getClazz());
            Label label = factory.createLabel();
            String s = e instanceof Dna ? "mt:DNA" : (e instanceof DnaRegion ? "ct:DNA" : (e instanceof Rna ? "mt:RNA" : (e instanceof RnaRegion ? "ct:RNA" : (e instanceof Gene ? "ct:gene" : "mt:NuclAc"))));
            label.setText(s);
            g.setLabel(label);
            list.add(g);
        }
        if (e instanceof PhysicalEntity) {
            PhysicalEntity pe = (PhysicalEntity)e;
            this.extractFeatures(pe.getFeature(), true, list);
            this.extractFeatures(pe.getNotFeature(), false, list);
        }
        return list;
    }

    private void extractFeatures(Set<EntityFeature> features, boolean normalFeature, List<Glyph> list) {
        for (EntityFeature feature : features) {
            if (!(feature instanceof ModificationFeature) && !(feature instanceof FragmentFeature)) continue;
            Glyph stvar = factory.createGlyph();
            stvar.setClazz(GlyphClazz.STATE_VARIABLE.getClazz());
            Glyph.State state = this.featStrGen.createStateVar(feature, factory);
            if (state == null) continue;
            if (!normalFeature) {
                state.setValue("!" + state.getValue());
            }
            stvar.setState(state);
            list.add(stvar);
        }
    }

    private Glyph getCompartment(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        String id = (name = name.toLowerCase().trim()).replaceAll("\\s+", "_");
        Glyph comp = this.compartmentMap.get(id);
        if (comp == null) {
            comp = factory.createGlyph();
            comp.setId(id);
            comp.setClazz(GlyphClazz.COMPARTMENT.getClazz());
            Label label = factory.createLabel();
            comp.setLabel(label);
            label.setText(name);
            this.compartmentMap.put(id, comp);
        }
        return comp;
    }

    private Glyph getCompartment(PhysicalEntity pe) {
        CellularLocationVocabulary cl = pe.getCellularLocation();
        if (cl != null && !cl.getTerm().isEmpty()) {
            String name = null;
            for (String term : cl.getTerm()) {
                if ((term = term.toLowerCase()).matches("(go|so|mi|bto|cl|pato|mod):")) continue;
                name = term;
                break;
            }
            return this.getCompartment(name);
        }
        return null;
    }

    private void createProcessAndConnections(Conversion cnv, ConversionDirectionType direction) {
        Glyph g;
        assert (cnv.getConversionDirection() == null || cnv.getConversionDirection().equals((Object)direction) || cnv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE));
        Glyph process = factory.createGlyph();
        process.setClazz(GlyphClazz.PROCESS.getClazz());
        process.setId(this.convertID(cnv.getUri()) + "_" + direction.name().replaceAll("_", ""));
        this.glyphMap.put(process.getId(), process);
        Set input = direction.equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) ? cnv.getRight() : cnv.getLeft();
        Set output = direction.equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) ? cnv.getLeft() : cnv.getRight();
        this.addPorts(process);
        java.util.Map<PhysicalEntity, Stoichiometry> stoic = this.getStoichiometry(cnv);
        for (PhysicalEntity pe : input) {
            g = this.getGlyphToLink((Entity)pe, process.getId());
            this.createArc(g, process.getPort().get(0), direction == ConversionDirectionType.REVERSIBLE ? ArcClazz.PRODUCTION.getClazz() : ArcClazz.CONSUMPTION.getClazz(), stoic.get(pe));
        }
        for (PhysicalEntity pe : output) {
            g = this.getGlyphToLink((Entity)pe, process.getId());
            this.createArc(process.getPort().get(1), g, ArcClazz.PRODUCTION.getClazz(), stoic.get(pe));
        }
        this.processControllers(cnv.getControlledOf(), process);
        HashSet<String> uris = new HashSet<String>();
        uris.add(cnv.getUri());
        this.sbgn2BPMap.put(process.getId(), uris);
    }

    private java.util.Map<PhysicalEntity, Stoichiometry> getStoichiometry(Conversion conv) {
        HashMap<PhysicalEntity, Stoichiometry> map = new HashMap<PhysicalEntity, Stoichiometry>();
        for (Stoichiometry stoc : conv.getParticipantStoichiometry()) {
            map.put(stoc.getPhysicalEntity(), stoc);
        }
        return map;
    }

    private void createProcessAndConnections(TemplateReaction tr) {
        Glyph process = factory.createGlyph();
        process.setClazz(GlyphClazz.PROCESS.getClazz());
        process.setId(this.convertID(tr.getUri()));
        this.glyphMap.put(process.getId(), process);
        Set products = tr.getProduct();
        HashSet participants = new HashSet(new ClassFilterSet(tr.getParticipant(), PhysicalEntity.class));
        for (PhysicalEntity pe : products) {
            Glyph g = this.getGlyphToLink((Entity)pe, process.getId());
            this.createArc(process, g, ArcClazz.PRODUCTION.getClazz(), null);
            participants.remove(pe);
        }
        NucleicAcid template = tr.getTemplate();
        if (template != null) {
            Glyph g = this.getGlyphToLink((Entity)template, process.getId());
            this.createArc(g, process, ArcClazz.CONSUMPTION.getClazz(), null);
            participants.remove(template);
        } else if (participants.isEmpty()) {
            Glyph sas = factory.createGlyph();
            sas.setClazz(GlyphClazz.SOURCE_AND_SINK.getClazz());
            sas.setId("unknown-template_" + ModelUtils.md5hex((String)process.getId()));
            this.glyphMap.put(sas.getId(), sas);
            this.createArc(sas, process, ArcClazz.CONSUMPTION.getClazz(), null);
        }
        for (PhysicalEntity pe : participants) {
            Glyph g = this.getGlyphToLink((Entity)pe, process.getId());
            if (template == null) {
                this.createArc(g, process, ArcClazz.CONSUMPTION.getClazz(), null);
                continue;
            }
            this.createArc(process, g, ArcClazz.PRODUCTION.getClazz(), null);
        }
        this.processControllers(tr.getControlledOf(), process);
        this.sbgn2BPMap.put(process.getId(), new HashSet<String>(Collections.singleton(tr.getUri())));
    }

    private void createBasicProcess(Interaction interaction) {
        Glyph process = factory.createGlyph();
        process.setClazz(GlyphClazz.PROCESS.getClazz());
        process.setId(this.convertID(interaction.getUri()));
        this.glyphMap.put(process.getId(), process);
        for (PhysicalEntity pe : new ClassFilterSet(interaction.getParticipant(), PhysicalEntity.class)) {
            Glyph g = this.getGlyphToLink((Entity)pe, process.getId());
            this.createArc(g, process, ArcClazz.CONSUMPTION.getClazz(), null);
        }
        this.sbgn2BPMap.put(process.getId(), new HashSet<String>(Collections.singleton(interaction.getUri())));
        this.processControllers(interaction.getControlledOf(), process);
    }

    private void createGiProcess(GeneticInteraction interaction) {
        Glyph g;
        Glyph process = factory.createGlyph();
        process.setClazz(GlyphClazz.AND.getClazz());
        process.setId(this.convertID(interaction.getUri()));
        this.glyphMap.put(process.getId(), process);
        PhenotypeVocabulary v = interaction.getPhenotype();
        if (v != null && !v.getTerm().isEmpty()) {
            String term = ((String)v.getTerm().iterator().next()).toLowerCase().trim();
            String id = this.convertID(term);
            g = this.glyphMap.get(id);
            if (g == null) {
                g = factory.createGlyph();
                g.setId(id);
                g.setClazz(GlyphClazz.PHENOTYPE.getClazz());
                Label label = factory.createLabel();
                label.setText(term);
                g.setLabel(label);
                this.glyphMap.put(g.getId(), g);
            }
            this.createArc(process, g, ArcClazz.STIMULATION.getClazz(), null);
        }
        for (Entity e : interaction.getParticipant()) {
            g = this.getGlyphToLink(e, process.getId());
            this.createArc(g, process, ArcClazz.LOGIC_ARC.getClazz(), null);
        }
        this.sbgn2BPMap.put(process.getId(), new HashSet<String>(Collections.singleton(interaction.getUri())));
        this.processControllers(interaction.getControlledOf(), process);
    }

    private Glyph createControlStructure(Control ctrl) {
        Glyph cg;
        Set<PhysicalEntity> controllers = this.getControllers(ctrl);
        if (controllers.isEmpty()) {
            cg = null;
        } else if (controllers.size() == 1 && this.getControllerSize(ctrl.getControlledOf()) == 0) {
            cg = this.getGlyphToLink((Entity)controllers.iterator().next(), this.convertID(ctrl.getUri()));
        } else {
            Set cofs;
            Glyph g;
            ArrayList<Glyph> toConnect = new ArrayList<Glyph>();
            Glyph gg = this.handlePEGroup(controllers, this.convertID(ctrl.getUri()));
            if (gg != null) {
                toConnect.add(gg);
            }
            if (ctrl instanceof Catalysis && (g = this.handlePEGroup(cofs = ((Catalysis)ctrl).getCofactor(), this.convertID(ctrl.getUri()))) != null) {
                toConnect.add(g);
            }
            if (toConnect.isEmpty()) {
                return null;
            }
            cg = toConnect.size() == 1 ? (Glyph)toConnect.iterator().next() : this.connectWithAND(toConnect);
        }
        return cg;
    }

    private Glyph handlePEGroup(Set<PhysicalEntity> pes, String context) {
        PhysicalEntity pe;
        int sz = pes.size();
        if (sz > 1) {
            List<Glyph> gs = this.getGlyphsOfPEs(pes, context);
            return this.connectWithAND(gs);
        }
        if (sz == 1 && this.glyphMap.containsKey(this.convertID((pe = pes.iterator().next()).getUri()))) {
            return this.getGlyphToLink((Entity)pe, context);
        }
        return null;
    }

    private List<Glyph> getGlyphsOfPEs(Set<PhysicalEntity> pes, String context) {
        ArrayList<Glyph> gs = new ArrayList<Glyph>();
        for (PhysicalEntity pe : pes) {
            if (!this.glyphMap.containsKey(this.convertID(pe.getUri()))) continue;
            gs.add(this.getGlyphToLink((Entity)pe, context));
        }
        return gs;
    }

    private Glyph connectWithAND(List<Glyph> gs) {
        StringBuilder sb = new StringBuilder();
        Iterator<Glyph> iterator = gs.iterator();
        if (iterator.hasNext()) {
            sb.append(iterator.next());
        }
        while (iterator.hasNext()) {
            sb.append("-AND-").append(iterator.next().getId());
        }
        String id = ModelUtils.md5hex((String)sb.toString());
        Glyph and = this.glyphMap.get(id);
        if (and == null) {
            and = factory.createGlyph();
            and.setClazz(GlyphClazz.AND.getClazz());
            and.setId(id);
            this.glyphMap.put(and.getId(), and);
        }
        for (Glyph g : gs) {
            this.createArc(g, and, ArcClazz.LOGIC_ARC.getClazz(), null);
        }
        return and;
    }

    private String getControlType(Control ctrl) {
        if (ctrl instanceof Catalysis) {
            return ArcClazz.CATALYSIS.getClazz();
        }
        ControlType type = ctrl.getControlType();
        if (type == null) {
            return ArcClazz.STIMULATION.getClazz();
        }
        switch (type) {
            case ACTIVATION: 
            case ACTIVATION_ALLOSTERIC: 
            case ACTIVATION_NONALLOSTERIC: 
            case ACTIVATION_UNKMECH: {
                return ArcClazz.STIMULATION.getClazz();
            }
            case INHIBITION: 
            case INHIBITION_ALLOSTERIC: 
            case INHIBITION_OTHER: 
            case INHIBITION_UNKMECH: 
            case INHIBITION_COMPETITIVE: 
            case INHIBITION_IRREVERSIBLE: 
            case INHIBITION_UNCOMPETITIVE: 
            case INHIBITION_NONCOMPETITIVE: {
                return ArcClazz.INHIBITION.getClazz();
            }
        }
        throw new RuntimeException("Invalid control type: " + type);
    }

    private int getControllerSize(Set<Control> ctrlSet) {
        int size = 0;
        for (Control ctrl : ctrlSet) {
            size += this.getControllers(ctrl).size();
        }
        return size;
    }

    private Set<PhysicalEntity> getControllers(Control ctrl) {
        HashSet<PhysicalEntity> controllers = new HashSet<PhysicalEntity>();
        for (Controller clr : ctrl.getController()) {
            if (!(clr instanceof PhysicalEntity) || !this.glyphMap.containsKey(this.convertID(clr.getUri()))) continue;
            controllers.add((PhysicalEntity)clr);
        }
        return controllers;
    }

    private void addPorts(Glyph g) {
        Port inputPort = factory.createPort();
        Port outputPort = factory.createPort();
        inputPort.setId("INP_" + g.getId());
        outputPort.setId("OUT_" + g.getId());
        g.getPort().add(inputPort);
        g.getPort().add(outputPort);
    }

    private void createArc(Object source, Object target, String clazz, Stoichiometry stoic) {
        assert (source instanceof Glyph || source instanceof Port) : "source = " + source;
        assert (target instanceof Glyph || target instanceof Port) : "target = " + target;
        Arc arc = factory.createArc();
        arc.setSource(source);
        arc.setTarget(target);
        arc.setClazz(clazz);
        String sourceID = source instanceof Glyph ? ((Glyph)source).getId() : ((Port)source).getId();
        String targetID = target instanceof Glyph ? ((Glyph)target).getId() : ((Port)target).getId();
        arc.setId(sourceID + "--TO--" + targetID);
        if (stoic != null && stoic.getStoichiometricCoefficient() > 1.0f) {
            Glyph card = factory.createGlyph();
            card.setClazz(GlyphClazz.CARDINALITY.getClazz());
            Label label = factory.createLabel();
            label.setText(new DecimalFormat("0.##").format(stoic.getStoichiometricCoefficient()));
            card.setLabel(label);
            arc.getGlyph().add(card);
        }
        Arc.Start start = new Arc.Start();
        start.setX(0.0f);
        start.setY(0.0f);
        arc.setStart(start);
        Arc.End end = new Arc.End();
        end.setX(0.0f);
        end.setY(0.0f);
        arc.setEnd(end);
        this.arcMap.put(arc.getId(), arc);
    }

    private Set<Glyph> getRootGlyphs(Collection<Glyph> glyphCol) {
        HashSet<Glyph> root = new HashSet<Glyph>(glyphCol);
        HashSet<Glyph> children = new HashSet<Glyph>();
        for (Glyph glyph : glyphCol) {
            this.addChildren(glyph, children);
        }
        root.removeAll(children);
        return root;
    }

    private void addChildren(Glyph glyph, Set<Glyph> set) {
        for (Glyph child : glyph.getGlyph()) {
            set.add(child);
            this.addChildren(child, set);
        }
    }

    public java.util.Map<String, Set<String>> getSbgn2BPMap() {
        return this.sbgn2BPMap;
    }

    private String convertID(String id) {
        return id;
    }

    static {
        factory = new ObjectFactory();
        typeMatchMap = new HashMap<Class<? extends BioPAXElement>, String>();
        typeMatchMap.put(Protein.class, GlyphClazz.MACROMOLECULE.getClazz());
        typeMatchMap.put(SmallMolecule.class, GlyphClazz.SIMPLE_CHEMICAL.getClazz());
        typeMatchMap.put(Dna.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(Rna.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(DnaRegion.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(RnaRegion.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(NucleicAcid.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
        typeMatchMap.put(PhysicalEntity.class, GlyphClazz.UNSPECIFIED_ENTITY.getClazz());
        typeMatchMap.put(SimplePhysicalEntity.class, GlyphClazz.UNSPECIFIED_ENTITY.getClazz());
        typeMatchMap.put(Complex.class, GlyphClazz.COMPLEX.getClazz());
        typeMatchMap.put(Gene.class, GlyphClazz.NUCLEIC_ACID_FEATURE.getClazz());
    }
}

