/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level2.XReferrable;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level2.xref;

public class SimpleInteraction {
    private BioPAXElement source;
    private BioPAXElement target;
    private BinaryInteractionType type;
    Log log = LogFactory.getLog(SimpleInteraction.class);
    private Set<BioPAXElement> mediators;

    public SimpleInteraction(BioPAXElement source, BioPAXElement target, BinaryInteractionType type) {
        this.source = source;
        this.target = target;
        this.type = type;
        this.mediators = new HashSet<BioPAXElement>();
    }

    public SimpleInteraction(BioPAXElement source, BioPAXElement target, BinaryInteractionType type, BioPAXElement ... mediator) {
        this(source, target, type, Arrays.asList(mediator));
    }

    public SimpleInteraction(BioPAXElement source, BioPAXElement target, BinaryInteractionType type, Collection<BioPAXElement> mediator) {
        this(source, target, type);
        this.mediators.addAll(mediator);
    }

    public BioPAXElement getSource() {
        return this.source;
    }

    public void setSource(BioPAXElement source) {
        this.source = source;
    }

    public BioPAXElement getTarget() {
        return this.target;
    }

    public void setTarget(BioPAXElement target) {
        this.target = target;
    }

    public BinaryInteractionType getType() {
        return this.type;
    }

    public void setType(BinaryInteractionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleInteraction that = (SimpleInteraction)o;
        return this.checkNullOrEquals((Object)this.type, (Object)that.type) && this.checkParticipants(that);
    }

    private boolean checkParticipants(SimpleInteraction that) {
        boolean equal;
        boolean bl = equal = this.checkNullOrEquals(this.source, that.source) && this.checkNullOrEquals(this.target, that.target);
        if (!(equal || this.type != null && this.type.isDirected())) {
            equal = this.checkNullOrEquals(this.source, that.target) && this.checkNullOrEquals(this.target, that.source);
        }
        return equal;
    }

    private boolean checkNullOrEquals(Object thisObject, Object thatObject) {
        return thisObject == null ? thatObject == null : thisObject.equals(thatObject);
    }

    public int hashCode() {
        int srcHash = this.source != null ? this.source.hashCode() : 0;
        int trgtHash = this.target != null ? this.target.hashCode() : 0;
        int result = 31 + (this.type != null ? this.type.hashCode() : 0);
        if (this.type != null) {
            int directionHash = 1;
            if (!this.type.isDirected()) {
                if (srcHash < trgtHash) {
                    int tmpHash = srcHash;
                    srcHash = trgtHash;
                    trgtHash = tmpHash;
                }
                directionHash = 2;
            }
            result = 31 * result + directionHash;
        }
        result = 31 * result + srcHash;
        result = 31 * result + trgtHash;
        return result;
    }

    public String toString() {
        String from = this.source.getRDFId();
        String to = this.target == null ? "null" : this.target.getRDFId();
        return from + "\t" + (Object)((Object)this.type) + "\t" + to;
    }

    public String getANameForSIF(BioPAXElement element) {
        String symbol;
        if (element instanceof XReferrable && (symbol = this.getRelatedEntrezGeneID((XReferrable)element)) != null) {
            return symbol;
        }
        if (element instanceof entity) {
            String synonym;
            entity ent = (entity)element;
            if (ent.getSHORT_NAME() != null && ent.getSHORT_NAME().length() > 0) {
                return ent.getSHORT_NAME();
            }
            if (ent.getNAME() != null && ent.getNAME().length() > 0) {
                return ent.getNAME();
            }
            if (ent.getSYNONYMS() != null && !ent.getSYNONYMS().isEmpty() && (synonym = (String)ent.getSYNONYMS().iterator().next()) != null && synonym.length() > 0) {
                return synonym;
            }
        }
        return element.getRDFId();
    }

    public String getRelatedEntrezGeneID(XReferrable obj) {
        for (xref xr : obj.getXREF()) {
            if (xr.getDB() == null || !xr.getDB().equalsIgnoreCase("GENE_SYMBOL") || xr.getID() == null) continue;
            return xr.getID();
        }
        return null;
    }

    public Set<BioPAXElement> getMediators() {
        return this.mediators;
    }

    public void addMediator(BioPAXElement element) {
        this.mediators.add(element);
    }
}

